/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.support.validation;

import com.google.inject.Injector;
import com.sap.cloud.security.ams.dcl.support.validation.SimpleCompositeEValidator;
import java.util.HashMap;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.CancelableDiagnostician;
import org.eclipse.xtext.validation.CompositeEValidator;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.ResourceValidatorImpl;

public class GenericValidationTools {
    private GenericValidationTools() {
    }

    public static IResourceValidator createResourceValidator(Injector injector, EPackage ePackage, EValidator validator) {
        LocalEValidatorRegistry registry = new LocalEValidatorRegistry();
        CompositeEValidator eVal = injector.getInstance(SimpleCompositeEValidator.class);
        eVal.addValidator(validator);
        registry.put(ePackage, eVal);
        CancelableDiagnostician cc = new CancelableDiagnostician(registry);
        injector.injectMembers(cc);
        ResourceValidatorImpl rv = injector.getInstance(ResourceValidatorWithoutResourceDiagnostic.class);
        rv.setDiagnostician(cc);
        return rv;
    }

    private static class LocalEValidatorRegistry
    extends HashMap<EPackage, Object>
    implements EValidator.Registry {
        private static final long serialVersionUID = 1L;

        @Override
        public Object get(Object key) {
            Object eValidator = super.get(key);
            if (eValidator != null) {
                return eValidator;
            }
            return key == null ? EObjectValidator.INSTANCE : null;
        }

        @Override
        public EValidator getEValidator(EPackage ePackage) {
            return (EValidator)this.get(ePackage);
        }
    }

    private static class ResourceValidatorWithoutResourceDiagnostic
    extends ResourceValidatorImpl {
        private ResourceValidatorWithoutResourceDiagnostic() {
        }

        @Override
        protected void collectResourceDiagnostics(Resource resource, CancelIndicator monitor, IAcceptor<Issue> acceptor) {
        }
    }
}

