/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.support.validation;

import com.google.inject.Injector;
import com.sap.cloud.security.ams.dcl.support.validation.ValidationHelper;
import com.sap.cloud.security.ams.dcl.validation.DataControlLanguageValidator;
import java.util.Objects;
import org.eclipse.emf.ecore.resource.ResourceSet;

public final class ValidationCache {
    public static final boolean USE_VALIDATION_INSTANCE = Boolean.getBoolean("com.sap.dcl.compiler.validationInstance");
    private static final ThreadLocal<ValidationCache> VAL_HELPER = new ThreadLocal();
    private final Injector injector;
    private final ValidationHelper vh;
    private DataControlLanguageValidator val;

    private ValidationCache(Injector injector) {
        this.injector = injector;
        this.vh = injector.getInstance(ValidationHelper.class);
    }

    public ValidationHelper getValidationHelper() {
        return this.vh;
    }

    public DataControlLanguageValidator getDataControlLanguageValidator() {
        if (this.val == null) {
            this.val = this.injector.getInstance(DataControlLanguageValidator.class);
        }
        return this.val;
    }

    public static boolean grantValidationCache(ResourceSet resourceSet, Injector injectior) {
        ValidationCache helper = VAL_HELPER.get();
        if (helper == null) {
            helper = new ValidationCache(injectior);
            VAL_HELPER.set(helper);
            return true;
        }
        return false;
    }

    public static void removeValidationCache(ResourceSet resourceSet) {
        VAL_HELPER.remove();
    }

    public static ValidationCache peekCache() {
        return VAL_HELPER.get();
    }

    public static ValidationCache getCache() {
        return Objects.requireNonNull(VAL_HELPER.get());
    }
}

