/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.support.validation;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.sap.cloud.security.ams.dcl.DCLResourceHelper;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguagePackage;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Expression;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionCall;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.FunctionDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyUse;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaDefinition;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class ValidationHelper {
    @Inject
    @Named(value="isMultiTenant")
    private boolean isMtSupport;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private DCLResourceHelper dclResourceHelper;
    @Inject
    private IQualifiedNameProvider qnp;
    private static final Function<Object, Map<Object, Object>> NEW_MAP = t -> new HashMap();
    private static final Object NULL = new Object();
    private final Map<Object, Object> cache = new HashMap<Object, Object>();

    public void clear() {
        this.cache.clear();
    }

    public <K, V> Map<K, V> getMap(String key) {
        return this.cache.computeIfAbsent(key, NEW_MAP);
    }

    public <K, V> Map<K, V> getMap(EClass key) {
        return this.cache.computeIfAbsent(key, NEW_MAP);
    }

    public <K, V> Map<K, V> getMap() {
        return this.cache;
    }

    public <K, V> Map<K, V> getResourceMap(Resource resource) {
        return this.cache.computeIfAbsent(resource, NEW_MAP);
    }

    public <K, V> Map<K, V> getResourceMap(EObject eObject) {
        return this.getResourceMap(eObject.eResource());
    }

    public ResourceLocation getResourceLocation(EObject eObject) {
        Map<String, ResourceLocation> map;
        Resource resource = eObject.eResource();
        ResourceLocation rl = this.dclResourceHelper.getResourceLocation(resource);
        if (rl == null && (rl = (ResourceLocation)(map = this.getResourceMap(resource)).get("resourceLocation")) == null) {
            rl = this.dclResourceHelper.createResourceLocation(resource);
            map.put("resourceLocation", rl);
        }
        return rl;
    }

    public QualifiedName getPackageQualifiedName(EObject context) {
        String key;
        Map<String, QualifiedName> rc = this.getResourceMap(context);
        QualifiedName qn = (QualifiedName)rc.get(key = "QualifiedName");
        if (qn == null) {
            qn = this.getResourceLocation(context).getQualifiedName();
            rc.put(key, qn);
        }
        return qn;
    }

    public boolean isInTenantPackage(EObject context) {
        Map<QualifiedName, Boolean> pt;
        if (!this.isMtSupport || context.eIsProxy()) {
            return false;
        }
        Map<String, Boolean> rc = this.getResourceMap(context);
        Boolean res = (Boolean)rc.get("isTenant");
        if (res != null) {
            return res;
        }
        res = Boolean.FALSE;
        QualifiedName qn = this.getPackageQualifiedName(context);
        if (!qn.isEmpty() && (res = (Boolean)(pt = this.getMap("isPackageTenant")).get(qn)) == null) {
            IScope schemaInScope = this.scopeProvider.getScope(context, DataControlLanguagePackage.Literals.POLICY_DOCUMENT__SCHEMA);
            IEObjectDescription tenantSchema = schemaInScope.getSingleElement(qn.append("schema"));
            if (tenantSchema != null) {
                SchemaDefinition eSchema = (SchemaDefinition)EcoreUtil.resolve(tenantSchema.getEObjectOrProxy(), context.eResource());
                res = eSchema != null && eSchema.isTenant();
            }
            if (res == null) {
                res = Boolean.FALSE;
            }
            pt.put(qn, res);
        }
        rc.put("isTenant", res);
        return res;
    }

    public boolean isInBasePackage(EObject context) {
        return !context.eIsProxy() && !this.isInTenantPackage(context);
    }

    public boolean isComplexExpression(Expression e) {
        if (e == null) {
            return false;
        }
        int classifierID = e.eClass().getClassifierID();
        switch (classifierID) {
            case 19: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return false;
            }
            case 39: {
                Map<Expression, Boolean> m = this.getMap("isComplexExpression");
                Boolean isComplex = (Boolean)m.get(e);
                if (isComplex == null) {
                    FunctionDefinition fd = ((ExpressionCall)e).getLeft();
                    isComplex = this.getInformation(fd).isRecursive() || this.isComplexExpression(fd.getResult());
                    m.put(e, isComplex);
                }
                return isComplex;
            }
        }
        return true;
    }

    public QualifiedName getQualifiedName(EObject obj) {
        Map map = this.getMap("QualifiedNames");
        Object res = map.get(obj);
        if (res == null) {
            res = this.qnp.getFullyQualifiedName(obj);
            if (res == null) {
                res = NULL;
            }
            map.put(obj, res);
        }
        return res == NULL ? null : (QualifiedName)res;
    }

    private <T> Set<T> getCachedTransitiveUse(String key, T root, Function<T, Iterator<? extends T>> childProvider) {
        return DCLTools.updateTransitiveUsageMap(this.getMap(key), root, childProvider);
    }

    private <E extends EObject, I> I grantInformationObject(E obj, Function<E, I> provider) {
        return (I)this.getMap("Informations").computeIfAbsent(obj, provider);
    }

    public PolicyDefinitionInformation getInformation(PolicyDefinition obj) {
        return this.grantInformationObject(obj, policyDefinition -> new PolicyDefinitionInformation((PolicyDefinition)policyDefinition));
    }

    public FunctionDefinitionInformation getInformation(FunctionDefinition obj) {
        return this.grantInformationObject(obj, functionDefinition -> new FunctionDefinitionInformation((FunctionDefinition)functionDefinition));
    }

    public class FunctionDefinitionInformation {
        private final FunctionDefinition obj;
        private Set<FunctionDefinition> transitiveFunctions;

        public FunctionDefinitionInformation(FunctionDefinition obj) {
            this.obj = Objects.requireNonNull(obj);
        }

        public Set<FunctionDefinition> getTransitiveFunctions() {
            if (this.transitiveFunctions == null) {
                this.transitiveFunctions = ValidationHelper.this.getCachedTransitiveUse("function-children", this.obj, f -> Iterators.transform(Iterators.filter(f.eAllContents(), ExpressionCall.class), ExpressionCall::getLeft));
            }
            return this.transitiveFunctions;
        }

        public Set<FunctionDefinition> getTransitiveFunctionCallClosure() {
            HashSet<FunctionDefinition> transitiveClosure = new HashSet<FunctionDefinition>();
            transitiveClosure.add(this.obj);
            transitiveClosure.addAll(this.getTransitiveFunctions());
            return transitiveClosure;
        }

        public boolean isRecursive() {
            return this.getTransitiveFunctions().contains(this.obj);
        }
    }

    public class PolicyDefinitionInformation {
        private final PolicyDefinition obj;
        private Set<PolicyDefinition> transitiveUnrestrictedUse;
        private Set<PolicyDefinition> transitiveUse;
        private Set<FunctionDefinition> transitiveCalls;

        public PolicyDefinitionInformation(PolicyDefinition obj) {
            this.obj = Objects.requireNonNull(obj);
        }

        public Set<PolicyDefinition> getTransitiveUnrestrictedUse() {
            if (this.transitiveUnrestrictedUse == null) {
                this.transitiveUnrestrictedUse = ValidationHelper.this.getCachedTransitiveUse("policy-unrestricted-use", this.obj, f -> Iterators.transform(Iterators.filter(f.getUses().iterator(), u -> u.getRestrictions().isEmpty()), PolicyUse::getPolicy));
            }
            return this.transitiveUnrestrictedUse;
        }

        public Set<PolicyDefinition> getTransitiveUse() {
            if (this.transitiveUse == null) {
                this.transitiveUse = ValidationHelper.this.getCachedTransitiveUse("policy-used", this.obj, f -> Iterators.transform(f.getUses().iterator(), PolicyUse::getPolicy));
            }
            return this.transitiveUse;
        }

        public Set<PolicyDefinition> getTransitiveUseClosure() {
            HashSet<PolicyDefinition> transitiveClosure = new HashSet<PolicyDefinition>();
            transitiveClosure.add(this.obj);
            transitiveClosure.addAll(this.getTransitiveUse());
            return transitiveClosure;
        }

        public Set<FunctionDefinition> getTransitiveFunctionCallClosure() {
            if (this.transitiveCalls == null) {
                this.transitiveCalls = this.getTransitiveUseClosure().stream().map(policy -> EcoreUtil2.getAllContentsOfType(policy, ExpressionCall.class)).flatMap(Collection::stream).map(expressionCall -> expressionCall.getLeft()).map(directFunctionCall -> ValidationHelper.this.getInformation((FunctionDefinition)directFunctionCall).getTransitiveFunctionCallClosure()).reduce(new HashSet(), (setA, setB) -> {
                    setA.addAll(setB);
                    return setA;
                });
                ValidationHelper.this.getMap("functions-called").put(this.obj, this.transitiveCalls);
            }
            return this.transitiveCalls;
        }
    }
}

