/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.validation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtext.util.Arrays;

public enum DCLIssue {
    UNKNOWN_ERROR("Unknown error. %1$s", Kind.ERROR, -1, new Mark[0]),
    CANNOT_FIND_TYPE_WITH_NAME("Cannot find %1$s with name '%2$s'.", Kind.ERROR, 50, new Mark[0]),
    LINKER_ERROR("Linker error. %1$s", Kind.ERROR, 51, new Mark[0]),
    SYNTAX_ERROR("Syntax error. %1$s", Kind.ERROR, 52, new Mark[0]),
    TRANSITIVE_ERROR("'%1$s' is erroneous because it uses directly or indirectly the erroneous %2$s '%3$s'.", Kind.ERROR, 53, new Mark[0]),
    SCHEMA_DUPLICATE("Schemas are already defined in package.", Kind.ERROR, 100, new Mark[0]),
    SCHEMA_MISSING("No schema is defined in package '%1$s'", Kind.ERROR, 101, new Mark[0]),
    SCHEMA_MISLOCATED("The schema must be located in the file 'schema.dcl' on root level.", Kind.ERROR, 102, new Mark[0]),
    SCHEMA_ONLY("Only the schema can be defined in 'schema.dcl'.", Kind.ERROR, 103, new Mark[0]),
    POLICY_DUPLICATE("The '%1$s' policy is already defined.", Kind.ERROR, 150, new Mark[0]),
    POLICY_DEFAULT_RESTRICTION("Restrictions are not allowed for '%1$s' policy since it is a default policy.", Kind.ERROR, 151, new Mark[0]),
    POLICY_INTERNAL("Internal '%1$s' policy not permitted for tenants.", Kind.ERROR, 153, new Mark[0]),
    POLICY_NAME_EXCEEDES_RECOMMENDED_LENGTH("The qualified policy name '%1$s' exceeds %2$d characters. It might be truncated in UIs.", Kind.INFO, 155, new Mark[0]),
    POLICY_INTERNAL_DEFAULT("The '%1$s' policy cannot be default and @internal at the same time.", Kind.ERROR, 156, new Mark[0]),
    POLICY_USE_DUPLICATE("The '%1$s' policy is already used.", Kind.WARNING, 200, new Mark[0]),
    POLICY_USE_CIRCULAR("Circular use of '%1$s' policy.", Kind.ERROR, 201, new Mark[0]),
    POLICY_USE_RESTR_NO_PARAMETER("Restrictions on '%1$s' policy without any parameter.", Kind.ERROR, 202, new Mark[0]),
    POLICY_USE_ALSO_UNRESTRICTED("The '%1$s' policy is used already without any restrictions", Kind.WARNING, 203, new Mark[0]),
    POLICY_USE_RESTR_MULTIPLE_TIMES("The '%1$s' parameter is defined multiple times.", Kind.ERROR, 204, new Mark[0]),
    POLICY_USE_RESTR_NOT_OVERWRITTEN("The '%1$s' parameter was not overwritten.", Kind.INFO, 205, new Mark[0]),
    POLICY_USE_MISSING_PARAMETER("No restricted parameter occurs in the expression.", Kind.ERROR, 206, new Mark[0]),
    POLICY_USE_DEFAULT_POLICY("Use of '%1$s' policy not allowed since it is a default policy.", Kind.ERROR, 207, new Mark[0]),
    POLICY_USE_INTERNAL("Use of internal policy '%1$s'.", Kind.ERROR, 208, new Mark[0]),
    POLICY_USE_WHERE_REMOVED("The WHERE condition on a USE clause was removed with version 0.14.0.", Kind.ERROR, 210, new Mark[0]),
    NAME_EMPTY("It is not allowed to define empty names.", Kind.ERROR, 301, new Mark[0]),
    NAME_CONTAINS("The '%1$s' name must not contain '%1$s'.", Kind.ERROR, 304, new Mark[0]),
    NAME_EXCEEDS_LENGTH("The '%1$s' name should have at maximum %2$d characters.", Kind.ERROR, 306, new Mark[0]),
    NAME_MUST_NOT_BE_A_KEYWORD("'%1$s' is a reserved keyword which is not allowed as identifier.", Kind.ERROR, 307, new Mark[0]),
    NAME_FORMAT_VIOLATED("The identifier '%1$s' contains not allowed characters.", Kind.ERROR, 308, new Mark[0]),
    EXPR_RESTRICTION_MISSING_IDENTIFIER("The restriction must refer to an identifier", Kind.ERROR, 400, new Mark[0]),
    EXPR_RESTRICTION_ON_ARRAY("It is not possible to define restrictions on arrays.", Kind.ERROR, 401, new Mark[0]),
    EXPR_RESTRICTION_ON_STRUCT("It is not possible to define restrictions on structs.", Kind.ERROR, 402, new Mark[0]),
    EXPR_NULLCHECK_MISSING_IDENTIFIER("Apply a null check on an identifier", Kind.ERROR, 403, new Mark[0]),
    EXPR_IN_ON_ARRAY("It is not possible to use array type for IN check.", Kind.ERROR, 420, new Mark[0]),
    EXPR_IN_ON_INCOMPATIBLE_TYPES("It is not possible to use a '%1$s' type for IN check on '%2$s' type.", Kind.ERROR, 421, new Mark[0]),
    EXPR_COMPARE_ON_INCOMPATIBLE_TYPES("It is not possible to compare a '%1$s' type with a '%2$s' type.", Kind.ERROR, 440, new Mark[0]),
    EXPR_LIKE_WRONG_TYPE("It is not possible to use LIKE with a '%1$s' type. Use a string.", Kind.ERROR, 460, new Mark[0]),
    EXPR_BETWEEN_BOUNDARY_TYPES_DIFFER("Different types for lower '%1$s' and upper '%2$s' boundary.", Kind.ERROR, 480, new Mark[0]),
    EXPR_BETWEEN_INCOMPATIBLE_TYPE("It is not possible to use '%1$s' type for between check with '%2$s' type.", Kind.ERROR, 481, new Mark[0]),
    EXPR_BETWEEN_WRONG_TYPE("It is not possible to use '%1$s' type for between check.", Kind.ERROR, 482, new Mark[0]),
    EXPR_BETWEEN_WRONG_ARRAY_TYPE("It is not possible to use array type for between check", Kind.ERROR, 483, new Mark[0]),
    EXPR_OPERAND_NOT_OF_TYPE("The operand is of type '%1$s' but type '%2$s' is expected", Kind.ERROR, 484, new Mark[0]),
    EXPR_WHERE_NOT_BOOLEAN("The WHERE condition must be of type boolean but was '%1$s'.", Kind.ERROR, 485, new Mark[0]),
    EXPR_CALL_INTERNAL("Call of internal function '%1$s'.", Kind.ERROR, 486, new Mark[0]),
    EXPR_WITH_INTERMEDIATE_VALUES("Expression with intermediate values. Cannot be representes currently in runtime.", Kind.ERROR, 487, new Mark[0]),
    EXPR_IS_TRUE("The expression is always true.", Kind.WARNING, 500, new Mark[0]),
    EXPR_IS_FALSE("The expression is always false.", Kind.WARNING, 501, new Mark[0]),
    EXPR_IS_NOT_NOLL_CHECK("The expression is an IS NOT NULL check for %1$s'.", Kind.WARNING, 502, new Mark[0]),
    RULE_WITHOUT_ON("Rule must contain 'ON <<resource>>' specification. At least ON * is required.", Kind.ERROR, 600, new Mark[0]),
    RULE_FORBIDDEN_VIOLATION("Admin policy contains GRANT even though onlycompositionandrestriction flag is set", Kind.ERROR, 601, new Mark[0]),
    JMAP_ENTRY_DUPLICATE("The '%1$s' structure attribute is already assigned.", Kind.ERROR, 800, new Mark[0]),
    JMAP_ENTRY_ASSIGN_WRONG_TYPE("It is not possible to assign '%1$s' type to '%2$s' type.", Kind.ERROR, 801, new Mark[0]),
    TEST_SCENARIO_DUPLICATE("The '%1$s' test is already defined.", Kind.ERROR, 850, new Mark[0]),
    TEST_CASE_WITH_EXPRESSION("The test case expects an expression as result. This is not supported by the current engine.", Kind.INFO, 903, new Mark[0]),
    SCHEMA_ATTRIBUTE_DUPLICATE("The '%1$s' schema attribute is already defined.", Kind.ERROR, 950, new Mark[0]),
    SCHEMA_SINGLE_TENANT("Tenant schema for '%1$s' not allowed in singe tenant mode.", Kind.ERROR, 951, new Mark[0]),
    SCHEMA_TENANT_NAME_EMPTY("Empty tenant name not allowed.", Kind.ERROR, 952, new Mark[0]),
    TEST_DOCUMENT_CONTAINS_SCHEMA("It is not allowed to define a schema in the DCL test document.", Kind.ERROR, 1000, new Mark[0]),
    TEST_DOCUMENT_CONTAINS_POLICY("It is not allowed to define the '%1$s' policy in the DCL test document.", Kind.ERROR, 1001, new Mark[0]),
    TEST_DOCUMENT_CONTAINS_FUNCTION("It is not allowed to define the '%1$s' function in the DCL test document.", Kind.ERROR, 1002, new Mark[0]),
    SCHEMA_ELEMENT_RESERVED("The '%1$s' schema sttribute name is not allowed (internal usage).", Kind.ERROR, 1050, new Mark[0]),
    SCHEMA_ELEMENT_NOT_STRUCT("The '%1$s' schema attribute must have the struct type.", Kind.ERROR, 1051, new Mark[0]),
    SCHEMA_ELEMENT_BETA_DOLLAR_PREFIX("The '%1$s' schema sttribute is prefixed with $. Note: This is a beta feature. The function might be different in the future.", Kind.INFO, 1052, new Mark[0]),
    DCL_FILE_NOT_IN_SOURCE_FOLDER("The DCL file is not within in a source folder.", Kind.ERROR, 1100, new Mark[0]),
    DCL_FILE_ON_ROOT("The file '%s' is on root level but must be placed in a package.", Kind.ERROR, 1101, new Mark[0]),
    DCL_FILE_CONTAINS("The file name '%s' must not contain '%2$s'.", Kind.ERROR, 1102, new Mark[0]),
    DCL_FILE_ENDS_WITH("The file name '%s' must end with '%2$s'.", Kind.ERROR, 1103, new Mark[0]),
    DCL_FILE_EQUALS("The file name '%s' is reserved.", Kind.ERROR, 1104, new Mark[0]),
    DCL_PACKAGE_CONTAINS("The package name '%s' must not contain '%2$s'.", Kind.ERROR, 1105, new Mark[0]),
    DCL_PACKAGE_DOES_NOT_MATCH("The package names '%s' must match the pattern [A-Za-z_][A-Za-z0-9_]* .", Kind.ERROR, 1106, new Mark[0]),
    DCL_PACKAGE_START_WITH("The package name '%s' must not start with '%2$s'.", Kind.ERROR, 1107, new Mark[0]),
    DCL_FILE_DOES_NOT_MATCH("The file name '%s' must match the pattern [A-Za-z_][A-Za-z0-9_]* .", Kind.ERROR, 1108, new Mark[0]),
    DCL_FILE_CONTAINS_MORE_THAN_ONE_ENTITY("The file '%s' contains more than one entity but the oneentitypertenantdocument flag doesn't allow this.", Kind.ERROR, 1109, new Mark[0]),
    DCL_LOCAL_PACKAGE_NO_NESTED("The DCL local package name must not nested packages '%1$s'.", Kind.ERROR, 1110, new Mark[0]),
    DCL_LOCAL_PACKAGE_CASING("The DCL local package name must be lowercase but was '%1$s'.", Kind.ERROR, 1111, new Mark[0]),
    DCL_LOCAL_PACKAGE_REFERENCE("References into local package are prohibited.", Kind.ERROR, 1112, new Mark[0]),
    FUNCTION_DUPLICATE("The '%1$s' function is already defined.", Kind.ERROR, 1200, new Mark[0]),
    FUNCTION_RECURSIVE("The '%1$s' function is used recursively.", Kind.ERROR, 1201, new Mark[0]),
    FUNCTION_RETURNS_WRONG_TYPE("The '%1$s' function must return a '%2$s' type result but returns a '%3$s' type result.", Kind.ERROR, 1203, new Mark[0]),
    FUNCTION_RETURN_TYPE_ARRAY("The '%1$s' function must not return an array (current constraint).", Kind.ERROR, 1204, new Mark[0]),
    FUNCTION_INTERNAL("Internal '%1$s' function not permitted for tenants.", Kind.ERROR, 1205, new Mark[0]),
    FUNCTION_CONTAINS_RESTRICTED("Restriction found in function '%1$s', this is not allowed.", Kind.ERROR, 1206, new Mark[0]),
    ANNOTATION_DEFAULT_DEPRECATED("The @default annotation is deprecated.", Kind.WARNING, 1250, Mark.DEPRECATED),
    ANNOTATION_DEFAULT_DUPLICATE("The @default annotation is deprecated (please remove) and DEFAULT keyword is used.", Kind.ERROR, 1251, new Mark[0]),
    ANNOTATION_DUPLICATE("The annotation with name '%1$s' is already specified.", Kind.ERROR, 1252, new Mark[0]),
    ANNOTATION_VH_WRONG_TYPE("The @valueHelp annotation must be either '@valueHelp: false' or '@valueHelp: { ... }.'", Kind.ERROR, 1253, new Mark[0]),
    ANNOTATION_VH_ILLEGAL_MENBER("The @valueHelp element '%1$s' is not supported. It must be either 'path', 'valueField', 'labelField' or 'filters'.", Kind.ERROR, 1254, new Mark[0]),
    ANNOTATION_VH_VALUE_WRONG_TYPE("The @valueHelp argument for element '%1$s' must be of type '%2$s'.", Kind.ERROR, 1255, new Mark[0]),
    ANNOTATION_VH_FILTERS_MUST_CONTAIN_ONLY_STRINGS("The @valueHelp structure for 'filters' contains an invalid element. Both keys and values must be strings.", Kind.ERROR, 1256, new Mark[0]),
    ANNOTATION_INTERNAL_DEPRECATED("The @internal annotation is deprecated.", Kind.WARNING, 1257, Mark.DEPRECATED),
    ANNOTATION_INTERNAL_DUPLICATE("The @internal annotation is deprecated (please remove) and replace with INTERNAL keyword.", Kind.ERROR, 1258, new Mark[0]);

    private final String message;
    private final Kind kind;
    private final int errorCode;
    private final String errorCodeStr;
    private final boolean isDeprecated;

    public static DCLIssue getIssueByCode(String codeString) {
        DCLIssue res = Helper.NUMBER_TO_ISSUE.get(codeString);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("No enum constant " + DCLIssue.class.getCanonicalName() + " for Code: " + codeString);
    }

    public static DCLIssue getIssueByCodeOrDefault(String codeString, DCLIssue defaultIssue) {
        return Helper.NUMBER_TO_ISSUE.getOrDefault(codeString, defaultIssue);
    }

    private DCLIssue(String message, Kind kind, int errorCode, Mark ... marks) {
        this.message = message;
        this.kind = kind;
        this.errorCode = errorCode;
        this.errorCodeStr = Integer.toString(errorCode);
        this.isDeprecated = Arrays.contains(marks, Mark.DEPRECATED);
        Helper.check(this);
    }

    public String format(Object ... args) {
        return String.format(this.message, args);
    }

    public String getMessage() {
        return this.message;
    }

    public Kind getKind() {
        return this.kind;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorCodeStr() {
        return this.errorCodeStr;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    private static class Helper {
        private static final Map<String, DCLIssue> NUMBER_TO_ISSUE = new HashMap<String, DCLIssue>();

        private Helper() {
        }

        public static void check(DCLIssue issue) {
            if (NUMBER_TO_ISSUE.put(issue.getErrorCodeStr(), issue) != null) {
                throw new IllegalStateException("Definition errorCode " + issue.getErrorCodeStr() + " already assigned.");
            }
        }
    }

    public static enum Kind {
        ERROR,
        WARNING,
        INFO;

    }

    public static enum Mark {
        DEPRECATED;

    }
}

