/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.validation;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.sap.cloud.security.ams.dcl.DCLMtTools;
import com.sap.cloud.security.ams.dcl.DCLNameTools;
import com.sap.cloud.security.ams.dcl.DCLStringProcessing;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.DCLType;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.AnnotatedElement;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Annotation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguagePackage;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Expression;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionAnd;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionBetween;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionBoolean;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionCall;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionConstant;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIdentifier;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIn;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIsNull;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIsRestricted;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionLike;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionOr;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionRelational;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionString;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.FunctionDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JMap;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JMapEntry;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JSONObject;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JSONObjectEntry;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.NamedElement;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDocument;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyUse;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Restriction;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.RoleRule;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Rule;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaMap;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestCase;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestCaseInput;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestScenario;
import com.sap.cloud.security.ams.dcl.support.validation.ValidationHelper;
import com.sap.cloud.security.ams.dcl.validation.DCLIssue;
import com.sap.cloud.security.ams.dcl.validation.DataControlLanguageValidatorBase;
import com.sap.cloud.security.ams.dcl.validation.NameUniquenessHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class DataControlLanguageValidator
extends DataControlLanguageValidatorBase {
    private static final int MAX_NAME_LENGTH = 512;
    private static final int MAX_POLICY_FQ_NAME_LENGTH_INFO = 80;
    private static final List<String> FORBIDDEN_NAME_CONTAINS = ImmutableList.of("___", "_dcl_");
    @Inject
    private DCLNameTools dclNameTools;
    private static final Predicate<ExpressionIsRestricted> HAS_RULE_PARENT = er -> {
        EObject eObj = er;
        while (eObj != null && !(eObj instanceof Rule) && !(eObj instanceof RoleRule)) {
            eObj = eObj.eContainer();
        }
        return eObj != null;
    };

    private static boolean isEmptyId(String name) {
        return name != null && (name.isEmpty() || name.equals("\"\""));
    }

    private void testSchemaElementName(EStructuralFeature ref, EObject source, String name) {
        if (name == null) {
            return;
        }
        if (DataControlLanguageValidator.isEmptyId(name)) {
            this.report(DCLIssue.NAME_EMPTY, ref, source, new Object[0]);
        }
    }

    private void testRuntimeName(EStructuralFeature ref, EObject source, String name) {
        if (name == null) {
            return;
        }
        if (DataControlLanguageValidator.isEmptyId(name)) {
            this.report(DCLIssue.NAME_EMPTY, ref, source, new Object[0]);
            return;
        }
        String lcName = name.toLowerCase(Locale.US);
        for (String check : FORBIDDEN_NAME_CONTAINS) {
            if (!lcName.contains(check)) continue;
            this.report(DCLIssue.NAME_CONTAINS, ref, source, name, check);
        }
        if (name.length() > 512) {
            this.report(DCLIssue.NAME_EXCEEDS_LENGTH, ref, source, name, 512);
        }
        if (!DCLStringProcessing.isValidCharacters(name)) {
            this.report(DCLIssue.NAME_FORMAT_VIOLATED, ref, source, name);
        }
    }

    @Check
    public void checkPolicyNamesLength(PolicyDocument it) {
        EList<PolicyDefinition> policies = it.getPolicies();
        if (DCLTools.isEmpty(policies)) {
            return;
        }
        ResourceLocation rl = this.isInTenantPackage(it) ? null : this.getResourceLocation(it);
        for (PolicyDefinition pol : policies) {
            String name = pol.getName();
            if (name == null || name.length() > 512) continue;
            if (rl != null) {
                name = rl.getFullQualifiedDclName(name);
            }
            if (name.length() <= 80) continue;
            this.report(DCLIssue.POLICY_NAME_EXCEEDES_RECOMMENDED_LENGTH, (EStructuralFeature)DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, pol, name, 80);
        }
    }

    @Check
    public void checkName(PolicyDefinition it) {
        this.testRuntimeName(DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, it, it.getName());
    }

    @Check
    public void checkName(TestScenario it) {
        this.testRuntimeName(DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, it, it.getName());
    }

    @Check
    public void checkTestCase(TestCase it) {
        if (it.getExpression() != null) {
            this.report(DCLIssue.TEST_CASE_WITH_EXPRESSION, (EStructuralFeature)DataControlLanguagePackage.Literals.TEST_CASE__EXPRESSION, it, new Object[0]);
        }
    }

    @Check
    public void checkName(FunctionDefinition it) {
        this.testRuntimeName(DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, it, it.getName());
    }

    @Check
    public void checkUseIsUnique(PolicyDefinition it) {
        Map<PolicyDefinition, Long> uses = it.getUses().stream().collect(Collectors.groupingBy(pu -> pu.getPolicy(), Collectors.counting()));
        it.getUses().stream().filter(pu -> (Long)uses.get(pu.getPolicy()) > 1L).forEach(pu -> this.report(DCLIssue.POLICY_USE_DUPLICATE, (EStructuralFeature)DataControlLanguagePackage.Literals.POLICY_USE__POLICY, (EObject)pu, pu.getPolicy().getName()));
    }

    @Check
    public void checkCircularUsage(PolicyUse use) {
        PolicyDefinition ownPolicy = (PolicyDefinition)use.eContainer();
        PolicyDefinition target = use.getPolicy();
        if (target != null && this.getInformation(target).getTransitiveUse().contains(ownPolicy)) {
            PolicyDefinition policy2 = use.getPolicy();
            this.report(DCLIssue.POLICY_USE_CIRCULAR, (EStructuralFeature)DataControlLanguagePackage.Literals.POLICY_USE__POLICY, use, policy2.getName());
        }
    }

    @Check
    public void checkUseOfDefault(PolicyUse use) {
        if (DCLTools.isDefault(use.getPolicy())) {
            this.report(DCLIssue.POLICY_USE_DEFAULT_POLICY, (EStructuralFeature)DataControlLanguagePackage.Literals.POLICY_USE__POLICY, use, use.getPolicy().getName());
        }
    }

    @Check
    public void checkUnrestricted(ExpressionIsRestricted it) {
        if (!(it.getLeft() instanceof ExpressionIdentifier)) {
            this.report(DCLIssue.EXPR_RESTRICTION_MISSING_IDENTIFIER, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_IS_RESTRICTED__LEFT, it, new Object[0]);
        }
    }

    private QualifiedName getExpressionQualifiedName(Expression it) {
        if (it instanceof ExpressionIsRestricted) {
            return this.getExpressionQualifiedName(((ExpressionIsRestricted)it).getLeft());
        }
        if (it instanceof ExpressionIdentifier) {
            return this.getValidationHelper(it).getQualifiedName(((ExpressionIdentifier)it).getSchemaAttribute());
        }
        return null;
    }

    private boolean updateCheckSets(Set<QualifiedName> refined, Set<QualifiedName> sourceRestrictions, Expression ex, String usedPolicyName) {
        QualifiedName qName = this.getExpressionQualifiedName(ex);
        if (qName == null || !sourceRestrictions.contains(qName)) {
            return false;
        }
        if (!refined.add(qName)) {
            this.report(DCLIssue.POLICY_USE_RESTR_MULTIPLE_TIMES, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_IDENTIFIER__SCHEMA_ATTRIBUTE, ex, this.dclNameTools.toString(qName));
        }
        return true;
    }

    @Check
    public void checkNoRestrictionsInDefaultPolicy(PolicyDefinition it) {
        if (DCLTools.isDefault(it)) {
            for (ExpressionIsRestricted restr : EcoreUtil2.getAllContentsOfType(it, ExpressionIsRestricted.class)) {
                this.report(DCLIssue.POLICY_DEFAULT_RESTRICTION, null, restr, it.getName());
            }
        }
    }

    @Check
    public void checkNoRestrictionInFunctionDefinition(FunctionDefinition it) {
        for (ExpressionIsRestricted restr : EcoreUtil2.getAllContentsOfType(it, ExpressionIsRestricted.class)) {
            this.report(DCLIssue.FUNCTION_CONTAINS_RESTRICTED, null, restr, it.getName());
        }
    }

    @Check
    public void checkDefaultAnnotation(PolicyDefinition it) {
        Annotation defaultAnnotation = DCLTools.getFirstAnnotation(it, "default");
        if (defaultAnnotation != null) {
            if (it.isDefault()) {
                this.report(DCLIssue.ANNOTATION_DEFAULT_DUPLICATE, null, defaultAnnotation, new Object[0]);
            } else {
                this.report(DCLIssue.ANNOTATION_DEFAULT_DEPRECATED, null, defaultAnnotation, new Object[0]);
            }
        }
    }

    @Check
    public void checkInternalAnnotation(PolicyDefinition it) {
        Annotation defaultAnnotation = DCLTools.getFirstAnnotation(it, "internal");
        if (defaultAnnotation != null) {
            if (it.isInternal()) {
                this.report(DCLIssue.ANNOTATION_INTERNAL_DUPLICATE, null, defaultAnnotation, new Object[0]);
            } else {
                this.report(DCLIssue.ANNOTATION_INTERNAL_DEPRECATED, null, defaultAnnotation, new Object[0]);
            }
        }
    }

    @Check
    public void checkDuplicateAnnotation(AnnotatedElement it) {
        EList<Annotation> annotations = it.getAnnotations();
        if (DCLTools.hasContent(annotations)) {
            String key;
            HashMap<String, Annotation> seenAnnotations = new HashMap<String, Annotation>();
            for (Annotation a : annotations) {
                key = a.getId().toLowerCase(Locale.ENGLISH);
                if (seenAnnotations.containsKey(key)) {
                    seenAnnotations.put(key, null);
                    continue;
                }
                seenAnnotations.put(key, a);
            }
            for (Annotation a : annotations) {
                key = a.getId().toLowerCase(Locale.ENGLISH);
                if (seenAnnotations.get(key) == a) continue;
                this.report(DCLIssue.ANNOTATION_DUPLICATE, null, a, a.getId());
            }
        }
    }

    @Check
    public void checkRestrict(PolicyUse use) {
        if (DCLTools.isEmpty(use.getRestrictions())) {
            return;
        }
        Set<QualifiedName> sourceRestrictions = EcoreUtil2.getAllContentsOfType(use.getPolicy(), ExpressionIsRestricted.class).stream().filter(HAS_RULE_PARENT).map(this::getExpressionQualifiedName).filter(Objects::nonNull).collect(Collectors.toSet());
        if (sourceRestrictions.isEmpty()) {
            this.report(DCLIssue.POLICY_USE_RESTR_NO_PARAMETER, (EStructuralFeature)DataControlLanguagePackage.Literals.POLICY_USE__RESTRICTIONS, use, use.getPolicy().getName());
            return;
        }
        Set<PolicyDefinition> unrestrictedUse = this.getInformation((PolicyDefinition)use.eContainer()).getTransitiveUnrestrictedUse();
        if (unrestrictedUse.contains(use.getPolicy())) {
            this.report(DCLIssue.POLICY_USE_ALSO_UNRESTRICTED, (EStructuralFeature)DataControlLanguagePackage.Literals.POLICY_USE__POLICY, use, use.getPolicy().getName());
            return;
        }
        String usedPolicyName = use.getPolicy().getName();
        for (Restriction r : use.getRestrictions()) {
            HashSet<QualifiedName> refined = new HashSet<QualifiedName>();
            for (Expression e : r.getParameter()) {
                boolean found = this.searchPolicyParameter(sourceRestrictions, usedPolicyName, refined, e);
                if (found) continue;
                this.report(DCLIssue.POLICY_USE_MISSING_PARAMETER, null, e, new Object[0]);
            }
            HashSet unused = new HashSet(sourceRestrictions);
            unused.removeAll(refined);
            for (QualifiedName param : unused) {
                this.report(DCLIssue.POLICY_USE_RESTR_NOT_OVERWRITTEN, null, r, this.dclNameTools.toString(param));
            }
        }
    }

    private boolean searchPolicyParameter(Set<QualifiedName> sourceRestrictions, String usedPolicyName, Set<QualifiedName> refined, Expression e) {
        boolean found;
        if (e instanceof ExpressionRelational) {
            ExpressionRelational ex = (ExpressionRelational)e;
            found = this.updateCheckSets(refined, sourceRestrictions, ex.getLeft(), usedPolicyName);
            found = this.updateCheckSets(refined, sourceRestrictions, ex.getRight(), usedPolicyName) || found;
        } else if (e instanceof ExpressionLike) {
            ExpressionLike ex = (ExpressionLike)e;
            found = this.updateCheckSets(refined, sourceRestrictions, ex.getLeft(), usedPolicyName);
        } else if (e instanceof ExpressionIn) {
            ExpressionIn ex = (ExpressionIn)e;
            found = this.updateCheckSets(refined, sourceRestrictions, ex.getLeft(), usedPolicyName);
        } else if (e instanceof ExpressionBetween) {
            ExpressionBetween ex = (ExpressionBetween)e;
            found = this.updateCheckSets(refined, sourceRestrictions, ex.getLeft(), usedPolicyName);
        } else if (e instanceof ExpressionIsNull) {
            ExpressionIsNull ex = (ExpressionIsNull)e;
            found = this.updateCheckSets(refined, sourceRestrictions, ex.getLeft(), usedPolicyName);
        } else if (e instanceof ExpressionIsRestricted) {
            ExpressionIsRestricted ex = (ExpressionIsRestricted)e;
            found = this.updateCheckSets(refined, sourceRestrictions, ex.getLeft(), usedPolicyName);
        } else {
            found = false;
        }
        return found;
    }

    @Check
    public void checkDocument(FunctionDefinition it) {
        if (it.isArray()) {
            this.report(DCLIssue.FUNCTION_RETURN_TYPE_ARRAY, null, it, it.getName());
        }
    }

    @Check
    public void checkDocument(PolicyDocument doc) {
        String name;
        boolean isTestSuffix;
        ResourceLocation pr = this.getResourceLocation(doc);
        if (pr.hasIssue()) {
            this.report(pr.getMessage(), pr.getIssue(), null, doc);
            return;
        }
        boolean hasSchema = this.hasAtLeastOneGlobalSchema(doc);
        if (!hasSchema) {
            this.report(DCLIssue.SCHEMA_MISSING, null, doc, pr.getDclPackage());
        }
        if (isTestSuffix = (name = pr.getDocumentName().toLowerCase(Locale.US)).endsWith("_test")) {
            SchemaDefinition schema = doc.getSchema();
            if (schema != null) {
                this.report(DCLIssue.TEST_DOCUMENT_CONTAINS_SCHEMA, null, schema, new Object[0]);
            }
            for (PolicyDefinition p : doc.getPolicies()) {
                this.report(DCLIssue.TEST_DOCUMENT_CONTAINS_POLICY, null, p, p.getName());
            }
            for (FunctionDefinition f : doc.getFunctions()) {
                this.report(DCLIssue.TEST_DOCUMENT_CONTAINS_FUNCTION, null, f, f.getName());
            }
        }
    }

    @Check
    public void checkTenantSchema(SchemaDefinition sd) {
        if (sd.isTenant()) {
            if (!DCLMtTools.isMtSupport(this.cra)) {
                this.report(DCLIssue.SCHEMA_SINGLE_TENANT, null, sd, sd.getName());
            } else if (DCLTools.isEmpty(sd.getName())) {
                this.report(DCLIssue.SCHEMA_TENANT_NAME_EMPTY, null, sd, new Object[0]);
            }
        }
    }

    private void checkSchemaElementNames(List<SchemaAttribute> elements) {
        if (DCLTools.isEmpty(elements)) {
            return;
        }
        NameUniquenessHelper.check(elements, NamedElement::getName, (qn, se) -> this.report(DCLIssue.SCHEMA_ATTRIBUTE_DUPLICATE, (EStructuralFeature)DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, (EObject)se, se.getName()));
        for (SchemaAttribute se2 : elements) {
            SchemaMap nested;
            if (se2.getType() != null && (nested = se2.getType().getNested()) != null) {
                this.checkSchemaElementNames(nested.getEntries());
            }
            this.testSchemaElementName(DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, se2, se2.getName());
        }
    }

    private void checkTopLevelSchemaElementNamesDollarType(List<SchemaAttribute> elements) {
        if (DCLTools.isEmpty(elements)) {
            return;
        }
        for (SchemaAttribute se : elements) {
            String name = se.getName();
            DCLStringProcessing.SegmentType segmentType = DCLStringProcessing.getSegmentType(name);
            if (se.getType() == null || segmentType == DCLStringProcessing.SegmentType.APP) continue;
            if (DCLTools.RESERVED_SECTIONS.contains(name)) {
                this.report(DCLIssue.SCHEMA_ELEMENT_RESERVED, (EStructuralFeature)DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, se, name);
            } else if (!DCLTools.ALLOWED_SECTIONS.contains(name)) {
                this.report(DCLIssue.SCHEMA_ELEMENT_BETA_DOLLAR_PREFIX, (EStructuralFeature)DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, se, name);
            }
            SchemaMap nested = se.getType().getNested();
            if (nested != null) continue;
            this.report(DCLIssue.SCHEMA_ELEMENT_NOT_STRUCT, (EStructuralFeature)DataControlLanguagePackage.Literals.SCHEMA_ATTRIBUTE__TYPE, se, name);
        }
    }

    private void checkJMapNamesUnique(JMap it) {
        if (it == null) {
            return;
        }
        NameUniquenessHelper.check(it.getEntries(), e -> e.getSchemaAttribute().getName(), (qn, e) -> this.report(DCLIssue.JMAP_ENTRY_DUPLICATE, (EStructuralFeature)DataControlLanguagePackage.Literals.JMAP_ENTRY__SCHEMA_ATTRIBUTE, (EObject)e, e.getSchemaAttribute().getName()));
        for (JMapEntry e2 : it.getEntries()) {
            if (!(e2.getValue() instanceof JMap)) continue;
            this.checkJMapNamesUnique((JMap)e2.getValue());
        }
    }

    @Check
    public void checkSchemaNamesUnique(SchemaDefinition it) {
        this.checkSchemaElementNames(it.getEntries());
        this.checkTopLevelSchemaElementNamesDollarType(it.getEntries());
    }

    @Check
    public void checkSchemaNamesUnique(TestCaseInput it) {
        this.checkJMapNamesUnique(it.getMap());
    }

    @Check(value=CheckType.NORMAL)
    public void checkGlobalSchemaFile(PolicyDocument pd) {
        boolean isSchemaFile;
        SchemaDefinition schema = pd.getSchema();
        if (schema != null && schema.isTenant()) {
            return;
        }
        URI uri = pd.eResource().getURI();
        boolean bl = isSchemaFile = uri.lastSegment().equals("schema.dcl") || uri.lastSegment().equals("schema.dcn");
        if (isSchemaFile) {
            ResourceLocation res;
            if (DCLTools.hasContent(pd.getFunctions()) || DCLTools.hasContent(pd.getPolicies()) || DCLTools.hasContent(pd.getTestScenarios())) {
                this.report(DCLIssue.SCHEMA_ONLY, null, pd, new Object[0]);
            }
            if (schema != null && !(res = this.getResourceLocation(pd)).hasIssue() && !res.getPath().isEmpty()) {
                this.report(DCLIssue.SCHEMA_MISLOCATED, null, schema, new Object[0]);
            }
        } else if (schema != null) {
            this.report(DCLIssue.SCHEMA_MISLOCATED, null, schema, new Object[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void warnRuleWithoutResource(Rule it) {
        if (it.getResources() == null) {
            this.report(DCLIssue.RULE_WITHOUT_ON, null, it, new Object[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkRuleWhere(Rule it) {
        DCLType type;
        if (it.getCondition() != null && (type = DCLTools.getExpressionType(it.getCondition())) != DCLType.Boolean && type != DCLType.UNRESOLVED) {
            this.report(DCLIssue.EXPR_WHERE_NOT_BOOLEAN, (EStructuralFeature)DataControlLanguagePackage.Literals.RULE__CONDITION, it, new Object[]{type});
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkRuleWhere(RoleRule it) {
        DCLType type;
        if (it.getCondition() != null && (type = DCLTools.getExpressionType(it.getCondition())) != DCLType.Boolean && type != DCLType.UNRESOLVED) {
            this.report(DCLIssue.EXPR_WHERE_NOT_BOOLEAN, (EStructuralFeature)DataControlLanguagePackage.Literals.ROLE_RULE__CONDITION, it, new Object[]{type});
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkFunctionNotRecursive(FunctionDefinition it) {
        if (this.getInformation(it).isRecursive()) {
            this.report(DCLIssue.FUNCTION_RECURSIVE, (EStructuralFeature)DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, it, it.getName());
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkUniqueSchema(SchemaDefinition it) {
        if (!this.isUnique(it)) {
            this.report(DCLIssue.SCHEMA_DUPLICATE, null, it, new Object[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkUniquePolicy(PolicyDefinition it) {
        if (it.getName() != null && !this.isUnique(it)) {
            this.report(DCLIssue.POLICY_DUPLICATE, (EStructuralFeature)DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, it, it.getName());
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkUniqueFunction(FunctionDefinition it) {
        if (it.getName() != null && !this.isUnique(it)) {
            this.report(DCLIssue.FUNCTION_DUPLICATE, (EStructuralFeature)DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, it, it.getName());
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkUniqueTestScenario(TestScenario it) {
        if (it.getName() != null && !this.isUnique(it)) {
            this.report(DCLIssue.TEST_SCENARIO_DUPLICATE, (EStructuralFeature)DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, it, it.getName());
        }
    }

    @Check
    public void checkTypeCompatibility(ExpressionRelational it) {
        DCLType l = DCLTools.getExpressionType(it.getLeft());
        DCLType r = DCLTools.getExpressionType(it.getRight());
        if (l.isArray() || r.isArray() || l != r) {
            this.report(DCLIssue.EXPR_COMPARE_ON_INCOMPATIBLE_TYPES, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_RELATIONAL__OPERATOR, it, l.toString(), r.toString());
        }
    }

    @Check
    public void checkTypeCompatibility(ExpressionLike it) {
        DCLType l = DCLTools.getExpressionType(it.getLeft());
        if (l != DCLType.String) {
            this.report(DCLIssue.EXPR_LIKE_WRONG_TYPE, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_LIKE__LEFT, it, l.toString());
        }
    }

    @Check
    public void checkTypeCompatibility(ExpressionIsRestricted it) {
        DCLType l = DCLTools.getExpressionType(it.getLeft());
        if (l.isArray()) {
            this.report(DCLIssue.EXPR_RESTRICTION_ON_ARRAY, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_IS_RESTRICTED__LEFT, it, new Object[0]);
        }
        if (l == DCLType.Structure) {
            this.report(DCLIssue.EXPR_RESTRICTION_ON_STRUCT, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_IS_RESTRICTED__LEFT, it, new Object[0]);
        }
    }

    @Check
    public void checkTypeCompatibility(ExpressionIsNull it) {
        if (!(it.getLeft() instanceof ExpressionIdentifier)) {
            this.report(DCLIssue.EXPR_NULLCHECK_MISSING_IDENTIFIER, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_IS_NULL__LEFT, it, new Object[0]);
        }
    }

    @Check
    public void checkTypeCompatibility(ExpressionIn it) {
        Expression left = it.getLeft();
        DCLType l = DCLTools.getExpressionType(left);
        DCLType r = DCLTools.getExpressionType(it.getRight());
        if (l.isArray()) {
            this.report(DCLIssue.EXPR_IN_ON_ARRAY, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_IN__LEFT, it, new Object[0]);
            return;
        }
        if (r == DCLType.EmptyArray) {
            if (it.isNot()) {
                if (left instanceof ExpressionIdentifier) {
                    String name = String.valueOf(this.getExpressionQualifiedName(left));
                    this.report(DCLIssue.EXPR_IS_NOT_NOLL_CHECK, null, it, name);
                } else {
                    this.report(DCLIssue.EXPR_IS_TRUE, null, it, new Object[0]);
                }
            } else {
                this.report(DCLIssue.EXPR_IS_FALSE, null, it, new Object[0]);
            }
        } else if (l.getArrayType() != r) {
            this.report(DCLIssue.EXPR_IN_ON_INCOMPATIBLE_TYPES, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_IN__LEFT, it, l.toString(), r.toString());
        }
    }

    @Check
    public void checkTypeCompatibility(ExpressionBetween it) {
        DCLType up;
        DCLType l = DCLTools.getExpressionType(it.getLeft());
        DCLType lo = DCLTools.getExpressionType(it.getLower());
        if (lo != (up = DCLTools.getExpressionType(it.getUpper()))) {
            this.report(DCLIssue.EXPR_BETWEEN_BOUNDARY_TYPES_DIFFER, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_BETWEEN__LOWER, it, lo.toString(), up.toString());
        } else if (l != lo) {
            this.report(DCLIssue.EXPR_BETWEEN_INCOMPATIBLE_TYPE, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_BETWEEN__LOWER, it, l.toString(), lo.toString());
        }
        if (l == DCLType.Boolean) {
            this.report(DCLIssue.EXPR_BETWEEN_WRONG_TYPE, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_BETWEEN__LEFT, it, l.toString());
        }
        if (l.isArray()) {
            this.report(DCLIssue.EXPR_BETWEEN_WRONG_ARRAY_TYPE, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_BETWEEN__LEFT, it, l.toString());
        } else if (lo.isArray()) {
            this.report(DCLIssue.EXPR_BETWEEN_WRONG_ARRAY_TYPE, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_BETWEEN__LOWER, it, lo.toString());
        } else if (up.isArray()) {
            this.report(DCLIssue.EXPR_BETWEEN_WRONG_ARRAY_TYPE, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_BETWEEN__UPPER, it, up.toString());
        }
    }

    @Check
    public void checkTypeCompatibility(JMapEntry it) {
        DCLType r;
        DCLType l = DCLTools.getExpressionType(it.getSchemaAttribute());
        if (l == (r = DCLTools.getExpressionType(it.getValue())) || l.isArray() && r == DCLType.EmptyArray || r == DCLType.Null) {
            return;
        }
        if (r == DCLType.IGNORE || r == DCLType.UNKNOWN) {
            return;
        }
        this.report(DCLIssue.JMAP_ENTRY_ASSIGN_WRONG_TYPE, (EStructuralFeature)DataControlLanguagePackage.Literals.JMAP_ENTRY__VALUE, it, r.toString(), l.toString());
    }

    @Check
    public void checkFunctionDefinition(FunctionDefinition it) {
        DCLType definedResult = DCLType.fromDataType(it.getDataType(), it.isArray());
        DCLType actualResult = DCLTools.getExpressionType(it.getResult());
        if (actualResult != definedResult) {
            this.report(DCLIssue.FUNCTION_RETURNS_WRONG_TYPE, (EStructuralFeature)DataControlLanguagePackage.Literals.FUNCTION_DEFINITION__RESULT, it, new Object[]{it.getName(), definedResult, actualResult});
        }
    }

    private void doCheckType(Expression root, EReference ref, Expression e) {
        DCLType eType = DCLTools.getExpressionType(e);
        if (eType != DCLType.Boolean) {
            this.report(DCLIssue.EXPR_OPERAND_NOT_OF_TYPE, (EStructuralFeature)ref, root, new Object[]{eType, DCLType.Boolean});
        }
    }

    @Check
    public void checkExpressionAnd(ExpressionAnd it) {
        for (Expression e : it.getAndList()) {
            this.doCheckType(it, DataControlLanguagePackage.Literals.EXPRESSION_AND__AND_LIST, e);
        }
    }

    @Check
    public void checkExpressionOr(ExpressionOr it) {
        for (Expression e : it.getOrList()) {
            this.doCheckType(it, DataControlLanguagePackage.Literals.EXPRESSION_OR__OR_LIST, e);
        }
    }

    @Check
    public void checkPolicyReferencesInternalPolicy(PolicyUse use) {
        PolicyDefinition usedPolicy = use.getPolicy();
        if (DCLTools.isInternal(usedPolicy)) {
            this.report(DCLIssue.POLICY_USE_INTERNAL, (EStructuralFeature)DataControlLanguagePackage.Literals.POLICY_USE__POLICY, use, usedPolicy.getName());
        }
    }

    @Check
    public void checkExpressionCallInternalFunction(ExpressionCall it) {
        FunctionDefinition fd = it.getLeft();
        if (this.isInTenantPackage(it) && this.isInBasePackage(fd) && DCLTools.isInternal(fd)) {
            this.report(DCLIssue.EXPR_CALL_INTERNAL, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_CALL__LEFT, it, fd.getName());
        }
    }

    @Check
    public void checkInternalFunction(FunctionDefinition it) {
        if (this.isInTenantPackage(it) && DCLTools.isInternal(it)) {
            this.report(DCLIssue.FUNCTION_INTERNAL, null, it, it.getName());
        }
    }

    @Check
    public void checkInternalPolicy(PolicyDefinition it) {
        if (this.isInTenantPackage(it) && DCLTools.isInternal(it)) {
            this.report(DCLIssue.POLICY_INTERNAL, null, it, it.getName());
        }
    }

    @Check
    public void checkInternalPolicyAndDefault(PolicyDefinition it) {
        if (DCLTools.isInternal(it) && DCLTools.isDefault(it)) {
            this.report(DCLIssue.POLICY_INTERNAL_DEFAULT, null, it, it.getName());
        }
    }

    @Check
    public void checkExpressionCallComplexity(ExpressionRelational it) {
        ValidationHelper vh = this.getValidationHelper(it);
        if (vh.isComplexExpression(it.getLeft())) {
            this.report(DCLIssue.EXPR_WITH_INTERMEDIATE_VALUES, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_RELATIONAL__LEFT, it, new Object[0]);
        }
        if (vh.isComplexExpression(it.getRight())) {
            this.report(DCLIssue.EXPR_WITH_INTERMEDIATE_VALUES, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_RELATIONAL__RIGHT, it, new Object[0]);
        }
    }

    @Check
    public void checkExpressionCallComplexity(ExpressionIn it) {
        if (this.getValidationHelper(it).isComplexExpression(it.getLeft())) {
            this.report(DCLIssue.EXPR_WITH_INTERMEDIATE_VALUES, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_IN__LEFT, it, new Object[0]);
        }
    }

    @Check
    public void checkExpressionCallComplexity(ExpressionBetween it) {
        if (this.getValidationHelper(it).isComplexExpression(it.getLeft())) {
            this.report(DCLIssue.EXPR_WITH_INTERMEDIATE_VALUES, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_BETWEEN__LEFT, it, new Object[0]);
        }
    }

    @Check
    public void checkExpressionCallComplexity(ExpressionIsNull it) {
        if (this.getValidationHelper(it).isComplexExpression(it.getLeft())) {
            this.report(DCLIssue.EXPR_WITH_INTERMEDIATE_VALUES, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_IS_NULL__LEFT, it, new Object[0]);
        }
    }

    @Check
    public void checkExpressionCallComplexity(ExpressionIsRestricted it) {
        if (this.getValidationHelper(it).isComplexExpression(it.getLeft())) {
            this.report(DCLIssue.EXPR_WITH_INTERMEDIATE_VALUES, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_IS_RESTRICTED__LEFT, it, new Object[0]);
        }
    }

    @Check
    public void checkOneEntityPerTenantDocument(PolicyDocument it) {
        if (!this.cra.get().getCompilerParameter().isOnlyOneEntityPerTenant() || !this.getValidationHelper(it).isInTenantPackage(it)) {
            return;
        }
        int entities = 0;
        if (it.getSchema() != null) {
            ++entities;
        }
        entities += DCLTools.count(it.getFunctions());
        entities += DCLTools.count(it.getPolicies());
        if ((entities += DCLTools.count(it.getTestScenarios())) > 1) {
            String filename = this.getValidationHelper(it).getResourceLocation(it).getDocumentName();
            this.report(DCLIssue.DCL_FILE_CONTAINS_MORE_THAN_ONE_ENTITY, null, it, filename);
        }
    }

    @Check
    public void checkKeysUnique(JSONObject it) {
        HashMap<String, JSONObjectEntry> entries = new HashMap<String, JSONObjectEntry>();
        for (JSONObjectEntry entry : it.getEntries()) {
            String key = entry.getElement();
            if (entries.containsKey(key)) {
                JSONObjectEntry old = (JSONObjectEntry)entries.get(key);
                if (old != null) {
                    this.report(DCLIssue.JMAP_ENTRY_DUPLICATE, (EStructuralFeature)DataControlLanguagePackage.Literals.JSON_OBJECT_ENTRY__ELEMENT, old, key);
                    entries.put(key, null);
                }
                this.report(DCLIssue.JMAP_ENTRY_DUPLICATE, (EStructuralFeature)DataControlLanguagePackage.Literals.JSON_OBJECT_ENTRY__ELEMENT, entry, key);
                continue;
            }
            entries.putIfAbsent(key, entry);
        }
    }

    @Check
    public void checkSchemaElementAnnotations(SchemaAttribute it) {
        Annotation ann;
        block19: {
            ann = DCLTools.getFirstAnnotation(it, "valueHelp");
            if (ann == null) {
                return;
            }
            ExpressionConstant val = ann.getValue();
            if (val instanceof ExpressionBoolean) {
                return;
            }
            if (!(val instanceof JSONObject)) break block19;
            JSONObject jo = (JSONObject)val;
            block10: for (JSONObjectEntry joe : jo.getEntries()) {
                switch (joe.getElement()) {
                    case "labelField": 
                    case "path": 
                    case "valueField": {
                        if (joe.getValue() instanceof ExpressionString) continue block10;
                        this.report(DCLIssue.ANNOTATION_VH_VALUE_WRONG_TYPE, (EStructuralFeature)DataControlLanguagePackage.Literals.JSON_OBJECT_ENTRY__VALUE, joe, joe.getElement(), "string");
                        break;
                    }
                    case "filters": {
                        if (!(joe.getValue() instanceof JSONObject)) {
                            this.report(DCLIssue.ANNOTATION_VH_VALUE_WRONG_TYPE, (EStructuralFeature)DataControlLanguagePackage.Literals.JSON_OBJECT_ENTRY__VALUE, joe, joe.getElement(), "structure");
                            break;
                        }
                        JSONObject filters = (JSONObject)joe.getValue();
                        for (JSONObjectEntry entry : filters.getEntries()) {
                            if (entry.getValue() instanceof ExpressionString) continue;
                            this.report(DCLIssue.ANNOTATION_VH_FILTERS_MUST_CONTAIN_ONLY_STRINGS, (EStructuralFeature)DataControlLanguagePackage.Literals.JSON_OBJECT_ENTRY__VALUE, entry, new Object[0]);
                        }
                        continue block10;
                    }
                    default: {
                        this.report(DCLIssue.ANNOTATION_VH_ILLEGAL_MENBER, (EStructuralFeature)DataControlLanguagePackage.Literals.JSON_OBJECT_ENTRY__ELEMENT, joe, joe.getElement());
                    }
                }
            }
            return;
        }
        this.report(DCLIssue.ANNOTATION_VH_WRONG_TYPE, null, ann, new Object[0]);
    }

    @Check
    public void checkOnlyCompositionAndRestriction(Rule it) {
        if (!this.cra.get().getCompilerParameter().isOnlyPolicyRefinements() || !this.isInTenantPackage(it)) {
            return;
        }
        this.report(DCLIssue.RULE_FORBIDDEN_VIOLATION, null, it, new Object[0]);
    }

    @Check
    public void checkOnlyCompositionAndRestriction(RoleRule it) {
        if (!this.cra.get().getCompilerParameter().isOnlyPolicyRefinements() || !this.isInTenantPackage(it)) {
            return;
        }
        this.report(DCLIssue.RULE_FORBIDDEN_VIOLATION, null, it, new Object[0]);
    }

    @Check
    public void checkUseDeprecatedWhere(PolicyUse it) {
        if (it.getCondition() == null) {
            return;
        }
        this.report(DCLIssue.POLICY_USE_WHERE_REMOVED, (EStructuralFeature)DataControlLanguagePackage.Literals.POLICY_USE__CONDITION, it, new Object[0]);
    }

    private boolean isIllegalReferenceToLocal(EObject from, EObject target) {
        return this.getResourceLocation(target).isInLocalPackage() && !this.getResourceLocation(from).isInLocalPackage();
    }

    @Check
    public void checkLocalUse(PolicyUse it) {
        if (this.isIllegalReferenceToLocal(it, it.getPolicy())) {
            this.report(DCLIssue.DCL_LOCAL_PACKAGE_REFERENCE, (EStructuralFeature)DataControlLanguagePackage.Literals.POLICY_USE__POLICY, it, new Object[0]);
        }
    }

    @Check
    public void checkLocalFunction(ExpressionCall it) {
        if (this.isIllegalReferenceToLocal(it, it.getLeft())) {
            this.report(DCLIssue.DCL_LOCAL_PACKAGE_REFERENCE, (EStructuralFeature)DataControlLanguagePackage.Literals.EXPRESSION_CALL__LEFT, it, new Object[0]);
        }
    }

    @Check
    public void checkLocalTestPolicies(TestCase it) {
        if (this.getResourceLocation(it).isInLocalPackage()) {
            return;
        }
        int idx = -1;
        PolicyList pl = it.getPolicyList();
        if (pl != null) {
            for (PolicyDefinition pd : pl.getPolicies()) {
                if (!this.getResourceLocation(pd).isInLocalPackage()) continue;
                this.report(DCLIssue.DCL_LOCAL_PACKAGE_REFERENCE, (EStructuralFeature)DataControlLanguagePackage.Literals.POLICY_LIST__POLICIES, idx, pl, new Object[0]);
            }
        }
        idx = -1;
        pl = it.getScopeFilter();
        if (pl != null) {
            for (PolicyDefinition pd : pl.getPolicies()) {
                ++idx;
                if (!this.getResourceLocation(pd).isInLocalPackage()) continue;
                this.report(DCLIssue.DCL_LOCAL_PACKAGE_REFERENCE, (EStructuralFeature)DataControlLanguagePackage.Literals.POLICY_LIST__POLICIES, idx, pl, new Object[0]);
            }
        }
    }
}

