/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.validation;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguagePackage;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.FunctionDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDefinition;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResultAccessor;
import com.sap.cloud.security.ams.dcl.support.validation.ValidationCache;
import com.sap.cloud.security.ams.dcl.support.validation.ValidationHelper;
import com.sap.cloud.security.ams.dcl.validation.AbstractDataControlLanguageValidator;
import com.sap.cloud.security.ams.dcl.validation.DCLIssue;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;

public class DataControlLanguageValidatorBase
extends AbstractDataControlLanguageValidator {
    @Inject
    ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    IContainer.Manager containerManager;
    @Inject
    protected DCLCompilerResultAccessor cra;
    private ValidationHelper vh;

    @Override
    protected boolean isResponsible(Map<Object, Object> context, EObject eObject) {
        boolean res = super.isResponsible(context, eObject);
        if (ValidationCache.USE_VALIDATION_INSTANCE && res) {
            this.vh = ValidationCache.getCache().getValidationHelper();
        }
        return res;
    }

    private void report(DCLIssue issue, String message, EObject source, EStructuralFeature ref, int idx) {
        String code = issue.getErrorCodeStr();
        switch (issue.getKind()) {
            case ERROR: {
                this.error(message, source, ref, idx, code, new String[0]);
                break;
            }
            case INFO: {
                this.info(message, source, ref, idx, code, new String[0]);
                break;
            }
            case WARNING: {
                this.warning(message, source, ref, idx, code, new String[0]);
                break;
            }
        }
    }

    protected void report(String message, DCLIssue issue, EStructuralFeature ref, EObject source) {
        this.report(issue, message, source, ref, -1);
    }

    protected void report(DCLIssue issue, EStructuralFeature ref, int index, EObject source, Object ... args) {
        this.report(issue, issue.format(args), source, ref, index);
    }

    protected void report(DCLIssue issue, EStructuralFeature ref, EObject source, Object ... args) {
        this.report(issue.format(args), issue, ref, source);
    }

    protected ResourceLocation getResourceLocation(EObject context) {
        return this.getValidationHelper(context).getResourceLocation(context);
    }

    protected boolean isInTenantPackage(EObject context) {
        return this.getValidationHelper(context).isInTenantPackage(context);
    }

    protected boolean isInBasePackage(EObject context) {
        return this.getValidationHelper(context).isInBasePackage(context);
    }

    protected final ValidationHelper getValidationHelper(EObject context) {
        return ValidationCache.USE_VALIDATION_INSTANCE ? this.vh : ValidationCache.getCache().getValidationHelper();
    }

    protected Iterator<IEObjectDescription> getExportedObjects(Resource resource, EClass type, QualifiedName name) {
        IResourceDescriptions index = this.resourceDescriptionsProvider.getResourceDescriptions(resource);
        IResourceDescription resourceDescription = index.getResourceDescription(resource.getURI());
        List<IContainer> visibleContainers = this.containerManager.getVisibleContainers(resourceDescription, index);
        switch (visibleContainers.size()) {
            case 0: {
                return Collections.emptyIterator();
            }
            case 1: {
                return visibleContainers.get(0).getExportedObjects(type, name, false).iterator();
            }
        }
        return Iterators.concat(Iterators.transform(visibleContainers.iterator(), vc -> vc.getExportedObjects(type, name, false).iterator()));
    }

    protected boolean isUnique(EObject eObject) {
        return this.isUnique(eObject.eClass(), eObject);
    }

    protected boolean isUnique(EClass type, EObject eObject) {
        ValidationHelper v = this.getValidationHelper(eObject);
        QualifiedName qname = v.getQualifiedName(eObject);
        if (qname == null) {
            return true;
        }
        return v.getMap(type).computeIfAbsent(qname, x -> {
            Iterator<IEObjectDescription> iterator = this.getExportedObjects(eObject.eResource(), type, qname);
            if (iterator.hasNext()) {
                iterator.next();
                return !iterator.hasNext();
            }
            return Boolean.FALSE;
        });
    }

    protected boolean hasAtLeastOneGlobalSchema(EObject root) {
        return this.getValidationHelper(root).getMap().computeIfAbsent("hasGlobalSchema", x -> this.getExportedObjects(root.eResource(), DataControlLanguagePackage.Literals.SCHEMA_DEFINITION, DCLTools.QN_ROOT_SCHEMA).hasNext());
    }

    public ValidationHelper.PolicyDefinitionInformation getInformation(PolicyDefinition obj) {
        return this.getValidationHelper(obj).getInformation(obj);
    }

    public ValidationHelper.FunctionDefinitionInformation getInformation(FunctionDefinition obj) {
        return this.getValidationHelper(obj).getInformation(obj);
    }
}

