/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

final class NameUniquenessHelper<K, T> {
    private final Map<Object, T> names = new HashMap<Object, T>();
    private final Function<T, K> keyProvider;
    private final BiConsumer<K, T> duplicateHandler;

    public NameUniquenessHelper(Function<T, K> keyProvider, BiConsumer<K, T> duplicateHandler) {
        this.keyProvider = keyProvider;
        this.duplicateHandler = duplicateHandler;
    }

    public void add(T element) {
        K name = this.keyProvider.apply(element);
        if (this.names.containsKey(name)) {
            T previous = this.names.get(name);
            if (previous != element) {
                if (previous != null) {
                    this.duplicateHandler.accept(name, previous);
                    this.names.put(name, null);
                }
                this.duplicateHandler.accept(name, element);
            }
        } else {
            this.names.put(name, element);
        }
    }

    public void addAll(Collection<? extends T> coll) {
        for (T e : coll) {
            this.add(e);
        }
    }

    public static <D, C> void check(Collection<? extends C> coll, Function<C, D> nameProvider, BiConsumer<D, C> duplicateHandler) {
        new NameUniquenessHelper<D, C>(nameProvider, duplicateHandler).addAll(coll);
    }
}

