/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.validation;

import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguagePackage;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.FunctionDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestCase;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestScenario;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerTools;
import com.sap.cloud.security.ams.dcl.generator.DCLSeverity;
import com.sap.cloud.security.ams.dcl.validation.DCLIssue;
import com.sap.cloud.security.ams.dcl.validation.DataControlLanguageValidatorBase;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.validation.Issue;

public class PartialCompileValidator
extends DataControlLanguageValidatorBase {
    private static final String POLICY = "policy";
    private static final String FUNCTION = "function";
    public static final int TRANSITIVE_ERROR_CODE = 53;
    private final Set<PolicyDefinition> erroneousPolicies = new HashSet<PolicyDefinition>();
    private final Set<FunctionDefinition> erroneousFunctions = new HashSet<FunctionDefinition>();
    private final Set<TestCase> erroneousTestCases = new HashSet<TestCase>();
    private boolean issuesProcessed = false;
    private Map<String, List<Issue>> issueMap;

    @Override
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkPolicyTransistiveIssues(PolicyDefinition it) {
        this.processIssues(it.eResource().getResourceSet());
        if (this.erroneousPolicies.contains(it)) {
            return;
        }
        for (PolicyDefinition erroneousUse : this.getErroneousUses(it)) {
            this.report(DCLIssue.TRANSITIVE_ERROR, (EStructuralFeature)DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, it, it.getName(), POLICY, erroneousUse.getName());
        }
        for (FunctionDefinition erroneousCall : this.getErroneousFunctionCalls(it)) {
            this.report(DCLIssue.TRANSITIVE_ERROR, (EStructuralFeature)DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, it, it.getName(), FUNCTION, erroneousCall.getName());
        }
    }

    @Check
    public void checkFunctionTransistiveIssues(FunctionDefinition it) {
        this.processIssues(it.eResource().getResourceSet());
        if (this.erroneousFunctions.contains(it)) {
            return;
        }
        for (FunctionDefinition erroneousCall : this.getErroneousFunctionCalls(it)) {
            this.report(DCLIssue.TRANSITIVE_ERROR, (EStructuralFeature)DataControlLanguagePackage.Literals.NAMED_ELEMENT__NAME, it, it.getName(), FUNCTION, erroneousCall.getName());
        }
    }

    @Check
    public void checkTestCaseTransistiveIssues(TestCase it) {
        this.processIssues(it.eResource().getResourceSet());
        String name = DataControlLanguagePackage.Literals.TEST_CASE.getName();
        TestScenario parent = PartialCompileValidator.computeParent(it, TestScenario.class);
        if (parent != null) {
            name = parent.getName();
        }
        if (this.erroneousTestCases.contains(it)) {
            return;
        }
        for (PolicyDefinition policy : it.getPolicyList().getPolicies()) {
            if (this.erroneousPolicies.contains(policy)) {
                this.report(DCLIssue.TRANSITIVE_ERROR, (EStructuralFeature)DataControlLanguagePackage.Literals.TEST_CASE__POLICY_LIST, it, name, POLICY, policy.getName());
                continue;
            }
            for (PolicyDefinition erroneousUse : this.getErroneousUses(policy)) {
                this.report(DCLIssue.TRANSITIVE_ERROR, (EStructuralFeature)DataControlLanguagePackage.Literals.TEST_CASE__POLICY_LIST, it, name, POLICY, erroneousUse.getName());
            }
            for (FunctionDefinition erroneousCall : this.getErroneousFunctionCalls(policy)) {
                this.report(DCLIssue.TRANSITIVE_ERROR, (EStructuralFeature)DataControlLanguagePackage.Literals.TEST_CASE__POLICY_LIST, it, name, FUNCTION, erroneousCall.getName());
            }
        }
    }

    private void processIssues(ResourceSet resourceSet) {
        if (!this.issuesProcessed) {
            if (resourceSet == null || this.issueMap == null) {
                return;
            }
            this.insertErroneousObjects(this.erroneousPolicies, resourceSet, this.issueMap, PolicyDefinition.class);
            this.insertErroneousObjects(this.erroneousFunctions, resourceSet, this.issueMap, FunctionDefinition.class);
            this.insertErroneousObjects(this.erroneousTestCases, resourceSet, this.issueMap, TestCase.class);
            this.issuesProcessed = true;
        }
    }

    private Set<PolicyDefinition> getErroneousUses(PolicyDefinition p) {
        return this.getInformation(p).getTransitiveUse().stream().filter(it -> this.erroneousPolicies.contains(it)).collect(Collectors.toSet());
    }

    private Set<FunctionDefinition> getErroneousFunctionCalls(FunctionDefinition p) {
        return this.getInformation(p).getTransitiveFunctionCallClosure().stream().filter(func -> this.erroneousFunctions.contains(func)).collect(Collectors.toSet());
    }

    private Set<FunctionDefinition> getErroneousFunctionCalls(PolicyDefinition p) {
        return this.getInformation(p).getTransitiveFunctionCallClosure().stream().filter(func -> this.erroneousFunctions.contains(func)).collect(Collectors.toSet());
    }

    public void setIssueMap(Map<String, List<Issue>> issueMap) {
        this.issueMap = issueMap;
        this.resetProcessingState();
    }

    private void resetProcessingState() {
        this.erroneousPolicies.clear();
        this.issuesProcessed = false;
    }

    private <T> void insertErroneousObjects(Set<T> states, ResourceSet resourceSet, Map<String, List<Issue>> issueMap, Class<T> type) {
        for (Map.Entry<String, List<Issue>> issues : issueMap.entrySet()) {
            List<Issue> resourceIssues = issues.getValue();
            if (DCLTools.isEmpty(resourceIssues)) continue;
            for (Issue issue : resourceIssues) {
                EObject eoWithError;
                T parent;
                URI uriToProblem;
                if (!DCLCompilerTools.convertToDCLSeverity(issue.getSeverity()).equals((Object)DCLSeverity.ERROR) || (uriToProblem = issue.getUriToProblem()) == null || (parent = PartialCompileValidator.computeParent(eoWithError = resourceSet.getEObject(uriToProblem, false), type)) == null) continue;
                states.add(parent);
            }
        }
    }

    public static <T> T computeParent(EObject o, Class<T> parentType) {
        if (o == null) {
            return null;
        }
        if (parentType.isInstance(o)) {
            return (T)o;
        }
        return PartialCompileValidator.computeParent(o.eContainer(), parentType);
    }
}

