/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.CommonUtil;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.resource.Capability;

public final class CommonPlugin
extends EMFPlugin {
    public static final CommonPlugin INSTANCE = new CommonPlugin();
    private static Implementation plugin;
    private static volatile Method collatorGetInstanceMethod;
    private static volatile boolean collatorGetInstanceMethodInitialized;

    private CommonPlugin() {
        super(new ResourceLocator[0]);
    }

    @Override
    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static URI asLocalURI(URI uri) {
        return plugin == null ? uri : Implementation.asLocalURI(uri);
    }

    public static URI resolve(URI uri) {
        return plugin == null ? uri : Implementation.resolve(uri);
    }

    public static Class<?> loadClass(String pluginID, String className) throws ClassNotFoundException {
        return plugin == null ? Class.forName(className) : Implementation.loadClass(pluginID, className);
    }

    public static Map<String, List<ElementRecord>> getTargetPlatformExtensionPoints(Set<String> extensionPoints) {
        if (IS_ECLIPSE_RUNNING && PDEHelper.IS_PDE_BUNDLE_AVAILABLE) {
            return PDEHelper.computeModels(extensionPoints);
        }
        return null;
    }

    public static Map<String, URI> getTargetPlatformBundleMappings() {
        if (IS_ECLIPSE_RUNNING && PDEHelper.IS_PDE_BUNDLE_AVAILABLE) {
            return PDEHelper.computeTargetPlatformBundleMappings();
        }
        return null;
    }

    private static Method getCollatorGetInstanceMethod() {
        if (!collatorGetInstanceMethodInitialized) {
            try {
                Class<?> collatorClass = CommonPlugin.loadClass("com.ibm.icu", "com.ibm.icu.text.Collator");
                collatorGetInstanceMethod = collatorClass.getMethod("getInstance", Locale.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            collatorGetInstanceMethodInitialized = true;
        }
        return collatorGetInstanceMethod;
    }

    public Comparator<String> getComparator() {
        return this.getComparator(Locale.getDefault());
    }

    public Comparator<String> getComparator(Locale locale) {
        Method collatorGetInstanceMethod = CommonPlugin.getCollatorGetInstanceMethod();
        if (collatorGetInstanceMethod != null) {
            try {
                return (Comparator)collatorGetInstanceMethod.invoke(null, locale);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Collator.getInstance(locale);
    }

    public static final class ElementRecord {
        private final String name;
        private final Map<String, String> attributes = new TreeMap<String, String>();
        private final List<ElementRecord> children = new ArrayList<ElementRecord>();

        private ElementRecord(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getAttributes() {
            return Collections.unmodifiableMap(this.attributes);
        }

        public List<ElementRecord> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public String toString() {
            return this.name + " attributes= " + this.attributes + " children=" + this.children;
        }
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        protected static URI asLocalURI(URI uri) {
            try {
                String fragment = uri.fragment();
                URL url = FileLocator.toFileURL(CommonUtil.newURL(uri.trimFragment().toString()));
                return Implementation.fix(url, fragment);
            }
            catch (IOException iOException) {
                return uri;
            }
        }

        protected static URI resolve(URI uri) {
            String fragment = uri.fragment();
            URI uriWithoutFragment = uri.trimFragment();
            String uriWithoutFragmentToString = uriWithoutFragment.toString();
            URL url = null;
            try {
                url = FileLocator.resolve(CommonUtil.newURL(uriWithoutFragmentToString));
            }
            catch (IOException exception1) {
                try {
                    uriWithoutFragmentToString = URI.decode(uriWithoutFragmentToString);
                    url = FileLocator.resolve(CommonUtil.newURL(uriWithoutFragmentToString));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (url != null) {
                try {
                    return Implementation.fix(url, fragment);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return uri;
        }

        protected static URI fix(URL url, String fragment) throws IOException {
            URI result;
            URI uRI = result = "file".equalsIgnoreCase(url.getProtocol()) ? URI.createFileURI(URI.decode(url.getFile())) : URI.createURI(url.toString());
            if (fragment != null) {
                result = result.appendFragment(fragment);
            }
            return result;
        }

        public static Class<?> loadClass(String pluginID, String className) throws ClassNotFoundException {
            Bundle bundle = Platform.getBundle((String)pluginID);
            if (bundle == null) {
                throw new ClassNotFoundException(String.valueOf(className) + " cannot be loaded because because bundle " + pluginID + " cannot be resolved");
            }
            return bundle.loadClass(className);
        }

        public static class Activator
        extends EMFPlugin.OSGiDelegatingBundleActivator {
            @Override
            protected BundleActivator createBundle() {
                return new Implementation();
            }
        }
    }

    private static class PDEHelper {
        private static final String ECORE_GENERATED_PACKAGE = "org.eclipse.emf.ecore.generated_package";
        private static final String ECORE_DYNAMIC_PACKAGE = "org.eclipse.emf.ecore.dynamic_package";
        private static final Method PLUGIN_MODEL_BASE_GET_BUNDLE_DESCRIPTION_METHOD;
        private static final Method PLUGIN_MODEL_BASE_GET_UNDERLYING_RESOURCE_METHOD;
        private static final Method RESOURCE_GET_PROJECT_METHOD;
        private static final Method RESOURCE_GET_FULL_PATH_METHOD;
        private static final Method PLUGIN_MODEL_BASE_GET_INSTALL_LOCATION_METHOD;
        private static final Method PLUGIN_MODEL_BASE_GET_EXTENSIONS_METHOD;
        private static final Method PLUGIN_REGISTRY_GET_ACTIVE_MODELS_METHOD;
        private static final Method EXTENSIONS_GET_EXTENSIONS_METHOD;
        private static final Method PLUGIN_EXTENSION_GET_POINT_METHOD;
        private static final Method PLUGIN_EXTENSION_GET_CHILDREN_METHOD;
        private static final Class<?> PLUGIN_ELEMENT_CLASS;
        private static final Method PLUGIN_ELEMENT_GET_ATTRIBUTES_METHOD;
        private static final Method PLUGIN_OBJECT_GET_NAME_METHOD;
        private static final Method PLUGIN_ATTRIBUTE_GET_VALUE_METHOD;
        private static final boolean IS_PDE_BUNDLE_AVAILABLE;

        static {
            Method pluginModelBaseGetBundleDescriptionMethod = null;
            Method pluginModelBaseGetUnderlyingResourceMethod = null;
            Method resourceGetProjectMethod = null;
            Method resourceGetFullPathtMethod = null;
            Method pluginModelBaseGetInstallLocationMethod = null;
            Method pluginModelBaseGetExtensionsMethod = null;
            Method pluginRegistryGetActiveModelsMethod = null;
            Method extensionsGetExtensionsMethod = null;
            Method pluginExtensionGetPointMethod = null;
            Method pluginExtensionGetChildrenMethod = null;
            Class<?> pluginElementClass = null;
            Method pluginElementGetAttributesMethod = null;
            Method pluginObjectGetNameMethod = null;
            Method pluginAttributeGetValueMethod = null;
            boolean isPDEBundleAvailable = false;
            try {
                Class<?> pluginModelBaseClass = CommonPlugin.loadClass("org.eclipse.pde.core", "org.eclipse.pde.core.plugin.IPluginModelBase");
                pluginModelBaseGetBundleDescriptionMethod = pluginModelBaseClass.getMethod("getBundleDescription", new Class[0]);
                pluginModelBaseGetUnderlyingResourceMethod = pluginModelBaseClass.getMethod("getUnderlyingResource", new Class[0]);
                resourceGetProjectMethod = pluginModelBaseGetUnderlyingResourceMethod.getReturnType().getMethod("getProject", new Class[0]);
                resourceGetFullPathtMethod = resourceGetProjectMethod.getReturnType().getMethod("getFullPath", new Class[0]);
                pluginModelBaseGetInstallLocationMethod = pluginModelBaseClass.getMethod("getInstallLocation", new Class[0]);
                pluginModelBaseGetExtensionsMethod = pluginModelBaseClass.getMethod("getExtensions", new Class[0]);
                Class<?> pluginRegistryClass = CommonPlugin.loadClass("org.eclipse.pde.core", "org.eclipse.pde.core.plugin.PluginRegistry");
                pluginRegistryGetActiveModelsMethod = pluginRegistryClass.getMethod("getActiveModels", Boolean.TYPE);
                Class<?> extensionsClass = CommonPlugin.loadClass("org.eclipse.pde.core", "org.eclipse.pde.core.plugin.IExtensions");
                extensionsGetExtensionsMethod = extensionsClass.getMethod("getExtensions", new Class[0]);
                Class<?> pluginExtensionClass = CommonPlugin.loadClass("org.eclipse.pde.core", "org.eclipse.pde.core.plugin.IPluginExtension");
                pluginExtensionGetPointMethod = pluginExtensionClass.getMethod("getPoint", new Class[0]);
                pluginExtensionGetChildrenMethod = pluginExtensionClass.getMethod("getChildren", new Class[0]);
                pluginElementClass = CommonPlugin.loadClass("org.eclipse.pde.core", "org.eclipse.pde.core.plugin.IPluginElement");
                pluginObjectGetNameMethod = pluginElementClass.getMethod("getName", new Class[0]);
                pluginElementGetAttributesMethod = pluginElementClass.getMethod("getAttributes", new Class[0]);
                Class<?> pluginAttributeClass = CommonPlugin.loadClass("org.eclipse.pde.core", "org.eclipse.pde.core.plugin.IPluginAttribute");
                pluginAttributeGetValueMethod = pluginAttributeClass.getMethod("getValue", new Class[0]);
                isPDEBundleAvailable = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            PLUGIN_MODEL_BASE_GET_BUNDLE_DESCRIPTION_METHOD = pluginModelBaseGetBundleDescriptionMethod;
            PLUGIN_MODEL_BASE_GET_UNDERLYING_RESOURCE_METHOD = pluginModelBaseGetUnderlyingResourceMethod;
            RESOURCE_GET_PROJECT_METHOD = resourceGetProjectMethod;
            RESOURCE_GET_FULL_PATH_METHOD = resourceGetFullPathtMethod;
            PLUGIN_MODEL_BASE_GET_INSTALL_LOCATION_METHOD = pluginModelBaseGetInstallLocationMethod;
            PLUGIN_MODEL_BASE_GET_EXTENSIONS_METHOD = pluginModelBaseGetExtensionsMethod;
            PLUGIN_REGISTRY_GET_ACTIVE_MODELS_METHOD = pluginRegistryGetActiveModelsMethod;
            EXTENSIONS_GET_EXTENSIONS_METHOD = extensionsGetExtensionsMethod;
            PLUGIN_EXTENSION_GET_POINT_METHOD = pluginExtensionGetPointMethod;
            PLUGIN_EXTENSION_GET_CHILDREN_METHOD = pluginExtensionGetChildrenMethod;
            PLUGIN_ELEMENT_CLASS = pluginElementClass;
            PLUGIN_OBJECT_GET_NAME_METHOD = pluginObjectGetNameMethod;
            PLUGIN_ELEMENT_GET_ATTRIBUTES_METHOD = pluginElementGetAttributesMethod;
            PLUGIN_ATTRIBUTE_GET_VALUE_METHOD = pluginAttributeGetValueMethod;
            IS_PDE_BUNDLE_AVAILABLE = isPDEBundleAvailable && !"true".equals(System.getProperty("org.eclipse.emf.common.CommonPlugin.doNotUsePDE"));
        }

        private PDEHelper() {
        }

        private static <T> T invoke(Object object, Method method, Object ... arguments) {
            try {
                return (T)method.invoke(object, arguments);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static Map<String, URI> computeTargetPlatformBundleMappings() {
            final TreeMap<String, URI> result = new TreeMap<String, URI>();
            new ActiveModelVisitor(){

                @Override
                void visitActiveModel(Object activeModel, BundleDescription bundleDescription, URI location) {
                    String symbolicName;
                    String string = symbolicName = bundleDescription == null ? null : bundleDescription.getSymbolicName();
                    if (symbolicName != null && location != null) {
                        result.put(symbolicName, location);
                    }
                }
            };
            return result;
        }

        private static Map<String, List<ElementRecord>> computeModels(final Set<String> extensionPoints) {
            final TreeMap<String, List<ElementRecord>> result = new TreeMap<String, List<ElementRecord>>();
            new ActiveModelVisitor(){

                @Override
                void visitActiveModel(Object activeModel, BundleDescription bundleDescription, URI location) {
                    block6: {
                        Object[] pluginExtensions;
                        String symbolicName;
                        block5: {
                            List<ElementRecord> elementRecords;
                            Map<String, Object> attributes;
                            ElementRecord elementRecord;
                            ElementRecord extensionRecord;
                            List<Capability> capabilities;
                            symbolicName = bundleDescription == null ? null : bundleDescription.getSymbolicName();
                            Object extensions = PDEHelper.invoke(activeModel, PLUGIN_MODEL_BASE_GET_EXTENSIONS_METHOD, new Object[0]);
                            pluginExtensions = (Object[])PDEHelper.invoke(extensions, EXTENSIONS_GET_EXTENSIONS_METHOD, new Object[0]);
                            if (pluginExtensions.length != 0) break block5;
                            if (extensionPoints == null || bundleDescription == null) break block6;
                            if (extensionPoints.contains(PDEHelper.ECORE_GENERATED_PACKAGE) && !(capabilities = bundleDescription.getCapabilities(PDEHelper.ECORE_GENERATED_PACKAGE)).isEmpty()) {
                                extensionRecord = new ElementRecord("extension");
                                this.recordExtensionAttributes(extensionRecord, PDEHelper.ECORE_GENERATED_PACKAGE, symbolicName, location);
                                for (Capability capability : capabilities) {
                                    elementRecord = new ElementRecord("package");
                                    attributes = capability.getAttributes();
                                    elementRecord.attributes.put("uri", "" + attributes.get("uri"));
                                    elementRecord.attributes.put("class", "" + attributes.get("class"));
                                    elementRecord.attributes.put("genModel", "" + attributes.get("genModel"));
                                    extensionRecord.children.add(elementRecord);
                                }
                                elementRecords = this.getElementRecords(PDEHelper.ECORE_GENERATED_PACKAGE);
                                elementRecords.add(extensionRecord);
                            }
                            if (!extensionPoints.contains(PDEHelper.ECORE_DYNAMIC_PACKAGE) || (capabilities = bundleDescription.getCapabilities(PDEHelper.ECORE_DYNAMIC_PACKAGE)).isEmpty()) break block6;
                            extensionRecord = new ElementRecord("extension");
                            this.recordExtensionAttributes(extensionRecord, PDEHelper.ECORE_DYNAMIC_PACKAGE, symbolicName, location);
                            for (Capability capability : capabilities) {
                                elementRecord = new ElementRecord("resource");
                                attributes = capability.getAttributes();
                                elementRecord.attributes.put("uri", "" + attributes.get("uri"));
                                elementRecord.attributes.put("location", "" + attributes.get("location"));
                                extensionRecord.children.add(elementRecord);
                            }
                            elementRecords = this.getElementRecords(PDEHelper.ECORE_DYNAMIC_PACKAGE);
                            elementRecords.add(extensionRecord);
                            break block6;
                        }
                        Object[] objectArray = pluginExtensions;
                        int n = pluginExtensions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object pluginExtension = objectArray[n2];
                            String point = (String)PDEHelper.invoke(pluginExtension, PLUGIN_EXTENSION_GET_POINT_METHOD, new Object[0]);
                            if (extensionPoints == null || extensionPoints.isEmpty() || extensionPoints.contains(point)) {
                                ElementRecord elementRecord = PDEHelper.visitElement(pluginExtension);
                                this.recordExtensionAttributes(elementRecord, point, symbolicName, location);
                                List<ElementRecord> elementRecords = this.getElementRecords(point);
                                elementRecords.add(elementRecord);
                            }
                            ++n2;
                        }
                    }
                }

                private void recordExtensionAttributes(ElementRecord elementRecord, String point, String symbolicName, URI location) {
                    if (location != null) {
                        elementRecord.attributes.put("point", point);
                        elementRecord.attributes.put("symbolicName", symbolicName);
                        elementRecord.attributes.put("location", location.toString());
                    }
                }

                private List<ElementRecord> getElementRecords(String point) {
                    ArrayList elementRecords = (ArrayList)result.get(point);
                    if (elementRecords == null) {
                        elementRecords = new ArrayList();
                        result.put(point, elementRecords);
                    }
                    return elementRecords;
                }
            };
            return result;
        }

        private static void visitElement(Object[] children, List<ElementRecord> elementRecords) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (PLUGIN_ELEMENT_CLASS.isInstance(child)) {
                    elementRecords.add(PDEHelper.visitElement(child));
                }
                ++n2;
            }
        }

        private static ElementRecord visitElement(Object child) {
            ElementRecord elementRecord;
            if (PLUGIN_ELEMENT_CLASS.isInstance(child)) {
                Object[] attributes;
                String elementName = (String)PDEHelper.invoke(child, PLUGIN_OBJECT_GET_NAME_METHOD, new Object[0]);
                elementRecord = new ElementRecord(elementName);
                Object[] objectArray = attributes = (Object[])PDEHelper.invoke(child, PLUGIN_ELEMENT_GET_ATTRIBUTES_METHOD, new Object[0]);
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    Object attribute = objectArray[n2];
                    String attributeName = (String)PDEHelper.invoke(attribute, PLUGIN_OBJECT_GET_NAME_METHOD, new Object[0]);
                    String attributeValue = (String)PDEHelper.invoke(attribute, PLUGIN_ATTRIBUTE_GET_VALUE_METHOD, new Object[0]);
                    elementRecord.attributes.put(attributeName, attributeValue);
                    ++n2;
                }
            } else {
                elementRecord = new ElementRecord("extension");
            }
            Object[] elements = (Object[])PDEHelper.invoke(child, PLUGIN_EXTENSION_GET_CHILDREN_METHOD, new Object[0]);
            if (elements.length != 0) {
                PDEHelper.visitElement(elements, elementRecord.children);
            }
            return elementRecord;
        }

        private static abstract class ActiveModelVisitor {
            public ActiveModelVisitor() {
                Object[] activeModels = (Object[])PDEHelper.invoke(null, PLUGIN_REGISTRY_GET_ACTIVE_MODELS_METHOD, new Object[]{Boolean.FALSE});
                if (activeModels != null) {
                    Object[] objectArray = activeModels;
                    int n = activeModels.length;
                    int n2 = 0;
                    while (n2 < n) {
                        URI location;
                        Object activeModel = objectArray[n2];
                        BundleDescription bundleDescription = (BundleDescription)PDEHelper.invoke(activeModel, PLUGIN_MODEL_BASE_GET_BUNDLE_DESCRIPTION_METHOD, new Object[0]);
                        Object underlyingResource = PDEHelper.invoke(activeModel, PLUGIN_MODEL_BASE_GET_UNDERLYING_RESOURCE_METHOD, new Object[0]);
                        String installLocation = (String)PDEHelper.invoke(activeModel, PLUGIN_MODEL_BASE_GET_INSTALL_LOCATION_METHOD, new Object[0]);
                        if (underlyingResource != null) {
                            Object project = PDEHelper.invoke(underlyingResource, RESOURCE_GET_PROJECT_METHOD, new Object[0]);
                            IPath fullPath = (IPath)PDEHelper.invoke(project, RESOURCE_GET_FULL_PATH_METHOD, new Object[0]);
                            location = URI.createPlatformResourceURI(fullPath.toString(), true);
                        } else {
                            File file;
                            location = installLocation != null ? ((file = new File(installLocation)).isDirectory() ? URI.createFileURI(installLocation) : URI.createURI("archive:" + URI.createFileURI(installLocation) + "!/")) : null;
                        }
                        this.visitActiveModel(activeModel, bundleDescription, location);
                        ++n2;
                    }
                }
            }

            abstract void visitActiveModel(Object var1, BundleDescription var2, URI var3);
        }
    }

    public static abstract class SimpleTargetPlatformRegistryImpl<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1L;

        protected Set<K> getTargetPlatformValues(String extensionPoint, String attributeName) {
            Map<String, List<ElementRecord>> targetPlatformExtensionPoints = CommonPlugin.getTargetPlatformExtensionPoints(Collections.singleton(extensionPoint));
            if (targetPlatformExtensionPoints != null) {
                LinkedHashSet<K> result = new LinkedHashSet<K>();
                List<ElementRecord> extensionPointElementRecords = targetPlatformExtensionPoints.get(extensionPoint);
                if (extensionPointElementRecords != null) {
                    for (ElementRecord extensionPointRecord : extensionPointElementRecords) {
                        for (ElementRecord elementRecord : extensionPointRecord.getChildren()) {
                            String attribute = elementRecord.getAttributes().get(attributeName);
                            if (attribute == null) continue;
                            result.add(this.createKey(attribute));
                        }
                    }
                }
                return result;
            }
            return new LinkedHashSet(this.keySet());
        }

        protected abstract K createKey(String var1);
    }
}

