/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;

public class Source2GeneratedMapping
implements Externalizable {
    private final Multimap<URI, URI> source2generated;
    private final Multimap<URI, URI> generated2source;
    private final Map<URI, String> generated2OutputConfigName;

    public Source2GeneratedMapping() {
        this(HashMultimap.create(), HashMultimap.create(), new HashMap<URI, String>());
    }

    public Source2GeneratedMapping(Multimap<URI, URI> source2generated, Multimap<URI, URI> generated2source, Map<URI, String> generated2OutputConfigName) {
        this.source2generated = source2generated;
        this.generated2source = generated2source;
        this.generated2OutputConfigName = generated2OutputConfigName;
    }

    public Source2GeneratedMapping copy() {
        return new Source2GeneratedMapping(HashMultimap.create(this.source2generated), HashMultimap.create(this.generated2source), new HashMap<URI, String>(this.generated2OutputConfigName));
    }

    public void addSource2Generated(URI source, URI generated) {
        this.addSource2Generated(source, generated, "DEFAULT_OUTPUT");
    }

    public void addSource2Generated(URI source, URI generated, String outputCfgName) {
        this.source2generated.put(source, generated);
        this.generated2source.put(generated, source);
        this.generated2OutputConfigName.put(generated, outputCfgName == null ? "DEFAULT_OUTPUT" : outputCfgName);
    }

    public void removeSource2Generated(URI source, URI generated) {
        this.source2generated.remove(source, generated);
        this.generated2source.remove(generated, source);
        if (!this.generated2source.containsKey(generated)) {
            this.generated2OutputConfigName.remove(generated);
        }
    }

    public Set<URI> deleteSource(URI source) {
        HashSet<URI> generated = new HashSet<URI>(this.source2generated.removeAll(source));
        for (URI gen : generated) {
            this.generated2source.remove(gen, source);
            if (this.generated2source.containsKey(gen)) continue;
            this.generated2OutputConfigName.remove(gen);
        }
        return generated;
    }

    public Map<URI, String> deleteSourceAndGetOutputConfigs(URI source) {
        HashSet<URI> generated = new HashSet<URI>(this.source2generated.removeAll(source));
        HashMap<URI, String> result = new HashMap<URI, String>();
        for (URI gen : generated) {
            this.generated2source.remove(gen, source);
            result.put(gen, this.generated2OutputConfigName.get(gen));
            if (this.generated2source.containsKey(gen)) continue;
            this.generated2OutputConfigName.remove(gen);
        }
        return result;
    }

    public void deleteGenerated(URI generated) {
        this.generated2source.removeAll(generated).forEach(it -> this.source2generated.remove(it, generated));
        this.generated2OutputConfigName.remove(generated);
    }

    public String getOutputConfigName(URI generated) {
        return this.generated2OutputConfigName.get(generated);
    }

    public List<URI> getGenerated(URI source) {
        return new ArrayList<URI>(this.source2generated.get(source));
    }

    public List<URI> getSource(URI generated) {
        return new ArrayList<URI>(this.generated2source.get(generated));
    }

    public List<URI> getAllGenerated() {
        return new ArrayList<URI>(this.generated2source.keySet());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int numEntries = in.readInt();
        while (numEntries > 0) {
            --numEntries;
            URI source = URI.createURI(in.readUTF());
            int numGenerated = in.readInt();
            while (numGenerated > 0) {
                --numGenerated;
                URI generated = URI.createURI(in.readUTF());
                String outputConfig = in.readUTF();
                this.addSource2Generated(source, generated, outputConfig);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Set<Map.Entry<URI, Collection<URI>>> entries = this.source2generated.asMap().entrySet();
        out.writeInt(entries.size());
        for (Map.Entry<URI, Collection<URI>> it : entries) {
            out.writeUTF(it.getKey().toString());
            out.writeInt(it.getValue().size());
            for (URI value : it.getValue()) {
                out.writeUTF(value.toString());
                out.writeUTF(this.generated2OutputConfigName.get(value));
            }
        }
    }
}

