/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.documentation.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.documentation.EObjectInComment;
import org.eclipse.xtext.documentation.IJavaDocTypeReferenceProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.TextRegion;

public class MultiLineJavaDocTypeReferenceProvider
implements IJavaDocTypeReferenceProvider {
    @Deprecated
    protected String lineDelimiter = System.getProperty("line.separator");
    @Inject
    protected IScopeProvider scopeProvider;
    @Inject
    protected IQualifiedNameConverter qualifiedNameConverter;

    @Override
    public List<ReplaceRegion> computeTypeRefRegions(INode node) {
        ArrayList<ReplaceRegion> regions = Lists.newArrayList();
        Iterable<ILeafNode> leafNodes = node.getLeafNodes();
        this.computeRegions(regions, leafNodes, "@link ", new String[]{"#", " ", "}"});
        this.computeRegions(regions, leafNodes, "@see ", "#", " ", "\r", "\n");
        return regions;
    }

    @Override
    public List<ReplaceRegion> computeParameterTypeRefRegions(INode node) {
        ArrayList<ReplaceRegion> regions = Lists.newArrayList();
        Iterable<ILeafNode> leafNodes = node.getLeafNodes();
        this.computeRegions(regions, leafNodes, "@param ", " ", "-", "\r", "\n");
        return regions;
    }

    @Override
    public EObjectInComment computeEObjectReferencedInComment(XtextResource resource, int offset) {
        EReference reference;
        ICompositeNode rootNode;
        ILeafNode node;
        EObject semanticObject;
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null && (semanticObject = NodeModelUtils.findActualSemanticObjectFor(node = NodeModelUtils.findLeafNodeAtOffset(rootNode = parseResult.getRootNode(), offset))) != null && (reference = this.getEReference(semanticObject, node, offset)) != null) {
            IScope scope = this.getScope(semanticObject, reference, node, offset);
            List<ReplaceRegion> eObjectReferences = this.computeTypeRefRegions(node);
            for (ReplaceRegion eObjectReference : eObjectReferences) {
                EObject eObject;
                TextRegion region;
                IEObjectDescription candidate;
                String eObjectReferenceText;
                if (eObjectReference.getOffset() > offset || offset > eObjectReference.getEndOffset() || Strings.isNullOrEmpty(eObjectReferenceText = eObjectReference.getText()) || (candidate = this.getElementFromScope(scope, node, region = new TextRegion(eObjectReference.getOffset(), eObjectReference.getLength()), eObjectReferenceText)) == null || (eObject = candidate.getEObjectOrProxy()) == null) continue;
                return new EObjectInComment(eObject, region);
            }
        }
        return null;
    }

    @Deprecated
    protected void computeRegions(List<ReplaceRegion> regions, Iterable<ILeafNode> leafNodes, String toSearch, String end, String optionalEnd, String optionalEnd2) {
        this.computeRegions(regions, leafNodes, toSearch, new String[]{end, optionalEnd, optionalEnd2});
    }

    protected void computeRegions(List<ReplaceRegion> regions, Iterable<ILeafNode> leafNodes, String toSearch, String ... ends) {
        block0: for (ILeafNode leafNode : leafNodes) {
            String text = leafNode.getText();
            int offset = leafNode.getOffset();
            int position = text.indexOf(toSearch);
            int textLength = text.length();
            while (position != -1) {
                int beginIndex = position + toSearch.length();
                if (Character.isWhitespace(text.charAt(beginIndex))) {
                    while (beginIndex < textLength && Character.isWhitespace(text.charAt(beginIndex))) {
                        ++beginIndex;
                    }
                }
                int endIndex = -1;
                int i = ends.length - 1;
                while (i >= 0) {
                    String end = ends[i];
                    int endCandidate = text.indexOf(end, beginIndex);
                    if (endCandidate != -1) {
                        if (endIndex == -1) {
                            endIndex = endCandidate;
                        } else if (endIndex > endCandidate) {
                            endIndex = endCandidate;
                        }
                    }
                    --i;
                }
                if (endIndex == -1) continue block0;
                String simpleName = text.substring(beginIndex, endIndex).replaceAll(" ", "");
                if (simpleName.length() > 0 && simpleName.matches("[0-9a-zA-Z\\.\\$_]*")) {
                    ReplaceRegion region = new ReplaceRegion(offset + beginIndex, simpleName.length(), simpleName);
                    regions.add(region);
                }
                position = text.indexOf(toSearch, endIndex);
            }
        }
    }

    protected EReference getEReference(EObject eObject, INode node, int offset) {
        return null;
    }

    protected IScope getScope(EObject semanticObject, EReference reference, INode node, int offset) {
        return this.scopeProvider.getScope(semanticObject, reference);
    }

    protected IEObjectDescription getElementFromScope(IScope scope, INode node, ITextRegion region, String text) {
        return scope.getSingleElement(this.qualifiedNameConverter.toQualifiedName(text));
    }
}

