/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting.IElementMatcherProvider;
import org.eclipse.xtext.formatting.impl.MatcherNFAProvider;
import org.eclipse.xtext.formatting.impl.MatcherState;
import org.eclipse.xtext.formatting.impl.MatcherTransition;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class ElementMatcherProvider
implements IElementMatcherProvider {
    @Inject
    protected IGrammarAccess grammar;
    @Inject
    protected MatcherNFAProvider nfaProvider;

    @Override
    public <T extends IElementMatcherProvider.IElementPattern> IElementMatcherProvider.IElementMatcher<T> createMatcher(Iterable<T> rules) {
        return new TransitionMatcher<T>(this.grammar, this.nfaProvider, rules);
    }

    protected static class TransitionMatcher<T extends IElementMatcherProvider.IElementPattern>
    implements IElementMatcherProvider.IElementMatcherExtension<T> {
        protected IGrammarAccess grammar;
        protected MatcherState lastState = null;
        protected MatcherNFAProvider nfaProvider;
        protected Stack<MatcherState> ruleCallStack = new Stack();

        public TransitionMatcher(IGrammarAccess grammar, MatcherNFAProvider nfaProvider, Iterable<T> patterns) {
            this.grammar = grammar;
            this.nfaProvider = nfaProvider;
            this.installAllPatterns(patterns);
        }

        protected Set<MatcherState> findRuleCallsTo(AbstractRule rule, Set<AbstractRule> visited) {
            if (!visited.add(rule)) {
                return Collections.emptySet();
            }
            HashSet<MatcherState> result = Sets.newHashSet();
            TreeIterator<EObject> i = rule.eAllContents();
            while (i.hasNext()) {
                MatcherState state;
                EObject obj = (EObject)i.next();
                if (!(obj instanceof AbstractElement) || !(state = (MatcherState)this.nfaProvider.getNFA((AbstractElement)obj)).hasTransitions()) continue;
                for (MatcherTransition incoming : state.getAllIncoming()) {
                    if (!incoming.isRuleCall() || !result.add((MatcherState)incoming.getSource()) || !((MatcherState)incoming.getSource()).isEndState()) continue;
                    result.addAll(this.findRuleCallsTo(GrammarUtil.containingRule(((MatcherState)incoming.getSource()).getGrammarElement()), visited));
                }
            }
            return result;
        }

        @Override
        public Pair<Integer, RuleCall> findTopmostRuleCall(Predicate<RuleCall> predicate) {
            int i = this.ruleCallStack.size() - 1;
            while (i >= 0) {
                if (predicate.apply((RuleCall)((MatcherState)this.ruleCallStack.get(i)).getGrammarElement())) {
                    return Tuples.create(i, (RuleCall)((MatcherState)this.ruleCallStack.get(i)).getGrammarElement());
                }
                --i;
            }
            return null;
        }

        protected Pair<List<MatcherTransition>, List<MatcherState>> findTransitionPath(MatcherState from, AbstractElement to, boolean returning, boolean canReturn, Set<Pair<Boolean, MatcherState>> visited) {
            if (!visited.add(Tuples.create(returning, from))) {
                return null;
            }
            if (from != null) {
                List<MatcherTransition> transitions = from.getAllOutgoing().isEmpty() ? from.collectOutgoingTransitions() : (returning ? from.getOutgoingAfterReturn() : from.getOutgoing());
                for (MatcherTransition transition : transitions) {
                    if (((MatcherState)transition.getTarget()).getGrammarElement() == to) {
                        return Tuples.create(Collections.singletonList(transition), Collections.singletonList(from));
                    }
                    if (!((MatcherState)transition.getTarget()).isParserRuleCall()) continue;
                    this.ruleCallStack.push((MatcherState)transition.getTarget());
                    Pair<List<MatcherTransition>, List<MatcherState>> next = this.findTransitionPath((MatcherState)transition.getTarget(), to, false, ((MatcherState)transition.getTarget()).isParserRuleCallOptional(), visited);
                    if (next != null) {
                        ArrayList<MatcherTransition> trans = Lists.newArrayList(transition);
                        trans.addAll((Collection<MatcherTransition>)next.getFirst());
                        ArrayList<MatcherState> stats = Lists.newArrayList(from);
                        stats.addAll((Collection<MatcherState>)next.getSecond());
                        return Tuples.create(trans, stats);
                    }
                    this.ruleCallStack.pop();
                }
                if (canReturn && from.isEndState() && !this.ruleCallStack.isEmpty()) {
                    MatcherState lastRuleCall = this.ruleCallStack.pop();
                    Pair<List<MatcherTransition>, List<MatcherState>> next = this.findTransitionPath(lastRuleCall, to, true, true, visited);
                    if (next != null) {
                        ArrayList<MatcherState> result = Lists.newArrayList(from);
                        result.addAll((Collection<MatcherState>)next.getSecond());
                        return Tuples.create(next.getFirst(), result);
                    }
                    this.ruleCallStack.push(lastRuleCall);
                }
            }
            return null;
        }

        protected List<MatcherTransition> findTransitionsToToken(MatcherState from, Set<MatcherState> targets, boolean returning, boolean canReturn, Set<MatcherState> visited) {
            if (!visited.add(from)) {
                return Collections.emptyList();
            }
            if (targets != null && targets.contains(from)) {
                targets = null;
            }
            ArrayList<MatcherTransition> result = Lists.newArrayList();
            for (MatcherTransition transition : returning ? from.getOutgoingAfterReturn() : from.getOutgoing()) {
                if (((MatcherState)transition.getTarget()).isParserRuleCall()) {
                    result.addAll(this.findTransitionsToToken((MatcherState)transition.getTarget(), targets, false, ((MatcherState)transition.getTarget()).isParserRuleCallOptional(), visited));
                    continue;
                }
                if (targets != null && !targets.contains(transition.getTarget())) continue;
                result.add(transition);
            }
            if (canReturn && from.isEndState()) {
                for (MatcherState caller : this.findRuleCallsTo(GrammarUtil.containingRule(from.getGrammarElement()), Sets.newHashSet())) {
                    result.addAll(this.findTransitionsToToken(caller, targets, true, true, visited));
                }
            }
            return result;
        }

        @Override
        public Collection<T> finish() {
            if (this.lastState != null) {
                ArrayList<IElementMatcherProvider.IAfterElement> result = Lists.newArrayList(this.lastState.getAfterPatterns());
                while (!this.ruleCallStack.isEmpty()) {
                    result.addAll(this.ruleCallStack.pop().getAfterPatterns());
                }
                this.lastState = null;
                return result;
            }
            return Collections.emptyList();
        }

        protected Set<MatcherState> getAllStates(AbstractElement element) {
            HashSet<MatcherState> result = Sets.newHashSet();
            TreeIterator<EObject> i = EcoreUtil2.eAll(element);
            while (i.hasNext()) {
                MatcherState state;
                EObject obj = (EObject)i.next();
                if (!(obj instanceof AbstractElement) || !(state = (MatcherState)this.nfaProvider.getNFA((AbstractElement)obj)).hasTransitions()) continue;
                result.add(state);
            }
            return result;
        }

        public IGrammarAccess getGrammar() {
            return this.grammar;
        }

        public MatcherNFAProvider getNfaProvider() {
            return this.nfaProvider;
        }

        protected void installAfter(IElementMatcherProvider.IAfterElement pattern) {
            Set<MatcherState> states = this.getAllStates(pattern.matchAfter());
            AbstractRule rule = GrammarUtil.containingRule(pattern.matchAfter());
            for (MatcherState state : states) {
                state.getAfterPatterns().add(pattern);
                for (MatcherTransition out : state.isParserRuleCall() ? state.getOutgoingAfterReturn() : state.getOutgoing()) {
                    if (pattern.matchAfter() != out.getLoopCenter() && states.contains(out.getTarget())) continue;
                    out.addPattern(pattern);
                }
                if (!state.isEndState()) continue;
                for (MatcherState caller : this.findRuleCallsTo(rule, Sets.newHashSet())) {
                    for (MatcherTransition afterReturn : caller.getOutgoingAfterReturn()) {
                        afterReturn.addPattern(state, pattern);
                    }
                }
            }
        }

        protected void installAllPatterns(Iterable<T> patterns) {
            for (IElementMatcherProvider.IElementPattern pattern : patterns) {
                if (pattern instanceof IElementMatcherProvider.IBeforeElement && ((IElementMatcherProvider.IBeforeElement)pattern).matchBefore() != null) {
                    this.installBefore((IElementMatcherProvider.IBeforeElement)pattern);
                }
                if (pattern instanceof IElementMatcherProvider.IAfterElement && ((IElementMatcherProvider.IAfterElement)pattern).matchAfter() != null) {
                    this.installAfter((IElementMatcherProvider.IAfterElement)pattern);
                }
                if (!(pattern instanceof IElementMatcherProvider.IBetweenElements) || ((IElementMatcherProvider.IBetweenElements)pattern).matchBetween() == null) continue;
                this.installBetween((IElementMatcherProvider.IBetweenElements)pattern);
            }
        }

        protected void installBefore(IElementMatcherProvider.IBeforeElement pattern) {
            Set<MatcherState> states = this.getAllStates(pattern.matchBefore());
            for (MatcherState state : states) {
                state.getBeforePatterns().add(pattern);
                for (MatcherTransition incoming : state.getAllIncoming()) {
                    if (pattern.matchBefore() != incoming.getLoopCenter() && states.contains(incoming.getSource())) continue;
                    incoming.addPattern(pattern);
                }
            }
        }

        protected void installBetween(IElementMatcherProvider.IBetweenElements pattern) {
            if (pattern.matchBetween().getFirst() == pattern.matchBetween().getSecond()) {
                this.installBetween(pattern, pattern.matchBetween().getFirst());
            } else {
                this.installBetween(pattern, pattern.matchBetween().getFirst(), pattern.matchBetween().getSecond());
            }
        }

        protected void installBetween(IElementMatcherProvider.IBetweenElements pattern, AbstractElement loopCenter) {
            Set<MatcherState> states = this.getAllStates(loopCenter);
            for (MatcherState state : states) {
                state.getBeforeBetweenElements().add(pattern);
                state.getAfterBetweenElements().add(pattern);
                for (MatcherTransition transition : state.getAllOutgoing()) {
                    if (transition.getLoopCenter() != loopCenter || !states.contains(transition.getTarget())) continue;
                    transition.addPattern(pattern);
                }
            }
        }

        protected void installBetween(IElementMatcherProvider.IBetweenElements pattern, AbstractElement first, AbstractElement second) {
            Set<MatcherState> sources = this.getAllStates(first);
            Set<MatcherState> targets = this.getAllStates(second);
            for (MatcherState target : targets) {
                target.getBeforeBetweenElements().add(pattern);
            }
            for (MatcherState source : sources) {
                source.getAfterBetweenElements().add(pattern);
                for (MatcherTransition transition : this.findTransitionsToToken(source, targets, source.isParserRuleCall(), true, Sets.newHashSet())) {
                    if (transition.getSource() == source) {
                        transition.addPattern(pattern);
                        continue;
                    }
                    transition.addPattern(source, pattern);
                }
            }
        }

        @Override
        public void init(ParserRule rule) {
            this.lastState = (MatcherState)this.nfaProvider.getNFA(rule.getAlternatives());
        }

        @Override
        public Collection<T> matchNext(AbstractElement nextElement) {
            Pair<List<MatcherTransition>, List<MatcherState>> path = this.findTransitionPath(this.lastState, nextElement, false, true, Sets.newHashSet());
            if (path == null) {
                MatcherState previousState = this.lastState;
                this.lastState = (MatcherState)this.nfaProvider.getNFA(nextElement);
                return this.patternsForTwoStates(previousState, this.lastState);
            }
            this.lastState = (MatcherState)path.getFirst().get(path.getFirst().size() - 1).getTarget();
            return this.patternsForTransition(path);
        }

        protected Collection<T> patternsForTransition(Pair<List<MatcherTransition>, List<MatcherState>> transition) {
            ArrayList<IElementMatcherProvider.IElementPattern> result = Lists.newArrayList();
            HashSet<MatcherState> exits = Sets.newHashSet((Iterable)transition.getSecond());
            for (MatcherTransition transitio : transition.getFirst()) {
                result.addAll(transitio.getPatterns(exits));
            }
            return result;
        }

        protected Collection<T> patternsForTwoStates(MatcherState first, MatcherState second) {
            HashSet<IElementMatcherProvider.IElementPattern> result = Sets.newHashSet();
            if (first != null) {
                result.addAll(first.getAfterPatterns());
                for (IElementMatcherProvider.IBetweenElements between : first.getAfterBetweenElements()) {
                    if (!this.getAllStates(between.matchBetween().getSecond()).contains(second)) continue;
                    result.add(between);
                }
                for (IElementMatcherProvider.IBetweenElements between : second.getBeforeBetweenElements()) {
                    if (!this.getAllStates(between.matchBetween().getFirst()).contains(first)) continue;
                    result.add(between);
                }
            }
            result.addAll(second.getBeforePatterns());
            return result;
        }
    }
}

