/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IFormattableSubDocument;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.IMerger;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.internal.DoubleHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.internal.HiddenRegionFormatting;
import org.eclipse.xtext.formatting2.internal.HiddenRegionFormattingMerger;
import org.eclipse.xtext.formatting2.internal.HiddenRegionReplacer;
import org.eclipse.xtext.formatting2.internal.MultilineCommentReplacer;
import org.eclipse.xtext.formatting2.internal.RegionTraceMissingException;
import org.eclipse.xtext.formatting2.internal.RootDocument;
import org.eclipse.xtext.formatting2.internal.SingleHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.internal.SinglelineCodeCommentReplacer;
import org.eclipse.xtext.formatting2.internal.SinglelineDocCommentReplacer;
import org.eclipse.xtext.formatting2.internal.SubDocument;
import org.eclipse.xtext.formatting2.internal.TextReplacerContext;
import org.eclipse.xtext.formatting2.internal.TextReplacerMerger;
import org.eclipse.xtext.formatting2.internal.WhitespaceReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionExtensions;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextRegions;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.lib.Extension;

public abstract class AbstractFormatter2
implements IFormatter2 {
    private FormatterRequest request = null;
    @Extension
    protected ITextRegionExtensions textRegionExtensions;

    protected void _format(Object obj, IFormattableDocument document) {
    }

    protected void _format(EObject obj, IFormattableDocument document) {
        for (EObject child : obj.eContents()) {
            document.format(child);
        }
    }

    protected void _format(Void obj, IFormattableDocument document) {
    }

    protected void _format(XtextResource resource, IFormattableDocument document) {
        EList<EObject> contents = resource.getContents();
        if (!contents.isEmpty()) {
            EObject model = (EObject)contents.get(0);
            document.format(model);
        }
    }

    public ITextReplacer createCommentReplacer(IComment comment) {
        EObject grammarElement = comment.getGrammarElement();
        if (grammarElement instanceof AbstractRule) {
            String ruleName = ((AbstractRule)grammarElement).getName();
            if (ruleName.startsWith("ML")) {
                return new MultilineCommentReplacer(comment, '*');
            }
            if (ruleName.startsWith("SL")) {
                if (comment.getLineRegions().get(0).getIndentation().getLength() > 0) {
                    return new SinglelineDocCommentReplacer(comment, "//");
                }
                return new SinglelineCodeCommentReplacer(comment, "//");
            }
        }
        String elementName = new GrammarElementTitleSwitch().showQualified().showRule().doSwitch(grammarElement);
        throw new IllegalStateException("No " + ITextReplacer.class.getSimpleName() + " configured for " + elementName);
    }

    public IFormattableDocument createFormattableRootDocument() {
        return new RootDocument(this);
    }

    public IFormattableSubDocument createFormattableSubDocument(ITextSegment region, IFormattableDocument parent) {
        return new SubDocument(region, parent);
    }

    public IHiddenRegionFormatter createHiddenRegionFormatter(IHiddenRegionFormatting formatting) {
        return new SingleHiddenRegionFormatter(formatting);
    }

    public IHiddenRegionFormatter createHiddenRegionFormatter(IHiddenRegionFormatting f1, IHiddenRegionFormatting f2) {
        return new DoubleHiddenRegionFormatter(f1, f2);
    }

    public IHiddenRegionFormatting createHiddenRegionFormatting() {
        return new HiddenRegionFormatting(this);
    }

    public IMerger<IHiddenRegionFormatting> createHiddenRegionFormattingMerger() {
        return new HiddenRegionFormattingMerger(this);
    }

    public ITextReplacer createHiddenRegionReplacer(IHiddenRegion region, IHiddenRegionFormatting formatting) {
        return new HiddenRegionReplacer(region, formatting);
    }

    public ITextReplacerContext createTextReplacerContext(IFormattableDocument document) {
        return new TextReplacerContext(document);
    }

    public IMerger<ITextReplacer> createTextReplacerMerger() {
        return new TextReplacerMerger(this);
    }

    public ITextReplacer createWhitespaceReplacer(ITextSegment hiddens, IHiddenRegionFormatting formatting) {
        return new WhitespaceReplacer(hiddens, formatting);
    }

    @Override
    public final List<ITextReplacement> format(FormatterRequest request) {
        try {
            List<ITextReplacement> postprocessed;
            this.initialize(request);
            XtextResource xtextResource = request.getTextRegionAccess().getResource();
            IFormattableDocument document = this.createFormattableRootDocument();
            try {
                this.format(xtextResource, document);
            }
            catch (RegionTraceMissingException e) {
                document = this.handleTraceMissing(document, e);
            }
            List<ITextReplacement> rendered = document.renderToTextReplacements();
            List<ITextReplacement> list = postprocessed = this.postProcess(document, rendered);
            return list;
        }
        finally {
            this.reset();
        }
    }

    protected IFormattableDocument handleTraceMissing(IFormattableDocument problematic, RegionTraceMissingException e) {
        if (this.request.isEnableDebugTracing()) {
            return problematic;
        }
        this.request.setEnableDebugTracing(true);
        XtextResource xtextResource = this.request.getTextRegionAccess().getResource();
        IFormattableDocument document = this.createFormattableRootDocument();
        this.format(xtextResource, document);
        return document;
    }

    public abstract void format(Object var1, IFormattableDocument var2);

    public <T> T getPreference(TypedPreferenceKey<T> key) {
        return this.request.getPreferences().getPreference(key);
    }

    public ITypedPreferenceValues getPreferences() {
        return this.request.getPreferences();
    }

    public FormatterRequest getRequest() {
        return this.request;
    }

    public ITextRegionAccess getTextRegionAccess() {
        return this.request.getTextRegionAccess();
    }

    @Deprecated
    protected void initalize(FormatterRequest request) {
        this.initialize(request);
    }

    protected void initialize(FormatterRequest request) {
        this.request = request;
        this.textRegionExtensions = request.getTextRegionAccess().getExtensions();
    }

    protected boolean isInRequestedRange(EObject obj) {
        Collection<ITextRegion> regions = this.request.getRegions();
        if (regions.isEmpty()) {
            return true;
        }
        ITextRegionAccess access = this.request.getTextRegionAccess();
        IEObjectRegion objRegion = access.regionForEObject(obj);
        if (objRegion == null) {
            return false;
        }
        IHiddenRegion previousHidden = objRegion.getPreviousHiddenRegion();
        IHiddenRegion nextHidden = objRegion.getNextHiddenRegion();
        int objOffset = previousHidden != null ? previousHidden.getOffset() : 0;
        int objEnd = nextHidden != null ? nextHidden.getEndOffset() : access.regionForRootEObject().getEndOffset();
        for (ITextRegion region : regions) {
            int regionOffset = region.getOffset();
            int regionEnd = regionOffset + region.getLength();
            if (regionOffset > objEnd || regionEnd < objOffset) continue;
            return true;
        }
        return false;
    }

    private boolean isInRequestedRange(int offset, int endOffset) {
        Collection<ITextRegion> regions = this.request.getRegions();
        if (regions.isEmpty()) {
            return true;
        }
        for (ITextRegion region : regions) {
            if (region.getOffset() > offset || region.getOffset() + region.getLength() < endOffset) continue;
            return true;
        }
        return false;
    }

    protected List<ITextReplacement> postProcess(IFormattableDocument document, List<ITextReplacement> replacements) {
        ArrayList<ITextSegment> expected = Lists.newArrayList();
        IHiddenRegion current = this.getTextRegionAccess().regionForRootEObject().getPreviousHiddenRegion();
        while (current != null) {
            if (current.isUndefined() && this.isInRequestedRange(current.getOffset(), current.getEndOffset())) {
                expected.addAll(current.getMergedSpaces());
            }
            current = current.getNextHiddenRegion();
        }
        if (expected.isEmpty()) {
            return replacements;
        }
        List<ITextSegment> missing = TextRegions.difference(expected, replacements);
        if (missing.isEmpty()) {
            return replacements;
        }
        ArrayList<ITextReplacement> result = Lists.newArrayList(replacements);
        for (ITextSegment seg : missing) {
            IHiddenRegion h = null;
            if (seg instanceof IHiddenRegion) {
                h = (IHiddenRegion)seg;
            }
            if (seg instanceof IHiddenRegionPart) {
                h = ((IHiddenRegionPart)seg).getHiddenRegion();
            }
            if (h != null && (h.getNextSemanticRegion() == null || h.getPreviousSemanticRegion() == null)) {
                result.add(seg.replaceWith(""));
                continue;
            }
            result.add(seg.replaceWith(" "));
        }
        return result;
    }

    protected void reset() {
        this.request = null;
        this.textRegionExtensions = null;
    }

    public boolean shouldFormat(Object obj, IFormattableDocument document) {
        if (obj instanceof EObject) {
            return this.isInRequestedRange((EObject)obj);
        }
        return true;
    }
}

