/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.debug;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionRewriter;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextRegions;

public class TextRegionsWithTitleToString {
    private ITextSegment frame;
    private List<Item> items = Lists.newArrayList();
    private int leadingLines = 4;
    private ITextRegionAccess textRegionAccess;
    private int trailingLines = 4;
    private final String[] BRACKETS_OPEN = new String[]{"{{{", "[[[", "(((", "<<<"};
    private final String[] BRACKETS_CLOSE = new String[]{"}}}", "]]]", ")))", ">>>"};

    public TextRegionsWithTitleToString add(String title, ITextSegment region) {
        this.items.add(new Item(title, region));
        return this;
    }

    protected String box(String title, String content) {
        int width = 80;
        int min = 3;
        int titleLength = title.length() + 2;
        int left = Math.max((80 - titleLength) / 2, 3);
        StringBuilder result = new StringBuilder();
        result.append(Strings.repeat("-", left));
        result.append(" ");
        result.append(title);
        result.append(" ");
        if (left > 3) {
            result.append(Strings.repeat("-", 80 - left - titleLength));
        }
        result.append("\n");
        result.append(org.eclipse.xtext.util.Strings.trimTrailingLineBreak(content));
        result.append("\n");
        result.append(Strings.repeat("-", 80));
        return result.toString();
    }

    public ITextSegment getFrame() {
        if (this.frame != null) {
            return this.frame;
        }
        ITextRegionAccess access = this.getTextRegionAccess();
        if (access != null) {
            ArrayList<ITextSegment> segments = Lists.newArrayList();
            for (Item item : this.items) {
                segments.add(item.getRegion());
            }
            ITextSegment impactRegion = TextRegions.merge(segments);
            List<ILineRegion> expandToLines = TextRegions.expandToLines(impactRegion, this.getLeadingLines(), this.getTrailingLines());
            return TextRegions.merge(expandToLines);
        }
        return null;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public int getLeadingLines() {
        return this.leadingLines;
    }

    public ITextRegionAccess getTextRegionAccess() {
        if (this.textRegionAccess != null) {
            return this.textRegionAccess;
        }
        Iterator<Item> iterator = this.items.iterator();
        if (iterator.hasNext()) {
            Item item = iterator.next();
            return item.region.getTextRegionAccess();
        }
        return null;
    }

    public int getTrailingLines() {
        return this.trailingLines;
    }

    public TextRegionsWithTitleToString setFrame(ITextSegment frame) {
        this.frame = frame;
        return this;
    }

    public TextRegionsWithTitleToString setLeadingLines(int leadingLines) {
        this.leadingLines = leadingLines;
        return this;
    }

    public TextRegionsWithTitleToString setTextRegionAccess(ITextRegionAccess textRegionAccess) {
        this.textRegionAccess = textRegionAccess;
        return this;
    }

    public TextRegionsWithTitleToString setTrailingLines(int trailingLines) {
        this.trailingLines = trailingLines;
        return this;
    }

    public String toString() {
        ITextRegionAccess access = this.getTextRegionAccess();
        ITextSegment frame = this.getFrame();
        if (access == null || frame == null) {
            return "(null)";
        }
        ITextRegionRewriter rewriter = access.getRewriter();
        StringBuilder builder = new StringBuilder();
        ArrayList<ITextReplacement> replacements = Lists.newArrayList();
        int i = 0;
        while (i < this.items.size()) {
            Item item = this.items.get(i);
            ITextSegment region = item.getRegion();
            String regionStr = "offset=" + region.getOffset() + " length=" + region.getLength();
            String open = i < this.BRACKETS_OPEN.length ? this.BRACKETS_OPEN[i] : "[" + i + "[";
            String close = i < this.BRACKETS_CLOSE.length ? this.BRACKETS_CLOSE[i] : "]" + i + "]";
            builder.append(open + close + ": " + item.getTitle() + " at " + regionStr + "\n");
            replacements.add(rewriter.createReplacement(region.getOffset(), 0, open));
            replacements.add(rewriter.createReplacement(region.getEndOffset(), 0, close));
            ++i;
        }
        String vizualized = rewriter.renderToString(frame, replacements);
        builder.append(this.box("document snippet", vizualized));
        return builder.toString();
    }

    public static class Item {
        private final ITextSegment region;
        private final String title;

        public Item(String title, ITextSegment region) {
            this.title = title;
            this.region = region;
        }

        public ITextSegment getRegion() {
            return this.region;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

