/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.IMerger;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.internal.HiddenRegionReplacer;
import org.eclipse.xtext.formatting2.internal.ICompositeTextReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;

public class TextReplacerMerger
implements IMerger<ITextReplacer> {
    private final AbstractFormatter2 formatter;
    private final IMerger<IHiddenRegionFormatting> merger;

    public TextReplacerMerger(AbstractFormatter2 formatter) {
        this.formatter = formatter;
        this.merger = formatter.createHiddenRegionFormattingMerger();
    }

    @Override
    public ITextReplacer merge(List<? extends ITextReplacer> conflicting) {
        ITextReplacer result = this.mergeHiddenRegionReplacers(conflicting);
        if (result == null) {
            result = this.mergeCompositeReplacers(conflicting);
        }
        return result;
    }

    protected ITextReplacer mergeCompositeReplacers(List<? extends ITextReplacer> conflicting) {
        ICompositeTextReplacer composite = null;
        for (ITextReplacer iTextReplacer : conflicting) {
            if (!(iTextReplacer instanceof ICompositeTextReplacer)) continue;
            if (composite == null) {
                composite = (ICompositeTextReplacer)iTextReplacer;
                continue;
            }
            return null;
        }
        if (composite == null) {
            return null;
        }
        for (ITextReplacer iTextReplacer : conflicting) {
            if (iTextReplacer == composite) continue;
            composite.addReplacer(iTextReplacer);
        }
        return composite;
    }

    protected ITextReplacer mergeHiddenRegionReplacers(List<? extends ITextReplacer> conflicting) {
        ArrayList<IHiddenRegionFormatting> formattings = Lists.newArrayList();
        IHiddenRegion region = null;
        for (ITextReplacer iTextReplacer : conflicting) {
            if (iTextReplacer instanceof HiddenRegionReplacer) {
                HiddenRegionReplacer hiddenRegionReplacer = (HiddenRegionReplacer)iTextReplacer;
                formattings.add(hiddenRegionReplacer.getFormatting());
                if (region == null) {
                    region = hiddenRegionReplacer.getRegion();
                    continue;
                }
                if (region == hiddenRegionReplacer.getRegion()) continue;
                return null;
            }
            return null;
        }
        IHiddenRegionFormatting iHiddenRegionFormatting = this.merger.merge(formattings);
        if (iHiddenRegionFormatting != null) {
            return this.formatter.createHiddenRegionReplacer(region, iHiddenRegionFormatting);
        }
        return null;
    }
}

