/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.xbase.lib.Pair;

public abstract class AbstractSemanticRegionsFinder
implements ISemanticRegionsFinder {
    protected void assertNoContainment(EStructuralFeature feat) {
        if (!(feat instanceof EAttribute || feat instanceof EReference && !((EReference)feat).isContainment())) {
            throw new IllegalStateException("Only EAttributes and CrossReferences allowed.");
        }
    }

    protected void assertNoEObjectRule(AbstractRule rule) {
        if (GrammarUtil.isEObjectRule(rule)) {
            throw new IllegalStateException("Only Enum, Datatype and Terminal Rule Calls allowed.");
        }
    }

    protected void assertNoEObjectRuleCall(RuleCall ruleCall) {
        this.assertNoEObjectRule(ruleCall.getRule());
    }

    @Override
    public ISemanticRegion assignment(Assignment assignment) {
        return this.findFirst(this.createPredicate((AbstractElement)assignment));
    }

    @Override
    public List<ISemanticRegion> assignments(Assignment ... assignments) {
        return this.findAll(this.createPredicate(assignments));
    }

    protected void collectMatchableElements(AbstractElement ele, Collection<AbstractElement> result) {
        switch (ele.eClass().getClassifierID()) {
            case 10: {
                this.assertNoEObjectRuleCall((RuleCall)ele);
            }
            case 9: {
                result.add(ele);
                break;
            }
            case 12: {
                this.collectMatchableElements(((CrossReference)ele).getTerminal(), result);
                break;
            }
            case 11: {
                this.collectMatchableElements(((Assignment)ele).getTerminal(), result);
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                for (AbstractElement child : ((CompoundElement)ele).getElements()) {
                    this.collectMatchableElements(child, result);
                }
                break;
            }
        }
    }

    protected Predicate<ISemanticRegion> createPredicate(AbstractElement ele) {
        switch (ele.eClass().getClassifierID()) {
            case 10: {
                this.assertNoEObjectRuleCall((RuleCall)ele);
            }
            case 9: {
                return new GrammarElementPredicate(ele);
            }
        }
        return this.createPredicate(new AbstractElement[]{ele});
    }

    protected Predicate<ISemanticRegion> createPredicate(AbstractElement ... ele) {
        HashSet<AbstractElement> result = Sets.newHashSet();
        AbstractElement[] abstractElementArray = ele;
        int n = ele.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractElement e = abstractElementArray[n2];
            this.collectMatchableElements(e, result);
            ++n2;
        }
        switch (result.size()) {
            case 0: {
                return Predicates.alwaysFalse();
            }
            case 1: {
                return new GrammarElementPredicate((EObject)result.iterator().next());
            }
        }
        return new GrammarElementsPredicate(result);
    }

    @Override
    public ISemanticRegion crossRef(CrossReference crossReference) {
        return this.findFirst(this.createPredicate((AbstractElement)crossReference));
    }

    @Override
    public List<ISemanticRegion> crossRefs(CrossReference ... crossReferences) {
        return this.findAll(this.createPredicate(crossReferences));
    }

    @Override
    public ISemanticRegion element(AbstractElement element) {
        return this.findFirst(this.createPredicate(element));
    }

    @Override
    public List<ISemanticRegion> elements(AbstractElement ... elements) {
        return this.findAll(this.createPredicate(elements));
    }

    @Override
    public ISemanticRegion feature(EStructuralFeature feature) {
        this.assertNoContainment(feature);
        return this.findFirst(new FeaturePredicate(feature));
    }

    @Override
    public List<ISemanticRegion> features(EStructuralFeature ... features) {
        HashSet<FeaturePredicate> predicates = Sets.newHashSet();
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feat = features[i];
            this.assertNoContainment(feat);
            predicates.add(new FeaturePredicate(feat));
            ++i;
        }
        return this.findAll(Predicates.or(predicates));
    }

    protected abstract ImmutableList<ISemanticRegion> findAll(Predicate<ISemanticRegion> var1);

    protected abstract ISemanticRegion findFirst(Predicate<ISemanticRegion> var1);

    @Override
    public ISemanticRegion keyword(Keyword keyword) {
        return this.findFirst(this.createPredicate((AbstractElement)keyword));
    }

    @Override
    public ISemanticRegion keyword(String keyword) {
        return this.findFirst(new KeywordPredicate(keyword));
    }

    @Override
    public List<Pair<ISemanticRegion, ISemanticRegion>> keywordPairs(Keyword kw1, Keyword kw2) {
        Preconditions.checkNotNull(kw1);
        Preconditions.checkNotNull(kw2);
        Preconditions.checkArgument(kw1 != kw2);
        Predicate<ISemanticRegion> p1 = this.createPredicate((AbstractElement)kw1);
        Predicate<ISemanticRegion> p2 = this.createPredicate((AbstractElement)kw2);
        ImmutableList<ISemanticRegion> all = this.findAll(Predicates.or(p1, p2));
        ImmutableList.Builder result = ImmutableList.builder();
        LinkedList<ISemanticRegion> stack = new LinkedList<ISemanticRegion>();
        for (ISemanticRegion region : all) {
            if (p1.apply(region)) {
                stack.push(region);
                continue;
            }
            if (stack.isEmpty()) continue;
            result.add(Pair.of((ISemanticRegion)stack.pop(), region));
        }
        return result.build();
    }

    @Override
    public List<Pair<ISemanticRegion, ISemanticRegion>> keywordPairs(String kw1, String kw2) {
        Preconditions.checkNotNull(kw1);
        Preconditions.checkNotNull(kw2);
        Preconditions.checkArgument(!kw1.equals(kw2));
        KeywordPredicate p1 = new KeywordPredicate(kw1);
        KeywordPredicate p2 = new KeywordPredicate(kw2);
        ImmutableList<ISemanticRegion> all = this.findAll(Predicates.or(p1, p2));
        ImmutableList.Builder result = ImmutableList.builder();
        LinkedList<ISemanticRegion> stack = new LinkedList<ISemanticRegion>();
        block0: for (ISemanticRegion region : all) {
            if (p1.apply(region)) {
                stack.push(region);
                continue;
            }
            AbstractRule regionRule = GrammarUtil.containingRule(region.getGrammarElement());
            while (!stack.isEmpty()) {
                AbstractRule candidateRule;
                ISemanticRegion candidate = (ISemanticRegion)stack.pop();
                if (region.getSemanticElement() != candidate.getSemanticElement() || regionRule != (candidateRule = GrammarUtil.containingRule(candidate.getGrammarElement()))) continue;
                result.add(Pair.of(candidate, region));
                continue block0;
            }
        }
        return result.build();
    }

    @Override
    public List<ISemanticRegion> keywords(Keyword ... keywords) {
        return this.findAll(this.createPredicate(keywords));
    }

    @Override
    public List<ISemanticRegion> keywords(String ... keywords) {
        Predicate<ISemanticRegion> predicate = keywords.length == 1 ? new KeywordPredicate(keywords[0]) : new KeywordsPredicate(Sets.newHashSet(keywords));
        return this.findAll(predicate);
    }

    @Override
    public ISemanticRegion ruleCall(RuleCall ruleCall) {
        return this.findFirst(this.createPredicate((AbstractElement)ruleCall));
    }

    @Override
    public List<ISemanticRegion> ruleCalls(RuleCall ... ruleCalls) {
        return this.findAll(this.createPredicate(ruleCalls));
    }

    @Override
    public List<ISemanticRegion> ruleCallsTo(AbstractRule ... rules) {
        int i = 0;
        while (i < rules.length) {
            this.assertNoEObjectRule(rules[i]);
            ++i;
        }
        Predicate<ISemanticRegion> predicate = rules.length == 1 ? new RulePredicate(rules[0]) : new RulesPredicate(Sets.newHashSet(rules));
        return this.findAll(predicate);
    }

    @Override
    public ISemanticRegion ruleCallTo(AbstractRule rule) {
        this.assertNoEObjectRule(rule);
        return this.findFirst(new RulePredicate(rule));
    }

    protected static class FeaturePredicate
    implements Predicate<ISemanticRegion> {
        private final String name;
        private final EClass type;

        public FeaturePredicate(EStructuralFeature feature) {
            this.name = feature.getName();
            this.type = feature.getEContainingClass();
        }

        @Override
        public boolean apply(ISemanticRegion input) {
            if (input == null) {
                return false;
            }
            EObject element = input.getGrammarElement();
            Assignment assignment = GrammarUtil.containingAssignment(element);
            if (assignment == null || !this.name.equals(assignment.getFeature())) {
                return false;
            }
            EObject semanticElement = input.getSemanticElement();
            return this.type.isInstance(semanticElement);
        }
    }

    protected static class GrammarElementPredicate
    implements Predicate<ISemanticRegion> {
        private final EObject grammarElement;

        public GrammarElementPredicate(EObject grammarElement) {
            this.grammarElement = grammarElement;
        }

        @Override
        public boolean apply(ISemanticRegion input) {
            if (input == null) {
                return false;
            }
            return input.getGrammarElement() == this.grammarElement;
        }

        public String toString() {
            String string = new GrammarElementTitleSwitch().showRule().showQualified().doSwitch(this.grammarElement);
            return "Predicate[" + string + "]";
        }
    }

    protected static class GrammarElementsPredicate
    implements Predicate<ISemanticRegion> {
        private final Set<? extends EObject> grammarElements;

        public GrammarElementsPredicate(Set<? extends EObject> grammarElements) {
            this.grammarElements = grammarElements;
        }

        @Override
        public boolean apply(ISemanticRegion input) {
            if (input == null) {
                return false;
            }
            return this.grammarElements.contains(input.getGrammarElement());
        }

        public String toString() {
            ArrayList<String> strings = Lists.newArrayList();
            GrammarElementTitleSwitch toString = new GrammarElementTitleSwitch().showRule().showQualified();
            for (EObject eObject : this.grammarElements) {
                strings.add(toString.doSwitch(eObject));
            }
            return "Predicate[" + Joiner.on(", ").join(strings) + "]";
        }
    }

    protected static class KeywordPredicate
    implements Predicate<ISemanticRegion> {
        private final String keyword;

        public KeywordPredicate(String keyword) {
            this.keyword = keyword;
        }

        @Override
        public boolean apply(ISemanticRegion input) {
            if (input == null) {
                return false;
            }
            EObject element = input.getGrammarElement();
            return element instanceof Keyword && this.keyword.equals(((Keyword)element).getValue());
        }

        public String toString() {
            return "Predicate[" + this.keyword + "]";
        }
    }

    protected static class KeywordsPredicate
    implements Predicate<ISemanticRegion> {
        private final Set<String> keywords;

        public KeywordsPredicate(Set<String> keywords) {
            this.keywords = keywords;
        }

        @Override
        public boolean apply(ISemanticRegion input) {
            if (input == null) {
                return false;
            }
            EObject element = input.getGrammarElement();
            return element instanceof Keyword && this.keywords.contains(((Keyword)element).getValue());
        }

        public String toString() {
            return "Predicate[" + Joiner.on(", ").join(this.keywords) + "]";
        }
    }

    protected static class RulePredicate
    implements Predicate<ISemanticRegion> {
        private final AbstractRule rule;

        public RulePredicate(AbstractRule rule) {
            this.rule = rule;
        }

        @Override
        public boolean apply(ISemanticRegion input) {
            if (input == null) {
                return false;
            }
            EObject element = input.getGrammarElement();
            return element instanceof RuleCall && ((RuleCall)element).getRule() == this.rule;
        }

        public String toString() {
            return "Predicate[" + this.rule.getName() + "]";
        }
    }

    protected static class RulesPredicate
    implements Predicate<ISemanticRegion> {
        private final Set<AbstractRule> rules;

        public RulesPredicate(Set<AbstractRule> rules) {
            this.rules = rules;
        }

        @Override
        public boolean apply(ISemanticRegion input) {
            if (input == null) {
                return false;
            }
            EObject element = input.getGrammarElement();
            return element instanceof RuleCall && this.rules.contains(((RuleCall)element).getRule());
        }

        public String toString() {
            ArrayList<String> strings = Lists.newArrayList();
            for (AbstractRule rule : this.rules) {
                strings.add(rule.getName());
            }
            return "Predicate[" + Joiner.on(", ").join(strings) + "]";
        }
    }
}

