/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace.node;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.trace.node.CompositeGeneratorNode;
import org.eclipse.xtext.generator.trace.node.GeneratorNodeExtensions;
import org.eclipse.xtext.generator.trace.node.IGeneratorNode;
import org.eclipse.xtext.generator.trace.node.IndentNode;
import org.eclipse.xtext.generator.trace.node.NewLineNode;
import org.eclipse.xtext.generator.trace.node.TextNode;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class TemplateNode
extends CompositeGeneratorNode
implements StringConcatenationClient.TargetStringConcatenation {
    private final GeneratorNodeExtensions nodeFactory;
    private CompositeGeneratorNode currentParent = this;
    private static final Splitter lineSplitter = Splitter.on(Pattern.compile("\\R"));

    public TemplateNode(StringConcatenationClient contents, GeneratorNodeExtensions nodeFactory) {
        this.nodeFactory = nodeFactory;
        StringConcatenationClient.appendTo(contents, this);
    }

    @Override
    public void append(Object object, String indentation) {
        if (indentation.length() > 0) {
            CompositeGeneratorNode before = this.currentParent;
            try {
                this.currentParent = new IndentNode(indentation, false, true);
                before.getChildren().add(this.currentParent);
                this.append(object);
            }
            finally {
                this.currentParent = before;
            }
        } else {
            this.append(object);
        }
    }

    @Override
    public void append(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof StringConcatenationClient) {
            this.nodeFactory.appendTemplate(this.currentParent, (StringConcatenationClient)object);
        } else if (object instanceof IGeneratorNode) {
            this.currentParent.getChildren().add((IGeneratorNode)object);
        } else {
            String str = object.toString();
            Iterator<String> iter = lineSplitter.split(str).iterator();
            while (iter.hasNext()) {
                String segment = iter.next();
                this.nodeFactory.append(this.currentParent, segment);
                if (!iter.hasNext()) continue;
                this.newLine();
            }
        }
    }

    protected Iterable<IGeneratorNode> leafsBackwards(IGeneratorNode it) {
        if (it instanceof CompositeGeneratorNode) {
            return IterableExtensions.reduce(Lists.transform(Lists.reverse(((CompositeGeneratorNode)it).getChildren()), this::leafsBackwards), Iterables::concat);
        }
        return Lists.newArrayList(it);
    }

    @Override
    public void appendImmediate(Object object, String indentation) {
        ArrayList<IGeneratorNode> removed = new ArrayList<IGeneratorNode>();
        int i = this.currentParent.getChildren().size() - 1;
        while (i >= 0) {
            IGeneratorNode node = this.currentParent.getChildren().get(i);
            if (node instanceof TextNode && !TemplateNode.hasContent(((TextNode)node).getText())) {
                removed.add(this.currentParent.getChildren().remove(i));
            } else if (node instanceof NewLineNode) {
                removed.add(this.currentParent.getChildren().remove(i));
            } else {
                this.append(object, indentation);
                Lists.reverse(removed).forEach(it -> this.append(it, indentation));
                return;
            }
            --i;
        }
        this.append(object, indentation);
    }

    protected static boolean hasContent(CharSequence s) {
        int i = 0;
        while (i < s.length()) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void newLine() {
        this.nodeFactory.appendNewLine(this.currentParent);
    }

    @Override
    public void newLineIfNotEmpty() {
        this.nodeFactory.appendNewLineIfNotEmpty(this.currentParent);
    }

    @Override
    public char charAt(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int length() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }
}

