/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.naming;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.CommonUtil;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtext.util.Strings;

public class QualifiedName
implements Comparable<QualifiedName> {
    private final int hash;
    private final String[] segments;
    private QualifiedName lowerCase;
    static boolean USE_INTERNING = Boolean.getBoolean("xtext.qn.interning");
    public static final QualifiedName EMPTY = new QualifiedName(new String[0]){

        @Override
        public QualifiedName append(QualifiedName relativeQualifiedName) {
            return relativeQualifiedName;
        }

        @Override
        public QualifiedName append(String segment) {
            return QualifiedName.create(segment);
        }

        @Override
        boolean hasLowerCase() {
            return true;
        }

        @Override
        public QualifiedName toLowerCase() {
            return this;
        }

        @Override
        public QualifiedName toUpperCase() {
            return this;
        }

        @Override
        public String toString(String delimiter) {
            return "";
        }
    };

    public static QualifiedName create(String ... segments) {
        if (segments == null || segments.length == 0) {
            return EMPTY;
        }
        if (segments.length == 1) {
            return QualifiedName.create(segments[0]);
        }
        String[] newArray = new String[segments.length];
        int i = 0;
        while (i < segments.length) {
            String string = segments[i];
            if (string == null) {
                throw new IllegalArgumentException("Segment cannot be null");
            }
            newArray[i] = QualifiedName.intern(string);
            ++i;
        }
        return new QualifiedName(newArray);
    }

    private static String intern(String string) {
        return USE_INTERNING ? CommonUtil.intern(string) : string;
    }

    public static QualifiedName createFromStream(BinaryResourceImpl.EObjectInputStream eObjectInputStream) throws IOException {
        int segmentCount = eObjectInputStream.readCompressedInt();
        if (segmentCount == 0) {
            return EMPTY;
        }
        String firstSegment = eObjectInputStream.readSegmentedString();
        boolean lowerCase = false;
        if (firstSegment == null) {
            lowerCase = true;
            firstSegment = eObjectInputStream.readSegmentedString();
            if (firstSegment == null) {
                throw new IllegalStateException("Read unexpected first segment from object stream");
            }
        }
        String[] segments = QualifiedName.readSegmentArray(eObjectInputStream, segmentCount, firstSegment);
        if (lowerCase) {
            return new QualifiedNameLowerCase(segments);
        }
        return new QualifiedName(segments);
    }

    private static String[] readSegmentArray(BinaryResourceImpl.EObjectInputStream from, int count, String first) throws IOException {
        String[] segments = new String[count];
        segments[0] = QualifiedName.intern(first);
        int i = 1;
        while (i < count) {
            String segment = from.readSegmentedString();
            if (segment == null) {
                throw new IllegalStateException("Read unexpected segment (#" + i + ") from object stream");
            }
            segments[i] = QualifiedName.intern(segment);
            ++i;
        }
        return segments;
    }

    public void writeToStream(BinaryResourceImpl.EObjectOutputStream eObjectOutputStream) throws IOException {
        int segmentCount = this.getSegmentCount();
        eObjectOutputStream.writeCompressedInt(segmentCount);
        int i = 0;
        while (i < segmentCount) {
            eObjectOutputStream.writeSegmentedString(this.getSegment(i));
            ++i;
        }
    }

    public static QualifiedName create(List<String> segments) {
        if (segments == null || segments.isEmpty()) {
            return EMPTY;
        }
        if (segments.size() == 1) {
            String singleSegment = segments.get(0);
            return QualifiedName.create(singleSegment);
        }
        String[] segmentArray = new String[segments.size()];
        int i = 0;
        while (i < segments.size()) {
            String string = segments.get(i);
            if (string == null) {
                throw new IllegalArgumentException("Segment cannot be null");
            }
            segmentArray[i] = QualifiedName.intern(string);
            ++i;
        }
        return new QualifiedName(segmentArray);
    }

    public static QualifiedName create(String singleSegment) {
        if (singleSegment == null) {
            throw new IllegalArgumentException("Segment cannot be null");
        }
        return new QualifiedName(QualifiedName.intern(singleSegment));
    }

    public static <F> Function<F, QualifiedName> wrapper(final Function<F, String> nameFunction) {
        return new Function<F, QualifiedName>(){

            @Override
            public QualifiedName apply(F from) {
                String name = (String)nameFunction.apply(from);
                if (name == null) {
                    return null;
                }
                return QualifiedName.create(name);
            }
        };
    }

    protected QualifiedName(String ... segments) {
        this.segments = segments == null || segments.length == 0 ? Strings.EMPTY_ARRAY : segments;
        this.hash = Arrays.hashCode(this.segments);
    }

    public boolean isEmpty() {
        return this.segments.length == 0;
    }

    public List<String> getSegments() {
        return Collections.unmodifiableList(Arrays.asList(this.segments));
    }

    public int getSegmentCount() {
        return this.segments.length;
    }

    public String getSegment(int index) {
        return this.segments[index];
    }

    public String getLastSegment() {
        return this.segments[this.segments.length - 1];
    }

    public String getFirstSegment() {
        return this.segments[0];
    }

    public QualifiedName append(String segment) {
        if (segment == null) {
            throw new IllegalArgumentException("Segment cannot be null");
        }
        String[] newSegments = new String[this.getSegmentCount() + 1];
        System.arraycopy(this.segments, 0, newSegments, 0, this.segments.length);
        newSegments[this.segments.length] = QualifiedName.intern(segment);
        return new QualifiedName(newSegments);
    }

    public QualifiedName append(QualifiedName relativeQualifiedName) {
        String[] newSegments = new String[this.getSegmentCount() + relativeQualifiedName.getSegmentCount()];
        int i = 0;
        while (i < this.getSegmentCount()) {
            newSegments[i] = this.getSegment(i);
            ++i;
        }
        i = 0;
        while (i < relativeQualifiedName.getSegmentCount()) {
            newSegments[i + this.getSegmentCount()] = relativeQualifiedName.getSegment(i);
            ++i;
        }
        return new QualifiedName(newSegments);
    }

    public QualifiedName skipFirst(int skipCount) {
        if (skipCount == this.getSegmentCount()) {
            return EMPTY;
        }
        if (skipCount == 0) {
            return this;
        }
        if (skipCount > this.getSegmentCount() || skipCount < 0) {
            throw new IllegalArgumentException("Cannot skip " + skipCount + " fragments from QualifiedName with " + this.getSegmentCount() + " segments");
        }
        String[] newSegments = new String[this.segments.length - skipCount];
        System.arraycopy(this.segments, skipCount, newSegments, 0, newSegments.length);
        return new QualifiedName(newSegments);
    }

    public QualifiedName skipLast(int skipCount) {
        if (skipCount == this.getSegmentCount()) {
            return EMPTY;
        }
        if (skipCount == 0) {
            return this;
        }
        if (skipCount > this.getSegmentCount() || skipCount < 0) {
            throw new IllegalArgumentException("Cannot skip " + skipCount + " fragments from QualifiedName with " + this.getSegmentCount() + " segments");
        }
        String[] newSegments = new String[this.segments.length - skipCount];
        System.arraycopy(this.segments, 0, newSegments, 0, newSegments.length);
        return new QualifiedName(newSegments);
    }

    public QualifiedName toLowerCase() {
        if (this.lowerCase != null) {
            return this.lowerCase;
        }
        String[] newSegments = new String[this.segments.length];
        boolean isLowerCase = true;
        int i = 0;
        while (i < this.getSegmentCount()) {
            String segment = this.segments[i];
            String lowerCaseSegment = segment.toLowerCase();
            isLowerCase = isLowerCase && segment == lowerCaseSegment;
            newSegments[i] = QualifiedName.intern(lowerCaseSegment);
            ++i;
        }
        this.lowerCase = isLowerCase ? this : new QualifiedNameLowerCase(newSegments);
        return this.lowerCase;
    }

    public QualifiedName toUpperCase() {
        String[] newSegments = new String[this.getSegmentCount()];
        int i = 0;
        while (i < this.getSegmentCount()) {
            newSegments[i] = QualifiedName.intern(this.segments[i].toUpperCase());
            ++i;
        }
        QualifiedName result = new QualifiedName(newSegments);
        result.lowerCase = this.lowerCase;
        return result;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QualifiedName) {
            QualifiedName other = (QualifiedName)obj;
            if (this.hash != other.hash) {
                return false;
            }
            return Arrays.equals(this.segments, other.segments);
        }
        return false;
    }

    boolean hasLowerCase() {
        return this.lowerCase != null;
    }

    public boolean equalsIgnoreCase(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QualifiedName) {
            QualifiedName other = (QualifiedName)obj;
            if (this.hasLowerCase() && other.hasLowerCase()) {
                return this.toLowerCase().equals(other.toLowerCase());
            }
            int segmentCount = this.getSegmentCount();
            if (segmentCount != other.getSegmentCount()) {
                return false;
            }
            int i = 0;
            while (i < segmentCount) {
                if (!this.getSegment(i).equalsIgnoreCase(other.getSegment(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(QualifiedName qualifiedName) {
        return this.compareTo(qualifiedName, false);
    }

    public int compareToIgnoreCase(QualifiedName qualifiedName) {
        return this.compareTo(qualifiedName, true);
    }

    protected int compareTo(QualifiedName qualifiedName, boolean ignoreCase) {
        if (ignoreCase) {
            int i = 0;
            int upTo = Math.min(this.getSegmentCount(), qualifiedName.getSegmentCount());
            while (i < upTo) {
                int result = this.getSegment(i).compareToIgnoreCase(qualifiedName.getSegment(i));
                if (result != 0) {
                    return result;
                }
                ++i;
            }
        } else {
            int i = 0;
            int upTo = Math.min(this.getSegmentCount(), qualifiedName.getSegmentCount());
            while (i < upTo) {
                int result = this.getSegment(i).compareTo(qualifiedName.getSegment(i));
                if (result != 0) {
                    return result;
                }
                ++i;
            }
        }
        return this.getSegmentCount() - qualifiedName.getSegmentCount();
    }

    public boolean startsWith(QualifiedName prefix) {
        return this.startsWith(prefix, false);
    }

    public boolean startsWithIgnoreCase(QualifiedName prefix) {
        return this.startsWith(prefix, true);
    }

    protected boolean startsWith(QualifiedName prefix, boolean ignoreCase) {
        Preconditions.checkArgument(prefix != null, "prefix must not be null");
        if (prefix.getSegmentCount() > this.getSegmentCount()) {
            return false;
        }
        if (ignoreCase) {
            int i = 0;
            while (i < prefix.getSegmentCount()) {
                if (!this.getSegment(i).equalsIgnoreCase(prefix.getSegment(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int i = 0;
        while (i < prefix.getSegmentCount()) {
            if (!this.getSegment(i).equals(prefix.getSegment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.toString(".");
    }

    public String toString(String delimiter) {
        int segmentCount = this.getSegmentCount();
        switch (segmentCount) {
            case 0: {
                return "";
            }
            case 1: {
                return this.getFirstSegment();
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getFirstSegment());
        int i = 1;
        while (i < segmentCount) {
            builder.append(delimiter);
            builder.append(this.segments[i]);
            ++i;
        }
        return builder.toString();
    }

    public static final class Builder {
        private final String[] segments;
        private int next;

        public Builder(int size) {
            this.segments = new String[size];
            this.next = 0;
        }

        public void add(String segment) {
            this.segments[this.next++] = QualifiedName.intern(segment);
        }

        public QualifiedName build() {
            if (this.next != this.segments.length) {
                throw new IllegalStateException("Unexpected number of segments");
            }
            return new QualifiedName(this.segments);
        }
    }

    private static class QualifiedNameLowerCase
    extends QualifiedName {
        public QualifiedNameLowerCase(String[] segments) {
            super(segments);
        }

        @Override
        public QualifiedName toLowerCase() {
            return this;
        }

        @Override
        boolean hasLowerCase() {
            return true;
        }

        @Override
        public void writeToStream(BinaryResourceImpl.EObjectOutputStream eObjectOutputStream) throws IOException {
            int segmentCount = this.getSegmentCount();
            eObjectOutputStream.writeCompressedInt(segmentCount);
            eObjectOutputStream.writeSegmentedString(null);
            int i = 0;
            while (i < segmentCount) {
                eObjectOutputStream.writeSegmentedString(this.getSegment(i));
                ++i;
            }
        }
    }
}

