/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.detachable;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.zip.GZIPOutputStream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.detachable.ArrayReference;
import org.eclipse.xtext.nodemodel.detachable.GrammarElementLookup;
import org.eclipse.xtext.nodemodel.detachable.NodeModelData;
import org.eclipse.xtext.nodemodel.detachable.StandardNodeModelReference;
import org.eclipse.xtext.nodemodel.detachable.Tabulated;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.NodeModelOutput;

public class DetachedNodeModelWriter
extends BinaryResourceImpl.EObjectOutputStream
implements NodeModelOutput {
    private final Tabulated<ArrayReference> grammarElementArrays;
    private final Tabulated<EObject> semanticObjects;
    private final Tabulated<SyntaxErrorMessage> syntaxErrorMessages;
    private final GrammarElementLookup grammarElements;
    private final ByteArrayOutputStream bout;
    private Tabulated<INode> externalReferences;

    public DetachedNodeModelWriter(GrammarElementLookup grammarElements) throws IOException {
        this(new ByteArrayOutputStream(), grammarElements);
    }

    public DetachedNodeModelWriter(ByteArrayOutputStream bout, GrammarElementLookup grammarElements) throws IOException {
        super(new GZIPOutputStream((OutputStream)bout, true), Collections.singletonMap("INTERNAL_BUFFER_CAPACITY", 8192), BinaryResourceImpl.BinaryIO.Version.VERSION_1_1, 16);
        this.grammarElements = grammarElements;
        this.syntaxErrorMessages = new Tabulated();
        this.grammarElementArrays = new Tabulated();
        this.semanticObjects = new Tabulated();
        this.bout = bout;
    }

    public NodeModelData serialize(StandardNodeModelReference standard) throws IOException {
        this.externalReferences = standard.externalReferences;
        this.writeCompressedInt(this.externalReferences.size());
        this.writeNode(standard.rootNode);
        this.flush();
        this.outputStream.close();
        return new NodeModelData(this.bout.toByteArray(), this.semanticObjects.getObjects(), this.syntaxErrorMessages.getObjects(), this.grammarElementArrays.getObjects());
    }

    @Override
    protected void writeSignature() throws IOException {
    }

    @Override
    public void writeNode(AbstractNode node, int type) throws IOException {
        type <<= 1;
        int externalId = this.externalReferences.tryGetId(node);
        if (externalId != -1) {
            type |= 1;
        }
        NodeModelOutput.super.writeNode(node, type);
        if (externalId != -1) {
            this.writeCompressedInt(externalId);
        }
    }

    @Override
    public void writeGrammarElement(Object grammarElementOrArray) throws IOException {
        if (grammarElementOrArray != null) {
            if (grammarElementOrArray instanceof EObject) {
                this.writeCompressedInt(this.grammarElements.getId((EObject)grammarElementOrArray));
            } else {
                this.writeCompressedInt(this.grammarElements.size() + this.grammarElementArrays.getId(new ArrayReference((EObject[])grammarElementOrArray)));
            }
        } else {
            this.writeCompressedInt(-1);
        }
    }

    @Override
    public void writeSemanticObject(EObject semanticElement) throws IOException {
        if (semanticElement != null) {
            this.writeCompressedInt(this.semanticObjects.getId(semanticElement));
        } else {
            this.writeCompressedInt(-1);
        }
    }

    @Override
    public void writeSyntaxErrorMessage(SyntaxErrorMessage syntaxErrorMessage) throws IOException {
        if (syntaxErrorMessage != null) {
            this.writeCompressedInt(this.syntaxErrorMessages.getId(syntaxErrorMessage));
        } else {
            this.writeCompressedInt(-1);
        }
    }

    @Override
    public void writeContent(String value) throws IOException {
        this.writeSegmentedString(value);
    }
}

