/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.detachable;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.detachable.AbstractDetachableParseResult;
import org.eclipse.xtext.nodemodel.detachable.NodeModelReference;
import org.eclipse.xtext.nodemodel.detachable.OffloadedNodeModelReference;
import org.eclipse.xtext.nodemodel.detachable.Tabulated;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.impl.RootNode;

public class StandardNodeModelReference
extends NodeModelReference {
    private static final Logger logger = Logger.getLogger(StandardNodeModelReference.class);
    protected final RootNode rootNode;
    protected final Map<EObject, CompositeNodeWithSemanticElement> associations;
    protected final Tabulated<INode> externalReferences;
    protected final AbstractDetachableParseResult<StandardNodeModelReference, ?> parseResult;

    public StandardNodeModelReference(AbstractDetachableParseResult<StandardNodeModelReference, ?> parseResult, RootNode rootNode, Map<EObject, CompositeNodeWithSemanticElement> associations) {
        this(parseResult, rootNode, associations, new Tabulated<INode>());
    }

    public StandardNodeModelReference(AbstractDetachableParseResult<StandardNodeModelReference, ?> parseResult, RootNode rootNode, Map<EObject, CompositeNodeWithSemanticElement> associations, Tabulated<INode> externalReferences) {
        this.rootNode = rootNode;
        this.associations = associations;
        this.externalReferences = externalReferences;
        this.parseResult = parseResult;
    }

    @Override
    protected RootNode rootNode() {
        return this.rootNode;
    }

    @Override
    protected void release() {
        this.serializeAndDetachFrom(this.parseResult);
    }

    protected <Serialized> void serializeAndDetachFrom(AbstractDetachableParseResult<StandardNodeModelReference, Serialized> parseResult) {
        try {
            Serialized serialized = parseResult.serialize(this);
            parseResult.reference = new OffloadedNodeModelReference<Serialized>(parseResult, serialized);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    protected ICompositeNode getNode(EObject semanticObject) {
        return this.associations.get(semanticObject);
    }

    @Override
    protected INode getNode(int id) {
        return this.externalReferences.getObject(id);
    }

    @Override
    protected int getId(INode node) {
        return this.externalReferences.getId(node);
    }

    public String toString() {
        String rootNodeStats = "[content=" + this.rootNode.getCompleteContent().length() + ", nodes=" + Iterators.size(this.rootNode.basicIterator()) + "]";
        return "StandardNodeModelReference [rootNode=" + rootNodeStats + ", associations=" + this.associations.size() + ", externalReferences=" + this.externalReferences.size() + "]";
    }
}

