/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaFactory;
import org.eclipse.xtext.util.formallang.StringNfa;

public class StringPda
extends StringNfa
implements Pda<String, String> {
    protected final Map<String, String> pops = Maps.newLinkedHashMap();
    protected final Map<String, String> pushs = Maps.newLinkedHashMap();

    public StringPda(String start, String stop) {
        super(start, stop);
    }

    @Override
    public String getPop(String state) {
        return this.pops.get(state);
    }

    @Override
    public String getPush(String state) {
        return this.pushs.get(state);
    }

    @Override
    public StringPDAState start() {
        return new StringPDAState(this.start);
    }

    @Override
    public StringPDAState state(String state) {
        return new StringPDAState(state);
    }

    @Override
    public StringPDAState stop() {
        return new StringPDAState(this.stop);
    }

    public class StringPDAState
    extends StringNfa.StringNfaState {
        protected StringPDAState(String name) {
            super(name);
        }

        @Override
        public StringPDAState followedBy(String ... states) {
            super.followedBy(states);
            return this;
        }

        public StringPDAState pop(String pop) {
            StringPda.this.pops.put(this.name, pop);
            return this;
        }

        public StringPDAState push(String push) {
            StringPda.this.pushs.put(this.name, push);
            return this;
        }
    }

    public static class StringPdaFactory<T>
    implements PdaFactory<StringPda, String, String, T> {
        protected Function<T, String> formatter;
        protected String nullStart;
        protected String nullState;
        protected String nullStop;

        public StringPdaFactory() {
            this("(start:null)", "(stop:null)");
        }

        public StringPdaFactory(String nullStart, String nullStop) {
            this(nullStart, nullStop, "(null)");
        }

        public StringPdaFactory(String nullStart, String nullStop, String nullState) {
            this.nullStart = nullStart;
            this.nullStop = nullStop;
            this.nullState = nullState;
        }

        @Override
        public StringPda create(T start, T stop) {
            return new StringPda(this.tokenToStr(start, this.nullStart), this.tokenToStr(stop, this.nullStop));
        }

        @Override
        public String createPop(StringPda pda, T token) {
            String pop = this.tokenToStr(token, this.nullState);
            Object s = pop.startsWith("<<") ? pop : "<<" + pop;
            pda.state((String)s).pop(pop);
            return s;
        }

        @Override
        public String createPush(StringPda pda, T token) {
            String push = this.tokenToStr(token, this.nullState);
            Object s = push.startsWith(">>") ? push : ">>" + push;
            pda.state((String)s).push(push);
            return s;
        }

        @Override
        public String createState(StringPda pda, T token) {
            return this.tokenToStr(token, this.nullState);
        }

        @Override
        public void setFollowers(StringPda pda, String owner, Iterable<String> followers) {
            pda.state(owner).followedBy(Iterables.toArray(followers, String.class));
        }

        public StringPdaFactory<T> setTokenFormatter(Function<T, String> formatter) {
            this.formatter = formatter;
            return this;
        }

        protected String tokenToStr(T token, String nullValue) {
            if (token == null) {
                return nullValue;
            }
            if (this.formatter != null) {
                return this.formatter.apply(token);
            }
            return token.toString();
        }
    }
}

