/*
 * Decompiled with CFR 0.152.
 */
package com.seanox.devwex;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class Generator {
    private HashMap scopes = new HashMap();
    private byte[] model;

    private Generator() {
    }

    public static Generator parse(byte[] byArray) {
        Generator generator = new Generator();
        generator.model = generator.scan(byArray);
        return generator;
    }

    private static int scan(byte[] byArray, int n) {
        if (byArray == null || n >= byArray.length) {
            return -1;
        }
        if (n + 1 >= byArray.length || byArray[n] != 35 || byArray[n + 1] != 91) {
            return 0;
        }
        int n2 = n;
        int n3 = 0;
        int[] nArray = new int[65535];
        while (n < byArray.length) {
            int n4 = 0;
            if (n3 > 0) {
                n4 = nArray[n3];
            }
            if (n + 1 < byArray.length && byArray[n] == 35 && byArray[n + 1] == 91 && n4 != 1) {
                if (n3 < 65535) {
                    nArray[++n3] = 1;
                }
                n += 2;
                continue;
            }
            if (n + 1 < byArray.length && byArray[n] == 91 && byArray[n + 1] == 91 && n4 == 1) {
                nArray[n3] = 2;
                n += 2;
                continue;
            }
            if (byArray[n] == 93 && n4 == 1) {
                if (--n3 <= 0) break;
                ++n;
                continue;
            }
            if (n + 2 < byArray.length && byArray[n + 0] == 93 && byArray[n + 1] == 93 && byArray[n + 2] == 93 && n4 == 2) {
                n += 2;
                if (--n3 <= 0) break;
                ++n;
                continue;
            }
            ++n;
        }
        if (n3 > 0) {
            return byArray.length - n2;
        }
        return n - n2 + 1;
    }

    private byte[] scan(byte[] object) {
        int n;
        if (object == null) {
            return new byte[0];
        }
        int n2 = 0;
        while ((n = Generator.scan(object, n2++)) >= 0) {
            Object object2;
            String string;
            if (n == 0) continue;
            byte[] byArray = new byte[]{};
            if ((string = new String((byte[])object, --n2, n)).matches("^(?si)#\\[[a-z]([\\w\\-]*\\w)?\\[\\[.*\\]\\]\\]$")) {
                object2 = string.substring(2);
                object2 = ((String)object2).substring(0, ((String)object2).indexOf(91));
                object2 = ((String)object2).toLowerCase();
                byte[] byArray2 = new byte[n - ((String)object2).length() - 7];
                System.arraycopy(object, n2 + ((String)object2).length() + 4, byArray2, 0, byArray2.length);
                if (!this.scopes.containsKey(object2)) {
                    this.scopes.put(object2, this.scan(byArray2));
                }
                byArray = "#[".concat((String)object2).concat("]").getBytes();
            } else if (string.matches("^(?i)#\\[[a-z]([\\w-]*\\w)?\\]$")) {
                byArray = string.toLowerCase().getBytes();
            } else if (string.matches("^(?i)#\\[0x([0-9A-F]{2})+\\]$")) {
                n2 += string.length() + 1;
                continue;
            }
            object2 = new byte[((byte[])object).length - n + byArray.length];
            System.arraycopy(object, 0, object2, 0, n2);
            System.arraycopy(byArray, 0, object2, n2, byArray.length);
            System.arraycopy(object, n2 + n, object2, n2 + byArray.length, ((byte[])object).length - n2 - n);
            object = object2;
            n2 += byArray.length;
        }
        return object;
    }

    private byte[] assemble(String string, Map hashMap, boolean bl) {
        int n;
        byte[] byArray;
        if (this.model == null) {
            return new byte[0];
        }
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
        }
        hashMap = new HashMap(hashMap);
        for (String string2 : new HashMap(hashMap).keySet()) {
            hashMap.put(string2.toLowerCase().trim(), hashMap.get(string2));
        }
        if (string != null) {
            if (!this.scopes.containsKey(string = string.toLowerCase().trim())) {
                return this.model;
            }
            byArray = this.extract(string, hashMap);
            hashMap.clear();
            hashMap.put(string, byArray);
        }
        int n2 = 0;
        while ((n = Generator.scan(this.model, n2++)) >= 0) {
            byte[] byArray2;
            if (n == 0) continue;
            byArray = new byte[]{};
            if ((string = new String(this.model, --n2, n)).matches("^(?i)#\\[[a-z]([\\w-]*\\w)?\\]$")) {
                if (!hashMap.containsKey(string = string.substring(2, string.length() - 1)) && !bl) {
                    n2 += string.length() + 3 + 1;
                    continue;
                }
                Object object2 = hashMap.get(string);
                if (this.scopes.containsKey(string) && object2 instanceof Map) {
                    byArray = this.extract(string, (Map)object2);
                } else if (this.scopes.containsKey(string) && object2 instanceof Collection) {
                    for (Object object2 : (Collection)object2) {
                        byte[] byArray3;
                        if (object2 instanceof Map) {
                            byArray3 = this.extract(string, (Map)object2);
                        } else if (object2 instanceof byte[]) {
                            byArray3 = (byte[])object2;
                        } else {
                            if (object2 == null) continue;
                            byArray3 = String.valueOf(object2).getBytes();
                        }
                        byArray2 = new byte[byArray.length + byArray3.length];
                        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                        System.arraycopy(byArray3, 0, byArray2, byArray.length, byArray3.length);
                        byArray = byArray2;
                    }
                } else if (object2 instanceof byte[]) {
                    byArray = (byte[])object2;
                } else if (object2 != null) {
                    byArray = String.valueOf(object2).getBytes();
                }
                if (!bl) {
                    int n3 = 0;
                    while (n3 < byArray.length) {
                        if (byArray[n3++] != 35) continue;
                        byArray2 = new byte[byArray.length + 6];
                        System.arraycopy(byArray, 0, byArray2, 0, n3);
                        System.arraycopy("[0x23]".getBytes(), 0, byArray2, n3, 6);
                        System.arraycopy(byArray, n3, byArray2, n3 + 6, byArray.length - n3);
                        byArray = byArray2;
                    }
                    if (this.scopes.containsKey(string)) {
                        string = "#[".concat(string).concat("]");
                        byArray2 = new byte[byArray.length + string.length()];
                        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                        System.arraycopy(string.getBytes(), 0, byArray2, byArray.length, string.length());
                        byArray = byArray2;
                    }
                }
            } else if (string.matches("^(?i)#\\[0x([0-9A-F]{2})+\\]$")) {
                if (!bl) {
                    n2 += string.length() + 1;
                    continue;
                }
                string = string.substring(4, string.length() - 1);
                string = "ff".concat(string);
                byArray = new BigInteger(string, 16).toByteArray();
                byArray = Arrays.copyOfRange(byArray, 2, byArray.length);
            }
            byArray2 = new byte[this.model.length - n + byArray.length];
            System.arraycopy(this.model, 0, byArray2, 0, n2);
            System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
            System.arraycopy(this.model, n2 + n, byArray2, n2 + byArray.length, this.model.length - n2 - n);
            this.model = byArray2;
            n2 += byArray.length;
        }
        return this.model;
    }

    public Enumeration scopes() {
        return Collections.enumeration(this.scopes.keySet());
    }

    public byte[] extract() {
        return (byte[])this.assemble(null, null, true).clone();
    }

    public byte[] extract(String string) {
        return this.extract(string, null);
    }

    public byte[] extract(String string, Map map) {
        if (string != null) {
            string = string.toLowerCase().trim();
        }
        if (string == null || !string.matches("^[a-z]([\\w-]*\\w)?$")) {
            return new byte[0];
        }
        Generator generator = new Generator();
        generator.scopes = (HashMap)this.scopes.clone();
        generator.scopes.remove(string);
        generator.model = (byte[])this.scopes.get(string);
        return generator.assemble(null, map, true);
    }

    public void set(Map map) {
        this.set(null, map);
    }

    public void set(String string, Map map) {
        if (string != null) {
            string = string.toLowerCase().trim();
        }
        if (string != null && !string.matches("^[a-z]([\\w-]*\\w)?$")) {
            return;
        }
        this.model = this.assemble(string, map, false);
    }
}

