/*
 * Decompiled with CFR 0.152.
 */
package com.seanox.devwex;

import com.seanox.devwex.Initialize;
import com.seanox.devwex.Section;
import com.seanox.devwex.Service;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class Remote
implements Runnable {
    private final ServerSocket socket;
    private final String caption;
    private volatile Socket accept;

    public Remote(String string, Initialize initialize) throws Throwable {
        if (string == null) {
            string = "";
        }
        string = string.trim();
        Section section = initialize.get(string.concat(":ini"));
        InetAddress inetAddress = null;
        String string2 = section.get("address").toLowerCase();
        if (!string2.equals("auto")) {
            inetAddress = InetAddress.getByName(string2);
        }
        int n = 0;
        try {
            n = Integer.parseInt(section.get("port"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.socket = new ServerSocket(n, 0, inetAddress);
        this.socket.setSoTimeout(10000);
        this.caption = "TCP ".concat(this.socket.getInetAddress().getHostAddress()).concat(":").concat(String.valueOf(n));
    }

    public String explain() {
        return this.caption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] call(String string, int n, String string2) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Socket socket = new Socket(string, n);
        try {
            int n2;
            string2 = string2 == null ? "" : string2.trim();
            socket.getOutputStream().write(string2.concat("\r\n").getBytes());
            byte[] byArray = new byte[65535];
            InputStream inputStream = socket.getInputStream();
            while ((n2 = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
                Thread.sleep(25L);
            }
        }
        finally {
            try {
                socket.close();
            }
            catch (Throwable throwable) {}
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static void service(Socket socket) {
        try {
            String string;
            int n;
            socket.setSoTimeout(10000);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = socket.getInputStream();
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(n);
                if (byteArrayOutputStream.size() < 65535 && n != 10 && n != 13) continue;
            }
            string = "status".equals(string = byteArrayOutputStream.toString().toLowerCase().trim()) ? Service.details() : ("restart".equals(string) ? "SERVICE RESTART".concat(!Service.restart() ? " FAILED" : "ED") : ("stop".equals(string) ? "SERVICE STOP".concat(!Service.destroy() ? " FAILED" : "PED") : "UNKNOWN COMMAND"));
            socket.getOutputStream().write(string.concat("\r\n").getBytes());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void destroy() {
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void run() {
        if (this.accept != null) {
            Remote.service(this.accept);
            return;
        }
        Service.print("SERVER ".concat(this.caption).concat(" READY"));
        Thread thread = null;
        while (!this.socket.isClosed()) {
            try {
                if (thread == null || !thread.isAlive()) {
                    this.accept = this.socket.accept();
                    thread = new Thread(this);
                    thread.start();
                }
                try {
                    Thread.sleep(250L);
                }
                catch (Throwable throwable) {
                    this.destroy();
                }
            }
            catch (SocketException socketException) {
                this.destroy();
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (Throwable throwable) {
                Service.print(throwable);
                try {
                    this.accept.close();
                }
                catch (Throwable throwable2) {
                    this.destroy();
                }
            }
        }
        Service.print("SERVER ".concat(this.caption).concat(" STOPPED"));
    }
}

