/*
 * Decompiled with CFR 0.152.
 */
package com.seanox.devwex;

import com.seanox.devwex.Initialize;
import com.seanox.devwex.Section;
import com.seanox.devwex.Service;
import com.seanox.devwex.Worker;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManagerFactory;

public class Server
implements Runnable {
    private final Initialize initialize;
    private final ServerSocket socket;
    private final String context;
    private final String caption;
    private final Vector worker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server(String string, Initialize initialize) throws Throwable {
        if (string == null) {
            string = "";
        }
        this.context = string.trim();
        this.initialize = (Initialize)initialize.clone();
        Section section = this.initialize.get(this.context.concat(":ini"));
        InetAddress inetAddress = null;
        String string2 = section.get("address").toLowerCase();
        if (!string2.equals("auto")) {
            inetAddress = InetAddress.getByName(string2);
        }
        int n = 0;
        try {
            n = Integer.parseInt(section.get("port"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(section.get("backlog"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int n3 = 0;
        try {
            n3 = Integer.parseInt(section.get("timeout"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        string = this.context.concat(":ssl");
        if (this.initialize.contains(string)) {
            section = this.initialize.get(string);
            String string3 = section.get("password");
            KeyStore keyStore = KeyStore.getInstance(section.get("type", KeyStore.getDefaultType()));
            FileInputStream fileInputStream = new FileInputStream(section.get("keystore"));
            try {
                keyStore.load(fileInputStream, string3.toCharArray());
            }
            finally {
                fileInputStream.close();
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(section.get("algorithm", KeyManagerFactory.getDefaultAlgorithm()));
            keyManagerFactory.init(keyStore, string3.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(section.get("algorithm", TrustManagerFactory.getDefaultAlgorithm()));
            trustManagerFactory.init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance(section.get("protocol", "TLS"));
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            this.socket = sSLContext.getServerSocketFactory().createServerSocket(n, n2, inetAddress);
            if (section.get("clientauth").toLowerCase().equals("on")) {
                ((SSLServerSocket)this.socket).setNeedClientAuth(true);
            }
            if (section.get("clientauth").toLowerCase().equals("auto")) {
                ((SSLServerSocket)this.socket).setWantClientAuth(true);
            }
        } else {
            this.socket = new ServerSocket(n, n2, inetAddress);
        }
        this.socket.setSoTimeout(n3);
        this.caption = "TCP ".concat(this.socket.getInetAddress().getHostAddress()).concat(":").concat(String.valueOf(n));
        this.worker = new Vector(256, 256);
    }

    public String explain() {
        return this.caption;
    }

    public void destroy() {
        try {
            this.socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void run() {
        Service.print("SERVER ".concat(this.caption).concat(" READY"));
        Section section = this.initialize.get(this.context.concat(":ini"));
        int n = 0;
        try {
            n = Integer.parseInt(section.get("maxaccess"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            int n2 = 0;
            while (!this.socket.isClosed()) {
                Runnable runnable;
                Runnable runnable2;
                boolean bl = false;
                Enumeration enumeration = ((Vector)this.worker.clone()).elements();
                while (enumeration.hasMoreElements() && !this.socket.isClosed()) {
                    Object[] objectArray = (Object[])enumeration.nextElement();
                    runnable2 = (Thread)objectArray[1];
                    if (!runnable2.isAlive() && bl) {
                        this.worker.remove(objectArray);
                    }
                    if (((Worker)(runnable = (Worker)objectArray[0])).available() && bl) {
                        ((Worker)runnable).isolate();
                    }
                    if (!((Worker)runnable).available() || !runnable2.isAlive()) continue;
                    bl = true;
                }
                for (int i = n2 = bl ? 0 : (n <= 0 ? 1 : n2 + n2 + 1); !(this.socket.isClosed() || i <= 0 || this.worker.size() >= n && n > 0); --i) {
                    runnable2 = new Worker(this.context, this.socket, (Initialize)this.initialize.clone());
                    runnable = new Thread(runnable2);
                    this.worker.add(new Object[]{runnable2, runnable});
                    ((Thread)runnable).start();
                }
                try {
                    Thread.sleep(25L);
                }
                catch (Throwable throwable) {
                    this.destroy();
                }
            }
        }
        catch (Throwable throwable) {
            Service.print(throwable);
        }
        this.destroy();
        Enumeration enumeration = this.worker.elements();
        while (enumeration.hasMoreElements()) {
            ((Worker)((Object[])enumeration.nextElement())[0]).destroy();
        }
        Service.print("SERVER ".concat(this.caption).concat(" STOPPED"));
    }
}

