/*
 * Decompiled with CFR 0.152.
 */
package com.seanox.devwex;

import com.seanox.devwex.Generator;
import com.seanox.devwex.Initialize;
import com.seanox.devwex.Section;
import com.seanox.devwex.Service;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

class Worker
implements Runnable {
    private final String context;
    private final Initialize initialize;
    private ServerSocket socket;
    private Socket accept;
    private InputStream input;
    private OutputStream output;
    private Section access;
    private Section environment;
    private Section fields;
    private Section filters;
    private Section interfaces;
    private Section mediatypes;
    private Section options;
    private Section references;
    private Section statuscodes;
    private String docroot;
    private String gateway;
    private String header;
    private String mediatype;
    private String resource;
    private String sysroot;
    private boolean control;
    private int blocksize;
    private int status;
    private long interrupt;
    private long timelock;
    private long timeout;
    private long volume;

    Worker(String string, ServerSocket serverSocket, Initialize initialize) {
        this.context = string;
        this.socket = serverSocket;
        this.initialize = initialize;
        Section section = new Section(true);
        Section section2 = this.initialize.get("mediatypes");
        if (section2 != null) {
            Enumeration enumeration = section2.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                StringTokenizer stringTokenizer = new StringTokenizer(section2.get(string2));
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken().trim();
                    if (string3.length() <= 0) continue;
                    section.set(string3, string2.toLowerCase());
                }
            }
            section2.clear();
            section2.merge(section);
        }
    }

    private static String cleanOptions(String string) {
        int n = string.indexOf(91);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n).trim();
    }

    private static String textHash(String string) throws Exception {
        if (string == null) {
            string = "";
        }
        MessageDigest messageDigest = MessageDigest.getInstance("md5");
        byte[] byArray = messageDigest.digest(string.getBytes());
        string = new BigInteger(1, byArray).toString(16);
        while (string.length() < 32) {
            string = "0".concat(string);
        }
        return string;
    }

    private static String textEscape(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = "\b\t\n\f\r\"'\\btnfr\"'\\".getBytes();
        byte[] byArray2 = "0123456789ABCDEF".getBytes();
        byte[] byArray3 = new byte[n * 6];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n3 = Arrays.binarySearch(byArray, (byte)c);
            if (n3 >= 0 && n3 < 8) {
                byArray3[n2++] = 92;
                byArray3[n2++] = byArray[n3 + 8];
                continue;
            }
            if (c > '\u00ff') {
                byArray3[n2++] = 92;
                byArray3[n2++] = 117;
                byArray3[n2++] = byArray2[c >> 12 & 0xF];
                byArray3[n2++] = byArray2[c >> 8 & 0xF];
                byArray3[n2++] = byArray2[c >> 4 & 0xF];
                byArray3[n2++] = byArray2[c & 0xF];
                continue;
            }
            if (c < ' ' || c > '\u007f') {
                byArray3[n2++] = 92;
                byArray3[n2++] = 120;
                byArray3[n2++] = byArray2[c >> 4 & 0xF];
                byArray3[n2++] = byArray2[c & 0xF];
                continue;
            }
            byArray3[n2++] = (byte)c;
        }
        return new String(byArray3, 0, n2);
    }

    private static String textDecode(String string) {
        int n;
        int n2;
        if (string == null) {
            string = "";
        }
        int n3 = string.length();
        byte[] byArray = new byte[n3 * 2];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n = string.charAt(n2);
            if (n == 43) {
                n = 32;
            }
            if (n == 37) {
                n2 += 2;
                try {
                    n = Integer.parseInt(string.substring(n2 - 1, n2 + 1), 16);
                }
                catch (Throwable throwable) {
                    n2 -= 2;
                }
            }
            byArray[n4++] = (byte)n;
        }
        byArray = Arrays.copyOfRange(byArray, 0, n4);
        n3 = byArray.length;
        n2 = 0;
        n = 0;
        boolean bl = false;
        n4 = 0;
        for (int i = 0; i < n3; ++i) {
            int n5 = byArray[i] & 0xFF;
            if (n5 >= 192 && n5 <= 195) {
                bl = true;
            }
            if ((n5 & 0xC0) == 128) {
                n = n << 6 | n5 & 0x3F;
                if (--n2 != 0) continue;
                byArray[n4++] = (byte)n;
                bl = false;
                continue;
            }
            n = 0;
            n2 = 0;
            if ((n5 & 0x80) == 0 || !bl) {
                byArray[n4++] = (byte)n5;
                bl = false;
            }
            if ((n5 & 0xE0) == 192) {
                n2 = 1;
                n = n5 & 0x1F;
                continue;
            }
            if ((n5 & 0xF0) == 224) {
                n2 = 2;
                n = n5 & 0xF;
                continue;
            }
            if ((n5 & 0xF8) == 240) {
                n2 = 3;
                n = n5 & 7;
                continue;
            }
            if ((n5 & 0xFC) == 248) {
                n2 = 4;
                n = n5 & 3;
                continue;
            }
            if ((n5 & 0xFE) != 252) continue;
            n2 = 5;
            n = n5 & 1;
        }
        return new String(byArray, 0, n4);
    }

    private static String dateFormat(String string, Date date, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.US);
        if (string2 != null) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string2));
        }
        return simpleDateFormat.format(date);
    }

    private static byte[] fileRead(File file) {
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static String fileNormalize(String string) {
        int n;
        String string2 = string.replace('\\', '/').trim();
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n).concat(string2.substring(n + 1));
        }
        if (string2.endsWith("/.")) {
            string2 = string2.concat("/");
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n).concat(string2.substring(n + 2));
        }
        if (string2.endsWith("/..")) {
            string2 = string2.concat("/");
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            String string3 = string2.substring(n + 3);
            string2 = string2.substring(0, n);
            n = string2.lastIndexOf("/");
            n = Math.max(0, n);
            string2 = string2.substring(0, n).concat(string3);
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n).concat(string2.substring(n + 1));
        }
        return string2;
    }

    private static boolean fileDelete(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return true;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (Worker.fileDelete(fileArray[i])) continue;
                return false;
            }
        }
        return file.delete();
    }

    private static boolean fileIsModified(File file, String string) {
        if (string.length() <= 0) {
            return true;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z", Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            long l = simpleDateFormat.parse(stringTokenizer.nextToken()).getTime() / 1000L;
            if (l != file.lastModified() / 1000L) {
                return true;
            }
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                string = stringTokenizer.nextToken().trim();
                if (!string.toLowerCase().startsWith("length") || (n = string.indexOf("=")) < 0) continue;
                return file.length() != Long.parseLong(string.substring(n + 1).trim());
            }
        }
        catch (Throwable throwable) {
            return true;
        }
        return false;
    }

    private static File fileCanonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private boolean invoke(String string, String string2) throws Exception {
        if (string2 == null || string2.trim().length() <= 0) {
            return false;
        }
        Object object = Service.load(Service.load(string), null);
        if (object == null) {
            return false;
        }
        String string3 = this.environment.get("module_opts");
        if (string3.length() <= 0) {
            string3 = null;
        }
        Method method = object.getClass().getMethod(string2, Object.class, String.class);
        method.invoke(object, this, string3);
        return true;
    }

    private String locate(String string) {
        String string2 = (string = string.replace('\\', '/').trim()).toLowerCase();
        if (!string2.endsWith("/")) {
            string2 = string2.concat("/");
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Enumeration enumeration = this.references.elements();
        Object object = null;
        while (enumeration.hasMoreElements()) {
            boolean bl5;
            String string9;
            String string10 = ((String)enumeration.nextElement()).toLowerCase();
            int n = (string10 = this.references.get(string10)).indexOf(62);
            if (n < 0) {
                n = string10.replace(']', '[').indexOf(91);
                if (n < 0) continue;
                string9 = string10.substring(0, n).trim();
                string10 = string10.substring(n).trim();
            } else {
                string9 = string10.substring(0, n).trim();
                string10 = string10.substring(n + 2).trim();
            }
            String string11 = Worker.cleanOptions(string10);
            string9 = Worker.fileNormalize(string9);
            String string12 = string10.toUpperCase();
            boolean bl6 = string12.contains("[A]") || string12.contains("[M]");
            boolean bl7 = bl5 = string12.contains("[M]") || string12.contains("[R]");
            if (string9.length() <= 0 || bl5 && string11.length() <= 0 || string10.length() <= 0 && string11.length() <= 0) continue;
            if (!string9.startsWith("/")) {
                string9 = "/".concat(string9);
            }
            if (string11.length() <= 0) {
                string11 = this.docroot.concat(string9);
            }
            String string13 = string9;
            if (!bl6 && !string13.endsWith("/") && string13.length() > 0) {
                string13 = string13.concat("/");
            }
            if (string2.startsWith(string13.toLowerCase()) && string13.length() > 0 && string7.length() <= string13.length()) {
                bl2 = string12.contains("[C]");
                if (!bl5 && (object = Worker.fileCanonical(new File(string11))) != null) {
                    string11 = ((File)object).getPath().replace('\\', '/');
                    if (((File)object).isDirectory() && !string11.endsWith("/")) {
                        string11 = string11.concat("/");
                    }
                }
                if (object != null || bl6 || bl5) {
                    string5 = string11;
                    string6 = string10;
                    string7 = string9;
                    bl3 = string12.contains("[M]");
                    bl = string12.contains("[A]") && !bl3;
                    bl4 = string12.contains("[R]") && !bl3;
                }
            }
            string13 = string9;
            if (!(bl || bl3 || string13.endsWith("/") || string13.length() <= 0)) {
                string13 = string13.concat("/");
            }
            if (!string12.contains("[ACC:") || !string2.startsWith(string13.toLowerCase()) || string13.length() <= 0 || string8.length() > string13.length()) continue;
            string8 = string13;
            string3 = string10.replaceAll("(?i)(\\[(((acc|realm):[^\\[\\]]*?)|d)\\])", "\u0000$1\u0001");
            string3 = string3.replaceAll("[^\u0001]+(\u0000|$)", "");
            string3 = string3.replaceAll("[\u0000\u0001]+", " ");
        }
        if (string7.length() <= 0) {
            string7 = string;
        }
        if (string7.length() > 0) {
            String string14 = string4 = bl || bl3 ? string5 : string5.concat(string.substring(Math.min(string.length(), string7.length())));
            if (bl || bl3) {
                object = string.substring(0, Math.min(string.length(), string7.length()));
                this.environment.set("script_name", (String)object);
                this.environment.set("path_context", (String)object);
                this.environment.set("path_info", string.substring(((String)object).length()));
            }
            if (bl3) {
                string4 = string6;
            }
        }
        if (string4.length() <= 0) {
            string4 = this.docroot.concat(this.environment.get("path_url"));
        }
        if (bl3) {
            return string4.concat(string3);
        }
        if (bl) {
            string4 = string4.concat("[A]");
        }
        if (bl2) {
            string4 = string4.concat("[C]");
        }
        if (bl4) {
            string4 = string4.concat("[R]");
        }
        return string4.concat(string3);
    }

    private void authorize(String string) throws Exception {
        String string2 = string.toLowerCase();
        if (!string2.contains("[acc:") || this.status >= 500) {
            return;
        }
        String string3 = string.replaceAll("^(.*(\\[\\s*(?i)realm:([^\\[\\]]*?)\\s*\\]).*)|.*$", "$3").replace("\"", "\\\"");
        this.fields.set("auth_realm", string3);
        boolean bl = string2.contains("[d]");
        this.fields.set("auth_type", bl ? "Digest" : "Basic");
        string2 = string2.replaceAll("\\[acc:([^\\[\\]]*?)\\]", "\u0000$1\u0001");
        string2 = string2.replaceAll("((((^|\u0001).*?)\u0000)|(\u0001.*$))|(^.*$)", " ").trim();
        String string4 = "";
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("none")) {
                return;
            }
            bl2 = true;
            string4 = string4.concat(" ").concat(this.access.get(string2));
        }
        if ((string4 = string4.trim()).length() <= 0) {
            if (bl2) {
                this.status = 401;
            }
            return;
        }
        string2 = this.fields.get("http_authorization");
        if (string2.toLowerCase().startsWith("digest ") && bl) {
            string2 = string2.replaceAll("(\\w+)\\s*=\\s*(?:(?:\"(.*?)\")|([^,]*))", "\u0000$1=$2$3\n");
            string2 = string2.replaceAll("[^\n]+\u0000", "");
            Section section = Section.parse(string2, true);
            String string5 = section.get("response");
            String string6 = section.get("username");
            string2 = Worker.textHash(this.environment.get("request_method").concat(":").concat(section.get("uri")));
            string2 = ":".concat(section.get("nonce")).concat(":").concat(section.get("nc")).concat(":").concat(section.get("cnonce")).concat(":").concat(section.get("qop")).concat(":").concat(string2);
            stringTokenizer = new StringTokenizer(string4);
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                if (string6.equals(string4)) {
                    string4 = string4.substring(string6.length());
                } else {
                    if (!string4.startsWith(string6.concat(":"))) continue;
                    string4 = string4.substring(string6.length() + 1);
                }
                string4 = Worker.textHash(string6.concat(":").concat(string3).concat(":").concat(string4));
                if (!string5.equals(string4 = Worker.textHash(string4.concat(string2)))) continue;
                this.fields.set("auth_user", string6);
                return;
            }
        } else if (string2.toLowerCase().startsWith("basic ") && !bl) {
            try {
                string2 = new String(Base64.getDecoder().decode(string2.substring(6).getBytes())).trim();
            }
            catch (Throwable throwable) {
                string2 = "";
            }
            string4 = " ".concat(string4).concat(" ");
            if (string2.length() > 0 && string4.contains(" ".concat(string2).concat(" "))) {
                string2 = string2.substring(0, Math.max(0, string2.indexOf(58))).trim();
                this.fields.set("auth_user", string2);
                return;
            }
        }
        this.status = 401;
    }

    private String filter() throws Exception {
        if (this.status == 400 || this.status >= 500) {
            return this.resource;
        }
        String string = this.resource;
        Enumeration enumeration = this.filters.elements();
        block0: while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = this.filters.get((String)enumeration.nextElement());
            int n = string3.indexOf(62);
            String string4 = string2 = n >= 0 ? string3.substring(n + 1).trim() : "";
            if (n >= 0) {
                string3 = string3.substring(0, n);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "[+]");
            while (stringTokenizer.hasMoreTokens()) {
                Object object;
                String string5;
                boolean bl;
                String string6 = stringTokenizer.nextToken().toLowerCase().trim();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string6);
                if (stringTokenizer2.countTokens() < 2) continue;
                String string7 = stringTokenizer2.nextToken();
                if (string7.length() > 0 && !string7.equals("all") && !string7.equals(this.environment.get("request_method").toLowerCase())) continue block0;
                String string8 = stringTokenizer2.nextToken();
                if (!string8.equals("always")) {
                    String string9;
                    if (!string8.equals("is") && !string8.equals("not")) continue block0;
                    bl = string8.equals("is");
                    if (stringTokenizer2.countTokens() < 2) continue block0;
                    string5 = stringTokenizer2.nextToken();
                    object = this.environment.get(stringTokenizer2.nextToken()).toLowerCase();
                    String string10 = Worker.textDecode((String)object);
                    String string11 = string9 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : "";
                    if (string5.equals("starts") && bl != (((String)object).startsWith(string9) || string10.startsWith(string9)) || string5.equals("contains") && bl != (((String)object).contains(string9) || string10.contains(string9)) || string5.equals("equals") && bl != (((String)object).equals(string9) || string10.equals(string9)) || string5.equals("ends") && bl != (((String)object).endsWith(string9) || string10.endsWith(string9)) || string5.equals("match") && bl != (((String)object).matches(string9) || string10.matches(string9)) || string5.equals("empty") && bl != ((String)object).length() <= 0) continue block0;
                    if (stringTokenizer.hasMoreTokens()) continue;
                }
                string5 = Worker.cleanOptions(string2);
                if (string2.toUpperCase().contains("[M]") && string5.length() > 0) {
                    bl = this.control;
                    int n2 = this.status;
                    this.environment.set("module_opts", string2);
                    this.invoke(string5, "filter");
                    if (this.control == bl && this.status == n2) continue;
                    return this.resource;
                }
                if (string2.toUpperCase().contains("[R]") && string5.length() > 0) {
                    this.environment.set("script_uri", string5);
                    this.status = 302;
                    return string;
                }
                if (string5.length() > 0 && (object = Worker.fileCanonical(new File(string2))) != null && ((File)object).exists()) {
                    return ((File)object).getPath();
                }
                this.status = 403;
                return string;
            }
        }
        return string;
    }

    private void initiate() throws Exception {
        String string;
        String string2;
        String string3;
        Object object;
        boolean bl;
        Object object2;
        Object object3;
        String string4;
        String string5;
        String string6;
        String string7;
        int n;
        ByteArrayOutputStream byteArrayOutputStream;
        block70: {
            try {
                this.blocksize = Integer.parseInt(this.options.get("blocksize"));
            }
            catch (Throwable throwable) {
                this.blocksize = 65535;
            }
            if (this.blocksize <= 0) {
                this.blocksize = 65535;
            }
            if (this.accept instanceof SSLSocket) {
                try {
                    this.fields.set("auth_cert", ((SSLSocket)this.accept).getSession().getPeerPrincipal().getName());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            byteArrayOutputStream = new ByteArrayOutputStream(65535);
            try {
                int n2;
                this.input = new BufferedInputStream(this.input, this.blocksize);
                int n3 = 0;
                n = 0;
                int n4 = 0;
                while ((n2 = this.input.read()) >= 0) {
                    int n5 = n = n2 == (n % 2 == 0 ? 13 : 10) ? n + 1 : 0;
                    if (n > 0 && n3 > 0 && n4 > 0 && byteArrayOutputStream.size() > 0) {
                        n4 = (string7 = new String(byteArrayOutputStream.toByteArray(), n4, byteArrayOutputStream.size() - n4)).indexOf(58);
                        string6 = string7.substring(n4 < 0 ? string7.length() : n4 + 1).trim();
                        string7 = string7.substring(0, n4 < 0 ? string7.length() : n4).trim();
                        if (!this.fields.contains(string7 = "http_".concat(string7.replace('-', '_'))) && string7.length() > 0 && string6.length() > 0) {
                            this.fields.set(string7, string6);
                        }
                        n4 = byteArrayOutputStream.size();
                    }
                    int n6 = n3 = n > 0 ? 0 : n3 + 1;
                    if (n3 == 1) {
                        n4 = byteArrayOutputStream.size();
                    }
                    if (n3 > 32768) {
                        this.status = 413;
                    }
                    byteArrayOutputStream.write(n2);
                    if (byteArrayOutputStream.size() >= 65535 && n < 4) {
                        this.status = 413;
                    } else if (n != 4) continue;
                    break;
                }
            }
            catch (Throwable throwable) {
                this.status = 400;
                if (!(throwable instanceof SocketTimeoutException)) break block70;
                this.status = 408;
            }
        }
        this.header = byteArrayOutputStream.toString().trim();
        StringTokenizer stringTokenizer = new StringTokenizer(this.header, "\r\n");
        String string8 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        this.fields.set("req_line", string8);
        n = string8.indexOf(32);
        String string9 = string8.substring(0, n < 0 ? string8.length() : n);
        this.fields.set("req_method", string9);
        if (this.status == 0 && string9.length() <= 0) {
            this.status = 400;
        }
        string7 = string8.substring(n < 0 ? string8.length() : n + 1);
        n = string7.lastIndexOf(32);
        string7 = string7.substring(0, n < 0 ? string7.length() : n);
        n = string7.indexOf(32);
        string7 = string7.substring(0, n < 0 ? string7.length() : n);
        n = string7.indexOf(63);
        string6 = string7.substring(0, n < 0 ? string7.length() : n);
        this.fields.set("req_uri", string6);
        String string10 = string7.substring(n < 0 ? string7.length() : n + 1);
        this.fields.set("req_query", string10);
        String string11 = Worker.textDecode(string6);
        String string12 = Worker.fileNormalize(string11);
        if (string11.endsWith("/") && !string12.endsWith("/")) {
            string12 = string12.concat("/");
        }
        this.fields.set("req_path", string12);
        if (!(this.status != 0 || string12.startsWith("/") && this.header.length() > 0)) {
            this.status = 400;
        }
        if ((string5 = string5.substring(0, (n = (string5 = this.fields.get("http_host")).indexOf(58)) < 0 ? string5.length() : n)).length() <= 0) {
            string5 = this.accept.getLocalAddress().getHostAddress();
        }
        this.fields.set("http_host", string5);
        if (string5.length() > 0 && (" ".concat(string4 = ((Section)(object3 = this.initialize.get(((String)(object2 = "virtual:".concat(string5))).concat(":ini")))).get("server").toLowerCase()).concat(" ").contains(" ".concat(this.context.toLowerCase()).concat(" ")) || string4.length() <= 0)) {
            this.access.merge(this.initialize.get(((String)object2).concat(":acc")));
            this.environment.merge(this.initialize.get(((String)object2).concat(":env")));
            this.filters.merge(this.initialize.get(((String)object2).concat(":flt")));
            this.interfaces.merge(this.initialize.get(((String)object2).concat(":cgi")));
            this.options.merge(this.initialize.get(((String)object2).concat(":ini")));
            this.references.merge(this.initialize.get(((String)object2).concat(":ref")));
        }
        try {
            this.blocksize = Integer.parseInt(this.options.get("blocksize"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.blocksize <= 0) {
            this.blocksize = 65535;
        }
        try {
            this.interrupt = Long.parseLong(this.options.get("interrupt"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.interrupt < 0L) {
            this.interrupt = 10L;
        }
        try {
            this.timeout = Long.parseLong(this.options.get("timeout"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.accept.setSoTimeout((int)this.timeout);
        object2 = Worker.fileCanonical(new File("."));
        Object object4 = object3 = object2 != null ? ((File)object2).getPath().replace('\\', '/') : ".";
        if (((String)object3).endsWith("/")) {
            object3 = ((String)object3).substring(0, ((String)object3).length() - 1);
        }
        Object object5 = this.sysroot = (object2 = Worker.fileCanonical(new File(this.options.get("sysroot")))) != null ? ((File)object2).getPath().replace('\\', '/') : object3;
        if (this.sysroot.endsWith("/")) {
            this.sysroot = this.sysroot.substring(0, this.sysroot.length() - 1);
        }
        if (this.options.get("sysroot").length() <= 0) {
            this.sysroot = object3;
        }
        Object object6 = this.docroot = (object2 = Worker.fileCanonical(new File(this.options.get("docroot")))) != null ? ((File)object2).getPath().replace('\\', '/') : object3;
        if (this.docroot.endsWith("/")) {
            this.docroot = this.docroot.substring(0, this.docroot.length() - 1);
        }
        if (this.options.get("docroot").length() <= 0) {
            this.docroot = object3;
        }
        this.environment.set("server_port", String.valueOf(this.accept.getLocalPort()));
        this.environment.set("server_protocol", "HTTP/1.0");
        this.environment.set("server_software", "Seanox-Devwex/5.5.1 20221013");
        this.environment.set("document_root", this.docroot);
        this.environment.set("content_length", this.fields.get("http_content_length"));
        this.environment.set("content_type", this.fields.get("http_content_type"));
        this.environment.set("query_string", this.fields.get("req_query"));
        this.environment.set("request", this.fields.get("req_line"));
        this.environment.set("request_method", this.fields.get("req_method"));
        this.environment.set("remote_addr", this.accept.getInetAddress().getHostAddress());
        this.environment.set("remote_port", String.valueOf(this.accept.getPort()));
        string4 = Long.toString(Math.abs(this.accept.hashCode()), 36);
        string4 = string4.concat(Long.toString(Math.abs(System.currentTimeMillis()) * 100000L + (long)this.accept.getPort(), 36));
        this.environment.set("unique_id", string4.toUpperCase());
        this.environment.set("path_url", string12);
        this.environment.set("script_name", string12);
        this.environment.set("script_url", this.fields.get("req_uri"));
        this.environment.set("path_context", "");
        this.environment.set("path_info", "");
        this.resource = this.locate(string12);
        String string13 = this.resource.toUpperCase();
        int n7 = string13.contains("[A]") ? 1 : 0;
        n7 |= string13.contains("[M]") ? 2 : 0;
        n7 |= string13.contains("[R]") ? 4 : 0;
        n7 |= string13.contains("[C]") ? 8 : 0;
        boolean bl2 = ((n7 |= string13.contains("[X]") ? 16 : 0) & 1) != 0;
        boolean bl3 = bl = (n7 & 6) != 0;
        if ((this.status == 0 || this.status == 404) && (n7 & 8) != 0) {
            this.status = 403;
        }
        if ((this.status == 0 || this.status == 404) && (n7 & 2) != 0) {
            this.status = 0;
        }
        if ((this.status == 0 || this.status == 404) && (n7 & 6) == 4) {
            this.environment.set("script_uri", Worker.cleanOptions(this.resource));
            this.status = 302;
        }
        this.authorize(this.resource);
        Enumeration enumeration = this.fields.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).startsWith("HTTP_") && !((String)object).startsWith("AUTH_")) continue;
            this.environment.set((String)object, this.fields.get((String)object));
        }
        this.environment.set("remote_user", this.fields.get("auth_user"));
        if (!bl) {
            this.resource = Worker.cleanOptions(this.resource);
        }
        if (this.resource.length() <= 0) {
            this.resource = this.docroot.concat(this.environment.get("path_url"));
        }
        object2 = new File(this.resource);
        if (!bl && this.status == 0) {
            object = Worker.fileCanonical((File)object2);
            if (!((File)object2).equals(object)) {
                this.status = 404;
            }
            if (object != null) {
                object2 = object;
            }
            if (((File)object2).isDirectory() && ((File)object2).list() == null) {
                this.status = 404;
            }
            this.resource = ((File)object2).getPath();
        }
        if (((File)object2).isFile() && string12.endsWith("/")) {
            string12 = string12.substring(0, string12.length() - 1);
        }
        if (((File)object2).isDirectory() && !string12.endsWith("/")) {
            string12 = string12.concat("/");
        }
        if (((String)(object = this.fields.get("http_host"))).length() <= 0) {
            object = this.accept.getLocalAddress().getHostAddress();
        }
        if (this.options.get("identity").toLowerCase().equals("on")) {
            this.environment.set("server_name", (String)object);
        }
        boolean bl4 = this.socket instanceof SSLServerSocket;
        String string14 = this.environment.get("server_port");
        string14 = (!string14.equals("80") && !bl4 || !string14.equals("443") && bl4) && string14.length() > 0 ? ":".concat(string14) : "";
        string14 = (bl4 ? "https" : "http").concat("://").concat((String)object).concat(string14);
        if (this.status != 302) {
            this.environment.set("script_uri", string14.concat(this.fields.get("req_path")));
        }
        if (!(this.status != 0 || this.environment.get("path_url").equals(string12) || bl2 || bl)) {
            this.environment.set("script_uri", string14.concat(string12));
            this.status = 302;
        }
        if (((File)object2).isDirectory()) {
            string3 = this.environment.get("script_uri");
            if (!(string3 = Worker.fileNormalize(string3)).endsWith("/")) {
                this.environment.set("script_uri", string3.concat("/"));
                if (this.status == 0) {
                    this.status = 302;
                }
            }
        }
        if (((File)object2).isDirectory() && this.status == 0) {
            if (!this.resource.endsWith("/")) {
                this.resource = this.resource.concat("/");
            }
            stringTokenizer = new StringTokenizer(this.options.get("default").replace('\\', '/'));
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (string3.length() <= 0 || string3.indexOf(47) >= 0 || !new File(this.resource.concat(string3)).isFile()) continue;
                this.resource = this.resource.concat(string3);
                string2 = this.environment.get("path_context");
                if (string2.length() <= 0) {
                    string2 = this.environment.get("path_url");
                }
                if (!string2.endsWith("/")) {
                    string2 = string2.concat("/");
                }
                this.environment.set("script_name", string2.concat(string3));
                break;
            }
        }
        string3 = Worker.cleanOptions(this.resource);
        this.environment.set("script_filename", string3);
        this.environment.set("path_translated", string3);
        if (string10.length() > 0) {
            this.environment.set("request_uri", string6.concat("?").concat(string10));
        } else {
            this.environment.set("request_uri", string6);
        }
        if ((n7 & 0x12) != 18 && !(string2 = " ".concat(this.options.get("methods").toLowerCase()).concat(" ")).contains(" ".concat(string9.toLowerCase()).concat(" ")) && this.status <= 0) {
            this.status = 405;
        }
        this.resource = this.filter();
        string3 = Worker.cleanOptions(this.resource);
        this.environment.set("script_filename", string3);
        this.environment.set("path_translated", string3);
        if (bl || this.resource.toUpperCase().contains("[M]")) {
            this.mediatype = this.options.get("mediatype");
            this.gateway = this.resource;
            return;
        }
        if (this.status == 302) {
            return;
        }
        n = this.resource.lastIndexOf(".");
        string2 = this.resource.substring(n >= 0 ? n + 1 : 0);
        this.gateway = this.interfaces.get(string2);
        if (this.gateway.length() > 0) {
            n = this.gateway.indexOf(62);
            string = this.gateway.substring(0, Math.max(0, n)).toLowerCase().trim();
            if (n >= 0) {
                this.gateway = this.gateway.substring(n + 2).trim();
            }
            if (this.gateway.length() > 0) {
                this.environment.set("gateway_interface", "CGI/1.1");
                if (string.length() > 0 && !(string = " ".concat(string).concat(" ")).contains(" ".concat(string9.toLowerCase()).concat(" ")) && !string.contains(" all ") && this.status < 500 && this.status != 302) {
                    this.status = 405;
                }
            }
        }
        this.mediatype = this.mediatypes.get(string2);
        if (this.mediatype.length() <= 0) {
            this.mediatype = this.options.get("mediatype");
        }
        if ((string = this.fields.get("http_accept")).length() > 0) {
            stringTokenizer = new StringTokenizer(string.toLowerCase().replace(';', ','), ",");
            while (this.status == 0) {
                if (stringTokenizer.hasMoreTokens()) {
                    String string15 = stringTokenizer.nextToken().trim();
                    if (!string15.equals(this.mediatype) && !string15.equals("*/*") && !string15.equals("*") && ((n = this.mediatype.indexOf("/")) < 0 || !string15.equals(this.mediatype.substring(0, n + 1).concat("*")) && !string15.equals("*".concat(this.mediatype.substring(n))))) continue;
                    break;
                }
                this.status = 406;
            }
        }
    }

    private String header(int n, String[] stringArray) {
        String string = String.valueOf(n);
        string = "HTTP/1.0 ".concat(string).concat(" ").concat(Worker.cleanOptions(this.statuscodes.get(string))).trim();
        if (this.options.get("identity").toLowerCase().equals("on")) {
            string = string.concat("\r\nServer: Seanox-Devwex/5.5.1 20221013");
        }
        string = string.concat("\r\n").concat(Worker.dateFormat("'Date: 'E, dd MMM yyyy HH:mm:ss z", new Date(), "GMT"));
        string = string.concat("\r\n").concat(String.join((CharSequence)"\r\n", stringArray));
        return string.trim();
    }

    private String[] getEnvironment() {
        String string;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.environment.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string = this.environment.get((String)object);
            if (string.length() <= 0 || arrayList.contains(string = ((String)object).concat("=").concat(string))) continue;
            arrayList.add(string);
        }
        object = new StringTokenizer(this.header, "\r\n");
        if (((StringTokenizer)object).hasMoreTokens()) {
            ((StringTokenizer)object).nextToken();
        }
        while (((StringTokenizer)object).hasMoreTokens()) {
            string = ((StringTokenizer)object).nextToken();
            int n = string.indexOf(58);
            if (n <= 0) continue;
            String string2 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            if (string2.length() <= 0 || string.length() <= 0 || arrayList.contains(string = (string2 = "http_".concat(string2.replace('-', '_'))).toUpperCase().concat("=").concat(string))) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doGateway() throws Exception {
        block52: {
            long l;
            if (this.gateway.toUpperCase().contains("[M]")) {
                this.environment.set("module_opts", this.gateway);
                this.invoke(Worker.cleanOptions(this.gateway), "service");
                return;
            }
            String string = this.gateway;
            String string2 = this.environment.get("script_filename");
            string2 = string2.replace('\\', File.separatorChar);
            string2 = string2.replace('/', File.separatorChar);
            string = string.replace("[c]", "[C]");
            string = string.replace("[C]", string2);
            String string3 = string2.replaceAll("[^\\\\/]+$", "");
            string = string.replace("[d]", "[D]");
            string = string.replace("[D]", string3);
            String string4 = string2.replaceAll("(^.*[\\\\/])|(\\..*$)", "");
            string = string.replace("[n]", "[N]");
            string = string.replace("[N]", string4);
            string = Worker.cleanOptions(string);
            long l2 = 0L;
            try {
                l2 = Long.parseLong(this.options.get("isolation"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            long l3 = 0L;
            if (l2 > 0L) {
                l3 = System.currentTimeMillis() + l2;
            }
            CharSequence[] charSequenceArray = this.getEnvironment();
            Process process = Runtime.getRuntime().exec(string.trim(), (String[])charSequenceArray);
            InputStream inputStream = process.getInputStream();
            OutputStream outputStream = process.getOutputStream();
            byte[] byArray = new byte[this.blocksize];
            if (this.gateway.toUpperCase().contains("[X]")) {
                outputStream.write(String.join((CharSequence)"\r\n", charSequenceArray).trim().concat("\r\n\r\n").getBytes());
            }
            int n = 0;
            try {
                n = Integer.parseInt(this.fields.get("http_content_length"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            while (n > 0 && (l = (long)this.input.read(byArray)) >= 0L) {
                if (l > (long)n) {
                    l = n;
                }
                outputStream.write(byArray, 0, (int)l);
                n = (int)((long)n - l);
                if (l3 > 0L && l3 < System.currentTimeMillis()) {
                    this.status = 504;
                    break;
                }
                Thread.sleep(this.interrupt);
            }
            if (process.isAlive()) {
                outputStream.close();
            }
            if (this.status == 200) break block51;
            Object var22_17 = null;
            try {
                byte[] byArray2 = new byte[this.blocksize];
                String string5 = "";
                InputStream inputStream2 = process.getErrorStream();
                while (inputStream2.available() > 0) {
                    int n2 = inputStream2.read(byArray2);
                    string5 = string5.concat(new String(byArray2, 0, n2));
                }
                if ((string5 = string5.trim()).length() > 0) {
                    Service.print("GATEWAY ".concat(string5));
                }
                Object var28_32 = null;
            }
            catch (Throwable throwable) {
                Object var28_33 = null;
                try {
                    process.destroy();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                process.destroy();
            }
            catch (Throwable throwable) {}
            {
                block51: {
                    return;
                }
                String string6 = "";
                while (true) {
                    try {
                        this.accept.getSoTimeout();
                    }
                    catch (Throwable throwable) {
                        this.status = 503;
                        break;
                    }
                    if (inputStream.available() > 0) {
                        n = inputStream.read(byArray);
                        int n3 = 0;
                        if (this.control && string6 != null) {
                            int n4 = (string6 = string6.concat(new String(byArray, 0, n))).indexOf("\r\n\r\n");
                            if (n4 >= 0) {
                                n3 = n - (string6.length() - n4 - 4);
                                string6 = string6.substring(0, n4);
                            } else {
                                n3 = string6.length();
                            }
                            if (string6.length() > 65535) {
                                this.status = 502;
                                break;
                            }
                            if (n4 >= 0) {
                                n4 = (string6 = string6.trim()).indexOf("\r\n");
                                String string7 = n4 >= 0 ? string6.substring(0, n4).trim() : string6;
                                String string8 = string7.toUpperCase();
                                if (string8.startsWith("HTTP/")) {
                                    if (string8.matches("^HTTP/STATUS(\\s.*)*$")) {
                                        string6 = null;
                                    }
                                    try {
                                        this.status = Math.abs(Integer.parseInt(string7.replaceAll("^(\\S+)\\s*(\\S+)*\\s*(.*?)\\s*$", "$2")));
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    string7 = string7.replaceAll("^(\\S+)\\s*(\\S+)*\\s*(.*?)\\s*$", "$3");
                                    if (string7.length() > 0 && !this.statuscodes.contains(String.valueOf(this.status))) {
                                        this.statuscodes.set(String.valueOf(this.status), string7);
                                    }
                                }
                                if (string6 != null) {
                                    string6 = string6.replaceAll("(?si)^ *HTTP */ *[^\r\n]*([\r\n]+|$)", "");
                                    string6 = this.header(this.status, string6.split("[\r\n]+"));
                                    this.control = false;
                                }
                            }
                        }
                        if (!this.control) {
                            if (this.timeout > 0L) {
                                this.timelock = System.currentTimeMillis();
                            }
                            if (string6 != null) {
                                this.output.write(string6.concat("\r\n\r\n").getBytes());
                            }
                            string6 = null;
                            this.output.write(byArray, n3, n - n3);
                            this.timelock = 0L;
                            this.volume += (long)(n - n3);
                        }
                    }
                    if (l3 > 0L && l3 < System.currentTimeMillis()) {
                        this.status = 504;
                        break;
                    }
                    if (inputStream.available() <= 0 && !process.isAlive()) break;
                    Thread.sleep(this.interrupt);
                }
            }
            Object var22_18 = null;
            try {
                byte[] byArray3 = new byte[this.blocksize];
                String string9 = "";
                InputStream inputStream3 = process.getErrorStream();
                while (inputStream3.available() > 0) {
                    int n5 = inputStream3.read(byArray3);
                    string9 = string9.concat(new String(byArray3, 0, n5));
                }
                if ((string9 = string9.trim()).length() > 0) {
                    Service.print("GATEWAY ".concat(string9));
                }
                Object var28_34 = null;
            }
            catch (Throwable throwable) {
                Object var28_35 = null;
                try {
                    process.destroy();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                process.destroy();
            }
            catch (Throwable throwable) {}
            break block52;
            catch (Throwable throwable) {
                Object var22_19 = null;
                try {
                    byte[] byArray4 = new byte[this.blocksize];
                    String string10 = "";
                    InputStream inputStream4 = process.getErrorStream();
                    while (inputStream4.available() > 0) {
                        int n6 = inputStream4.read(byArray4);
                        string10 = string10.concat(new String(byArray4, 0, n6));
                    }
                    if ((string10 = string10.trim()).length() > 0) {
                        Service.print("GATEWAY ".concat(string10));
                    }
                    Object var28_36 = null;
                }
                catch (Throwable throwable4) {
                    Object var28_37 = null;
                    try {
                        process.destroy();
                    }
                    catch (Throwable throwable5) {
                        // empty catch block
                    }
                    throw throwable4;
                }
                try {
                    process.destroy();
                }
                catch (Throwable throwable6) {}
                throw throwable;
            }
        }
    }

    private byte[] createDirectoryIndex(File file, String string) {
        Object object;
        int n;
        Object object2;
        char c;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Enumeration enumeration = this.environment.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.toLowerCase().equals("path") || string2.toLowerCase().equals("file")) continue;
            hashtable.put(string2, this.environment.get(string2));
        }
        if (string.length() <= 0) {
            string = "n";
        }
        boolean bl = (c = (string = string.substring(0, 1)).charAt(0)) >= 'A' && c <= 'Z';
        string = string.toLowerCase();
        c = string.charAt(0);
        int[] nArray = new int[]{0, 1, 2, 3, 4};
        if (c == 'd') {
            nArray = new int[]{0, 2, 1, 3, 4};
        } else if (c == 's') {
            nArray = new int[]{0, 3, 1, 2, 4};
        } else if (c == 't') {
            nArray = new int[]{0, 4, 1, 2, 3};
        } else {
            string = "n";
        }
        File file2 = new File(this.sysroot.concat("/index.html"));
        Generator generator = Generator.parse(Worker.fileRead(file2));
        String string3 = this.environment.get("path_url");
        if (!string3.endsWith("/")) {
            string3 = string3.concat("/");
        }
        hashtable.put("path_url", string3);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
        Object object3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken();
            object3 = object3.concat("/").concat((String)object2);
            hashtable.put("path", object3);
            hashtable.put("name", object2);
            generator.set("location", hashtable);
        }
        object3 = file.listFiles();
        if (object3 == null) {
            object3 = new File[]{};
        }
        object2 = new ArrayList<File>(Arrays.asList(object3));
        boolean bl2 = this.options.get("index").toUpperCase().contains("[S]");
        String[] stringArray = new String[5];
        for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
            file2 = (File)((ArrayList)object2).get(i);
            stringArray[0] = file2.isDirectory() ? "directory" : "file";
            stringArray[1] = file2.getName();
            stringArray[2] = String.format("%tF %<tT", new Date(file2.lastModified()));
            stringArray[3] = file2.isDirectory() ? "-" : String.valueOf(file2.length());
            stringArray[3] = String.valueOf((char)stringArray[3].length()).concat(stringArray[3]);
            n = stringArray[1].lastIndexOf(".");
            stringArray[4] = n >= 0 ? stringArray[1].substring(n + 1) : "";
            stringArray[4] = file2.isDirectory() ? "-" : stringArray[4].toLowerCase().trim();
            object = String.join((CharSequence)"\u0000 ", stringArray[nArray[0]], stringArray[nArray[1]], stringArray[nArray[2]], stringArray[nArray[3]], stringArray[nArray[4]]);
            if (bl2 && file2.isHidden()) {
                object = "";
            }
            ((ArrayList)object2).set(i, object);
        }
        Collections.sort(object2, String.CASE_INSENSITIVE_ORDER);
        if (bl) {
            Collections.reverse(object2);
        }
        ArrayList arrayList = new ArrayList();
        for (n = 0; n < ((ArrayList)object2).size(); ++n) {
            stringTokenizer = new StringTokenizer((String)((ArrayList)object2).get(n), "\u0000");
            if (stringTokenizer.countTokens() <= 0) continue;
            object = new Hashtable<String, String>(hashtable);
            arrayList.add(object);
            stringArray[nArray[0]] = stringTokenizer.nextToken();
            stringArray[nArray[1]] = stringTokenizer.nextToken().substring(1);
            stringArray[nArray[2]] = stringTokenizer.nextToken().substring(1);
            stringArray[nArray[3]] = stringTokenizer.nextToken().substring(1);
            stringArray[nArray[4]] = stringTokenizer.nextToken().substring(1);
            ((Hashtable)object).put("case", stringArray[0]);
            ((Hashtable)object).put("name", stringArray[1]);
            ((Hashtable)object).put("date", stringArray[2]);
            ((Hashtable)object).put("size", stringArray[3].substring(1));
            ((Hashtable)object).put("type", stringArray[4]);
            String string4 = stringArray[4];
            if (!string4.equals("-")) {
                if ((string4 = this.mediatypes.get(string4)).length() <= 0) {
                    string4 = this.options.get("mediatype");
                }
            } else {
                string4 = "";
            }
            ((Hashtable)object).put("mime", string4);
        }
        string = string.concat(bl ? "d" : "a");
        if (arrayList.size() <= 0) {
            string = string.concat(" x");
        }
        hashtable.put("sort", string);
        hashtable.put("file", arrayList);
        generator.set(hashtable);
        return generator.extract();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGet() throws Exception {
        Object object;
        String string;
        long l;
        String string2 = this.fields.get("req_method").toLowerCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(this.resource);
        if (file.isDirectory()) {
            if (Worker.cleanOptions(this.options.get("index")).toLowerCase().equals("on")) {
                arrayList.add("Content-Type: ".concat(this.mediatypes.get("html")));
                byte[] byArray = new byte[]{};
                if (string2.equals("get")) {
                    byArray = this.createDirectoryIndex(file, this.environment.get("query_string"));
                    arrayList.add("Content-Length: ".concat(String.valueOf(byArray.length)));
                }
                String string3 = this.header(this.status, arrayList.toArray(new String[0])).concat("\r\n\r\n");
                this.control = false;
                if (this.timeout > 0L) {
                    this.timelock = System.currentTimeMillis();
                }
                this.output.write(string3.getBytes());
                this.output.write(byArray);
                this.timelock = 0L;
                this.volume += (long)byArray.length;
                return;
            }
            this.status = 403;
            return;
        }
        if (!Worker.fileIsModified(file, this.fields.get("http_if_modified_since"))) {
            this.status = 304;
            return;
        }
        if (this.fields.contains("http_if_unmodified_since") && Worker.fileIsModified(file, this.fields.get("http_if_unmodified_since"))) {
            this.status = 412;
            return;
        }
        long l2 = 0L;
        long l3 = l = file.length();
        if (this.fields.contains("http_range") && l > 0L) {
            string = this.fields.get("http_range").replace(';', '\n');
            if ((string = Section.parse(string).get("bytes")).matches("^(\\d+)*\\s*-\\s*(\\d+)*$")) {
                object = new StringTokenizer(string, "-");
                try {
                    l2 = Long.parseLong(((StringTokenizer)object).nextToken().trim());
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        l3 = Long.parseLong(((StringTokenizer)object).nextToken().trim());
                    } else if (string.startsWith("-")) {
                        if (l2 > 0L) {
                            l3 = l - 1L;
                            l2 = Math.max(0L, l - l2);
                        } else {
                            l3 = -1L;
                        }
                    }
                    l3 = Math.min(l3, l - 1L);
                    if (l2 >= l) {
                        this.status = 416;
                        return;
                    }
                    if (l2 <= l3) {
                        this.status = 206;
                        ++l3;
                    } else {
                        l2 = 0L;
                        l3 = l;
                    }
                }
                catch (Throwable throwable) {
                    l2 = 0L;
                    l3 = l = file.length();
                }
            }
        }
        arrayList.add("Last-Modified: ".concat(Worker.dateFormat("E, dd MMM yyyy HH:mm:ss z", new Date(file.lastModified()), "GMT")));
        arrayList.add("Content-Length: ".concat(String.valueOf(l3 - l2)));
        arrayList.add("Accept-Ranges: bytes");
        if (this.mediatype.length() > 0) {
            arrayList.add("Content-Type: ".concat(this.mediatype));
        }
        if (this.status == 206) {
            arrayList.add("Content-Range: bytes ".concat(String.valueOf(l2)).concat("-").concat(String.valueOf(l3 - 1L)).concat("/").concat(String.valueOf(l)));
        }
        string = this.header(this.status, arrayList.toArray(new String[0])).concat("\r\n\r\n");
        this.control = false;
        if (this.timeout > 0L) {
            this.timelock = System.currentTimeMillis();
        }
        this.output.write(string.getBytes());
        this.timelock = 0L;
        if (string2.equals("get")) {
            object = new byte[this.blocksize];
            FileInputStream fileInputStream = new FileInputStream(this.resource);
            try {
                ((InputStream)fileInputStream).skip(l2);
                while (l2 + this.volume < l3 && (l = (long)((InputStream)fileInputStream).read((byte[])object)) >= 0L) {
                    if (this.status == 206 && l2 + this.volume + l > l3) {
                        l = l3 - (l2 + this.volume);
                    }
                    if (this.timeout > 0L) {
                        this.timelock = System.currentTimeMillis();
                    }
                    this.output.write((byte[])object, 0, Math.max(0, (int)l));
                    this.timelock = 0L;
                    this.volume += l;
                }
                Object var14_13 = null;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPut() throws Exception {
        long l;
        File file = new File(this.resource);
        if (!this.fields.contains("http_content_length")) {
            if (!file.isDirectory() && !file.mkdirs()) {
                this.status = 424;
            }
            if (this.status == 200 || this.status == 404) {
                this.fields.set("req_location", this.environment.get("script_uri"));
                this.status = 201;
            }
            return;
        }
        try {
            if (l < 0L) {
                throw new Throwable();
            }
        }
        catch (Throwable throwable) {
            this.status = 411;
            return;
        }
        file.delete();
        byte[] byArray = new byte[this.blocksize];
        FileOutputStream fileOutputStream = new FileOutputStream(this.resource);
        try {
            long l2;
            for (l = Long.parseLong(this.fields.get("http_content_length")); l > 0L && (l2 = (long)this.input.read(byArray)) >= 0L; l -= l2) {
                l2 = Math.min(l2, l);
                ((OutputStream)fileOutputStream).write(byArray, 0, (int)l2);
                Thread.sleep(this.interrupt);
            }
            if (l > 0L) {
                this.status = 424;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((OutputStream)fileOutputStream).close();
        }
        catch (Throwable throwable) {}
        if (this.status == 200 || this.status == 404) {
            this.fields.set("req_location", this.environment.get("script_uri"));
            this.status = 201;
        }
    }

    private void doDelete() {
        if (Worker.fileDelete(new File(this.resource))) {
            return;
        }
        this.status = 424;
    }

    private void doStatus() throws Exception {
        String string;
        Object object;
        String string2 = this.fields.get("req_method").toLowerCase();
        if (string2.equals("options") && (this.status == 302 || this.status == 404)) {
            this.status = 200;
        }
        if (this.status == 302) {
            object = this.environment.get("query_string");
            if (((String)object).length() > 0) {
                object = "?".concat((String)object);
            }
            object = this.environment.get("script_uri").concat((String)object);
            this.fields.set("req_location", (String)object);
        } else {
            object = String.valueOf(this.status);
            this.resource = this.sysroot.concat("/status-").concat((String)object).concat(".html");
            if (!new File(this.resource).exists()) {
                this.resource = this.sysroot.concat("/status-").concat(((String)object).substring(0, 1)).concat("xx.html");
            }
            if (!new File(this.resource).exists()) {
                this.resource = this.sysroot.concat("/status.html");
            }
        }
        object = new ArrayList();
        String string3 = this.fields.get("auth_type");
        if (this.status == 401 && string3.length() > 0) {
            string = " realm=\"".concat(this.fields.get("auth_realm")).concat("\"");
            if (string3.equals("Digest")) {
                string = "Digest".concat(string);
                string = string.concat(", qop=\"auth\"");
                string3 = this.environment.get("unique_id");
                string = string.concat(", nonce=\"").concat(string3).concat("\"");
                string3 = Worker.textHash(string3.concat(String.valueOf(string3.hashCode())));
                string = string.concat(", opaque=\"").concat(string3).concat("\"");
                string = string.concat(", algorithm=\"MD5\"");
            } else {
                string = "Basic".concat(string);
            }
            ((ArrayList)object).add("WWW-Authenticate: ".concat(string));
        }
        if (this.fields.contains("req_location")) {
            ((ArrayList)object).add("Location: ".concat(this.fields.get("req_location")));
        }
        string = this.statuscodes.get(String.valueOf(this.status));
        Generator generator = string2.equals("head") || string2.equals("options") || string.toUpperCase().contains("[H]") ? Generator.parse(null) : Generator.parse(Worker.fileRead(new File(this.resource)));
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = this.fields.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            hashtable.put(string, this.fields.get(string));
        }
        Enumeration enumeration2 = this.environment.elements();
        while (enumeration2.hasMoreElements()) {
            string = (String)enumeration2.nextElement();
            hashtable.put(string, this.environment.get(string));
        }
        string = String.valueOf(this.status);
        hashtable.put("HTTP_STATUS", string);
        hashtable.put("HTTP_STATUS_TEXT", Worker.cleanOptions(this.statuscodes.get(string)));
        generator.set(hashtable);
        byte[] byArray = generator.extract();
        if (byArray.length > 0) {
            ((ArrayList)object).add("Content-Type: ".concat(this.mediatypes.get("html")));
            ((ArrayList)object).add("Content-Length: ".concat(String.valueOf(byArray.length)));
        }
        if ((string = String.join((CharSequence)", ", this.options.get("methods").split("\\s+"))).length() > 0) {
            ((ArrayList)object).add("Allow: ".concat(string));
        }
        string = this.header(this.status, ((ArrayList)object).toArray(new String[0])).concat("\r\n\r\n");
        this.control = false;
        if (this.timeout > 0L) {
            this.timelock = System.currentTimeMillis();
        }
        if (this.output != null) {
            this.output.write(string.getBytes());
            this.output.write(byArray);
        }
        this.timelock = 0L;
        this.volume += (long)byArray.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void service() throws Exception {
        try {
            try {
                this.accept.setSoTimeout((int)this.timeout);
                this.input = this.accept.getInputStream();
                this.output = this.accept.getOutputStream();
                try {
                    this.initiate();
                }
                catch (Exception exception) {
                    this.status = 500;
                    throw exception;
                }
                File file = new File(this.resource);
                if (this.status == 0) {
                    int n = this.status = this.resource.toUpperCase().contains("[M]") || file.isDirectory() || file.isFile() ? 200 : 404;
                }
                if (this.control) {
                    if (this.status == 200 && this.gateway.length() > 0) {
                        try {
                            this.doGateway();
                        }
                        catch (Exception exception) {
                            this.status = 502;
                            throw exception;
                        }
                    }
                    String string = this.fields.get("req_method").toLowerCase();
                    if (!(this.status != 200 || string.equals("options") || string.equals("head") || string.equals("get") || string.equals("put") || string.equals("delete"))) {
                        this.status = 501;
                    }
                    if (this.status == 200 && (string.equals("head") || string.equals("get"))) {
                        try {
                            this.doGet();
                        }
                        catch (Exception exception) {
                            this.status = 500;
                            throw exception;
                        }
                    }
                    if ((this.status == 200 || this.status == 404) && string.equals("put")) {
                        try {
                            this.doPut();
                        }
                        catch (Exception exception) {
                            this.status = 424;
                            throw exception;
                        }
                    }
                    if (this.status == 200 && string.equals("delete")) {
                        try {
                            this.doDelete();
                        }
                        catch (Exception exception) {
                            this.status = 424;
                            throw exception;
                        }
                    }
                }
                Object var5_9 = null;
                this.timelock = 0L;
                if (!this.control) return;
            }
            catch (Exception exception) {
                if (this.status != 0) {
                    if (this.status != 200) throw exception;
                }
                this.status = 500;
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.timelock = 0L;
            if (!this.control) throw throwable;
            try {
                this.doStatus();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        this.doStatus();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trace() throws Exception {
        String string = this.environment.get("remote_addr");
        try {
            string = InetAddress.getByName(string).getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.environment.set("remote_host", string);
        this.environment.set("response_length", String.valueOf(this.volume));
        this.environment.set("response_status", String.valueOf(this.status == 0 ? 500 : this.status));
        Class<Worker> clazz = Worker.class;
        synchronized (Worker.class) {
            block12: {
                String string2;
                String string3 = this.options.get("accesslog");
                string3 = string3.replaceAll("#", "#[0x23]");
                string3 = string3.replaceAll("%%", "#[0x25]");
                string3 = string3.replaceAll("%\\[", "#[");
                string3 = string3.replaceAll("%t", "%1\\$t");
                string3 = String.format(Locale.US, string3, new Date());
                if (string3.contains(">")) {
                    string2 = string3.split(">")[1].trim();
                    string3 = string3.split(">")[0].trim();
                } else {
                    string2 = "";
                }
                if (string3.length() <= 0 || string3.toLowerCase().equals("off")) {
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return;
                }
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                Enumeration enumeration = this.environment.elements();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    hashtable.put(string, Worker.textEscape(this.environment.get(string)));
                }
                Generator generator = Generator.parse(string3.getBytes());
                generator.set(hashtable);
                string3 = new String(generator.extract());
                string3 = string3.replaceAll("(?<=\\s)(''|\"\")((?=\\s)|$)", "-");
                string3 = string3.replaceAll("(\\s)((?=\\s)|$)", "$1-");
                string3 = string3.concat(System.lineSeparator());
                generator = Generator.parse(string2.getBytes());
                generator.set(hashtable);
                string2 = new String(generator.extract());
                string2 = string2.replaceAll("(?<=\\s)(''|\"\")((?=\\s)|$)", "-");
                string2 = string2.replaceAll("(\\s)((?=\\s)|$)", "$1-").trim();
                if (string2.length() > 0) {
                    FileOutputStream fileOutputStream = new FileOutputStream(string2, true);
                    try {
                        ((OutputStream)fileOutputStream).write(string3.getBytes());
                        Object var10_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        ((OutputStream)fileOutputStream).close();
                        throw throwable;
                    }
                    ((OutputStream)fileOutputStream).close();
                    {
                        break block12;
                    }
                }
                Service.print(string3, true);
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    void isolate() {
        if (this.accept == null && this.socket != null) {
            this.socket = null;
        }
    }

    boolean available() {
        if (this.timelock > 0L && System.currentTimeMillis() - this.timelock > this.timeout) {
            try {
                this.accept.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.socket != null && this.accept == null;
    }

    void destroy() {
        this.socket = null;
        try {
            this.accept.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void run() {
        ServerSocket serverSocket;
        while ((serverSocket = this.socket) != null) {
            this.status = 0;
            this.volume = 0L;
            this.control = true;
            this.docroot = "";
            this.gateway = "";
            this.mediatype = "";
            this.resource = "";
            this.sysroot = "";
            this.fields = new Section(true);
            Initialize initialize = (Initialize)this.initialize.clone();
            this.access = initialize.get(this.context.concat(":acc"));
            this.environment = initialize.get(this.context.concat(":env"));
            this.filters = initialize.get(this.context.concat(":flt"));
            this.interfaces = initialize.get(this.context.concat(":cgi"));
            this.options = initialize.get(this.context.concat(":ini"));
            this.references = initialize.get(this.context.concat(":ref"));
            this.mediatypes = initialize.get("mediatypes");
            this.statuscodes = initialize.get("statuscodes");
            try {
                this.timeout = serverSocket.getSoTimeout();
            }
            catch (Throwable throwable) {
                this.timeout = 0L;
            }
            try {
                this.accept = serverSocket.accept();
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            catch (SocketException socketException) {
                break;
            }
            catch (Throwable throwable) {
                Service.print(throwable);
                break;
            }
            try {
                this.service();
            }
            catch (Throwable throwable) {
                Service.print(throwable);
            }
            try {
                this.accept.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.trace();
            }
            catch (Throwable throwable) {
                Service.print(throwable);
            }
            this.accept = null;
        }
    }
}

