/*
 * Decompiled with CFR 0.152.
 */
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionPool {
    private final HikariDataSource dataSource;

    public static ConnectionPool create(String host, int port, String dbName, String username, String password, int minConnections, int maxConnections, int connectionTimeout, int idleTimeout, int keepaliveTime, int maxLifetime, boolean autoCommit) throws SQLException {
        HikariConfig config = new HikariConfig();
        config.setDataSourceClassName("com.sybase.jdbc4.jdbc.SybDataSource");
        config.addDataSourceProperty("serverName", (Object)host);
        config.addDataSourceProperty("portNumber", (Object)port);
        config.addDataSourceProperty("user", (Object)username);
        config.addDataSourceProperty("password", (Object)password);
        config.addDataSourceProperty("databaseName", (Object)dbName);
        config.setIdleTimeout((long)idleTimeout);
        config.setConnectionTimeout((long)connectionTimeout);
        config.setMaximumPoolSize(maxConnections);
        config.setMinimumIdle(minConnections);
        config.setKeepaliveTime((long)keepaliveTime);
        config.setMaxLifetime((long)maxLifetime);
        config.setAutoCommit(autoCommit);
        HikariDataSource ds = new HikariDataSource(config);
        return new ConnectionPool(ds);
    }

    private ConnectionPool(HikariDataSource ds) {
        this.dataSource = ds;
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void shutdown() throws SQLException {
        this.dataSource.close();
    }
}

