/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class ExecSQLTransactionCallable
implements Callable<String> {
    private ConnectionPoolTransaction pool;
    private DateFormat df;
    private SQLRequest request;

    public ExecSQLTransactionCallable(ConnectionPoolTransaction pool, DateFormat df, SQLRequest request) {
        this.pool = pool;
        this.df = df;
        this.request = request;
    }

    @Override
    public String call() throws Exception {
        String result = this.execSQLJsonSimple();
        System.out.println(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execSQLJsonSimple() {
        JSONObject response = new JSONObject();
        response.put((Object)"msgId", (Object)this.request.msgId);
        response.put((Object)"transId", (Object)this.request.transId);
        JSONArray rss = new JSONArray();
        response.put((Object)"result", (Object)rss);
        Statement stmt = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            conn = this.pool.getConnection(this.request.transId);
            if (conn.isClosed()) {
                throw new Exception("Connection for query in transaction is closed!");
            }
            stmt = conn.createStatement();
            boolean isRS = stmt.execute(this.request.sql);
            while (isRS || stmt.getUpdateCount() != -1) {
                if (!isRS) {
                    isRS = stmt.getMoreResults();
                    continue;
                }
                rs = stmt.getResultSet();
                ResultSetMetaData meta = rs.getMetaData();
                int colCount = meta.getColumnCount();
                String[] columns = new String[colCount + 1];
                for (int c = 1; c < colCount + 1; ++c) {
                    columns[c] = meta.getColumnLabel(c);
                }
                JSONArray jsonRS = new JSONArray();
                rss.add((Object)jsonRS);
                while (rs.next()) {
                    JSONObject row = new JSONObject();
                    jsonRS.add((Object)row);
                    block34: for (int c = 1; c < colCount + 1; ++c) {
                        Object val = rs.getObject(c);
                        if (val == null) continue;
                        int dataType = meta.getColumnType(c);
                        switch (dataType) {
                            case 91: 
                            case 93: {
                                String my8601formattedDate = this.df.format(new Date(rs.getTimestamp(c).getTime()));
                                row.put((Object)columns[c], (Object)my8601formattedDate);
                                continue block34;
                            }
                            case 92: {
                                String timeFromRS = rs.getTime(c).toString();
                                String my8601formattedTime = "1970-01-01T" + timeFromRS + ".000Z";
                                row.put((Object)columns[c], (Object)my8601formattedTime);
                                continue block34;
                            }
                            default: {
                                row.put((Object)columns[c], rs.getObject(c));
                            }
                        }
                    }
                }
                rs.close();
                isRS = stmt.getMoreResults();
            }
            stmt.close();
        }
        catch (Exception ex) {
            response.put((Object)"error", (Object)ex.getMessage());
            try {
                conn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            try {
                if (this.request.finishTrans) {
                    this.pool.releaseConnection(this.request.transId);
                }
            }
            catch (Exception ex) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {}
        }
        response.put((Object)"javaStartTime", (Object)this.request.javaStartTime);
        long beforeParse = System.currentTimeMillis();
        response.put((Object)"javaEndTime", (Object)beforeParse);
        String jsonResult = response.toJSONString();
        return jsonResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safePrintln(String s) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println(s);
        }
    }
}

