/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.RowDataFormat2;
import com.sybase.jdbc4.tds.RowFormatToken;
import com.sybase.jdbc4.tds.Tds;
import com.sybase.jdbc4.tds.TdsInputStream;
import java.io.IOException;
import java.sql.SQLException;

public class RowFormat2Token
extends RowFormatToken {
    private int _isGetColumnLabelForNameEnabled = -1;

    public RowFormat2Token(int n) throws SQLException {
        this._numUserColumns = n;
        this._numColumns = n;
        this._column = new RowDataFormat2[this._numColumns];
    }

    public RowFormat2Token() throws SQLException {
        this._numColumns = 0;
        this._column = new RowDataFormat2[this._numColumns];
    }

    public RowFormat2Token(TdsInputStream tdsInputStream) throws IOException {
        super(tdsInputStream);
    }

    public RowFormat2Token(TdsInputStream tdsInputStream, long l) throws IOException {
        super(tdsInputStream, l);
    }

    @Override
    protected DataFormat dataFormatFactory(TdsInputStream tdsInputStream) throws IOException {
        return new RowDataFormat2(tdsInputStream);
    }

    @Override
    protected long readLength(TdsInputStream tdsInputStream) throws IOException {
        long l = tdsInputStream.readUnsignedIntAsLong();
        return l;
    }

    @Override
    protected String getLabel(int n) throws SQLException {
        return ((RowDataFormat2)this.getDataFormat(n)).getLabelName();
    }

    protected String getDBOwnerName(int n) throws SQLException {
        return ((RowDataFormat2)this.getDataFormat(n)).getSchemaName();
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        int n2 = this.mapColumn(n);
        return this.getLabel(n2);
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        if (this._isGetColumnLabelForNameEnabled == -1 && this.isGetColumnLabelForNameEnabled()) {
            this._isGetColumnLabelForNameEnabled = 1;
        }
        if (this._isGetColumnLabelForNameEnabled == 1) {
            return this.getColumnLabel(n);
        }
        return this.getName(this.mapColumn(n));
    }

    private boolean isGetColumnLabelForNameEnabled() throws SQLException {
        SybProperty sybProperty = ((Tds)this._tpc._protocol).getSybProperty();
        return sybProperty.getBoolean(65);
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        int n2 = this.mapColumn(n);
        String string = this.getDBOwnerName(n2);
        return string;
    }

    @Override
    public String getTableName(int n) throws SQLException {
        int n2 = this.mapColumn(n);
        return ((RowDataFormat2)this.getDataFormat(n2)).getTableName();
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        int n2 = this.mapColumn(n);
        return ((RowDataFormat2)this.getDataFormat(n2)).getCatalogName();
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        int n2 = this.mapColumn(n);
        int n3 = this.getDataFormat((int)n2)._datatype;
        String string = this.getCatalogName(n);
        n3 = super.getColumnDataType(n3, n2);
        return ((Tds)this._tpc._protocol).getColumnTypeName(n3, this._column[n2]._usertype, string);
    }
}

