/*
 * Decompiled with CFR 0.152.
 */
import com.sybase.jdbc4.jdbc.SybDriver;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;

public class ConnectionPoolTransaction1
implements ConnectionPoolTransaction {
    private String url;
    Properties props;
    private int transactionConnections;
    private List<Connection> availableConnections;
    private HashMap<Integer, Connection> transactions = new HashMap();

    public static ConnectionPoolTransaction1 create(String host, int port, String dbName, String username, String password, int transactionConnections) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String url = "jdbc:sybase:Tds:" + host + ":" + port + "/" + dbName;
        SybDriver sybDriver = (SybDriver)Class.forName("com.sybase.jdbc4.jdbc.SybDriver").newInstance();
        DriverManager.registerDriver((Driver)sybDriver);
        Properties props = new Properties();
        props.put("user", username);
        props.put("password", password);
        props.put("autoCommit", (Object)false);
        ArrayList<Connection> pool = new ArrayList<Connection>(transactionConnections);
        for (int i = 0; i < transactionConnections; ++i) {
            pool.add(ConnectionPoolTransaction1.createConnection(url, props));
        }
        return new ConnectionPoolTransaction1(url, props, pool, transactionConnections);
    }

    private ConnectionPoolTransaction1(String url, Properties props, List<Connection> pool, int transactionConnections) {
        this.url = url;
        this.props = props;
        this.availableConnections = pool;
        this.transactionConnections = transactionConnections;
    }

    private static Connection createConnection(String url, Properties props) throws SQLException {
        Connection connection = DriverManager.getConnection(url, props);
        connection.setAutoCommit(false);
        return connection;
    }

    @Override
    public Connection getConnection(int transactionId) throws SQLException {
        Connection connection = this.transactions.get(transactionId);
        if (connection == null) {
            try {
                connection = this.availableConnections.remove(0);
            }
            catch (NoSuchElementException e) {
                connection = ConnectionPoolTransaction1.createConnection(this.url, this.props);
            }
            this.transactions.put(transactionId, connection);
        }
        return connection;
    }

    @Override
    public void releaseConnection(int transactionId) throws SQLException {
        Connection connection = this.transactions.get(transactionId);
        this.transactions.remove(transactionId);
        if (this.availableConnections.size() < this.transactionConnections) {
            try {
                this.availableConnections.add(ConnectionPoolTransaction1.createConnection(this.url, this.props));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        connection.close();
    }

    @Override
    public void shutdown() throws SQLException {
        for (Connection connection : this.availableConnections) {
            connection.close();
        }
        for (Connection connection : this.transactions.values()) {
            connection.close();
        }
    }
}

