/*
 * Decompiled with CFR 0.152.
 */
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;

public class ConnectionPoolTransaction2
implements ConnectionPoolTransaction {
    private final HikariDataSource dataSource;
    private HashMap<Integer, Connection> transactions = new HashMap();

    public static ConnectionPoolTransaction2 create(String host, int port, String dbName, String username, String password, int minConnections, int maxConnections, int connectionTimeout, int idleTimeout, int keepaliveTime, int maxLifetime, boolean autoCommit) throws SQLException {
        HikariConfig config = new HikariConfig();
        config.setDataSourceClassName("com.sybase.jdbc4.jdbc.SybDataSource");
        config.addDataSourceProperty("serverName", (Object)host);
        config.addDataSourceProperty("portNumber", (Object)port);
        config.addDataSourceProperty("user", (Object)username);
        config.addDataSourceProperty("password", (Object)password);
        config.addDataSourceProperty("databaseName", (Object)dbName);
        config.setIdleTimeout((long)idleTimeout);
        config.setConnectionTimeout((long)connectionTimeout);
        config.setMaximumPoolSize(maxConnections);
        config.setMinimumIdle(minConnections);
        config.setKeepaliveTime((long)keepaliveTime);
        config.setMaxLifetime((long)maxLifetime);
        config.setAutoCommit(autoCommit);
        HikariDataSource ds = new HikariDataSource(config);
        return new ConnectionPoolTransaction2(ds);
    }

    private ConnectionPoolTransaction2(HikariDataSource ds) {
        this.dataSource = ds;
    }

    @Override
    public Connection getConnection(int transactionId) throws SQLException {
        Connection connection = this.transactions.get(transactionId);
        if (connection == null) {
            connection = this.dataSource.getConnection();
            this.transactions.put(transactionId, connection);
        }
        return connection;
    }

    @Override
    public void releaseConnection(int transactionId) throws SQLException {
        Connection connection = this.transactions.get(transactionId);
        this.transactions.remove(transactionId);
        connection.close();
    }

    @Override
    public void shutdown() throws SQLException {
        this.dataSource.close();
    }
}

