/*
 * Decompiled with CFR 0.152.
 */
import com.sybase.jdbc4.jdbc.SybDriver;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;

public class ConnectionPoolTransaction3
implements ConnectionPoolTransaction {
    private String url;
    Properties props;
    private int transactionConnections;
    private HashMap<Integer, Connection> transactions = new HashMap();

    public static ConnectionPoolTransaction3 create(String host, int port, String dbName, String username, String password, int transactionConnections) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String url = "jdbc:sybase:Tds:" + host + ":" + port + "/" + dbName;
        SybDriver sybDriver = (SybDriver)Class.forName("com.sybase.jdbc4.jdbc.SybDriver").newInstance();
        DriverManager.registerDriver((Driver)sybDriver);
        Properties props = new Properties();
        props.put("user", username);
        props.put("password", password);
        props.put("autoCommit", (Object)false);
        return new ConnectionPoolTransaction3(url, props, transactionConnections);
    }

    private ConnectionPoolTransaction3(String url, Properties props, int transactionConnections) {
        this.url = url;
        this.props = props;
        this.transactionConnections = transactionConnections;
    }

    private static Connection createConnection(String url, Properties props) throws SQLException {
        Connection connection = DriverManager.getConnection(url, props);
        connection.setAutoCommit(false);
        return connection;
    }

    @Override
    public Connection getConnection(int transactionId) throws SQLException {
        Connection connection = this.transactions.get(transactionId);
        if (connection == null) {
            connection = ConnectionPoolTransaction3.createConnection(this.url, this.props);
            this.transactions.put(transactionId, connection);
        }
        return connection;
    }

    @Override
    public void releaseConnection(int transactionId) throws SQLException {
        Connection connection = this.transactions.get(transactionId);
        this.transactions.remove(transactionId);
        connection.close();
    }

    @Override
    public void shutdown() throws SQLException {
        for (Connection connection : this.transactions.values()) {
            connection.close();
        }
    }
}

