/*
 * Decompiled with CFR 0.152.
 */
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class SybaseDB {
    public static final int TYPE_TIME_STAMP = 93;
    public static final int TYPE_DATE = 91;
    public static final int TYPE_TIME = 92;
    public static final int NUMBER_OF_THREADS = 10;
    private String host;
    private Integer port;
    private String dbname;
    private String username;
    private String password;
    private ConnectionPool pool;
    private ConnectionPoolTransaction transactionPool;
    private int minConnections;
    private int maxConnections;
    private int connectionTimeout;
    private int idleTimeout;
    private int keepaliveTime;
    private int maxLifetime;
    private int transactionConnections;
    DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
    ExecutorService executor;

    public SybaseDB(String host, Integer port, String dbname, String username, String password, int minConnections, int maxConnections, int connectionTimeout, int idleTimeout, int keepaliveTime, int maxLifetime, int transactionConnections) {
        this.host = host;
        this.port = port;
        this.dbname = dbname;
        this.username = username;
        this.password = password;
        this.minConnections = minConnections;
        this.maxConnections = maxConnections;
        this.executor = Executors.newFixedThreadPool(10);
        this.connectionTimeout = connectionTimeout;
        this.idleTimeout = idleTimeout;
        this.keepaliveTime = keepaliveTime;
        this.maxLifetime = maxLifetime;
        this.transactionConnections = transactionConnections;
        this.df.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public boolean connect() {
        try {
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            rootLogger.setLevel(Level.SEVERE);
            for (Handler h : rootLogger.getHandlers()) {
                h.setLevel(Level.SEVERE);
            }
            this.pool = ConnectionPool.create(this.host, this.port, this.dbname, this.username, this.password, this.minConnections, this.maxConnections, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maxLifetime, true);
            this.transactionPool = ConnectionPoolTransaction2.create(this.host, this.port, this.dbname, this.username, this.password, this.minConnections, this.transactionConnections, this.connectionTimeout, this.idleTimeout, this.keepaliveTime, this.maxLifetime, false);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        SybaseDB.this.pool.shutdown();
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                        System.err.println(ex.getMessage());
                    }
                    try {
                        SybaseDB.this.transactionPool.shutdown();
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                        System.err.println(ex.getMessage());
                    }
                }
            });
            return true;
        }
        catch (Exception ex) {
            System.err.println(ex);
            System.err.println(ex.getMessage());
            return false;
        }
    }

    public void disconnect() {
        try {
            this.pool.shutdown();
        }
        catch (Exception ex) {
            System.err.println(ex);
            System.err.println(ex.getMessage());
        }
        try {
            this.transactionPool.shutdown();
        }
        catch (Exception ex) {
            System.err.println(ex);
            System.err.println(ex.getMessage());
        }
    }

    public void execSQL(SQLRequest request) {
        if (request.transId != -1) {
            Future<String> future = this.executor.submit(new ExecSQLTransactionCallable(this.transactionPool, this.df, request));
        } else {
            Future<String> future = this.executor.submit(new ExecSQLCallable(this.pool, this.df, request));
        }
    }
}

