/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.rntimpush;

import android.app.Application;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.tencent.qcloud.rntimpush.TencentCloudPushModule;
import com.tencent.qcloud.tuicore.TUICore;
import com.tencent.qcloud.tuicore.interfaces.ITUINotification;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class TencentCloudPushApplication
extends Application {
    private String TAG = "TencentCloudPushApplication";

    public void onCreate() {
        super.onCreate();
        Log.i((String)this.TAG, (String)"onCreate");
        this.registerEvent();
    }

    public void registerEvent() {
        Log.i((String)this.TAG, (String)"registerEvent");
        TUICore.registerEvent((String)"TIMPushNotifyEvent", (String)"TIMPushNotifyEvent", (ITUINotification)new ITUINotification(){

            public void onNotifyEvent(String key, String subKey, Map<String, Object> param) {
                Log.i((String)TencentCloudPushApplication.this.TAG, (String)("onNotifyEvent key:" + key + " subKey:" + subKey));
                TencentCloudPushApplication.this.launchMainActivity();
                if ("TIMPushNotifyEvent".equals(key) && "TIMPushNotifyEvent".equals(subKey) && param != null) {
                    String extString = (String)param.get("ext");
                    Log.i((String)TencentCloudPushApplication.this.TAG, (String)("extString:" + extString));
                    TencentCloudPushApplication.this.scheduleCheckPluginInstanceAndNotify(extString);
                }
            }
        });
    }

    private void launchMainActivity() {
        Intent intentLaunchMain = this.getPackageManager().getLaunchIntentForPackage(this.getPackageName());
        if (intentLaunchMain != null) {
            this.startActivity(intentLaunchMain);
        } else {
            Log.e((String)this.TAG, (String)("Failed to get launch intent for package: " + this.getPackageName()));
        }
    }

    private void scheduleCheckPluginInstanceAndNotify(final String extString) {
        final Handler handler = new Handler(Looper.getMainLooper());
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Log.i((String)TencentCloudPushApplication.this.TAG, (String)("Checking instance: " + String.valueOf(TencentCloudPushModule.instance != null)));
                            if (TencentCloudPushModule.instance != null) {
                                TencentCloudPushModule.instance.storeExtInfo(extString);
                                timer.cancel();
                            }
                        }
                        catch (Exception e) {
                            Log.e((String)TencentCloudPushApplication.this.TAG, (String)e.toString());
                        }
                    }
                });
            }
        }, 100L, 500L);
    }
}

