/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.rntimpush;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.google.gson.Gson;
import com.tencent.qcloud.tim.push.TIMPushCallback;
import com.tencent.qcloud.tim.push.TIMPushListener;
import com.tencent.qcloud.tim.push.TIMPushManager;
import com.tencent.qcloud.tim.push.TIMPushMessage;
import com.tencent.qcloud.tim.push.config.TIMPushConfig;
import javax.annotation.Nullable;

@ReactModule(name="TencentCloudPush")
public class TencentCloudPushModule
extends ReactContextBaseJavaModule {
    private Context mContext;
    private String mExtInfo = "";
    private String LOG_PREFIX = "Push java |";
    public static final String NAME = "TencentCloudPush";
    public static TencentCloudPushModule instance;
    public static ReactApplicationContext rContext;
    private int listenerCount = 0;

    public TencentCloudPushModule(ReactApplicationContext reactContext) {
        super(reactContext);
        rContext = reactContext;
        this.mContext = reactContext.getApplicationContext();
        instance = this;
    }

    @NonNull
    public String getName() {
        return NAME;
    }

    @ReactMethod
    public void registerPush(int SDKAppID, String appKey, final Callback onSucc) {
        Log.i((String)NAME, (String)(this.LOG_PREFIX + " registerPush | " + SDKAppID + " " + appKey));
        this.setRunningPlatform();
        TIMPushManager.getInstance().registerPush(this.mContext, SDKAppID, appKey, new TIMPushCallback(){

            public void onSuccess(Object data) {
                onSucc.invoke(new Object[]{data});
                if (data != null) {
                    String token = (String)data;
                    Log.i((String)TencentCloudPushModule.NAME, (String)(TencentCloudPushModule.this.LOG_PREFIX + " registerPush ok | " + token));
                }
            }

            public void onError(int errCode, String errMsg, Object data) {
                Log.i((String)TencentCloudPushModule.NAME, (String)(TencentCloudPushModule.this.LOG_PREFIX + " registerPush failed | " + errCode + " " + errMsg));
            }
        });
    }

    @ReactMethod
    public void registerPushWithOnError(int SDKAppID, String appKey, final Callback onSucc, final Callback onErr) {
        Log.i((String)NAME, (String)(this.LOG_PREFIX + " registerPushWithOnError " + SDKAppID + " " + appKey));
        this.setRunningPlatform();
        TIMPushManager.getInstance().registerPush(this.mContext, SDKAppID, appKey, new TIMPushCallback(){

            public void onSuccess(Object data) {
                onSucc.invoke(new Object[]{data});
                if (data != null) {
                    String token = (String)data;
                    Log.i((String)TencentCloudPushModule.NAME, (String)(TencentCloudPushModule.this.LOG_PREFIX + " registerPush ok | " + token));
                }
            }

            public void onError(int errCode, String errMsg, Object data) {
                Log.i((String)TencentCloudPushModule.NAME, (String)(TencentCloudPushModule.this.LOG_PREFIX + " registerPush failed | " + errCode + " " + errMsg));
                onErr.invoke(new Object[]{errCode, errMsg});
            }
        });
    }

    @ReactMethod
    public void unRegisterPush(final Callback onSucc) {
        Log.i((String)NAME, (String)(this.LOG_PREFIX + " unRegisterPush"));
        TIMPushManager.getInstance().unRegisterPush(new TIMPushCallback(){

            public void onSuccess(Object data) {
                Log.i((String)TencentCloudPushModule.NAME, (String)(TencentCloudPushModule.this.LOG_PREFIX + " unRegisterPush ok - "));
                onSucc.invoke(new Object[0]);
            }
        });
    }

    @ReactMethod
    public void unRegisterPushWithOnError(final Callback onSucc) {
        Log.i((String)NAME, (String)(this.LOG_PREFIX + " unRegisterPushWithOnError"));
        TIMPushManager.getInstance().unRegisterPush(new TIMPushCallback(){

            public void onSuccess(Object data) {
                Log.i((String)TencentCloudPushModule.NAME, (String)(TencentCloudPushModule.this.LOG_PREFIX + " unRegisterPushWithOnError ok - "));
                onSucc.invoke(new Object[0]);
            }
        });
    }

    @ReactMethod
    public void getRegistrationID(final Callback onSucc) {
        TIMPushManager.getInstance().getRegistrationID(new TIMPushCallback(){

            public void onSuccess(Object data) {
                if (data != null) {
                    String ret = (String)data;
                    Log.i((String)TencentCloudPushModule.NAME, (String)(TencentCloudPushModule.this.LOG_PREFIX + " getRegistrationID ok | " + ret));
                    onSucc.invoke(new Object[]{ret});
                }
            }
        });
    }

    @ReactMethod
    public void setRegistrationID(String registrationID, final Callback onSucc) {
        TIMPushManager.getInstance().setRegistrationID(registrationID, new TIMPushCallback(){

            public void onSuccess(Object data) {
                Log.i((String)TencentCloudPushModule.NAME, (String)(TencentCloudPushModule.this.LOG_PREFIX + " setRegistrationID ok"));
                onSucc.invoke(new Object[0]);
            }
        });
    }

    @ReactMethod
    public void getNotificationExtInfo(Callback onSucc) {
        onSucc.invoke(new Object[]{this.mExtInfo});
    }

    public void storeExtInfo(String extInfo) {
        this.LOG_PREFIX = " storeExtInfo | " + extInfo;
        Log.i((String)NAME, (String)this.LOG_PREFIX);
        this.mExtInfo = extInfo;
    }

    private void setRunningPlatform() {
        TIMPushConfig.getInstance().setRunningPlatform(5L);
    }

    private void sendEvent(String eventName, @Nullable WritableMap params) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)rContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)params);
    }

    @ReactMethod
    public void addListener(String eventName) {
        if (this.listenerCount == 0) {
            this.addPushListener();
        }
        ++this.listenerCount;
    }

    @ReactMethod
    public void removeListeners(Integer count) {
        this.listenerCount -= count.intValue();
        if (this.listenerCount == 0) {
            this.removePushListener();
        }
    }

    @ReactMethod
    public void addPushListener() {
        Log.i((String)NAME, (String)(this.LOG_PREFIX + " addPushListener "));
        TIMPushManager.getInstance().addPushListener(new TIMPushListener(){

            public void onRecvPushMessage(TIMPushMessage message) {
                Gson gson = new Gson();
                WritableMap params = Arguments.createMap();
                params.putString("data", gson.toJson((Object)message));
                TencentCloudPushModule.this.sendEvent("message_received", params);
            }

            public void onRevokePushMessage(String messageID) {
                WritableMap params = Arguments.createMap();
                params.putString("data", messageID);
                TencentCloudPushModule.this.sendEvent("message_revoked", params);
            }
        });
    }

    @ReactMethod
    public void removePushListener() {
        Log.i((String)NAME, (String)(this.LOG_PREFIX + " removePushListener"));
        TIMPushManager.getInstance().removePushListener(new TIMPushListener(){

            public void onRecvPushMessage(TIMPushMessage message) {
                Gson gson = new Gson();
                WritableMap params = Arguments.createMap();
                params.putString("data", gson.toJson((Object)message));
                TencentCloudPushModule.this.sendEvent("message_received", params);
            }

            public void onRevokePushMessage(String messageID) {
                WritableMap params = Arguments.createMap();
                params.putString("data", messageID);
                TencentCloudPushModule.this.sendEvent("message_revoked", params);
            }
        });
    }
}

