/*
 * Decompiled with CFR 0.152.
 */
package co.tryinhouse.android;

import android.util.Log;
import co.tryinhouse.android.models.Event;
import co.tryinhouse.android.models.SDKConfig;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0086@\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u000bH\u0002J\u001a\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u000e\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lco/tryinhouse/android/NetworkClient;", "", "config", "Lco/tryinhouse/android/models/SDKConfig;", "<init>", "(Lco/tryinhouse/android/models/SDKConfig;)V", "httpClient", "Lokhttp3/OkHttpClient;", "gson", "Lcom/google/gson/Gson;", "sendEvent", "", "event", "Lco/tryinhouse/android/models/Event;", "shortLink", "(Lco/tryinhouse/android/models/Event;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "buildUserAgent", "buildInstallBody", "buildCaptureBody", "sendInstallEvent", "sendCaptureEvent", "getInstallData", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "client_release"})
@SourceDebugExtension(value={"SMAP\nNetworkClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkClient.kt\nco/tryinhouse/android/NetworkClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,193:1\n216#2,2:194\n*S KotlinDebug\n*F\n+ 1 NetworkClient.kt\nco/tryinhouse/android/NetworkClient\n*L\n48#1:194,2\n*E\n"})
public final class NetworkClient {
    @NotNull
    private final SDKConfig config;
    @NotNull
    private final OkHttpClient httpClient;
    @NotNull
    private final Gson gson;

    public NetworkClient(@NotNull SDKConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.httpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
        this.gson = new Gson();
    }

    @Nullable
    public final Object sendEvent(@NotNull Event event, @Nullable String shortLink, @NotNull Continuation<? super String> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(event, this, shortLink, null){
            int label;
            final /* synthetic */ Event $event;
            final /* synthetic */ NetworkClient this$0;
            final /* synthetic */ String $shortLink;
            {
                this.$event = $event;
                this.this$0 = $receiver;
                this.$shortLink = $shortLink;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            Log.d((String)"TrackingSDK", (String)("sendEvent called with eventType=" + this.$event.getEventType()));
                            return Intrinsics.areEqual((Object)this.$event.getEventType(), (Object)"app_install") ? NetworkClient.access$sendInstallEvent(this.this$0, this.$event, this.$shortLink) : NetworkClient.access$sendCaptureEvent(this.this$0, this.$event);
                        }
                        catch (Exception e) {
                            Log.e((String)"TrackingSDK", (String)"Network error sending event", (Throwable)e);
                            return "{\"status\":\"error\",\"message\":\"" + e.getMessage() + "\"}";
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object sendEvent$default(NetworkClient networkClient, Event event, String string, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return networkClient.sendEvent(event, string, (Continuation<? super String>)continuation);
    }

    private final String buildUserAgent() {
        return "TrackingSDK/1.0";
    }

    private final String buildInstallBody(Event event, String shortLink) {
        String referrerValue;
        Pair[] $this$forEach$iv;
        Map extra = new LinkedHashMap();
        Pair[] pairArray = event.getExtra();
        if (pairArray != null) {
            $this$forEach$iv = pairArray;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator.next();
                boolean bl = false;
                String k = entry.getKey();
                Object v = entry.getValue();
                extra.put(k, v);
            }
        }
        if (!extra.containsKey("user_agent") && event.getUserAgent() != null) {
            extra.put("user_agent", event.getUserAgent());
        }
        if (!extra.containsKey("device_id")) {
            extra.put("device_id", event.getDeviceId());
        }
        if (!extra.containsKey("session_id")) {
            extra.put("session_id", event.getSessionId());
        }
        if (!extra.containsKey("timestamp")) {
            extra.put("timestamp", event.getTimestamp());
        }
        if (!extra.containsKey("shortlink") && event.getShortLink() != null) {
            extra.put("shortlink", event.getShortLink());
        }
        $this$forEach$iv = new Pair[]{TuplesKt.to((Object)"event_type", (Object)event.getEventType()), TuplesKt.to((Object)"extra", (Object)extra)};
        Map bodyMap = MapsKt.mutableMapOf((Pair[])$this$forEach$iv);
        String string = shortLink;
        if (string == null) {
            string = event.getReferrer();
        }
        if ((referrerValue = string) != null) {
            bodyMap.put("referrer", referrerValue);
        }
        String string2 = this.gson.toJson((Object)bodyMap);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toJson(...)");
        return string2;
    }

    private final String buildCaptureBody(Event event) {
        Pair[] pairArray = new Pair[9];
        pairArray[0] = TuplesKt.to((Object)"event", (Object)event.getEventType());
        pairArray[1] = TuplesKt.to((Object)"fingerprint", (Object)"");
        pairArray[2] = TuplesKt.to((Object)"user_id", (Object)"");
        String string = event.getDeviceId();
        if (string == null) {
            string = "";
        }
        pairArray[3] = TuplesKt.to((Object)"anonymous_id", (Object)string);
        Pair[] pairArray2 = new Pair[2];
        String string2 = event.getShortLink();
        if (string2 == null) {
            string2 = "";
        }
        pairArray2[0] = TuplesKt.to((Object)"shortlink", (Object)string2);
        String string3 = event.getDeepLink();
        if (string3 == null) {
            string3 = "";
        }
        pairArray2[1] = TuplesKt.to((Object)"deep_link", (Object)string3);
        pairArray[4] = TuplesKt.to((Object)"properties", (Object)MapsKt.mapOf((Pair[])pairArray2));
        pairArray2 = new Pair[4];
        String string4 = event.getIpAddress();
        if (string4 == null) {
            string4 = "";
        }
        pairArray2[0] = TuplesKt.to((Object)"ip_address", (Object)string4);
        String string5 = event.getUserAgent();
        if (string5 == null) {
            string5 = this.buildUserAgent();
        }
        pairArray2[1] = TuplesKt.to((Object)"user_agent", (Object)string5);
        pairArray2[2] = TuplesKt.to((Object)"collected_at", (Object)event.getTimestamp());
        pairArray2[3] = TuplesKt.to((Object)"session_id", (Object)event.getSessionId());
        pairArray[5] = TuplesKt.to((Object)"system", (Object)MapsKt.mapOf((Pair[])pairArray2));
        pairArray[6] = TuplesKt.to((Object)"type", (Object)"mobile");
        pairArray[7] = TuplesKt.to((Object)"version", (Object)"1");
        pairArray[8] = TuplesKt.to((Object)"writeKey", (Object)"");
        Map captureEvent = MapsKt.mutableMapOf((Pair[])pairArray);
        String string6 = this.gson.toJson((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"batch", (Object)CollectionsKt.listOf((Object)captureEvent))));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toJson(...)");
        return string6;
    }

    private final String sendInstallEvent(Event event, String shortLink) {
        HttpUrl.Builder builder;
        HttpUrl builtUrl;
        String jsonBody = this.buildInstallBody(event, shortLink);
        RequestBody requestBody = RequestBody.Companion.create(jsonBody, MediaType.Companion.get("application/json"));
        HttpUrl httpUrl = HttpUrl.Companion.parse(this.config.getServerUrl() + "/v1/api/events/fingerprint/");
        HttpUrl httpUrl2 = builtUrl = httpUrl != null && (builder = httpUrl.newBuilder()) != null ? builder.build() : null;
        if (builtUrl == null) {
            Log.e((String)"TrackingSDK", (String)"Failed to build URL for fingerprint install event");
            return "{\"status\":\"error\",\"message\":\"Invalid URL\"}";
        }
        Log.d((String)"TrackingSDK", (String)("Sending install event to " + builtUrl + " with body: " + jsonBody));
        Request request = new Request.Builder().url(builtUrl).post(requestBody).addHeader("Content-Type", "application/json").addHeader("User-Agent", this.buildUserAgent()).addHeader("x-api-token-id", this.config.getTokenId()).addHeader("x-api-token-secret", this.config.getProjectToken()).addHeader("x-inhouse-app", "mobile").build();
        Response response = this.httpClient.newCall(request).execute();
        Object object = response.body();
        if (object == null || (object = object.string()) == null) {
            object = "{}";
        }
        Object responseBody = object;
        Log.d((String)"TrackingSDK", (String)("Received response: " + (String)responseBody + " with code: " + response.code()));
        return responseBody;
    }

    private final String sendCaptureEvent(Event event) {
        HttpUrl.Builder builder;
        HttpUrl builtUrl;
        String jsonBody = this.buildCaptureBody(event);
        RequestBody requestBody = RequestBody.Companion.create(jsonBody, MediaType.Companion.get("application/json"));
        HttpUrl httpUrl = HttpUrl.Companion.parse(this.config.getServerUrl() + "/v1/api/events/track/");
        HttpUrl httpUrl2 = builtUrl = httpUrl != null && (builder = httpUrl.newBuilder()) != null ? builder.build() : null;
        if (builtUrl == null) {
            Log.e((String)"TrackingSDK", (String)"Failed to build URL for capture event");
            return "{\"status\":\"error\",\"message\":\"Invalid URL\"}";
        }
        Log.d((String)"TrackingSDK", (String)("Sending capture event to " + builtUrl + " with body: " + jsonBody));
        Request request = new Request.Builder().url(builtUrl).post(requestBody).addHeader("Content-Type", "application/json").addHeader("User-Agent", this.buildUserAgent()).addHeader("x-api-token-id", this.config.getTokenId()).addHeader("x-api-token-secret", this.config.getProjectToken()).build();
        Response response = this.httpClient.newCall(request).execute();
        Object object = response.body();
        if (object == null || (object = object.string()) == null) {
            object = "{}";
        }
        Object responseBody = object;
        Log.d((String)"TrackingSDK", (String)("Received response: " + (String)responseBody + " with code: " + response.code()));
        return responseBody;
    }

    @Nullable
    public final Object getInstallData(@NotNull String shortLink, @NotNull Continuation<? super Map<String, String>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends String>>, Object>(shortLink, this, null){
            int label;
            final /* synthetic */ String $shortLink;
            final /* synthetic */ NetworkClient this$0;
            {
                this.$shortLink = $shortLink;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Map map;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            Map map2;
                            HttpUrl httpUrl;
                            HttpUrl.Builder builder;
                            HttpUrl.Builder builder2;
                            Log.d((String)"TrackingSDK", (String)("getInstallData called with shortLink=" + this.$shortLink));
                            String url = NetworkClient.access$getConfig$p(this.this$0).getServerUrl() + "/install-data";
                            HttpUrl httpUrl2 = HttpUrl.Companion.parse(url);
                            if (httpUrl2 == null || (builder2 = httpUrl2.newBuilder()) == null || (builder = builder2.addQueryParameter("shortlink", this.$shortLink)) == null || (httpUrl = builder.build()) == null) {
                                throw new IllegalArgumentException("Invalid URL");
                            }
                            HttpUrl builtUrl = httpUrl;
                            Log.d((String)"TrackingSDK", (String)("Requesting install data from " + builtUrl));
                            Request request = new Request.Builder().url(builtUrl).get().addHeader("User-Agent", NetworkClient.access$buildUserAgent(this.this$0)).addHeader("x-api-token-id", NetworkClient.access$getConfig$p(this.this$0).getTokenId()).addHeader("x-api-token-secret", NetworkClient.access$getConfig$p(this.this$0).getProjectToken()).addHeader("x-inhouse-app", "mobile").build();
                            Response response = NetworkClient.access$getHttpClient$p(this.this$0).newCall(request).execute();
                            if (response.isSuccessful()) {
                                Object object2 = response.body();
                                if (object2 == null || (object2 = object2.string()) == null) {
                                    object2 = "{}";
                                }
                                Object jsonResponse = object2;
                                Log.d((String)"TrackingSDK", (String)("Install data response: " + (String)jsonResponse));
                                Type type2 = new TypeToken<Map<String, ? extends String>>(){}.getType();
                                map2 = (Map)NetworkClient.access$getGson$p(this.this$0).fromJson((String)jsonResponse, type2);
                                if (map2 == null) {
                                    map2 = MapsKt.emptyMap();
                                }
                            } else {
                                Log.e((String)"TrackingSDK", (String)("Failed to get install data: " + response.code()));
                                map2 = MapsKt.emptyMap();
                            }
                            map = map2;
                        }
                        catch (Exception e) {
                            Log.e((String)"TrackingSDK", (String)"Error getting install data", (Throwable)e);
                            map = MapsKt.emptyMap();
                        }
                        return map;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Map<String, String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final /* synthetic */ String access$sendInstallEvent(NetworkClient $this, Event event, String shortLink) {
        return $this.sendInstallEvent(event, shortLink);
    }

    public static final /* synthetic */ String access$sendCaptureEvent(NetworkClient $this, Event event) {
        return $this.sendCaptureEvent(event);
    }

    public static final /* synthetic */ SDKConfig access$getConfig$p(NetworkClient $this) {
        return $this.config;
    }

    public static final /* synthetic */ String access$buildUserAgent(NetworkClient $this) {
        return $this.buildUserAgent();
    }

    public static final /* synthetic */ OkHttpClient access$getHttpClient$p(NetworkClient $this) {
        return $this.httpClient;
    }

    public static final /* synthetic */ Gson access$getGson$p(NetworkClient $this) {
        return $this.gson;
    }
}

