/*
 * Decompiled with CFR 0.152.
 */
package co.tryinhouse.android;

import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u0003J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lco/tryinhouse/android/ShortLinkDetector;", "", "shortLinkDomain", "", "<init>", "(Ljava/lang/String;)V", "isShortLink", "", "url", "extractShortLink", "referrer", "extractShortLinkFromIntent", "intent", "Landroid/content/Intent;", "client_release"})
public final class ShortLinkDetector {
    @NotNull
    private final String shortLinkDomain;

    public ShortLinkDetector(@NotNull String shortLinkDomain) {
        Intrinsics.checkNotNullParameter((Object)shortLinkDomain, (String)"shortLinkDomain");
        this.shortLinkDomain = shortLinkDomain;
    }

    public final boolean isShortLink(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            Log.d((String)"TrackingSDK", (String)("isShortLink called with url=" + url));
            Uri uri = Uri.parse((String)url);
            String host = uri.getHost();
            boolean result = host != null && (Intrinsics.areEqual((Object)host, (Object)this.shortLinkDomain) || StringsKt.endsWith$default((String)host, (String)("." + this.shortLinkDomain), (boolean)false, (int)2, null));
            Log.d((String)"TrackingSDK", (String)("isShortLink result: " + result + " for host=" + host + " and domain=" + this.shortLinkDomain));
            return result;
        }
        catch (Exception e) {
            Log.e((String)"TrackingSDK", (String)("Error in isShortLink: " + e.getMessage()));
            return false;
        }
    }

    @Nullable
    public final String extractShortLink(@NotNull String referrer) {
        Intrinsics.checkNotNullParameter((Object)referrer, (String)"referrer");
        try {
            Log.d((String)"TrackingSDK", (String)("extractShortLink called with referrer=" + referrer));
            Uri uri = Uri.parse((String)referrer);
            String shortLinkParam = uri.getQueryParameter("shortlink");
            if (shortLinkParam != null && this.isShortLink(shortLinkParam)) {
                Log.d((String)"TrackingSDK", (String)("Shortlink param found and valid: " + shortLinkParam));
                return shortLinkParam;
            }
            if (this.isShortLink(referrer)) {
                Log.d((String)"TrackingSDK", (String)("Referrer itself is a shortlink: " + referrer));
                return referrer;
            }
            Log.d((String)"TrackingSDK", (String)"No valid shortlink found in referrer");
            return null;
        }
        catch (Exception e) {
            Log.e((String)"TrackingSDK", (String)("Error in extractShortLink: " + e.getMessage()));
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String extractShortLinkFromIntent(@NotNull Intent intent) {
        Uri data;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                data = intent.getData();
                Log.d((String)"TrackingSDK", (String)("extractShortLinkFromIntent called with data=" + data));
                if (data == null) break block2;
                String string = data.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                if (this.isShortLink(string)) break block3;
            }
            Log.d((String)"TrackingSDK", (String)"Intent data is not a valid shortlink");
            return null;
        }
        Log.d((String)"TrackingSDK", (String)("Intent data is a valid shortlink: " + data));
        String string = data.toString();
        return string;
    }
}

