/*
 * Decompiled with CFR 0.152.
 */
package co.tryinhouse.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import co.tryinhouse.android.models.Event;
import co.tryinhouse.android.models.InstallData;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0006\u0010\u0013\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\rJ\b\u0010\u001a\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001fJ\u0006\u0010 \u001a\u00020\u0011R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lco/tryinhouse/android/StorageManager;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "sharedPreferences", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "Landroid/content/SharedPreferences;", "gson", "Lcom/google/gson/Gson;", "getDeviceId", "", "isFirstInstall", "", "setFirstInstallComplete", "", "resetFirstInstall", "debugFirstInstallState", "storeInstallData", "installData", "Lco/tryinhouse/android/models/InstallData;", "getInstallData", "storeInstallReferrer", "referrer", "getInstallReferrer", "storeFailedEvent", "event", "Lco/tryinhouse/android/models/Event;", "getFailedEvents", "", "clearFailedEvents", "Companion", "client_release"})
public final class StorageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final SharedPreferences sharedPreferences;
    @NotNull
    private final Gson gson;
    @NotNull
    private static final String KEY_DEVICE_ID = "device_id";
    @NotNull
    private static final String KEY_FIRST_INSTALL = "first_install";
    @NotNull
    private static final String KEY_INSTALL_DATA = "install_data";
    @NotNull
    private static final String KEY_INSTALL_REFERRER = "install_referrer";
    @NotNull
    private static final String KEY_FAILED_EVENTS = "failed_events";

    public StorageManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.sharedPreferences = context.getSharedPreferences("tracking_sdk", 0);
        this.gson = new Gson();
    }

    @NotNull
    public final String getDeviceId() {
        String deviceId = this.sharedPreferences.getString(KEY_DEVICE_ID, null);
        if (deviceId == null) {
            deviceId = UUID.randomUUID().toString();
            this.sharedPreferences.edit().putString(KEY_DEVICE_ID, deviceId).apply();
        }
        return deviceId;
    }

    public final boolean isFirstInstall() {
        boolean isFirst = this.sharedPreferences.getBoolean(KEY_FIRST_INSTALL, true);
        boolean hasKey = this.sharedPreferences.contains(KEY_FIRST_INSTALL);
        Log.d((String)"StorageManager", (String)("isFirstInstall() called, hasKey=" + hasKey + ", returning: " + isFirst));
        return isFirst;
    }

    public final void setFirstInstallComplete() {
        Log.d((String)"StorageManager", (String)"setFirstInstallComplete() called, setting first_install to false");
        this.sharedPreferences.edit().putBoolean(KEY_FIRST_INSTALL, false).apply();
    }

    public final void resetFirstInstall() {
        Log.d((String)"StorageManager", (String)"resetFirstInstall() called, setting first_install to true");
        this.sharedPreferences.edit().putBoolean(KEY_FIRST_INSTALL, true).apply();
    }

    public final void debugFirstInstallState() {
        boolean hasKey = this.sharedPreferences.contains(KEY_FIRST_INSTALL);
        boolean value = this.sharedPreferences.getBoolean(KEY_FIRST_INSTALL, true);
        Log.d((String)"StorageManager", (String)("DEBUG: first_install key exists=" + hasKey + ", value=" + value));
    }

    public final void storeInstallData(@NotNull InstallData installData) {
        Intrinsics.checkNotNullParameter((Object)installData, (String)"installData");
        String json = this.gson.toJson((Object)installData);
        this.sharedPreferences.edit().putString(KEY_INSTALL_DATA, json).apply();
    }

    @Nullable
    public final InstallData getInstallData() {
        InstallData installData;
        String json = this.sharedPreferences.getString(KEY_INSTALL_DATA, null);
        if (json != null) {
            InstallData installData2;
            try {
                installData2 = (InstallData)this.gson.fromJson(json, InstallData.class);
            }
            catch (Exception e) {
                installData2 = null;
            }
            installData = installData2;
        } else {
            installData = null;
        }
        return installData;
    }

    public final void storeInstallReferrer(@NotNull String referrer) {
        Intrinsics.checkNotNullParameter((Object)referrer, (String)"referrer");
        this.sharedPreferences.edit().putString(KEY_INSTALL_REFERRER, referrer).apply();
    }

    @Nullable
    public final String getInstallReferrer() {
        return this.sharedPreferences.getString(KEY_INSTALL_REFERRER, null);
    }

    public final void storeFailedEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List existingEvents = CollectionsKt.toMutableList((Collection)this.getFailedEvents());
        existingEvents.add(event);
        if (existingEvents.size() > 100) {
            existingEvents.remove(0);
        }
        String json = this.gson.toJson((Object)existingEvents);
        this.sharedPreferences.edit().putString(KEY_FAILED_EVENTS, json).apply();
    }

    @NotNull
    public final List<Event> getFailedEvents() {
        List list;
        String json = this.sharedPreferences.getString(KEY_FAILED_EVENTS, null);
        if (json != null) {
            List list2;
            try {
                Type type2 = new TypeToken<List<? extends Event>>(){}.getType();
                List list3 = (List)this.gson.fromJson(json, type2);
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                list2 = list3;
            }
            catch (Exception e) {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void clearFailedEvents() {
        this.sharedPreferences.edit().remove(KEY_FAILED_EVENTS).apply();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lco/tryinhouse/android/StorageManager$Companion;", "", "<init>", "()V", "KEY_DEVICE_ID", "", "KEY_FIRST_INSTALL", "KEY_INSTALL_DATA", "KEY_INSTALL_REFERRER", "KEY_FAILED_EVENTS", "client_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

