/*
 * Decompiled with CFR 0.152.
 */
package com.rn_advanced_video_player;

import android.content.Context;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.rn_advanced_video_player.AdvancedVideoView;
import java.util.Map;

public class AdvancedVideoManager
extends SimpleViewManager<AdvancedVideoView> {
    private static final String REACT_CLASS = "RCTAdvancedVideoControls";
    public static final int PAUSE_VIDEO = 1;
    public static final int PLAY_VIDEO = 2;
    public static final int KILL_PLAYER = 3;
    public static final int MUTE_PLAYER = 4;
    public static final int UNMUTE_PLAYER = 5;

    public String getName() {
        return REACT_CLASS;
    }

    protected AdvancedVideoView createViewInstance(ThemedReactContext reactContext) {
        return new AdvancedVideoView((Context)reactContext, reactContext.getCurrentActivity());
    }

    @ReactProp(name="source")
    public void setSource(AdvancedVideoView view, String url) {
        view.initVideoPlayer(url);
    }

    @ReactProp(name="showFullscreenControls")
    public void setShowFullscreenControls(AdvancedVideoView view, Boolean show) {
        view.needSetFullscreenControlsProps = true;
        view.setShowFullscreenControls(show);
    }

    @ReactProp(name="fullscreen")
    public void setFullScreenImg(AdvancedVideoView view, Boolean isFullscreen) {
        view.setFullscreenImg(isFullscreen);
    }

    @ReactProp(name="swipeToSeek")
    public void setSwipeToSeek(AdvancedVideoView view, Boolean swipeToSeek) {
        view.setSwipeToSeek(swipeToSeek);
    }

    @ReactProp(name="isLiked")
    public void setIsLiked(AdvancedVideoView view, Boolean isLiked) {
        view.setIsLiked(isLiked);
    }

    @ReactProp(name="title")
    public void setTitle(AdvancedVideoView view, String title) {
        view.setTitle(title);
    }

    @ReactProp(name="seekBarColor")
    public void setSeekBarColor(AdvancedVideoView view, String colorString) {
        view.setSeekBarColor(colorString);
    }

    @ReactProp(name="showLikeButton")
    public void setShowLike(AdvancedVideoView view, Boolean show) {
        view.setShowLike(show);
    }

    @ReactProp(name="showShareButton")
    public void setShowShare(AdvancedVideoView view, Boolean show) {
        view.setShowShare(show);
    }

    @ReactProp(name="showDownloadButton")
    public void setShowDownload(AdvancedVideoView view, Boolean show) {
        view.setShowDownload(show);
    }

    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of((Object)"pauseVideo", (Object)1, (Object)"playVideo", (Object)2, (Object)"killPlayer", (Object)3, (Object)"mutePlayer", (Object)4, (Object)"unmutePlayer", (Object)5);
    }

    public void receiveCommand(AdvancedVideoView view, int commandType, @Nullable ReadableArray args) {
        Assertions.assertNotNull((Object)((Object)view));
        Assertions.assertNotNull((Object)args);
        switch (commandType) {
            case 1: {
                view.pauseVideo();
                return;
            }
            case 2: {
                view.playVideo();
                return;
            }
            case 3: {
                view.killPlayer();
                return;
            }
            case 4: {
                view.mutePlayer();
                return;
            }
            case 5: {
                view.unmutePlayer();
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported command %d received by %s.", commandType, ((Object)((Object)this)).getClass().getSimpleName()));
    }

    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put((Object)"onFullscreen", (Object)MapBuilder.of((Object)"registrationName", (Object)"onFullscreen")).put((Object)"onBackPressed", (Object)MapBuilder.of((Object)"registrationName", (Object)"onBackPressed")).put((Object)"onLikePressed", (Object)MapBuilder.of((Object)"registrationName", (Object)"onLikePressed")).put((Object)"onSharePressed", (Object)MapBuilder.of((Object)"registrationName", (Object)"onSharePressed")).put((Object)"onDownloadPressed", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDownloadPressed")).put((Object)"onRefreshPressed", (Object)MapBuilder.of((Object)"registrationName", (Object)"onRefreshPressed")).put((Object)"onControlsShow", (Object)MapBuilder.of((Object)"registrationName", (Object)"onControlsShow")).put((Object)"onControlsHide", (Object)MapBuilder.of((Object)"registrationName", (Object)"onControlsHide")).build();
    }
}

