/*
 * Decompiled with CFR 0.152.
 */
package com.rn_advanced_video_player;

import android.app.Activity;
import android.content.Context;
import android.graphics.PorterDuff;
import android.media.AudioManager;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.google.android.exoplayer2.ui.PlayerView;
import com.rn_advanced_video_player.ColorHelper;
import com.rn_advanced_video_player.CustomVideoView;
import com.rn_advanced_video_player.MyHelper;
import com.rn_advanced_video_player.OnSwipeTouchListener;
import com.rn_advanced_video_player.R;
import com.rn_advanced_video_player.VideoPlayer;

public class AdvancedVideoView
extends FrameLayout {
    private ReactContext reactContext;
    private Activity myActivity;
    private FrameLayout screenLayout;
    private VideoPlayer videoPlayer;
    private AudioManager audio;
    public int containerWidth = 0;
    public int containerHeight = 0;
    private RelativeLayout swipeParentContainer;
    private LinearLayout swipeDetailsContainer;
    private TextView swipeSeconds;
    private TextView swipeCurrentTime;
    private TextView swipeVideoLength;
    private Boolean isSwiping = false;
    private Boolean canSwipeToSeek = true;
    private int swipeAmount;
    private int seekToInt;
    private double swipeThreshold = 25.0;
    public boolean needSetFullscreenControlsProps = false;
    private Handler setFullscreenControlsPropsTimer = new Handler();
    private Handler setSeekBarColorTimer = new Handler();
    private boolean doneSetSeekBarColor = false;
    private Handler setTitleTimer = new Handler();
    private Handler setIsLikeTimer = new Handler();
    private Handler setShowLikeBtnTimer = new Handler();
    private Handler setShowShareBtnTimer = new Handler();
    private Handler setShowDownloadBtnTimer = new Handler();
    private final Runnable measureAndLayout = new Runnable(){

        @Override
        public void run() {
            AdvancedVideoView.this.measure(View.MeasureSpec.makeMeasureSpec((int)AdvancedVideoView.this.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)AdvancedVideoView.this.getHeight(), (int)0x40000000));
            AdvancedVideoView.this.layout(AdvancedVideoView.this.getLeft(), AdvancedVideoView.this.getTop(), AdvancedVideoView.this.getRight(), AdvancedVideoView.this.getBottom());
        }
    };

    public AdvancedVideoView(Context context) {
        super(context);
        this.reactContext = (ReactContext)context;
    }

    public AdvancedVideoView(Context context, Activity activity) {
        super(context);
        this.reactContext = (ReactContext)context;
        this.myActivity = activity;
        this.screenLayout = (FrameLayout)activity.getLayoutInflater().inflate(R.layout.video, null);
        this.audio = (AudioManager)context.getSystemService("audio");
        this.initLayoutChangeListener();
        this.initSwipeGestures(context);
        this.addView((View)this.screenLayout);
        this.videoPlayer = new VideoPlayer(context, activity, this.screenLayout, new SpecialFunctions());
        this.videoPlayer.videoContainer = (RelativeLayout)this.screenLayout.findViewById(R.id.videoContainer);
        this.videoPlayer.videoView = (CustomVideoView)this.screenLayout.findViewById(R.id.surface_view);
        this.videoPlayer.videoView.avv = this;
        this.videoPlayer.exoView = (PlayerView)this.screenLayout.findViewById(R.id.exoplayer);
        this.videoPlayer.videoContainer.removeViewAt(0);
    }

    public void pauseVideo() {
        this.videoPlayer.pause(false);
    }

    public void playVideo() {
        this.videoPlayer.play(false);
    }

    public void killPlayer() {
        this.videoPlayer.killVideoPlayer(true);
        this.reactContext.getCurrentActivity().getWindow().clearFlags(128);
    }

    public void mutePlayer() {
        this.videoPlayer.mutePlayer();
    }

    public void unmutePlayer() {
        this.videoPlayer.unmutePlayer();
    }

    public void initVideoPlayer(String passedString) {
        if (this.videoPlayer.videoControls != null) {
            this.videoPlayer.isBuffering = true;
            this.videoPlayer.videoControls.setPlayPauseImage("buffering", false);
        }
        this.videoPlayer.videoUrl = passedString;
        this.videoPlayer.initializePlayer();
    }

    public void setShowFullscreenControls(final Boolean show) {
        if (this.needSetFullscreenControlsProps) {
            this.setFullscreenControlsPropsTimer.removeCallbacksAndMessages(null);
            if (this.videoPlayer != null && this.videoPlayer.videoControls != null) {
                this.needSetFullscreenControlsProps = false;
                this.videoPlayer.videoControls.setShowFullscreenControls(show);
            } else {
                this.setFullscreenControlsPropsTimer = new Handler();
                this.setFullscreenControlsPropsTimer.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        AdvancedVideoView.this.setShowFullscreenControls(show);
                    }
                }, 200L);
            }
        }
    }

    public void setFullscreenImg(Boolean isFullScreen) {
        if (this.videoPlayer != null && this.videoPlayer.videoControls != null) {
            this.videoPlayer.videoControls.setFullscreenImg(isFullScreen);
        }
    }

    public void setSwipeToSeek(Boolean swipeToSeek) {
        this.canSwipeToSeek = swipeToSeek;
    }

    public void setIsLiked(Boolean isLiked) {
        if (this.videoPlayer != null && this.videoPlayer.videoControls != null && this.videoPlayer.videoControls.favButton != null) {
            this.setIsLikeTimer.removeCallbacksAndMessages(null);
            if (isLiked.booleanValue()) {
                this.videoPlayer.videoControls.favButton.setBackgroundResource(R.drawable.favourite);
            } else {
                this.videoPlayer.videoControls.favButton.setBackgroundResource(R.drawable.bookmark);
            }
        } else {
            final Boolean copyIsLiked = isLiked;
            this.setIsLikeTimer = new Handler();
            this.setIsLikeTimer.postDelayed(new Runnable(){

                @Override
                public void run() {
                    AdvancedVideoView.this.setIsLiked(copyIsLiked);
                }
            }, 500L);
        }
    }

    public void setTitle(final String title) {
        this.setTitleTimer.removeCallbacksAndMessages(null);
        if (this.videoPlayer != null && this.videoPlayer.videoControls != null && this.videoPlayer.videoControls.titleText != null) {
            this.videoPlayer.videoControls.titleText.setText((CharSequence)title);
        } else {
            this.setTitleTimer = new Handler();
            this.setTitleTimer.postDelayed(new Runnable(){

                @Override
                public void run() {
                    AdvancedVideoView.this.setTitle(title);
                }
            }, 500L);
        }
    }

    public void setSeekBarColor(final String colorString) {
        if (!this.doneSetSeekBarColor && this.videoPlayer != null && this.videoPlayer.videoControls != null) {
            this.doneSetSeekBarColor = true;
            this.setSeekBarColorTimer.removeCallbacksAndMessages(null);
            this.videoPlayer.videoControls.seekBar.getProgressDrawable().setColorFilter(ColorHelper.getColorFromString(colorString), PorterDuff.Mode.SRC_IN);
            this.videoPlayer.videoControls.seekBar.getThumb().setColorFilter(ColorHelper.getColorFromString(colorString), PorterDuff.Mode.SRC_IN);
        } else {
            this.setSeekBarColorTimer = new Handler();
            this.setSeekBarColorTimer.postDelayed(new Runnable(){

                @Override
                public void run() {
                    AdvancedVideoView.this.setSeekBarColor(colorString);
                }
            }, 500L);
        }
    }

    public void setShowLike(final boolean show) {
        if (this.videoPlayer != null && this.videoPlayer.videoControls != null) {
            this.setShowLikeBtnTimer.removeCallbacksAndMessages(null);
            this.videoPlayer.videoControls.hideButton("like", show);
        } else {
            this.setShowLikeBtnTimer = new Handler();
            this.setShowLikeBtnTimer.postDelayed(new Runnable(){

                @Override
                public void run() {
                    AdvancedVideoView.this.setShowLike(show);
                }
            }, 500L);
        }
    }

    public void setShowShare(final boolean show) {
        if (this.videoPlayer != null && this.videoPlayer.videoControls != null) {
            this.setShowShareBtnTimer.removeCallbacksAndMessages(null);
            this.videoPlayer.videoControls.hideButton("share", show);
        } else {
            this.setShowShareBtnTimer = new Handler();
            this.setShowShareBtnTimer.postDelayed(new Runnable(){

                @Override
                public void run() {
                    AdvancedVideoView.this.setShowShare(show);
                }
            }, 500L);
        }
    }

    public void setShowDownload(final boolean show) {
        if (this.videoPlayer != null && this.videoPlayer.videoControls != null) {
            this.setShowDownloadBtnTimer.removeCallbacksAndMessages(null);
            this.videoPlayer.videoControls.hideButton("download", show);
        } else {
            this.setShowDownloadBtnTimer = new Handler();
            this.setShowDownloadBtnTimer.postDelayed(new Runnable(){

                @Override
                public void run() {
                    AdvancedVideoView.this.setShowDownload(show);
                }
            }, 500L);
        }
    }

    public void updateSwipeUI() {
        String videoLength = MyHelper.getSeconds(this.videoPlayer.videoLength);
        String currentTime = MyHelper.getSeconds(this.seekToInt);
        if (this.swipeAmount > 0) {
            this.swipeSeconds.setText((CharSequence)("+ " + String.valueOf(this.swipeAmount) + " seconds"));
        } else {
            this.swipeSeconds.setText((CharSequence)(String.valueOf(this.swipeAmount) + " seconds"));
        }
        this.swipeCurrentTime.setText((CharSequence)currentTime);
        this.swipeVideoLength.setText((CharSequence)videoLength);
        this.swipeParentContainer.setBackgroundResource(R.color.black_see_through);
        this.swipeDetailsContainer.setAlpha(1.0f);
    }

    public void initSwipeGestures(Context context) {
        this.swipeParentContainer = (RelativeLayout)this.screenLayout.findViewById(R.id.swipeDetailsParentContainer);
        this.swipeDetailsContainer = (LinearLayout)this.screenLayout.findViewById(R.id.swipeDetailsContainer);
        this.swipeSeconds = (TextView)this.screenLayout.findViewById(R.id.swipeSeconds);
        this.swipeCurrentTime = (TextView)this.screenLayout.findViewById(R.id.swipe_current_time);
        this.swipeVideoLength = (TextView)this.screenLayout.findViewById(R.id.swipe_video_length);
        this.screenLayout.setOnTouchListener((View.OnTouchListener)new OnSwipeTouchListener(context){

            @Override
            public void onClick() {
                if (((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoControls.isVisible.booleanValue()) {
                    ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoControls.hideControls();
                } else {
                    ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoControls.showControls();
                }
            }

            @Override
            public void onDoubleTapped() {
                if (((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.isLiveStream) {
                    return;
                }
                if (((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.isPlaying.booleanValue()) {
                    AdvancedVideoView.this.videoPlayer.pause(true);
                } else {
                    AdvancedVideoView.this.videoPlayer.play(true);
                }
            }

            @Override
            public void onStartSwipe(MotionEvent me) {
                System.out.println("START SWIPE " + ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.canSeek);
                if (!AdvancedVideoView.this.canSwipeToSeek.booleanValue() || ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.isLiveStream || !((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.canSeek) {
                    return;
                }
                System.out.println("ENTERRRRR");
                if (AdvancedVideoView.this.videoPlayer != null && ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoControls != null) {
                    ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoControls.setDevSwipeStatus(AdvancedVideoView.this.checkVolOrBrtChanging(me), "start", me);
                }
                AdvancedVideoView.this.swipeAmount = 0;
                AdvancedVideoView.this.seekToInt = ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.currentTime;
            }

            @Override
            public void onStopSwipe() {
                if (!AdvancedVideoView.this.canSwipeToSeek.booleanValue() || ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.isLiveStream || !((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.canSeek) {
                    return;
                }
                if (AdvancedVideoView.this.videoPlayer != null && ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoControls != null) {
                    ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoControls.setDevSwipeStatus("volume", "stop", null);
                }
                AdvancedVideoView.this.swipeParentContainer.setBackgroundColor(0);
                AdvancedVideoView.this.swipeDetailsContainer.setAlpha(0.0f);
                AdvancedVideoView.this.isSwiping = false;
                if (AdvancedVideoView.this.swipeAmount != 0) {
                    AdvancedVideoView.this.videoPlayer.seekToPosition(AdvancedVideoView.this.seekToInt);
                    AdvancedVideoView.this.swipeAmount = 0;
                }
            }

            @Override
            public void onSwipeRight(float distance) {
                if (!AdvancedVideoView.this.canSwipeToSeek.booleanValue() || ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.isLiveStream || !((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.canSeek) {
                    return;
                }
                if (!AdvancedVideoView.this.canSwipeToSeek.booleanValue()) {
                    return;
                }
                if (!AdvancedVideoView.this.isSwiping.booleanValue() && (double)distance < AdvancedVideoView.this.swipeThreshold) {
                    return;
                }
                AdvancedVideoView.this.isSwiping = true;
                distance /= 5.0f;
                if ((float)AdvancedVideoView.this.seekToInt + distance >= (float)((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoLength) {
                    AdvancedVideoView.this.swipeAmount += ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoLength - AdvancedVideoView.this.seekToInt;
                    AdvancedVideoView.this.seekToInt = ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoLength;
                } else {
                    AdvancedVideoView.this.swipeAmount += (int)distance;
                    AdvancedVideoView.this.seekToInt += (int)distance;
                }
                AdvancedVideoView.this.updateSwipeUI();
            }

            @Override
            public void onSwipeLeft(float distance) {
                if (!AdvancedVideoView.this.canSwipeToSeek.booleanValue() || ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.isLiveStream || !((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.canSeek) {
                    return;
                }
                if (!AdvancedVideoView.this.canSwipeToSeek.booleanValue()) {
                    return;
                }
                if (!AdvancedVideoView.this.isSwiping.booleanValue() && (double)distance < AdvancedVideoView.this.swipeThreshold) {
                    return;
                }
                AdvancedVideoView.this.isSwiping = true;
                distance /= 5.0f;
                if ((float)AdvancedVideoView.this.seekToInt - distance <= 0.0f) {
                    AdvancedVideoView.this.swipeAmount -= AdvancedVideoView.this.seekToInt;
                    AdvancedVideoView.this.seekToInt = 0;
                } else {
                    AdvancedVideoView.this.swipeAmount -= (int)distance;
                    AdvancedVideoView.this.seekToInt -= (int)distance;
                }
                AdvancedVideoView.this.updateSwipeUI();
            }

            @Override
            public void onSwipeUp(float distance, MotionEvent me1, MotionEvent me2) {
                if (!AdvancedVideoView.this.isSwiping.booleanValue() && AdvancedVideoView.this.videoPlayer != null && ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoControls != null) {
                    ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoControls.updateDevSwipeValues(AdvancedVideoView.this.checkVolOrBrtChanging(me1), distance, me1, me2);
                }
            }

            @Override
            public void onSwipeDown(float distance, MotionEvent me1, MotionEvent me2) {
                if (!AdvancedVideoView.this.isSwiping.booleanValue() && AdvancedVideoView.this.videoPlayer != null && ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoControls != null) {
                    ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoControls.updateDevSwipeValues(AdvancedVideoView.this.checkVolOrBrtChanging(me1), distance, me1, me2);
                }
            }
        });
    }

    public String checkVolOrBrtChanging(MotionEvent event) {
        int containerWidth = this.screenLayout.getWidth();
        if (event.getX() > (float)(containerWidth / 2)) {
            return "volume";
        }
        return "brightness";
    }

    public void initLayoutChangeListener() {
        this.screenLayout.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                Boolean widthChanged = v.getWidth() != AdvancedVideoView.this.containerWidth;
                Boolean heightChanged = v.getHeight() != AdvancedVideoView.this.containerHeight;
                if (!widthChanged.booleanValue() && !heightChanged.booleanValue()) {
                    return;
                }
                if (widthChanged.booleanValue()) {
                    AdvancedVideoView.this.containerWidth = v.getWidth();
                }
                if (heightChanged.booleanValue()) {
                    AdvancedVideoView.this.containerHeight = v.getHeight();
                }
                if (AdvancedVideoView.this.videoPlayer != null && ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoControls != null && ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoView != null) {
                    ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoView.resizeVideo();
                    ((AdvancedVideoView)AdvancedVideoView.this).videoPlayer.videoControls.setSeekBarProgress();
                }
            }
        });
    }

    public void requestLayout() {
        super.requestLayout();
        this.post(this.measureAndLayout);
    }

    public class SpecialFunctions {
        public void toggleFullscreen() {
            WritableMap event = Arguments.createMap();
            ((RCTEventEmitter)AdvancedVideoView.this.reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(AdvancedVideoView.this.getId(), "onFullscreen", event);
        }

        public void backPressed() {
            WritableMap event = Arguments.createMap();
            ((RCTEventEmitter)AdvancedVideoView.this.reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(AdvancedVideoView.this.getId(), "onBackPressed", event);
        }

        public void likePressed() {
            WritableMap event = Arguments.createMap();
            ((RCTEventEmitter)AdvancedVideoView.this.reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(AdvancedVideoView.this.getId(), "onLikePressed", event);
        }

        public void sharePressed() {
            WritableMap event = Arguments.createMap();
            ((RCTEventEmitter)AdvancedVideoView.this.reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(AdvancedVideoView.this.getId(), "onSharePressed", event);
        }

        public void downloadPressed() {
            WritableMap event = Arguments.createMap();
            ((RCTEventEmitter)AdvancedVideoView.this.reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(AdvancedVideoView.this.getId(), "onDownloadPressed", event);
        }

        public void refreshPressed() {
            WritableMap event = Arguments.createMap();
            ((RCTEventEmitter)AdvancedVideoView.this.reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(AdvancedVideoView.this.getId(), "onRefreshPressed", event);
        }

        public void controlsShown() {
            WritableMap event = Arguments.createMap();
            ((RCTEventEmitter)AdvancedVideoView.this.reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(AdvancedVideoView.this.getId(), "onControlsShow", event);
        }

        public void controlsHidden() {
            WritableMap event = Arguments.createMap();
            ((RCTEventEmitter)AdvancedVideoView.this.reactContext.getJSModule(RCTEventEmitter.class)).receiveEvent(AdvancedVideoView.this.getId(), "onControlsHide", event);
        }
    }
}

