/*
 * Decompiled with CFR 0.152.
 */
package com.rn_advanced_video_player;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;

public class OnSwipeTouchListener
implements View.OnTouchListener {
    private final GestureDetector gestureDetector;

    public OnSwipeTouchListener(Context ctx) {
        this.gestureDetector = new GestureDetector(ctx, (GestureDetector.OnGestureListener)new GestureListener());
    }

    public boolean onTouch(View v, MotionEvent event) {
        int action = event.getActionMasked();
        if (action == 1) {
            this.onStopSwipe();
        }
        return this.gestureDetector.onTouchEvent(event);
    }

    public void onSwipeRight(float distance) {
    }

    public void onSwipeLeft(float distance) {
    }

    public void onStartSwipe(MotionEvent me) {
    }

    public void onStopSwipe() {
    }

    public void onSwipeUp(float distance, MotionEvent me1, MotionEvent me2) {
    }

    public void onSwipeDown(float distance, MotionEvent me1, MotionEvent me2) {
    }

    public void onClick() {
    }

    public void onDoubleTapped() {
    }

    private final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private static final int SWIPE_THRESHOLD = 100;
        private static final int SWIPE_VELOCITY_THRESHOLD = 100;

        private GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            OnSwipeTouchListener.this.onStartSwipe(e);
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            OnSwipeTouchListener.this.onDoubleTapped();
            return true;
        }

        public boolean onScroll(MotionEvent event1, MotionEvent event2, float distanceX, float distanceY) {
            if (distanceX > 0.0f) {
                OnSwipeTouchListener.this.onSwipeLeft(Math.abs(distanceX));
            } else if (distanceX < 0.0f) {
                OnSwipeTouchListener.this.onSwipeRight(Math.abs(distanceX));
            } else if (distanceY > 0.0f) {
                OnSwipeTouchListener.this.onSwipeUp(Math.abs(distanceY), event1, event2);
            } else if (distanceY < 0.0f) {
                OnSwipeTouchListener.this.onSwipeDown(-Math.abs(distanceY), event1, event2);
            }
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            OnSwipeTouchListener.this.onClick();
            return true;
        }
    }
}

