/*
 * Decompiled with CFR 0.152.
 */
package com.rn_advanced_video_player;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.github.ybq.android.spinkit.SpinKitView;
import com.lukelorusso.verticalseekbar.VerticalSeekBar;
import com.rn_advanced_video_player.MyHelper;
import com.rn_advanced_video_player.R;
import com.rn_advanced_video_player.SettingsContentObserver;
import com.rn_advanced_video_player.TimeHelper;
import com.rn_advanced_video_player.VideoPlayer;
import java.util.HashMap;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class VideoControls {
    private Context myContext;
    private Activity myActivity;
    private TimeHelper timeHelper;
    private Window window;
    private WindowManager.LayoutParams layoutParams;
    private VideoPlayer.VideoFunctions videoFns;
    public boolean showLikeButton = true;
    public boolean showShareButton = true;
    public boolean showDownloadButton = true;
    public boolean showFullscreenControls = true;
    private FrameLayout screenLayout;
    public LinearLayout topLayout;
    public ImageButton backButton;
    public TextView titleText;
    public ImageButton favButton;
    public ImageButton shareButton;
    public ImageButton dlButton;
    public ImageButton refreshButton;
    public ImageButton playPauseButton;
    public SpinKitView spinner;
    public RelativeLayout brightnessContainer;
    public ImageButton brightnessIcon;
    public VerticalSeekBar brightnessSeekBar;
    public RelativeLayout volumeContainer;
    public ImageButton volumeIcon;
    public VerticalSeekBar volumeSeekBar;
    public LinearLayout btmLayout;
    public RelativeLayout dummyView;
    public ImageButton zoomButton;
    public TextView currentTime;
    public TextView videoLength;
    public SeekBar seekBar;
    private AudioManager audio;
    private ContentResolver cResolver;
    public Boolean isVisible = false;
    private boolean isSeeking = false;
    private int currentTimeInt = 0;
    private int videoLengthInt = 0;
    private boolean skipVolSeek = false;
    private boolean skipVolListener = false;
    private int maxVolume = 0;
    private double lastBrightnessProgress = 0.0;
    private double lastVolProgress = 0.0;
    private double startLocation = 0.0;
    private int timeToHideControls = 2000;
    private Handler hidePlayStatusTimer = new Handler();
    private Handler hideControlsTimer = new Handler();
    private Handler restartVolSeek = new Handler();
    private int seekToInt;

    public VideoControls(Context context, Activity activity, FrameLayout frameLayout, VideoPlayer.VideoFunctions videoFunctions) {
        this.myContext = context;
        this.myActivity = activity;
        this.screenLayout = frameLayout;
        this.videoFns = videoFunctions;
    }

    public void initializeControls() {
        this.audio = (AudioManager)this.myContext.getSystemService("audio");
        this.maxVolume = this.audio.getStreamMaxVolume(3);
        this.cResolver = this.myContext.getApplicationContext().getContentResolver();
        this.timeHelper = new TimeHelper();
        this.playPauseButton = (ImageButton)this.screenLayout.findViewById(R.id.pause_play_button);
        this.spinner = (SpinKitView)this.screenLayout.findViewById(R.id.spinner);
        this.setPlayPauseImage("buffering", false);
        this.topLayout = (LinearLayout)this.screenLayout.findViewById(R.id.top_layout);
        this.backButton = (ImageButton)this.screenLayout.findViewById(R.id.back_button);
        this.titleText = (TextView)this.screenLayout.findViewById(R.id.titleText);
        this.favButton = (ImageButton)this.screenLayout.findViewById(R.id.like_button);
        this.shareButton = (ImageButton)this.screenLayout.findViewById(R.id.share_button);
        this.dlButton = (ImageButton)this.screenLayout.findViewById(R.id.download_button);
        this.refreshButton = (ImageButton)this.screenLayout.findViewById(R.id.refresh_button);
        this.btmLayout = (LinearLayout)this.screenLayout.findViewById(R.id.btm_layout);
        this.currentTime = (TextView)this.screenLayout.findViewById(R.id.current_time);
        this.videoLength = (TextView)this.screenLayout.findViewById(R.id.video_length);
        this.seekBar = (SeekBar)this.screenLayout.findViewById(R.id.seek_bar);
        this.dummyView = (RelativeLayout)this.screenLayout.findViewById(R.id.dummy_view);
        this.zoomButton = (ImageButton)this.screenLayout.findViewById(R.id.zoom_button);
        this.brightnessIcon = (ImageButton)this.screenLayout.findViewById(R.id.brightness_icon);
        this.brightnessContainer = (RelativeLayout)this.screenLayout.findViewById(R.id.brightnessContainer);
        this.brightnessSeekBar = (VerticalSeekBar)this.screenLayout.findViewById(R.id.brightness_seekbar);
        this.volumeIcon = (ImageButton)this.screenLayout.findViewById(R.id.volume_icon);
        this.volumeContainer = (RelativeLayout)this.screenLayout.findViewById(R.id.volumeContainer);
        this.volumeSeekBar = (VerticalSeekBar)this.screenLayout.findViewById(R.id.volume_seekbar);
        this.setFullscreenImg(false);
        this.initSeekbars(this.myContext);
        this.initButtonClickListeners(this.myContext);
        this.initDeviceHardwareListener(this.myContext);
        this.hideControls();
        this.screenLayout.setFocusable(true);
        this.screenLayout.requestFocus();
        this.screenLayout.setFocusableInTouchMode(true);
    }

    public void updateProgress(long timeNow, long timeLength) {
        if (this.isSeeking) {
            return;
        }
        this.currentTimeInt = (int)timeNow / 1000;
        this.videoLengthInt = (int)timeLength / 1000;
        String stringCurrentTime = MyHelper.getSeconds(this.currentTimeInt);
        this.currentTime.setText((CharSequence)stringCurrentTime);
        String stringVideoLength = MyHelper.getSeconds(this.videoLengthInt);
        this.videoLength.setText((CharSequence)stringVideoLength);
        this.seekBar.setMax(this.videoLengthInt);
        this.seekBar.setProgress(this.currentTimeInt);
    }

    public void setPlayPauseImage(String type, Boolean btnVisible) {
        switch (type) {
            case "pause": {
                if (this.videoFns.isBuffering().booleanValue()) {
                    return;
                }
                this.spinner.setAlpha(0.0f);
                this.playPauseButton.setTag((Object)R.drawable.pause);
                this.playPauseButton.setBackgroundResource(R.drawable.pause);
                break;
            }
            case "play": {
                if (this.videoFns.isBuffering().booleanValue()) {
                    return;
                }
                this.spinner.setAlpha(0.0f);
                this.playPauseButton.setTag((Object)R.drawable.play);
                this.playPauseButton.setBackgroundResource(R.drawable.play);
                break;
            }
            case "buffering": {
                this.playPauseButton.setVisibility(4);
                this.spinner.setAlpha(1.0f);
                break;
            }
            default: {
                this.spinner.setAlpha(0.0f);
                this.playPauseButton.setTag((Object)R.drawable.pause);
                this.playPauseButton.setBackgroundResource(R.drawable.pause);
                this.playPauseButton.setVisibility(0);
            }
        }
        if (type != "buffering") {
            if (btnVisible.booleanValue()) {
                this.playPauseButton.setVisibility(0);
            }
            this.hidePlayStatusTimer.removeCallbacksAndMessages(null);
            this.hidePlayStatusTimer = new Handler();
            this.hidePlayStatusTimer.postDelayed(new Runnable(){

                @Override
                public void run() {
                    VideoControls.this.playPauseButton.setVisibility(4);
                }
            }, 500L);
        }
    }

    public void setShowFullscreenControls(Boolean show) {
        this.showFullscreenControls = show;
        if (!this.showFullscreenControls) {
            int btmChildCount = this.btmLayout.getChildCount();
            String topFirstChild = (String)this.topLayout.getChildAt(0).getTag();
            String btmLastChild = (String)this.btmLayout.getChildAt(btmChildCount - 1).getTag();
            if (btmLastChild != null && btmLastChild.equals("zoomBtn")) {
                this.btmLayout.removeViewAt(btmChildCount - 1);
            }
            if (topFirstChild.equals("backBtn")) {
                this.topLayout.removeViewAt(0);
            }
        }
    }

    public void setFullscreenImg(Boolean isFullScreen) {
        if (!this.showFullscreenControls) {
            return;
        }
        int btmChildCount = this.btmLayout.getChildCount();
        String topFirstChild = (String)this.topLayout.getChildAt(0).getTag();
        String btmLastChild = (String)this.btmLayout.getChildAt(btmChildCount - 1).getTag();
        if (isFullScreen.booleanValue()) {
            if (btmLastChild != null && btmLastChild.equals("zoomBtn")) {
                this.btmLayout.removeViewAt(btmChildCount - 1);
            }
            if (!topFirstChild.equals("backBtn")) {
                this.topLayout.addView((View)this.backButton, 0);
            }
        } else {
            if (btmLastChild == null || !btmLastChild.equals("zoomBtn")) {
                this.btmLayout.addView((View)this.zoomButton);
            }
            if (topFirstChild.equals("backBtn")) {
                this.topLayout.removeViewAt(0);
            }
        }
    }

    public void hideButton(String button, boolean show) {
        if (!show) {
            String btnTag = button + "Btn";
            int childCount = this.topLayout.getChildCount();
            int found = -1;
            for (int i = 0; i < childCount; ++i) {
                if (this.topLayout.getChildAt(i).getTag() == null || !this.topLayout.getChildAt(i).getTag().equals(btnTag)) continue;
                found = i;
            }
            if (found != -1) {
                this.topLayout.removeViewAt(found);
            }
        }
    }

    public void hideControls() {
        this.stopTimer();
        this.isVisible = false;
        this.topLayout.setAlpha(0.0f);
        this.btmLayout.setAlpha(0.0f);
        this.currentTime.setAlpha(0.0f);
        this.seekBar.setAlpha(0.0f);
        this.videoLength.setAlpha(0.0f);
        this.volumeIcon.setVisibility(4);
        this.volumeContainer.setAlpha(0.0f);
        this.brightnessIcon.setVisibility(4);
        this.brightnessContainer.setAlpha(0.0f);
        this.playPauseButton.setVisibility(4);
        this.zoomButton.setVisibility(4);
        this.videoFns.controlsHidden();
    }

    public void showControls() {
        this.stopTimer();
        this.isVisible = true;
        this.topLayout.setAlpha(1.0f);
        this.btmLayout.setAlpha(1.0f);
        this.currentTime.setAlpha(1.0f);
        this.seekBar.setAlpha(1.0f);
        this.videoLength.setAlpha(1.0f);
        this.volumeIcon.setVisibility(0);
        this.volumeContainer.setAlpha(1.0f);
        this.brightnessIcon.setVisibility(0);
        this.brightnessContainer.setAlpha(1.0f);
        this.zoomButton.setVisibility(0);
        this.videoFns.controlsShown();
        this.restartTimer();
    }

    public void restartTimer() {
        this.hideControlsTimer.removeCallbacksAndMessages(null);
        this.hideControlsTimer = new Handler();
        this.hideControlsTimer.postDelayed(new Runnable(){

            @Override
            public void run() {
                VideoControls.this.hideControls();
            }
        }, (long)this.timeToHideControls);
    }

    public void switchControls(String type) {
        String[] topRemovables;
        String[] btmRemovables;
        LinearLayout layoutToAdd;
        HashMap<LinearLayout, String[]> toRemove = new HashMap<LinearLayout, String[]>();
        int i = 0;
        int j = 0;
        int found = -1;
        View child = null;
        if (type == "live" || type == "rtmp") {
            layoutToAdd = this.topLayout;
            btmRemovables = new String[]{"currentTimeText", "videoSeekBar", "videoLengthText"};
            topRemovables = new String[]{""};
            toRemove.put(this.btmLayout, btmRemovables);
            toRemove.put(this.topLayout, topRemovables);
        } else {
            layoutToAdd = this.btmLayout;
            btmRemovables = new String[]{"dummyView"};
            topRemovables = new String[]{"refreshBtn"};
            toRemove.put(this.btmLayout, btmRemovables);
            toRemove.put(this.topLayout, topRemovables);
        }
        for (Map.Entry item : toRemove.entrySet()) {
            LinearLayout layoutToRemove = (LinearLayout)item.getKey();
            String[] removables = (String[])item.getValue();
            for (i = 0; i < removables.length; ++i) {
                found = -1;
                child = null;
                for (j = 0; j < layoutToRemove.getChildCount(); ++j) {
                    child = layoutToRemove.getChildAt(j);
                    if (child.getTag() == null || !child.getTag().equals(removables[i])) continue;
                    found = j;
                }
                if (found <= -1) continue;
                layoutToRemove.removeViewAt(found);
            }
        }
        if (type == "live" || type == "rtmp") {
            if (this.refreshButton.getParent() == null) {
                layoutToAdd.addView((View)this.refreshButton, layoutToAdd.getChildCount());
            }
            if (this.dummyView.getParent() == null) {
                this.btmLayout.addView((View)this.dummyView, 0);
            }
        } else {
            if (this.videoLength.getParent() == null) {
                layoutToAdd.addView((View)this.videoLength, 0);
            }
            if (this.seekBar.getParent() == null) {
                layoutToAdd.addView((View)this.seekBar, 0);
            }
            if (this.currentTime.getParent() == null) {
                layoutToAdd.addView((View)this.currentTime, 0);
            }
        }
    }

    public void setDevSwipeStatus(String type, String status, MotionEvent me) {
        ImageButton icon = this.brightnessIcon;
        RelativeLayout container = this.brightnessContainer;
        if (type == "volume") {
            icon = this.volumeIcon;
            container = this.volumeContainer;
        }
        if (status == "start") {
            this.skipVolListener = true;
            this.skipVolSeek = true;
            this.startLocation = me.getY();
            this.stopTimer();
        } else {
            this.skipVolListener = false;
            this.skipVolSeek = false;
            this.restartTimer();
        }
    }

    public void updateDevSwipeValues(String type, float distance, MotionEvent me1, MotionEvent me2) {
        this.stopTimer();
        ImageButton icon = this.brightnessIcon;
        RelativeLayout container = this.brightnessContainer;
        VerticalSeekBar vSeekBar = this.brightnessSeekBar;
        int newSliderPos = this.getNewProgress(me2.getY(), container.getHeight());
        if (type == "volume") {
            icon = this.volumeIcon;
            container = this.volumeContainer;
            vSeekBar = this.volumeSeekBar;
            icon.setVisibility(0);
            container.setAlpha(1.0f);
            newSliderPos = this.setDeviceVolume(container.getHeight(), distance, me2);
        } else {
            icon.setVisibility(0);
            container.setAlpha(1.0f);
            newSliderPos = this.setDeviceBrightness(container.getHeight(), distance, me2);
        }
        vSeekBar.setProgress(newSliderPos);
    }

    public void stopTimer() {
        this.hideControlsTimer.removeCallbacksAndMessages(null);
    }

    public void initDeviceHardwareListener(Context context) {
        SettingsContentObserver mSettingsContentObserver = new SettingsContentObserver(context, new Handler(){

            public void handleMessage(Message msg) {
                if (!VideoControls.this.skipVolListener) {
                    VideoControls.this.restartVolSeek.removeCallbacksAndMessages(null);
                    VideoControls.this.skipVolSeek = true;
                    double doubleMaxVol = VideoControls.this.maxVolume;
                    double volPercent = (double)msg.arg1 / doubleMaxVol;
                    double newVolume = volPercent * 100.0;
                    int roundedVolume = (int)Math.ceil(newVolume);
                    VideoControls.this.lastVolProgress = roundedVolume;
                    VideoControls.this.volumeSeekBar.setProgress(roundedVolume);
                    VideoControls.this.restartTimer();
                    super.handleMessage(msg);
                    VideoControls.this.restartVolSeek = new Handler();
                    VideoControls.this.restartVolSeek.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            VideoControls.this.skipVolSeek = false;
                        }
                    }, 500L);
                }
            }
        });
        context.getApplicationContext().getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)mSettingsContentObserver);
    }

    public void initButtonClickListeners(Context context) {
        this.backButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!VideoControls.this.isVisible.booleanValue()) {
                    return;
                }
                VideoControls.this.videoFns.backPressed();
                VideoControls.this.restartTimer();
            }
        });
        this.favButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!VideoControls.this.isVisible.booleanValue()) {
                    return;
                }
                VideoControls.this.videoFns.likePressed();
                VideoControls.this.restartTimer();
            }
        });
        this.shareButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!VideoControls.this.isVisible.booleanValue()) {
                    return;
                }
                VideoControls.this.videoFns.sharePressed();
                VideoControls.this.restartTimer();
            }
        });
        this.dlButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!VideoControls.this.isVisible.booleanValue()) {
                    return;
                }
                VideoControls.this.videoFns.downloadPressed();
                VideoControls.this.restartTimer();
            }
        });
        this.playPauseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!VideoControls.this.isVisible.booleanValue()) {
                    return;
                }
                VideoControls.this.videoFns.togglePlayStatus();
                VideoControls.this.restartTimer();
            }
        });
        this.zoomButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!VideoControls.this.isVisible.booleanValue()) {
                    return;
                }
                VideoControls.this.videoFns.toggleFullscreen();
                VideoControls.this.restartTimer();
            }
        });
        this.refreshButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!VideoControls.this.isVisible.booleanValue()) {
                    return;
                }
                VideoControls.this.videoFns.seekToLivePosition();
                VideoControls.this.restartTimer();
            }
        });
    }

    public void initSeekbars(Context context) {
        this.setSeekBarProgress();
        this.brightnessSeekBar.setOnProgressChangeListener((Function1)new Function1<Integer, Unit>(){

            public Unit invoke(Integer progressValue) {
                VideoControls.this.brightnessIcon.setVisibility(0);
                VideoControls.this.brightnessContainer.setAlpha(1.0f);
                VideoControls.this.lastBrightnessProgress = progressValue.intValue();
                ((VideoControls)VideoControls.this).layoutParams.screenBrightness = (float)(VideoControls.this.lastBrightnessProgress / 100.0);
                if (((VideoControls)VideoControls.this).layoutParams.screenBrightness > 1.0f) {
                    ((VideoControls)VideoControls.this).layoutParams.screenBrightness = 1.0f;
                } else if (((VideoControls)VideoControls.this).layoutParams.screenBrightness < 0.1f) {
                    ((VideoControls)VideoControls.this).layoutParams.screenBrightness = 0.1f;
                }
                VideoControls.this.window.setAttributes(VideoControls.this.layoutParams);
                VideoControls.this.restartTimer();
                return null;
            }
        });
        this.volumeSeekBar.setOnProgressChangeListener((Function1)new Function1<Integer, Unit>(){

            public Unit invoke(Integer progressValue) {
                if (VideoControls.this.skipVolSeek) {
                    return null;
                }
                VideoControls.this.volumeIcon.setVisibility(0);
                VideoControls.this.volumeContainer.setAlpha(1.0f);
                VideoControls.this.lastVolProgress = progressValue.intValue();
                int newVolume = (int)((double)progressValue.intValue() / 100.0 * (double)VideoControls.this.maxVolume);
                VideoControls.this.audio.setStreamVolume(3, newVolume, 0);
                VideoControls.this.restartTimer();
                return null;
            }
        });
        this.seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (!VideoControls.this.isVisible.booleanValue()) {
                    return;
                }
                VideoControls.this.seekToInt = progress;
                String temp = TimeHelper.getSeconds(progress);
                VideoControls.this.currentTime.setText((CharSequence)temp);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                if (!VideoControls.this.isVisible.booleanValue()) {
                    return;
                }
                VideoControls.this.setPlayPauseImage("buffering", false);
                VideoControls.this.isSeeking = true;
                VideoControls.this.stopTimer();
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                if (!VideoControls.this.isVisible.booleanValue()) {
                    return;
                }
                VideoControls.this.videoFns.seekTo(VideoControls.this.seekToInt);
                VideoControls.this.isSeeking = false;
                VideoControls.this.restartTimer();
            }
        });
    }

    public int setDeviceBrightness(double height, float distance, MotionEvent me2) {
        double meDistance = Math.abs((double)me2.getY() - this.startLocation);
        this.startLocation = me2.getY();
        double changedVal = meDistance / height * 100.0;
        if (distance < 0.0f) {
            changedVal = -changedVal;
        }
        this.lastBrightnessProgress = this.lastBrightnessProgress + changedVal >= 100.0 ? 100.0 : (this.lastBrightnessProgress + changedVal <= 0.0 ? 0.0 : (this.lastBrightnessProgress += changedVal));
        this.layoutParams.screenBrightness = (float)(this.lastBrightnessProgress / 100.0);
        if (this.layoutParams.screenBrightness > 1.0f) {
            this.layoutParams.screenBrightness = 1.0f;
        } else if (this.layoutParams.screenBrightness < 0.1f) {
            this.layoutParams.screenBrightness = 0.1f;
        }
        this.window.setAttributes(this.layoutParams);
        return (int)this.lastBrightnessProgress;
    }

    public int setDeviceVolume(double height, float distance, MotionEvent me2) {
        this.skipVolListener = true;
        double meDistance = Math.abs((double)me2.getY() - this.startLocation);
        this.startLocation = me2.getY();
        double changedVal = meDistance / height * 100.0;
        if (distance < 0.0f) {
            changedVal = -changedVal;
        }
        this.lastVolProgress = this.lastVolProgress + changedVal >= 100.0 ? 100.0 : (this.lastVolProgress + changedVal <= 0.0 ? 0.0 : (this.lastVolProgress += changedVal));
        int newVolume = (int)(this.lastVolProgress / 100.0 * (double)this.maxVolume);
        this.audio.setStreamVolume(3, newVolume, 0);
        return (int)this.lastVolProgress;
    }

    public int getNewProgress(double yPos, double containerHeight) {
        int result = (int)((containerHeight - yPos) / containerHeight * 100.0);
        return result;
    }

    public void setSeekBarProgress() {
        if (this.lastBrightnessProgress < 1.0) {
            this.window = this.myActivity.getWindow();
            this.layoutParams = this.window.getAttributes();
            int curDevBrightness = Settings.System.getInt((ContentResolver)this.cResolver, (String)"screen_brightness", (int)-1);
            this.lastBrightnessProgress = (double)curDevBrightness / 255.0 * 100.0;
        }
        if (this.lastVolProgress < 1.0) {
            double maxVolDouble = this.maxVolume;
            int currentVol = this.audio.getStreamVolume(3);
            this.lastVolProgress = (double)currentVol / maxVolDouble * 100.0;
        }
        this.brightnessSeekBar.setProgress((int)this.lastBrightnessProgress);
        this.volumeSeekBar.setProgress((int)this.lastVolProgress);
    }
}

