/*
 * Decompiled with CFR 0.152.
 */
package com.rn_advanced_video_player;

import android.graphics.Color;

public class MyHelper {
    public static int getColorFromString(String colorString) {
        int redVal = 0;
        int greenVal = 0;
        int blueVal = 0;
        int alphaVal = 255;
        int finalColor = -1;
        if (colorString.contains("rgb")) {
            String tempString = colorString.replace("rgb(", "");
            tempString = tempString.replace(" ", "");
            String[] stringArr = (tempString = tempString.replace(")", "")).split(",");
            if (stringArr.length >= 3) {
                redVal = Integer.parseInt(stringArr[0]);
                greenVal = Integer.parseInt(stringArr[1]);
                blueVal = Integer.parseInt(stringArr[2]);
            }
            if (stringArr.length == 4) {
                alphaVal = Integer.parseInt(stringArr[3]);
                alphaVal = (int)((float)alphaVal * 255.0f);
            }
            finalColor = Color.argb((int)alphaVal, (int)redVal, (int)greenVal, (int)blueVal);
        } else if (colorString.contains("#")) {
            finalColor = Color.parseColor((String)colorString);
        }
        return finalColor;
    }

    public static String pad(int num) {
        String temp = String.valueOf(num);
        if (temp.length() < 2) {
            return "0" + temp;
        }
        return temp;
    }

    public static String getSeconds(double secs) {
        int minutes = (int)Math.floor(secs / 60.0);
        int intSecs = (int)(secs %= 60.0);
        int hours = (int)Math.floor(minutes / 60);
        String hourString = MyHelper.pad(hours);
        String minuteString = MyHelper.pad(minutes %= 60);
        String secondString = MyHelper.pad(intSecs);
        return hourString + ":" + minuteString + ":" + secondString;
    }

    public static String getStreamType(String uri) {
        if (uri.contains("rtmp")) {
            return "rtmp";
        }
        if (uri.contains(".m3u8")) {
            return "live";
        }
        return "normal";
    }
}

