/*
 * Decompiled with CFR 0.152.
 */
package com.rn_advanced_video_player;

import android.app.Activity;
import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.MediaController;
import android.widget.RelativeLayout;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.ext.rtmp.RtmpDataSourceFactory;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.rn_advanced_video_player.AdvancedVideoView;
import com.rn_advanced_video_player.CustomVideoView;
import com.rn_advanced_video_player.MyHelper;
import com.rn_advanced_video_player.VideoControls;
import java.util.HashMap;
import wseemann.media.FFmpegMediaMetadataRetriever;

public class VideoPlayer
extends Activity
implements SurfaceHolder.Callback {
    public Window window;
    public MediaPlayer mPlayer;
    public SurfaceHolder surfaceHolder;
    public RelativeLayout videoContainer;
    public CustomVideoView videoView;
    public PlayerView exoView;
    public SimpleExoPlayer exoPlayer;
    public VideoControls videoControls;
    private Handler handler = new Handler();
    private Handler seekToLiveHandler = new Handler();
    private Handler waitForSurfaceExistHandler = new Handler();
    MediaSource mediaSource;
    public Context myContext;
    public Activity myActivity;
    public AdvancedVideoView.SpecialFunctions specialFns;
    public FrameLayout screenLayout;
    public boolean surfaceExist = false;
    public boolean doneInit = false;
    public boolean mPlayerReleased = false;
    public String videoUrl;
    public Uri videoUri;
    public Boolean isPlaying = true;
    public Boolean isBuffering = true;
    public int currentTime = 0;
    public int videoLength = 0;
    public boolean canSeek = false;
    public boolean isLiveStream = false;
    public String currentPlayer = "videoView";
    private final Runnable updateProgressAction = new Runnable(){

        @Override
        public void run() {
            VideoPlayer.this.updateProgressBar();
        }
    };

    public VideoPlayer(Context context, Activity activity, FrameLayout frameLayout, AdvancedVideoView.SpecialFunctions specialFunctions) {
        this.myContext = context;
        this.myActivity = activity;
        this.screenLayout = frameLayout;
        this.specialFns = specialFunctions;
        this.window = activity.getWindow();
    }

    public void initializePlayer() {
        new MyAsyncTask().execute(new Void[0]);
    }

    public void initPlayer2() {
        System.out.println("AFTER KILL");
        this.isLiveStream = false;
        this.surfaceHolder = this.videoView.getHolder();
        this.surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        if (!this.doneInit) {
            this.doneInit = true;
            this.initExoPlayer();
            this.mPlayer = new MediaPlayer();
            MediaController mediaController = new MediaController(this.myContext);
            mediaController.setVisibility(8);
            mediaController.setAnchorView((View)this.videoView);
            this.videoControls = new VideoControls(this.myContext, this.myActivity, this.screenLayout, new VideoFunctions());
            this.videoControls.initializeControls();
            this.toggleSeekBarStatus(false);
        }
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VideoPlayer.this.isBuffering = true;
                VideoPlayer.this.videoControls.setPlayPauseImage("buffering", false);
            }
        });
        String streamType = MyHelper.getStreamType(this.videoUrl);
        this.videoUri = Uri.parse((String)this.videoUrl);
        this.window.addFlags(128);
        this.toggleSeekBarStatus(false);
        if (streamType == "rtmp") {
            this.isLiveStream = true;
            this.currentPlayer = "exoPlayer";
            this.switchPlayers();
            RtmpDataSourceFactory rtmpDataSourceFactory = new RtmpDataSourceFactory();
            this.mediaSource = null;
            this.mediaSource = new ExtractorMediaSource.Factory((DataSource.Factory)rtmpDataSourceFactory).createMediaSource(this.videoUri);
            try {
                this.exoPlayer.prepare(this.mediaSource);
                this.continueInitialization();
            }
            catch (Exception e) {
                System.out.println("PREPARE EXO PLAYER EXCEPTION");
                e.printStackTrace();
            }
        } else {
            this.currentPlayer = "videoView";
            if (streamType == "live") {
                this.isLiveStream = true;
            }
            this.switchPlayers();
            this.setMpMediaSource(this.videoUrl);
        }
        this.videoControls.switchControls(streamType);
    }

    public void setMpMediaSource(final String videoUrl) {
        if (this.waitForSurfaceExistHandler != null) {
            this.waitForSurfaceExistHandler.removeCallbacksAndMessages(null);
        }
        if (this.surfaceExist && this.mPlayer != null) {
            try {
                String streamType = MyHelper.getStreamType(videoUrl);
                if (!streamType.equals("live")) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                FFmpegMediaMetadataRetriever mmr = new FFmpegMediaMetadataRetriever();
                                mmr.setDataSource(videoUrl);
                                HashMap mtData = mmr.getMetadata().getAll();
                                VideoPlayer.this.videoView.oriWidth = Double.valueOf((String)mtData.get("video_width")) / Double.valueOf((String)mtData.get("video_height"));
                                VideoPlayer.this.videoView.oriHeight = 1.0;
                                mmr.release();
                                VideoPlayer.this.videoView.requestLayout();
                                VideoPlayer.this.videoView.invalidate();
                            }
                            catch (RuntimeException e) {
                                System.out.println("CALC META DATA EXCEPTION");
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
                this.mPlayer.reset();
                this.mPlayer.setDataSource(videoUrl);
                System.out.println("DONE SET DATA SOURCE MPLAYER");
                this.mPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                    public void onPrepared(MediaPlayer mp) {
                        System.out.println("PREPARED CONTINUE INIT");
                        VideoPlayer.this.continueInitialization();
                    }
                });
                this.mPlayer.prepareAsync();
            }
            catch (Exception e) {
                System.out.println("SET MPMEDIASOURCE EXCEPTION");
                e.printStackTrace();
            }
        } else {
            this.waitForSurfaceExistHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    VideoPlayer.this.setMpMediaSource(videoUrl);
                }
            }, 100L);
        }
    }

    public void continueInitialization() {
        this.unmutePlayer();
        this.play(false);
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
        this.handler = new Handler();
        this.updateProgressBar();
        this.toggleSeekBarStatus(true);
    }

    public void initExoPlayer() {
        DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory((BandwidthMeter)bandwidthMeter);
        DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
        this.exoPlayer = ExoPlayerFactory.newSimpleInstance((Context)this.myContext, (TrackSelector)trackSelector);
        this.exoView.setPlayer((Player)this.exoPlayer);
        this.exoView.setUseController(false);
    }

    public void switchPlayers() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (VideoPlayer.this.currentPlayer == "videoView") {
                    if (VideoPlayer.this.exoView.getParent() != null && VideoPlayer.this.videoContainer.getChildAt(0).getTag() != null && VideoPlayer.this.videoContainer.getChildAt(0).getTag().equals("exoPlayer")) {
                        VideoPlayer.this.videoContainer.removeViewAt(0);
                    }
                    if (VideoPlayer.this.videoView.getParent() == null) {
                        VideoPlayer.this.videoContainer.addView((View)VideoPlayer.this.videoView, 0);
                    }
                } else {
                    if (VideoPlayer.this.videoView.getParent() != null && VideoPlayer.this.videoContainer.getChildAt(0).getTag() != null && VideoPlayer.this.videoContainer.getChildAt(0).getTag().equals("videoView")) {
                        VideoPlayer.this.videoContainer.removeViewAt(0);
                    }
                    if (VideoPlayer.this.exoView.getParent() == null) {
                        VideoPlayer.this.videoContainer.addView((View)VideoPlayer.this.exoView, 0);
                    }
                }
            }
        });
    }

    public void surfaceCreated(SurfaceHolder holder) {
        try {
            this.mPlayer.setDisplay(holder);
            this.surfaceExist = true;
        }
        catch (Exception e) {
            System.out.println("SURFACE CREATED ERROR");
            e.printStackTrace();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.surfaceExist = false;
    }

    public void seekToPosition(int value) {
        if (this.mPlayer != null && !this.mPlayerReleased && this.canSeek) {
            try {
                if (this.isPlaying.booleanValue()) {
                    this.videoControls.setPlayPauseImage("buffering", false);
                    this.isBuffering = true;
                }
                this.mPlayer.seekTo(value * 1000);
            }
            catch (Exception e) {
                System.out.println("SEEK TO POSITION ERROR");
                e.printStackTrace();
            }
        }
    }

    public void play(Boolean showIcon) {
        if (this.currentPlayer.equals("videoView")) {
            try {
                if (this.mPlayer != null && !this.mPlayerReleased && !this.mPlayer.isPlaying()) {
                    this.mPlayer.start();
                    this.isPlaying = true;
                    this.window.addFlags(128);
                }
            }
            catch (Exception e) {
                System.out.println("PLAY MPLAYER ERROR");
                e.printStackTrace();
            }
        } else if (this.exoPlayer != null) {
            this.isPlaying = true;
            this.exoPlayer.setPlayWhenReady(true);
            this.window.addFlags(128);
        }
        this.videoControls.setPlayPauseImage("play", showIcon);
    }

    public void pause(Boolean showIcon) {
        if (this.currentPlayer.equals("videoView")) {
            try {
                if (this.mPlayer != null && !this.mPlayerReleased && this.mPlayer.isPlaying()) {
                    this.mPlayer.pause();
                    this.isPlaying = false;
                    this.window.clearFlags(128);
                }
            }
            catch (Exception e) {
                System.out.println("PAUSE MPLAYER ERROR");
                e.printStackTrace();
            }
        } else if (this.exoPlayer != null) {
            this.isPlaying = false;
            this.exoPlayer.setPlayWhenReady(false);
            this.window.clearFlags(128);
        }
        this.videoControls.setPlayPauseImage("pause", showIcon);
    }

    public void mutePlayer() {
        if (this.exoPlayer != null) {
            this.exoPlayer.setVolume(0.0f);
        }
        if (this.mPlayer != null && !this.mPlayerReleased) {
            try {
                this.mPlayer.setVolume(0.0f, 0.0f);
            }
            catch (Exception e) {
                System.out.println("MPLAYER MUTE ERROR");
                e.printStackTrace();
            }
        }
    }

    public void unmutePlayer() {
        if (this.exoPlayer != null) {
            this.exoPlayer.setVolume(1.0f);
        }
        if (this.mPlayer != null && !this.mPlayerReleased) {
            try {
                this.mPlayer.setVolume(1.0f, 1.0f);
            }
            catch (Exception e) {
                System.out.println("MPLAYER UNMUTE ERROR");
            }
        }
    }

    private void updateProgressBar() {
        if (this.handler == null) {
            return;
        }
        long duration = 0L;
        long position = 0L;
        if (this.currentPlayer == "videoView" && this.videoView != null) {
            if (this.mPlayer == null || this.mPlayerReleased) {
                return;
            }
            duration = this.mPlayer.getDuration();
            position = this.mPlayer.getCurrentPosition();
        } else if (this.currentPlayer == "exoPlayer") {
            if (this.exoPlayer == null) {
                return;
            }
            duration = this.exoPlayer.getDuration();
            position = this.mPlayer.getCurrentPosition();
        }
        if (this.currentPlayer == "exoPlayer" && this.exoPlayer.getPlaybackState() == 2) {
            this.isBuffering = true;
            this.videoControls.setPlayPauseImage("buffering", false);
        } else if (this.currentPlayer == "exoPlayer" && this.isPlaying.booleanValue() && this.isBuffering.booleanValue()) {
            System.out.println("here");
            this.isBuffering = false;
            if (this.isPlaying.booleanValue()) {
                this.play(false);
            } else {
                this.pause(false);
            }
        } else if (this.isPlaying.booleanValue() && this.isBuffering.booleanValue() && (long)this.currentTime != position / 1000L) {
            System.out.println("here 2");
            this.isBuffering = false;
            if (this.isPlaying.booleanValue()) {
                this.play(false);
            } else {
                this.pause(false);
            }
        }
        this.currentTime = (int)position / 1000;
        this.videoLength = (int)duration / 1000;
        this.videoControls.updateProgress(position, duration);
        if (this.handler == null) {
            return;
        }
        this.handler.postDelayed(this.updateProgressAction, 1000L);
    }

    public void killVideoPlayer(boolean realKill) {
        if (this.mPlayer != null && !this.mPlayerReleased && this.exoView != null && this.exoPlayer != null && this.doneInit) {
            if (this.handler != null) {
                this.handler.removeCallbacksAndMessages(null);
                this.handler = null;
            }
            this.currentTime = 0;
            this.videoLength = 0;
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (VideoPlayer.this.videoControls != null) {
                        VideoPlayer.this.videoControls.hideControls();
                        VideoPlayer.this.videoControls.updateProgress(VideoPlayer.this.currentTime, VideoPlayer.this.videoLength);
                    }
                }
            });
            if (!realKill) {
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (VideoPlayer.this.mPlayer != null) {
                                VideoPlayer.this.mPlayer.stop();
                                VideoPlayer.this.mPlayer.reset();
                                VideoPlayer.this.mPlayer.setOnPreparedListener(null);
                                VideoPlayer.this.toggleSeekBarStatus(false);
                                System.out.println("STOPPED MPLAYER");
                            }
                        }
                        catch (Exception e) {
                            System.out.println("STOP MPLAYER ERROR");
                            e.printStackTrace();
                        }
                    }
                });
                if (this.surfaceHolder != null) {
                    this.surfaceHolder.removeCallback((SurfaceHolder.Callback)this);
                }
            } else if (this.currentPlayer.equals("videoView")) {
                if (this.mPlayer != null && !this.mPlayerReleased) {
                    try {
                        this.mPlayer.release();
                        this.mPlayerReleased = true;
                        this.toggleSeekBarStatus(false);
                    }
                    catch (Exception e) {
                        System.out.println("RELEASE MPLAYER ERROR");
                    }
                }
            } else {
                this.exoPlayer.release();
            }
        }
    }

    public void toggleSeekBarStatus(boolean active) {
        if (this.videoControls != null && this.videoControls.seekBar != null) {
            this.canSeek = active;
            this.videoControls.seekBar.setEnabled(active);
        }
    }

    private class MyAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private MyAsyncTask() {
        }

        protected Void doInBackground(Void ... params) {
            VideoPlayer.this.killVideoPlayer(false);
            return null;
        }

        protected void onPostExecute(Void result) {
            VideoPlayer.this.initPlayer2();
        }
    }

    public class VideoFunctions {
        public void togglePlayStatus() {
            if (VideoPlayer.this.isPlaying.booleanValue()) {
                VideoPlayer.this.pause(true);
            } else {
                VideoPlayer.this.play(true);
            }
        }

        public void seekTo(int value) {
            VideoPlayer.this.seekToPosition(value);
        }

        public Boolean isBuffering() {
            return VideoPlayer.this.isBuffering;
        }

        public void toggleFullscreen() {
            VideoPlayer.this.specialFns.toggleFullscreen();
        }

        public void backPressed() {
            VideoPlayer.this.specialFns.backPressed();
        }

        public void likePressed() {
            VideoPlayer.this.specialFns.likePressed();
        }

        public void sharePressed() {
            VideoPlayer.this.specialFns.sharePressed();
        }

        public void downloadPressed() {
            VideoPlayer.this.specialFns.downloadPressed();
        }

        public void seekToLivePosition() {
            VideoPlayer.this.pause(false);
            if (VideoPlayer.this.seekToLiveHandler != null) {
                VideoPlayer.this.seekToLiveHandler.removeCallbacksAndMessages(null);
            }
            if (VideoPlayer.this.handler != null) {
                VideoPlayer.this.handler.removeCallbacksAndMessages(null);
            }
            VideoPlayer.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    VideoPlayer.this.isBuffering = true;
                    VideoPlayer.this.videoControls.setPlayPauseImage("buffering", false);
                }
            });
            VideoPlayer.this.specialFns.refreshPressed();
            VideoPlayer.this.seekToLiveHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    VideoPlayer.this.initializePlayer();
                }
            }, 1000L);
        }

        public void controlsShown() {
            VideoPlayer.this.specialFns.controlsShown();
        }

        public void controlsHidden() {
            VideoPlayer.this.specialFns.controlsHidden();
        }
    }
}

