/*
 * Decompiled with CFR 0.152.
 */
package com.appcelerator.verify;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Debug;
import android.util.Base64;
import com.appcelerator.security.Security;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.appcelerator.kroll.KrollRuntime;
import org.appcelerator.kroll.common.Log;
import org.appcelerator.kroll.util.KrollAssetHelper;
import org.appcelerator.titanium.ITiAppInfo;
import org.appcelerator.titanium.TiApplication;
import org.json.JSONException;
import org.json.JSONObject;
import ti.modules.titanium.network.TiSocketFactory;

public final class AssetCryptImpl
implements KrollAssetHelper.AssetCrypt {
    private static final String TAG = "AssetCryptImpl";
    private static final int CONNECTION_TIMEOUT = 15000;
    private static Activity _activity;
    private static boolean _excepted;
    private static String _exception;
    private TiApplication _app;
    private ITiAppInfo _appInfo;
    private String _pepper;
    private String _hmacKey;
    private JSONObject _keys;
    private boolean _isRestartRequired;
    private ArrayList<String> _filePaths = new ArrayList();
    private CountDownLatch _countDownLatch = new CountDownLatch(1);

    public AssetCryptImpl(TiApplication app, ITiAppInfo appInfo) {
        _excepted = false;
        try {
            String storedSha;
            Log.d((String)TAG, (String)"Starting platform AssetCryptImpl", (String)"DEBUG_MODE");
            this._app = app;
            this._appInfo = appInfo;
            String appStoreFn = Security.sha1((String)appInfo.getId());
            JSONObject appStore = this.readJSON(appStoreFn);
            String encryptedFn = Security.sha1((String)appInfo.getGUID());
            Object[] files = this._app.getAssets().list(encryptedFn);
            Arrays.sort(files);
            MessageDigest mOverallDigest = MessageDigest.getInstance("SHA1");
            for (Object encryptedFile : files) {
                int len;
                InputStream in = this._app.getAssets().open(encryptedFn + "/" + (String)encryptedFile);
                MessageDigest mSingleDigest = MessageDigest.getInstance("SHA1");
                byte[] buf = new byte[8192];
                while ((len = in.read(buf)) >= 0) {
                    mSingleDigest.update(buf, 0, len);
                }
                in.close();
                mOverallDigest.update(Security.bytesToHex((byte[])mSingleDigest.digest()).getBytes());
            }
            String calculatedSha = Security.bytesToHex((byte[])mOverallDigest.digest());
            if (!calculatedSha.equals(storedSha = appStore.getString("sha"))) {
                AssetCryptImpl.showSecurityException("Files compromised.");
                return;
            }
            if (appStore.getString("debuggerDetect").equals("true") && Debug.isDebuggerConnected()) {
                AssetCryptImpl.showSecurityException("Debugger detected.");
                return;
            }
            if (appStore.getString("jailBreakDetect").equals("true") && (this.cr1() || this.cr2() || this.cr3())) {
                AssetCryptImpl.showSecurityException("Device rooted.");
                return;
            }
            SharedPreferences cache = app.getSharedPreferences(appStoreFn, 0);
            String cachedSha = cache.getString("sha", null);
            String cachedBuild = cache.getString("build", null);
            if (cachedBuild != null && cachedSha != null && !cachedBuild.equals(appStore.getString("build"))) {
                cachedSha = null;
            }
            if (!(cachedSha == null || cachedSha.equals(storedSha) && cachedSha.equals(calculatedSha))) {
                AssetCryptImpl.showSecurityException("Files compromised.");
                return;
            }
            if (cachedSha == null) {
                Log.d((String)TAG, (String)"Hitting the network for encryption info", (String)"DEBUG_MODE");
                this.hitNetwork(appStore.getString("url") + "/" + storedSha, appStore.getString("build"), calculatedSha, cache);
            } else {
                Log.d((String)TAG, (String)("Using cached values " + cache), (String)"DEBUG_MODE");
                this._pepper = cache.getString("pepper", null);
                this._hmacKey = cache.getString("hmacKey", null);
                this._keys = new JSONObject(cache.getString("keys", null));
                this._countDownLatch.countDown();
            }
        }
        catch (Exception e) {
            this._countDownLatch.countDown();
            AssetCryptImpl.showSecurityException("Security violation detected: " + e);
        }
    }

    public static void setActivity(Activity activity) {
        _activity = activity;
        if (_excepted && _exception != null) {
            AssetCryptImpl.showSecurityException(_exception);
        }
    }

    public InputStream openAsset(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        String utf16Result = this.readAsset(path = this.sanetizePath(path));
        if (utf16Result == null) {
            return null;
        }
        byte[] bytes = null;
        try {
            bytes = utf16Result.getBytes("UTF-8");
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
        }
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public String readAsset(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        path = this.sanetizePath(path);
        try {
            this._countDownLatch.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_excepted || this._keys == null) {
            if (path.equals("app.js") || path.equals("ti.main.js")) {
                this._isRestartRequired = true;
                return "";
            }
            return null;
        }
        try {
            int len;
            String encryptedFn = Security.sha1((String)this._appInfo.getGUID());
            String pathSHA = Security.sha1((String)path);
            InputStream inputStream = this._app.getAssets().open(encryptedFn + "/" + pathSHA);
            byte[] buffer = new byte[1024];
            GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((len = gzipInputStream.read(buffer)) > 0) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
            gzipInputStream.close();
            byteArrayOutputStream.close();
            String key = this._keys.getString(path);
            byte[] bytes = byteArrayOutputStream.toByteArray();
            return Security.decryptWithKey((String)new String(bytes, "UTF-8"), (String)key, (String)this._pepper, (String)this._hmacKey, (String)"base64", (int)128);
        }
        catch (FileNotFoundException encryptedFn) {
        }
        catch (IOException e) {
            AssetCryptImpl.showSecurityException("Unable to load application asset:\n" + path);
        }
        catch (JSONException e) {
            AssetCryptImpl.showSecurityException("Unable to read SHA for file at path:\n" + path);
        }
        return null;
    }

    public Collection<String> getAssetPaths() {
        if (this._keys != null && this._filePaths.isEmpty()) {
            this._filePaths.ensureCapacity(this._keys.length());
            Iterator keyIterator = this._keys.keys();
            while (keyIterator.hasNext()) {
                String filePath = (String)keyIterator.next();
                if (filePath == null) continue;
                this._filePaths.add(filePath);
            }
        }
        return this._filePaths;
    }

    private String readString(String name) throws IOException {
        String str;
        if (name == null || name.isEmpty()) {
            return null;
        }
        name = this.sanetizePath(name);
        InputStream inputStream = this._app.getAssets().open(name);
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        while ((str = bufferedReader.readLine()) != null) {
            stringBuilder.append(str);
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    private JSONObject readJSON(String name) throws IOException, JSONException {
        String string2 = this.readString(name);
        String json = AssetCryptImpl.decodeB64(string2);
        JSONObject object = new JSONObject(json);
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = object.getString(key);
            object.put(key, (Object)AssetCryptImpl.decodeB64(value));
        }
        return object;
    }

    private static String decodeB64(String encoded) throws UnsupportedEncodingException {
        return new String(Base64.decode((String)encoded, (int)0), "UTF-8");
    }

    private String sanetizePath(String path) {
        if (path.startsWith("Resources/")) {
            return path.substring(10);
        }
        return path;
    }

    private boolean cr1() {
        try {
            String buildTags = Build.TAGS;
            return buildTags != null && buildTags.contains(AssetCryptImpl.decodeB64("dGVzdC1rZXlz"));
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean cr2() {
        try {
            File file = new File(AssetCryptImpl.decodeB64("L3N5c3RlbS9hcHAvU3VwZXJ1c2VyLmFwaw=="));
            return file.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean cr3() {
        return this.checkExeOutput("L3N5c3RlbS94YmluL3doaWNo", "c3U=") || this.checkExeOutput("L3N5c3RlbS9iaW4vd2hpY2g=", "c3U=");
    }

    private boolean checkExeOutput(String pathB64, String argB64) {
        try {
            String[] cmd = new String[]{AssetCryptImpl.decodeB64(pathB64), AssetCryptImpl.decodeB64(argB64)};
            Process lp = Runtime.getRuntime().exec(cmd);
            BufferedReader bri = new BufferedReader(new InputStreamReader(lp.getInputStream()));
            return bri.readLine() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void hitNetwork(final String url, final String build, final String calculatedSha, final SharedPreferences cache) throws ExecutionException, InterruptedException {
        class NetworkAsync
        extends AsyncTask<Void, Integer, String> {
            NetworkAsync() {
            }

            protected String doInBackground(Void ... arg0) {
                String errorMessage = this.doDownload();
                AssetCryptImpl.this._countDownLatch.countDown();
                return errorMessage;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private String doDownload() {
                String response;
                block32: {
                    HttpURLConnection connection = null;
                    response = null;
                    try {
                        Log.d((String)AssetCryptImpl.TAG, (String)("Performing GET " + url), (String)"DEBUG_MODE");
                        String urlWithParams = url + "?http.protocol.expect-continue=false";
                        connection = (HttpsURLConnection)new URL(urlWithParams).openConnection();
                        connection.setDoInput(true);
                        connection.setDoOutput(false);
                        ((HttpsURLConnection)connection).setSSLSocketFactory((SSLSocketFactory)new TiSocketFactory(null, null, 0));
                        connection.setConnectTimeout(15000);
                        connection.setReadTimeout(15000);
                        connection.setInstanceFollowRedirects(true);
                        connection.setAllowUserInteraction(false);
                        connection.setRequestMethod("GET");
                        connection.setRequestProperty("accept", "application/json,text/json");
                        connection.setRequestProperty("Accept-Encoding", "gzip");
                        connection.setUseCaches(false);
                        int responseCode = connection.getResponseCode();
                        try (InputStream rawInputStream = connection.getInputStream();){
                            int readCount;
                            InputStream decodedInputStream = rawInputStream;
                            if ("gzip".equalsIgnoreCase(connection.getContentEncoding())) {
                                decodedInputStream = new GZIPInputStream(rawInputStream);
                            }
                            int MAX_BUFFER_SIZE = 2048;
                            char[] buffer = new char[2048];
                            StringBuilder stringBuilder = new StringBuilder();
                            InputStreamReader reader = new InputStreamReader(decodedInputStream, "UTF-8");
                            while ((readCount = reader.read(buffer, 0, 2048)) > 0) {
                                stringBuilder.append(buffer, 0, readCount);
                            }
                            response = stringBuilder.toString();
                        }
                        if (connection == null) break block32;
                    }
                    catch (Throwable t) {
                        try {
                            Log.e((String)AssetCryptImpl.TAG, (String)("Error performing security checks: " + t));
                            String responseCode = "Error performing security checks: The Internet connection appears to be offline. Please make sure your device has network connectivity.";
                            return responseCode;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (connection != null) {
                                try {
                                    connection.disconnect();
                                }
                                catch (Exception rawInputStream) {}
                            }
                        }
                    }
                    try {
                        connection.disconnect();
                    }
                    catch (Exception urlWithParams) {}
                }
                if (response == null) {
                    return "Error performing security checks: Result code was not success. Response was empty.";
                }
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    Log.d((String)AssetCryptImpl.TAG, (String)("Parsed response " + jsonObject.toString()), (String)"DEBUG_MODE");
                    if (!jsonObject.getBoolean("success")) {
                        return "Error performing security checks: Result code was not success. Response was: " + response;
                    }
                    String fetchedSha = jsonObject.getString("sha");
                    if (!calculatedSha.equals(fetchedSha)) {
                        return "The application binary has been tampered with. This application will not run.";
                    }
                    SharedPreferences.Editor edit = cache.edit();
                    edit.putString("sha", fetchedSha);
                    edit.putString("key", jsonObject.getString("key"));
                    edit.putString("pepper", AssetCryptImpl.this._pepper = jsonObject.getString("pepper"));
                    edit.putString("hmacKey", AssetCryptImpl.this._hmacKey = jsonObject.getString("hmacKey"));
                    AssetCryptImpl.this._keys = jsonObject.getJSONObject("keys");
                    edit.putString("keys", AssetCryptImpl.this._keys.toString());
                    edit.putString("build", build);
                    edit.apply();
                    Log.d((String)AssetCryptImpl.TAG, (String)("keys: " + AssetCryptImpl.this._keys.toString()), (String)"DEBUG_MODE");
                    Log.d((String)AssetCryptImpl.TAG, (String)"Done hitting network.", (String)"DEBUG_MODE");
                    return null;
                }
                catch (Throwable t) {
                    return "Error performing security checks: Result code was not success. Response was: " + response;
                }
            }

            protected void onPostExecute(String errorMessage) {
                if (errorMessage != null) {
                    AssetCryptImpl.showSecurityException(errorMessage);
                    return;
                }
                if (AssetCryptImpl.this._isRestartRequired) {
                    AssetCryptImpl.this._isRestartRequired = false;
                    KrollRuntime runtime = KrollRuntime.getInstance();
                    if (runtime != null && !KrollRuntime.isDisposed()) {
                        try {
                            runtime.evalString("Ti.App._restart();");
                        }
                        catch (Exception ex) {
                            Log.e((String)AssetCryptImpl.TAG, (String)"Failed to restart Titanium runtime.", (Throwable)ex);
                        }
                    }
                }
            }
        }
        new NetworkAsync().execute(new Void[0]);
    }

    private static void showSecurityException(String error) {
        if (_excepted && _exception == null) {
            return;
        }
        _excepted = true;
        if (_activity == null) {
            _exception = error;
            Log.e((String)TAG, (String)error);
            Log.e((String)TAG, (String)"Security exception encountered. Waiting for root activity to show error.");
            return;
        }
        Log.e((String)TAG, (String)error, (String)"DEBUG_MODE");
        new AlertDialog.Builder((Context)_activity).setTitle((CharSequence)"Security Violation Detected").setMessage((CharSequence)(error + "\n\nThis application must close.")).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                _exception = null;
                _activity.finish();
                android.os.Process.killProcess((int)android.os.Process.myPid());
            }
        }).setCancelable(false).create().show();
    }
}

