/*
 * Decompiled with CFR 0.152.
 */
package com.reactlibrary;

import android.content.Context;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import io.chirp.connect.ChirpConnect;
import io.chirp.connect.interfaces.ConnectEventListener;
import io.chirp.connect.interfaces.ConnectLicenceListener;
import io.chirp.connect.models.ChirpError;
import io.chirp.connect.models.ConnectState;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class RNChirpReactNativeModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    private static final String TAG = "RNChirpReactNative";
    private ChirpConnect chirpConnect;
    private ReactContext context;
    private boolean started = false;
    private boolean wasStarted = false;

    public String getName() {
        return TAG;
    }

    public RNChirpReactNativeModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.context = reactContext;
        reactContext.addLifecycleEventListener((LifecycleEventListener)this);
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("CHIRP_CONNECT_NOT_CREATED", ConnectState.ConnectNotCreated.ordinal());
        constants.put("CHIRP_CONNECT_STATE_STOPPED", ConnectState.AudioStateStopped.ordinal());
        constants.put("CHIRP_CONNECT_STATE_PAUSED", ConnectState.AudioStatePaused.ordinal());
        constants.put("CHIRP_CONNECT_STATE_RUNNING", ConnectState.AudioStateRunning.ordinal());
        constants.put("CHIRP_CONNECT_STATE_SENDING", ConnectState.AudioStateSending.ordinal());
        constants.put("CHIRP_CONNECT_STATE_RECEIVING", ConnectState.AudioStateReceiving.ordinal());
        return constants;
    }

    @ReactMethod
    public void init(String key, String secret) {
        this.chirpConnect = new ChirpConnect((Context)this.getCurrentActivity(), key, secret);
        this.chirpConnect.setListener(new ConnectEventListener(){

            public void onSending(byte[] data) {
                WritableMap params = RNChirpReactNativeModule.assembleData(data);
                ((DeviceEventManagerModule.RCTDeviceEventEmitter)RNChirpReactNativeModule.this.context.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("onSending", (Object)params);
            }

            public void onSent(byte[] data) {
                WritableMap params = RNChirpReactNativeModule.assembleData(data);
                ((DeviceEventManagerModule.RCTDeviceEventEmitter)RNChirpReactNativeModule.this.context.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("onSent", (Object)params);
            }

            public void onReceiving() {
                WritableMap params = Arguments.createMap();
                ((DeviceEventManagerModule.RCTDeviceEventEmitter)RNChirpReactNativeModule.this.context.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("onReceiving", (Object)params);
            }

            public void onReceived(byte[] data) {
                WritableMap params = RNChirpReactNativeModule.assembleData(data);
                ((DeviceEventManagerModule.RCTDeviceEventEmitter)RNChirpReactNativeModule.this.context.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("onReceived", (Object)params);
            }

            public void onStateChanged(byte oldState, byte newState) {
                WritableMap params = Arguments.createMap();
                params.putInt("status", (int)newState);
                ((DeviceEventManagerModule.RCTDeviceEventEmitter)RNChirpReactNativeModule.this.context.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("onStateChanged", (Object)params);
            }

            public void onSystemVolumeChanged(int oldVolume, int newVolume) {
            }
        });
    }

    @ReactMethod
    public void getLicence(final Promise promise) {
        this.chirpConnect.getLicence(new ConnectLicenceListener(){

            public void onSuccess(String networkLicence) {
                ChirpError setLicenceError = RNChirpReactNativeModule.this.chirpConnect.setLicence(networkLicence);
                if (setLicenceError.getCode() > 0) {
                    promise.reject("Licence Error", setLicenceError.getMessage());
                } else {
                    promise.resolve((Object)"Initialisation Success");
                }
            }

            public void onError(ChirpError chirpError) {
                promise.reject("Network Error", chirpError.getMessage());
            }
        });
    }

    @ReactMethod
    public void setLicence(String licence) {
        ChirpError setLicenceError = this.chirpConnect.setLicence(licence);
        if (setLicenceError.getCode() > 0) {
            this.onError(this.context, setLicenceError.getMessage());
        }
    }

    @ReactMethod
    public void start() {
        ChirpError error = this.chirpConnect.start();
        if (error.getCode() > 0) {
            this.onError(this.context, error.getMessage());
        }
        this.started = true;
    }

    @ReactMethod
    public void stop() {
        ChirpError error = this.chirpConnect.stop();
        if (error.getCode() > 0) {
            this.onError(this.context, error.getMessage());
        }
        this.started = false;
    }

    @ReactMethod
    public void send(ReadableArray data) {
        byte[] payload = new byte[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            payload[i] = (byte)data.getInt(i);
        }
        long maxSize = this.chirpConnect.getMaxPayloadLength();
        if (maxSize < (long)payload.length) {
            this.onError(this.context, "Invalid payload");
            return;
        }
        ChirpError error = this.chirpConnect.send(payload);
        if (error.getCode() > 0) {
            this.onError(this.context, error.getMessage());
        }
    }

    @ReactMethod
    public void sendRandom() {
        Random r = new Random();
        long length = r.nextInt((int)this.chirpConnect.getMaxPayloadLength() - 1);
        byte[] payload = this.chirpConnect.randomPayload(length);
        ChirpError error = this.chirpConnect.send(payload);
        if (error.getCode() > 0) {
            this.onError(this.context, error.getMessage());
        }
    }

    public static String asString(byte[] in) {
        StringBuilder builder = new StringBuilder();
        for (byte b : in) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    private static WritableMap assembleData(byte[] data) {
        WritableArray payload = Arguments.createArray();
        for (int i = 0; i < data.length; ++i) {
            payload.pushInt((int)data[i]);
        }
        WritableMap params = Arguments.createMap();
        params.putArray("data", payload);
        return params;
    }

    private void onError(ReactContext reactContext, String error) {
        WritableMap params = Arguments.createMap();
        params.putString("message", error);
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("onError", (Object)params);
    }

    public void onHostResume() {
        if (this.wasStarted) {
            this.chirpConnect.start();
        }
    }

    public void onHostPause() {
        this.wasStarted = this.started;
        this.chirpConnect.stop();
    }

    public void onHostDestroy() {
        this.wasStarted = this.started;
        try {
            this.chirpConnect.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

