/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.react;

import android.content.Context;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.clevertap.android.sdk.CTExperimentsListener;
import com.clevertap.android.sdk.CTFeatureFlagsListener;
import com.clevertap.android.sdk.CTInboxListener;
import com.clevertap.android.sdk.CTInboxMessage;
import com.clevertap.android.sdk.CTInboxStyleConfig;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.EventDetail;
import com.clevertap.android.sdk.InAppNotificationButtonListener;
import com.clevertap.android.sdk.InAppNotificationListener;
import com.clevertap.android.sdk.InboxMessageButtonListener;
import com.clevertap.android.sdk.SyncListener;
import com.clevertap.android.sdk.UTMDetail;
import com.clevertap.android.sdk.displayunits.DisplayUnitListener;
import com.clevertap.android.sdk.displayunits.model.CleverTapDisplayUnit;
import com.clevertap.android.sdk.featureFlags.CTFeatureFlagsController;
import com.clevertap.android.sdk.product_config.CTProductConfigController;
import com.clevertap.android.sdk.product_config.CTProductConfigListener;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CleverTapModule
extends ReactContextBaseJavaModule
implements SyncListener,
InAppNotificationListener,
CTInboxListener,
CTExperimentsListener,
InboxMessageButtonListener,
InAppNotificationButtonListener,
DisplayUnitListener,
CTProductConfigListener,
CTFeatureFlagsListener {
    private ReactApplicationContext context;
    private CleverTapAPI mCleverTap;
    private static Uri mlaunchURI;
    private static final String REACT_MODULE_NAME = "CleverTapReact";
    private static final String TAG = "CleverTapReact";
    private static final String CLEVERTAP_PROFILE_DID_INITIALIZE = "CleverTapProfileDidInitialize";
    private static final String CLEVERTAP_PROFILE_SYNC = "CleverTapProfileSync";
    private static final String CLEVERTAP_IN_APP_NOTIFICATION_DISMISSED = "CleverTapInAppNotificationDismissed";
    private static final String FCM = "FCM";
    private static final String XPS = "XPS";
    private static final String BPS = "BPS";
    private static final String HPS = "HPS";
    private static final String CLEVERTAP_INBOX_DID_INITIALIZE = "CleverTapInboxDidInitialize";
    private static final String CLEVERTAP_INBOX_MESSAGES_DID_UPDATE = "CleverTapInboxMessagesDidUpdate";
    private static final String CLEVERTAP_EXPERIMENTS_DID_UPDATE = "CleverTapExperimentsDidUpdate";
    private static final String CLEVERTAP_ON_INBOX_BUTTON_CLICK = "CleverTapInboxMessageButtonTapped";
    private static final String CLEVERTAP_ON_INAPP_BUTTON_CLICK = "CleverTapInAppNotificationButtonTapped";
    private static final String CLEVERTAP_ON_DISPLAY_UNITS_LOADED = "CleverTapDisplayUnitsLoaded";
    private static final String CLEVERTAP_FEATURE_FLAGS_DID_UPDATE = "CleverTapFeatureFlagsDidUpdate";
    private static final String CLEVERTAP_PRODUCT_CONFIG_DID_INITIALIZE = "CleverTapProductConfigDidInitialize";
    private static final String CLEVERTAP_PRODUCT_CONFIG_DID_FETCH = "CleverTapProductConfigDidFetch";
    private static final String CLEVERTAP_PRODUCT_CONFIG_DID_ACTIVATE = "CleverTapProductConfigDidActivate";

    public static void setInitialUri(Uri uri) {
        mlaunchURI = uri;
    }

    public String getName() {
        return "CleverTapReact";
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put(CLEVERTAP_PROFILE_DID_INITIALIZE, CLEVERTAP_PROFILE_DID_INITIALIZE);
        constants.put(CLEVERTAP_PROFILE_SYNC, CLEVERTAP_PROFILE_SYNC);
        constants.put(CLEVERTAP_IN_APP_NOTIFICATION_DISMISSED, CLEVERTAP_IN_APP_NOTIFICATION_DISMISSED);
        constants.put(FCM, FCM);
        constants.put(XPS, XPS);
        constants.put(BPS, BPS);
        constants.put(HPS, HPS);
        constants.put(CLEVERTAP_INBOX_DID_INITIALIZE, CLEVERTAP_INBOX_DID_INITIALIZE);
        constants.put(CLEVERTAP_INBOX_MESSAGES_DID_UPDATE, CLEVERTAP_INBOX_MESSAGES_DID_UPDATE);
        constants.put(CLEVERTAP_ON_INBOX_BUTTON_CLICK, CLEVERTAP_ON_INBOX_BUTTON_CLICK);
        constants.put(CLEVERTAP_ON_DISPLAY_UNITS_LOADED, CLEVERTAP_ON_DISPLAY_UNITS_LOADED);
        constants.put(CLEVERTAP_ON_INAPP_BUTTON_CLICK, CLEVERTAP_ON_INAPP_BUTTON_CLICK);
        constants.put(CLEVERTAP_FEATURE_FLAGS_DID_UPDATE, CLEVERTAP_FEATURE_FLAGS_DID_UPDATE);
        constants.put(CLEVERTAP_PRODUCT_CONFIG_DID_INITIALIZE, CLEVERTAP_PRODUCT_CONFIG_DID_INITIALIZE);
        constants.put(CLEVERTAP_PRODUCT_CONFIG_DID_FETCH, CLEVERTAP_PRODUCT_CONFIG_DID_FETCH);
        constants.put(CLEVERTAP_PRODUCT_CONFIG_DID_ACTIVATE, CLEVERTAP_PRODUCT_CONFIG_DID_ACTIVATE);
        return constants;
    }

    public CleverTapModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.context = reactContext;
        this.getCleverTapAPI();
    }

    private CleverTapAPI getCleverTapAPI() {
        if (this.mCleverTap == null) {
            CleverTapAPI clevertap = CleverTapAPI.getDefaultInstance((Context)this.context);
            if (clevertap != null) {
                clevertap.setInAppNotificationListener((InAppNotificationListener)this);
                clevertap.setSyncListener((SyncListener)this);
                clevertap.setCTNotificationInboxListener((CTInboxListener)this);
                clevertap.setCTExperimentsListener((CTExperimentsListener)this);
                clevertap.setInboxMessageButtonListener((InboxMessageButtonListener)this);
                clevertap.setInAppNotificationButtonListener((InAppNotificationButtonListener)this);
                clevertap.setDisplayUnitListener((DisplayUnitListener)this);
                clevertap.setCTProductConfigListener((CTProductConfigListener)this);
                clevertap.setCTFeatureFlagsListener((CTFeatureFlagsListener)this);
                clevertap.setLibrary("React-Native");
            }
            this.mCleverTap = clevertap;
        }
        return this.mCleverTap;
    }

    @ReactMethod
    public void getInitialUrl(Callback callback) {
        String error = null;
        String url = null;
        if (mlaunchURI == null) {
            error = "CleverTap InitialUrl is null";
        } else {
            url = mlaunchURI.toString();
        }
        this.callbackWithErrorAndResult(callback, error, url);
    }

    @ReactMethod
    public void registerForPush() {
        Log.i((String)"CleverTapReact", (String)"CleverTap.registerForPush is a no-op in Android");
    }

    @ReactMethod
    public void setPushTokenAsString(String token, String type) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null || token == null || type == null) {
            return;
        }
        if (FCM.equals(type)) {
            clevertap.pushFcmRegistrationId(token, true);
        } else if (XPS.equals(type)) {
            clevertap.pushXiaomiRegistrationId(token, true);
        } else if (BPS.equals(type)) {
            clevertap.pushBaiduRegistrationId(token, true);
        } else if (HPS.equals(type)) {
            clevertap.pushHuaweiRegistrationId(token, true);
        } else {
            Log.e((String)"CleverTapReact", (String)("Unknown push token type " + type));
        }
    }

    @ReactMethod
    public void setUIEditorConnectionEnabled(boolean enabled) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        CleverTapAPI.setUIEditorConnectionEnabled((boolean)enabled);
        Log.i((String)"CleverTapReact", (String)("UI Editor connection enabled - " + enabled));
    }

    @ReactMethod
    public void createNotificationChannel(String channelId, String channelName, String channelDescription, int importance, boolean showBadge) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null || channelId == null || channelName == null || channelDescription == null) {
            return;
        }
        CleverTapAPI.createNotificationChannel((Context)this.context, (String)channelId, (CharSequence)channelName, (String)channelDescription, (int)importance, (boolean)showBadge);
        Log.i((String)"CleverTapReact", (String)("Notification Channel " + channelName + " created"));
    }

    @ReactMethod
    public void createNotificationChannelWithSound(String channelId, String channelName, String channelDescription, int importance, boolean showBadge, String sound) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null || channelId == null || channelName == null || channelDescription == null || sound == null) {
            return;
        }
        CleverTapAPI.createNotificationChannel((Context)this.context, (String)channelId, (CharSequence)channelName, (String)channelDescription, (int)importance, (boolean)showBadge, (String)sound);
        Log.i((String)"CleverTapReact", (String)("Notification Channel " + channelName + " with sound file " + sound + " created"));
    }

    @ReactMethod
    public void createNotificationChannelWithGroupId(String channelId, String channelName, String channelDescription, int importance, String groupId, boolean showBadge) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null || channelId == null || channelName == null || channelDescription == null || groupId == null) {
            return;
        }
        CleverTapAPI.createNotificationChannel((Context)this.context, (String)channelId, (CharSequence)channelName, (String)channelDescription, (int)importance, (String)groupId, (boolean)showBadge);
        Log.i((String)"CleverTapReact", (String)("Notification Channel " + channelName + " with Group Id " + groupId + " created"));
    }

    @ReactMethod
    public void createNotificationChannelWithGroupIdAndSound(String channelId, String channelName, String channelDescription, int importance, String groupId, boolean showBadge, String sound) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null || channelId == null || channelName == null || channelDescription == null || groupId == null || sound == null) {
            return;
        }
        CleverTapAPI.createNotificationChannel((Context)this.context, (String)channelId, (CharSequence)channelName, (String)channelDescription, (int)importance, (String)groupId, (boolean)showBadge, (String)sound);
        Log.i((String)"CleverTapReact", (String)("Notification Channel " + channelName + " with Group Id " + groupId + " and sound file " + sound + " created"));
    }

    @ReactMethod
    public void createNotificationChannelGroup(String groupId, String groupName) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null || groupId == null || groupName == null) {
            return;
        }
        CleverTapAPI.createNotificationChannelGroup((Context)this.context, (String)groupId, (CharSequence)groupName);
        Log.i((String)"CleverTapReact", (String)("Notification Channel Group " + groupName + " created"));
    }

    @ReactMethod
    public void deleteNotificationChannel(String channelId) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null || channelId == null) {
            return;
        }
        CleverTapAPI.deleteNotificationChannel((Context)this.context, (String)channelId);
        Log.i((String)"CleverTapReact", (String)("Notification Channel Id " + channelId + " deleted"));
    }

    @ReactMethod
    public void deleteNotificationChannelGroup(String groupId) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null || groupId == null) {
            return;
        }
        CleverTapAPI.deleteNotificationChannelGroup((Context)this.context, (String)groupId);
        Log.i((String)"CleverTapReact", (String)("Notification Channel Group Id " + groupId + " deleted"));
    }

    @ReactMethod
    public void createNotification(ReadableMap extras) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        JSONObject extrasJsonObject = null;
        try {
            extrasJsonObject = CleverTapModule.jsonObjectFromReadableMap(extras);
            Bundle bundle = new Bundle();
            Iterator entry = extrasJsonObject.keys();
            while (entry.hasNext()) {
                String key = (String)entry.next();
                String str = extrasJsonObject.optString(key);
                bundle.putString(key, str);
            }
            CleverTapAPI.createNotification((Context)this.context, (Bundle)bundle);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void setOptOut(boolean value) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        clevertap.setOptOut(value);
    }

    @ReactMethod
    public void setOffline(boolean value) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        clevertap.setOffline(value);
    }

    @ReactMethod
    public void enableDeviceNetworkInfoReporting(boolean value) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        clevertap.enableDeviceNetworkInfoReporting(value);
    }

    @ReactMethod
    public void enablePersonalization() {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        clevertap.enablePersonalization();
    }

    @ReactMethod
    public void disablePersonalization() {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        clevertap.disablePersonalization();
    }

    @ReactMethod
    public void recordScreenView(String screenName) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        clevertap.recordScreen(screenName);
    }

    @ReactMethod
    public void recordEvent(String eventName, ReadableMap props) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        HashMap<String, Object> finalProps = this.eventPropsFromReadableMap(props, Object.class);
        if (finalProps == null) {
            clevertap.pushEvent(eventName);
        } else {
            clevertap.pushEvent(eventName, finalProps);
        }
    }

    @ReactMethod
    public void recordChargedEvent(ReadableMap details, ReadableArray items) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null || details == null) {
            return;
        }
        HashMap<String, Object> finalDetails = this.eventPropsFromReadableMap(details, Object.class);
        ArrayList<HashMap<String, Object>> finalItems = new ArrayList<HashMap<String, Object>>();
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                try {
                    HashMap<String, Object> item = this.eventPropsFromReadableMap(items.getMap(i), Object.class);
                    finalItems.add(item);
                    continue;
                }
                catch (Throwable t) {
                    Log.e((String)"CleverTapReact", (String)t.getLocalizedMessage());
                }
            }
        }
        try {
            clevertap.pushChargedEvent(finalDetails, finalItems);
        }
        catch (Throwable t) {
            Log.e((String)"CleverTapReact", (String)t.getLocalizedMessage());
        }
    }

    @ReactMethod
    public void eventGetFirstTime(String eventName, Callback callback) {
        String error = null;
        int result = -1;
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap != null) {
            result = clevertap.getFirstTime(eventName);
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void eventGetLastTime(String eventName, Callback callback) {
        String error = null;
        int result = -1;
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap != null) {
            result = clevertap.getLastTime(eventName);
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void eventGetOccurrences(String eventName, Callback callback) {
        String error = null;
        int result = -1;
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap != null) {
            result = clevertap.getCount(eventName);
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void eventGetDetail(String eventName, Callback callback) {
        String error = null;
        WritableMap result = null;
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap != null) {
            EventDetail detail = clevertap.getDetails(eventName);
            result = CleverTapModule.eventDetailToWritableMap(detail);
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void getEventHistory(Callback callback) {
        String error = null;
        WritableMap result = null;
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap != null) {
            Map history = clevertap.getHistory();
            result = CleverTapModule.eventHistoryToWritableMap(history);
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void setLocation(double latitude, double longitude) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        Location location = new Location("CleverTapReact");
        location.setLatitude(latitude);
        location.setLongitude(longitude);
        clevertap.setLocation(location);
    }

    @ReactMethod
    public void profileGetCleverTapAttributionIdentifier(Callback callback) {
        String error = null;
        String result = null;
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap != null) {
            result = clevertap.getCleverTapAttributionIdentifier();
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void profileGetCleverTapID(Callback callback) {
        String error = null;
        String result = null;
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap != null) {
            result = clevertap.getCleverTapID();
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void onUserLogin(ReadableMap profile) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        HashMap<String, Object> finalProfile = this.profileFromReadableMap(profile);
        clevertap.onUserLogin(finalProfile);
    }

    @ReactMethod
    public void profileSet(ReadableMap profile) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        HashMap<String, Object> finalProfile = this.profileFromReadableMap(profile);
        clevertap.pushProfile(finalProfile);
    }

    @ReactMethod
    public void profileSetGraphUser(ReadableMap profile) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        try {
            JSONObject finalProfile = CleverTapModule.jsonObjectFromReadableMap(profile);
            clevertap.pushFacebookUser(finalProfile);
        }
        catch (Throwable t) {
            Log.e((String)"CleverTapReact", (String)t.getLocalizedMessage());
        }
    }

    @ReactMethod
    public void profileGetProperty(String propertyName, Callback callback) {
        String error = null;
        Object result = null;
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap != null) {
            Object value = clevertap.getProperty(propertyName);
            if (value instanceof JSONArray) {
                JSONArray valueArray = (JSONArray)value;
                WritableArray writableArray = Arguments.createArray();
                for (int i = 0; i < valueArray.length(); ++i) {
                    try {
                        writableArray.pushString(valueArray.get(i).toString());
                        continue;
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                result = writableArray;
            } else {
                result = value;
            }
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void profileRemoveValueForKey(String key) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        clevertap.removeValueForKey(key);
    }

    @ReactMethod
    public void profileSetMultiValues(ReadableArray values, String key) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        ArrayList<String> finalValues = CleverTapModule.arrayListStringFromReadableArray(values);
        clevertap.setMultiValuesForKey(key, finalValues);
    }

    @ReactMethod
    public void profileAddMultiValue(String value, String key) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        clevertap.addMultiValueForKey(key, value);
    }

    @ReactMethod
    public void profileAddMultiValues(ReadableArray values, String key) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        ArrayList<String> finalValues = CleverTapModule.arrayListStringFromReadableArray(values);
        clevertap.addMultiValuesForKey(key, finalValues);
    }

    @ReactMethod
    public void profileRemoveMultiValue(String value, String key) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        clevertap.removeMultiValueForKey(key, value);
    }

    @ReactMethod
    public void profileRemoveMultiValues(ReadableArray values, String key) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        ArrayList<String> finalValues = CleverTapModule.arrayListStringFromReadableArray(values);
        clevertap.removeMultiValuesForKey(key, finalValues);
    }

    @ReactMethod
    public void pushInstallReferrer(String source, String medium, String campaign) {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return;
        }
        clevertap.pushInstallReferrer(source, medium, campaign);
    }

    @ReactMethod
    public void sessionGetTimeElapsed(Callback callback) {
        String error = null;
        int result = -1;
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap != null) {
            result = clevertap.getTimeElapsed();
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void sessionGetTotalVisits(Callback callback) {
        String error = null;
        int result = -1;
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap != null) {
            result = clevertap.getTotalVisits();
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void sessionGetScreenCount(Callback callback) {
        String error = null;
        int result = -1;
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap != null) {
            result = clevertap.getScreenCount();
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void sessionGetPreviousVisitTime(Callback callback) {
        String error = null;
        int result = -1;
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap != null) {
            result = clevertap.getPreviousVisitTime();
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void sessionGetUTMDetails(Callback callback) {
        String error = null;
        WritableMap result = null;
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap != null) {
            UTMDetail details = clevertap.getUTMDetails();
            result = CleverTapModule.utmDetailsToWritableMap(details);
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void initializeInbox() {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.initializeInbox();
            Log.e((String)"CleverTapReact", (String)"initializeInbox Called");
        }
    }

    @ReactMethod
    public void showInbox(ReadableMap styleConfig) {
        CTInboxStyleConfig inboxStyleConfig = this.styleConfigFromReadableMap(styleConfig);
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.showAppInbox(inboxStyleConfig);
        }
    }

    @ReactMethod
    public void getInboxMessageCount(Callback callback) {
        String error = null;
        int result = -1;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getInboxMessageCount();
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void getInboxMessageUnreadCount(Callback callback) {
        String error = null;
        int result = -1;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getInboxMessageUnreadCount();
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void getAllInboxMessages(Callback callback) {
        this.getInboxMessages(callback, InBoxMessages.ALL);
    }

    @ReactMethod
    public void getUnreadInboxMessages(Callback callback) {
        this.getInboxMessages(callback, InBoxMessages.UNREAD);
    }

    @ReactMethod
    public void getInboxMessageForId(String messageId, Callback callback) {
        String error = null;
        String result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            CTInboxMessage inboxMessage = cleverTap.getInboxMessageForId(messageId);
            if (inboxMessage != null && inboxMessage.getData() != null) {
                result = inboxMessage.getData().toString();
            }
        } else {
            error = ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage();
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void deleteInboxMessageForId(String messageId) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.deleteInboxMessage(messageId);
        } else {
            Log.e((String)"CleverTapReact", (String)ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage());
        }
    }

    @ReactMethod
    public void markReadInboxMessageForId(String messageId) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.markReadInboxMessage(messageId);
        } else {
            Log.e((String)"CleverTapReact", (String)ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage());
        }
    }

    @ReactMethod
    public void pushInboxNotificationViewedEventForId(String messageId) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.pushInboxNotificationViewedEvent(messageId);
        } else {
            Log.e((String)"CleverTapReact", (String)ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage());
        }
    }

    @ReactMethod
    public void pushInboxNotificationClickedEventForId(String messageId) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.pushInboxNotificationClickedEvent(messageId);
        } else {
            Log.e((String)"CleverTapReact", (String)ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage());
        }
    }

    private void getInboxMessages(Callback callback, InBoxMessages type) {
        String error = null;
        ArrayList inboxMessages = new ArrayList();
        WritableArray result = Arguments.createArray();
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            if (type == InBoxMessages.ALL) {
                inboxMessages = cleverTap.getAllInboxMessages();
            } else if (type == InBoxMessages.UNREAD) {
                inboxMessages = cleverTap.getUnreadInboxMessages();
            }
            for (CTInboxMessage message : inboxMessages) {
                if (message == null || message.getData() == null) continue;
                result.pushString(message.getData().toString());
            }
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void getAllDisplayUnits(Callback callback) {
        String error = null;
        WritableArray result = Arguments.createArray();
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = this.getWritableArrayFromList(cleverTap.getAllDisplayUnits());
        } else {
            error = ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage();
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void getDisplayUnitForId(String unitID, Callback callback) {
        String error = null;
        String result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            CleverTapDisplayUnit displayUnit = cleverTap.getDisplayUnitForId(unitID);
            if (displayUnit != null && displayUnit.getJsonObject() != null) {
                result = displayUnit.getJsonObject().toString();
            }
        } else {
            error = ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage();
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void pushDisplayUnitViewedEventForID(String unitID) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.pushDisplayUnitViewedEventForID(unitID);
        } else {
            Log.e((String)"CleverTapReact", (String)ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage());
        }
    }

    @ReactMethod
    public void pushDisplayUnitClickedEventForID(String unitID) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.pushDisplayUnitClickedEventForID(unitID);
        } else {
            Log.e((String)"CleverTapReact", (String)ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage());
        }
    }

    @ReactMethod
    public void registerBooleanVariable(String name) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.registerBooleanVariable(name);
        } else {
            Log.e((String)"CleverTapReact", (String)"CleverTap not initialized");
        }
    }

    @ReactMethod
    public void registerDoubleVariable(String name) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.registerDoubleVariable(name);
        } else {
            Log.e((String)"CleverTapReact", (String)"CleverTap not initialized");
        }
    }

    @ReactMethod
    public void registerIntegerVariable(String name) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.registerIntegerVariable(name);
        } else {
            Log.e((String)"CleverTapReact", (String)"CleverTap not initialized");
        }
    }

    @ReactMethod
    public void registerStringVariable(String name) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.registerStringVariable(name);
        } else {
            Log.e((String)"CleverTapReact", (String)"CleverTap not initialized");
        }
    }

    @ReactMethod
    public void registerListOfBooleanVariable(String name) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.registerListOfBooleanVariable(name);
        } else {
            Log.e((String)"CleverTapReact", (String)"CleverTap not initialized");
        }
    }

    @ReactMethod
    public void registerListOfDoubleVariable(String name) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.registerListOfDoubleVariable(name);
        } else {
            Log.e((String)"CleverTapReact", (String)"CleverTap not initialized");
        }
    }

    @ReactMethod
    public void registerListOfIntegerVariable(String name) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.registerListOfIntegerVariable(name);
        } else {
            Log.e((String)"CleverTapReact", (String)"CleverTap not initialized");
        }
    }

    @ReactMethod
    public void registerListOfStringVariable(String name) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.registerListOfStringVariable(name);
        } else {
            Log.e((String)"CleverTapReact", (String)"CleverTap not initialized");
        }
    }

    @ReactMethod
    public void registerMapOfBooleanVariable(String name) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.registerMapOfBooleanVariable(name);
        } else {
            Log.e((String)"CleverTapReact", (String)"CleverTap not initialized");
        }
    }

    @ReactMethod
    public void registerMapOfDoubleVariable(String name) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.registerMapOfDoubleVariable(name);
        } else {
            Log.e((String)"CleverTapReact", (String)"CleverTap not initialized");
        }
    }

    @ReactMethod
    public void registerMapOfIntegerVariable(String name) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.registerMapOfIntegerVariable(name);
        } else {
            Log.e((String)"CleverTapReact", (String)"CleverTap not initialized");
        }
    }

    @ReactMethod
    public void registerMapOfStringVariable(String name) {
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            cleverTap.registerMapOfStringVariable(name);
        } else {
            Log.e((String)"CleverTapReact", (String)"CleverTap not initialized");
        }
    }

    @ReactMethod
    public void getBooleanVariable(String name, Boolean defaultValue, Callback callback) {
        String error = null;
        Boolean result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getBooleanVariable(name, defaultValue);
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void getDoubleVariable(String name, Double defaultValue, Callback callback) {
        String error = null;
        Double result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getDoubleVariable(name, defaultValue);
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void getIntegerVariable(String name, int defaultValue, Callback callback) {
        String error = null;
        int result = -1;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getIntegerVariable(name, Integer.valueOf(defaultValue));
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void getStringVariable(String name, String defaultValue, Callback callback) {
        String error = null;
        String result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getStringVariable(name, defaultValue);
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void getListOfBooleanVariable(String name, ReadableArray defaultValue, Callback callback) {
        String error = null;
        List result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getListOfBooleanVariable(name, CleverTapModule.arrayListFromReadableArray(defaultValue, Boolean.class));
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, CleverTapModule.writableArrayFromArrayList(result, Boolean.class));
    }

    @ReactMethod
    public void getListOfDoubleVariable(String name, ReadableArray defaultValue, Callback callback) {
        String error = null;
        List result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getListOfDoubleVariable(name, CleverTapModule.arrayListFromReadableArray(defaultValue, Double.class));
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, CleverTapModule.writableArrayFromArrayList(result, Double.class));
    }

    @ReactMethod
    public void getListOfIntegerVariable(String name, ReadableArray defaultValue, Callback callback) {
        String error = null;
        List result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getListOfIntegerVariable(name, CleverTapModule.arrayListFromReadableArray(defaultValue, Integer.class));
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, CleverTapModule.writableArrayFromArrayList(result, Integer.class));
    }

    @ReactMethod
    public void getListOfStringVariable(String name, ReadableArray defaultValue, Callback callback) {
        String error = null;
        List result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getListOfStringVariable(name, CleverTapModule.arrayListFromReadableArray(defaultValue, String.class));
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, CleverTapModule.writableArrayFromArrayList(result, String.class));
    }

    @ReactMethod
    public void getMapOfBooleanVariable(String name, ReadableMap defaultValue, Callback callback) {
        String error = null;
        Map result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getMapOfBooleanVariable(name, this.eventPropsFromReadableMap(defaultValue, Boolean.class));
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, this.writableMapFromMap(result, Boolean.class));
    }

    @ReactMethod
    public void getMapOfDoubleVariable(String name, ReadableMap defaultValue, Callback callback) {
        String error = null;
        Map result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getMapOfDoubleVariable(name, this.eventPropsFromReadableMap(defaultValue, Double.class));
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, this.writableMapFromMap(result, Double.class));
    }

    @ReactMethod
    public void getMapOfIntegerVariable(String name, ReadableMap defaultValue, Callback callback) {
        String error = null;
        Map result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getMapOfIntegerVariable(name, this.eventPropsFromReadableMap(defaultValue, Integer.class));
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, this.writableMapFromMap(result, Integer.class));
    }

    @ReactMethod
    public void getMapOfStringVariable(String name, ReadableMap defaultValue, Callback callback) {
        String error = null;
        Map result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            result = cleverTap.getMapOfStringVariable(name, this.eventPropsFromReadableMap(defaultValue, String.class));
        } else {
            error = "CleverTap not initialized";
        }
        this.callbackWithErrorAndResult(callback, error, this.writableMapFromMap(result, String.class));
    }

    @ReactMethod
    public void setDefaultsMap(ReadableMap map) {
        CTProductConfigController productConfigController = this.getCtProductConfigController();
        if (productConfigController == null) {
            return;
        }
        HashMap<String, Object> finalMap = this.eventPropsFromReadableMap(map, Object.class);
        productConfigController.setDefaults(finalMap);
    }

    @ReactMethod
    public void fetch() {
        CTProductConfigController productConfigController = this.getCtProductConfigController();
        if (productConfigController == null) {
            return;
        }
        productConfigController.fetch();
    }

    @ReactMethod
    public void fetchWithMinimumFetchIntervalInSeconds(int interval) {
        CTProductConfigController productConfigController = this.getCtProductConfigController();
        if (productConfigController == null) {
            return;
        }
        productConfigController.fetch((long)interval);
    }

    @ReactMethod
    public void activate() {
        CTProductConfigController productConfigController = this.getCtProductConfigController();
        if (productConfigController == null) {
            return;
        }
        productConfigController.activate();
    }

    @ReactMethod
    public void fetchAndActivate() {
        CTProductConfigController productConfigController = this.getCtProductConfigController();
        if (productConfigController == null) {
            return;
        }
        productConfigController.fetchAndActivate();
    }

    @ReactMethod
    public void setMinimumFetchIntervalInSeconds(int interval) {
        CTProductConfigController productConfigController = this.getCtProductConfigController();
        if (productConfigController == null) {
            return;
        }
        productConfigController.setMinimumFetchIntervalInSeconds((long)interval);
    }

    @ReactMethod
    public void reset() {
        CTProductConfigController productConfigController = this.getCtProductConfigController();
        if (productConfigController == null) {
            return;
        }
        productConfigController.reset();
    }

    @ReactMethod
    public void getString(String key, Callback callback) {
        String error = null;
        String result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            CTProductConfigController productConfigController = cleverTap.productConfig();
            if (productConfigController != null) {
                result = productConfigController.getString(key);
            } else {
                error = ErrorMessages.PRODUCTCONFIG_NOT_INITIALIZED.getErrorMessage();
            }
        } else {
            error = ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage();
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void getBoolean(String key, Callback callback) {
        String error = null;
        Boolean result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            CTProductConfigController productConfigController = cleverTap.productConfig();
            if (productConfigController != null) {
                result = productConfigController.getBoolean(key);
            } else {
                error = ErrorMessages.PRODUCTCONFIG_NOT_INITIALIZED.getErrorMessage();
            }
        } else {
            error = ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage();
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void getDouble(String key, Callback callback) {
        String error = null;
        Double result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            CTProductConfigController productConfigController = cleverTap.productConfig();
            if (productConfigController != null) {
                result = productConfigController.getDouble(key);
            } else {
                error = ErrorMessages.PRODUCTCONFIG_NOT_INITIALIZED.getErrorMessage();
            }
        } else {
            error = ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage();
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void getLastFetchTimeStampInMillis(Callback callback) {
        String error = null;
        String result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            CTProductConfigController productConfigController = cleverTap.productConfig();
            if (productConfigController != null) {
                result = String.valueOf(productConfigController.getLastFetchTimeStampInMillis());
            } else {
                error = ErrorMessages.PRODUCTCONFIG_NOT_INITIALIZED.getErrorMessage();
            }
        } else {
            error = ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage();
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    private CTProductConfigController getCtProductConfigController() {
        CleverTapAPI clevertap = this.getCleverTapAPI();
        if (clevertap == null) {
            return null;
        }
        return clevertap.productConfig();
    }

    @ReactMethod
    public void getFeatureFlag(String name, Boolean defaultValue, Callback callback) {
        String error = null;
        Boolean result = null;
        CleverTapAPI cleverTap = this.getCleverTapAPI();
        if (cleverTap != null) {
            CTFeatureFlagsController featureFlagsController = cleverTap.featureFlag();
            if (featureFlagsController != null) {
                result = featureFlagsController.get(name, defaultValue.booleanValue());
            } else {
                error = ErrorMessages.FF_NOT_INITIALIZED.getErrorMessage();
            }
        } else {
            error = ErrorMessages.CLEVERTAP_NOT_INITIALIZED.getErrorMessage();
        }
        this.callbackWithErrorAndResult(callback, error, result);
    }

    @ReactMethod
    public void setDebugLevel(int level) {
        CleverTapAPI.setDebugLevel((int)level);
    }

    private void callbackWithErrorAndResult(Callback callback, String error, Object result) {
        if (callback == null) {
            Log.i((String)"CleverTapReact", (String)"CleverTap callback is null");
            return;
        }
        try {
            callback.invoke(new Object[]{error, result});
        }
        catch (Throwable t) {
            Log.e((String)"CleverTapReact", (String)t.getLocalizedMessage());
        }
    }

    private void sendEvent(String eventName, @Nullable Object params) {
        try {
            ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.context.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, params);
        }
        catch (Throwable t) {
            Log.e((String)"CleverTapReact", (String)t.getLocalizedMessage());
        }
    }

    private static JSONObject jsonObjectFromReadableMap(ReadableMap readableMap) throws JSONException {
        JSONObject object = new JSONObject();
        ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
        while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            switch (readableMap.getType(key)) {
                case Null: {
                    object.put(key, JSONObject.NULL);
                    break;
                }
                case Boolean: {
                    object.put(key, readableMap.getBoolean(key));
                    break;
                }
                case Number: {
                    object.put(key, readableMap.getDouble(key));
                    break;
                }
                case String: {
                    object.put(key, (Object)readableMap.getString(key));
                    break;
                }
                case Map: {
                    object.put(key, (Object)CleverTapModule.jsonObjectFromReadableMap(readableMap.getMap(key)));
                    break;
                }
                case Array: {
                    object.put(key, (Object)CleverTapModule.jsonArrayFromReadableArray(readableMap.getArray(key)));
                }
            }
        }
        return object;
    }

    private static JSONArray jsonArrayFromReadableArray(ReadableArray readableArray) throws JSONException {
        JSONArray array = new JSONArray();
        block8: for (int i = 0; i < readableArray.size(); ++i) {
            switch (readableArray.getType(i)) {
                case Null: {
                    continue block8;
                }
                case Boolean: {
                    array.put(readableArray.getBoolean(i));
                    continue block8;
                }
                case Number: {
                    array.put(readableArray.getDouble(i));
                    continue block8;
                }
                case String: {
                    array.put((Object)readableArray.getString(i));
                    continue block8;
                }
                case Map: {
                    array.put((Object)CleverTapModule.jsonObjectFromReadableMap(readableArray.getMap(i)));
                    continue block8;
                }
                case Array: {
                    array.put((Object)CleverTapModule.jsonArrayFromReadableArray(readableArray.getArray(i)));
                }
            }
        }
        return array;
    }

    private static ArrayList<String> arrayListStringFromReadableArray(ReadableArray readableArray) {
        ArrayList<String> array = new ArrayList<String>();
        block6: for (int i = 0; i < readableArray.size(); ++i) {
            switch (readableArray.getType(i)) {
                case Null: {
                    continue block6;
                }
                case Boolean: {
                    array.add(String.valueOf(readableArray.getBoolean(i)));
                    continue block6;
                }
                case Number: {
                    array.add(String.valueOf(readableArray.getDouble(i)));
                    continue block6;
                }
                case String: {
                    array.add(readableArray.getString(i));
                }
            }
        }
        return array;
    }

    private static <T> ArrayList<T> arrayListFromReadableArray(ReadableArray readableArray, Class<T> tClass) {
        ArrayList<T> array = new ArrayList<T>();
        block10: for (int i = 0; i < readableArray.size(); ++i) {
            switch (readableArray.getType(i)) {
                case Null: {
                    continue block10;
                }
                case Boolean: {
                    array.add(tClass.cast(readableArray.getBoolean(i)));
                    continue block10;
                }
                case Number: {
                    try {
                        array.add(tClass.cast(readableArray.getDouble(i)));
                    }
                    catch (Throwable t) {
                        try {
                            array.add(tClass.cast(readableArray.getInt(i)));
                        }
                        catch (Throwable t1) {
                            Log.e((String)"CleverTapReact", (String)"Unhandled ReadableType.Number from ReadableArray");
                        }
                    }
                    continue block10;
                }
                case String: {
                    array.add(tClass.cast(readableArray.getString(i)));
                }
            }
        }
        return array;
    }

    private static <T> WritableArray writableArrayFromArrayList(List<T> list, Class<T> tClass) {
        WritableArray writableArray = Arguments.createArray();
        if (list != null) {
            for (T item : list) {
                switch (tClass.getSimpleName()) {
                    case "Boolean": {
                        writableArray.pushBoolean(((Boolean)item).booleanValue());
                        break;
                    }
                    case "Double": {
                        writableArray.pushDouble(((Double)item).doubleValue());
                        break;
                    }
                    case "Integer": {
                        writableArray.pushInt(((Integer)item).intValue());
                        break;
                    }
                    case "String": {
                        writableArray.pushString((String)item);
                    }
                }
            }
        }
        return writableArray;
    }

    private <T> HashMap<String, T> eventPropsFromReadableMap(ReadableMap propsMap, Class<T> tClass) {
        if (propsMap == null) {
            return null;
        }
        HashMap<String, T> props = new HashMap<String, T>();
        ReadableMapKeySetIterator iterator = propsMap.keySetIterator();
        while (iterator.hasNextKey()) {
            try {
                String key = iterator.nextKey();
                ReadableType readableType = propsMap.getType(key);
                if (readableType == ReadableType.String) {
                    props.put(key, tClass.cast(propsMap.getString(key)));
                    continue;
                }
                if (readableType == ReadableType.Boolean) {
                    props.put(key, tClass.cast(propsMap.getBoolean(key)));
                    continue;
                }
                if (readableType == ReadableType.Number) {
                    try {
                        props.put(key, tClass.cast(propsMap.getDouble(key)));
                    }
                    catch (Throwable t) {
                        try {
                            props.put(key, tClass.cast(propsMap.getInt(key)));
                        }
                        catch (Throwable t1) {
                            Log.e((String)"CleverTapReact", (String)"Unhandled ReadableType.Number from ReadableMap");
                        }
                    }
                    continue;
                }
                Log.e((String)"CleverTapReact", (String)"Unhandled event property ReadableType");
            }
            catch (Throwable t) {
                Log.e((String)"CleverTapReact", (String)t.getLocalizedMessage());
            }
        }
        return props;
    }

    private HashMap<String, Object> profileFromReadableMap(ReadableMap profileMap) {
        if (profileMap == null) {
            return null;
        }
        HashMap<String, Object> profile = new HashMap<String, Object>();
        ReadableMapKeySetIterator iterator = profileMap.keySetIterator();
        while (iterator.hasNextKey()) {
            try {
                String key = iterator.nextKey();
                ReadableType readableType = profileMap.getType(key);
                if ("DOB".equals(key) && readableType == ReadableType.String) {
                    String dob = profileMap.getString(key);
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                    try {
                        Date date = format.parse(dob);
                        profile.put(key, date);
                    }
                    catch (Throwable t) {
                        Log.e((String)"CleverTapReact", (String)t.getLocalizedMessage());
                    }
                    continue;
                }
                if (readableType == ReadableType.String) {
                    profile.put(key, profileMap.getString(key));
                    continue;
                }
                if (readableType == ReadableType.Boolean) {
                    profile.put(key, profileMap.getBoolean(key));
                    continue;
                }
                if (readableType == ReadableType.Number) {
                    try {
                        profile.put(key, profileMap.getDouble(key));
                    }
                    catch (Throwable t) {
                        try {
                            profile.put(key, profileMap.getInt(key));
                        }
                        catch (Throwable t1) {
                            Log.e((String)"CleverTapReact", (String)"Unhandled ReadableType.Number from ReadableMap");
                        }
                    }
                    continue;
                }
                if (readableType == ReadableType.Array) {
                    try {
                        profile.put(key, CleverTapModule.arrayListStringFromReadableArray(profileMap.getArray(key)));
                    }
                    catch (Throwable t) {
                        Log.e((String)"CleverTapReact", (String)"Unhandled ReadableType.Array from ReadableMap");
                    }
                    continue;
                }
                Log.e((String)"CleverTapReact", (String)"Unhandled profile property ReadableType");
            }
            catch (Throwable t) {
                Log.e((String)"CleverTapReact", (String)t.getLocalizedMessage());
            }
        }
        return profile;
    }

    private static WritableMap eventDetailToWritableMap(EventDetail details) {
        WritableMap ret = Arguments.createMap();
        if (details != null) {
            ret.putString("name", details.getName());
            ret.putInt("firstTime", details.getFirstTime());
            ret.putInt("lastTime", details.getLastTime());
            ret.putInt("count", details.getCount());
        }
        return ret;
    }

    private static WritableMap utmDetailsToWritableMap(UTMDetail details) {
        WritableMap ret = Arguments.createMap();
        if (details != null) {
            ret.putString("campaign", details.getCampaign());
            ret.putString("source", details.getSource());
            ret.putString("medium", details.getMedium());
        }
        return ret;
    }

    private static WritableMap eventHistoryToWritableMap(Map<String, EventDetail> history) {
        WritableMap ret = Arguments.createMap();
        if (history != null) {
            for (String key : history.keySet()) {
                ret.putMap(key, CleverTapModule.eventDetailToWritableMap(history.get(key)));
            }
        }
        return ret;
    }

    private CTInboxStyleConfig styleConfigFromReadableMap(ReadableMap styleConfig) {
        if (styleConfig == null) {
            return new CTInboxStyleConfig();
        }
        CTInboxStyleConfig ctInboxStyleConfig = new CTInboxStyleConfig();
        ReadableMapKeySetIterator iterator = styleConfig.keySetIterator();
        while (iterator.hasNextKey()) {
            try {
                String styleConfigKey = iterator.nextKey();
                ReadableType readableType = styleConfig.getType(styleConfigKey);
                if ("navBarTitle".equals(styleConfigKey) && readableType == ReadableType.String) {
                    String navBarTitle = styleConfig.getString(styleConfigKey);
                    ctInboxStyleConfig.setNavBarTitle(navBarTitle);
                }
                if ("navBarTitleColor".equals(styleConfigKey) && readableType == ReadableType.String) {
                    String navBarTitleColor = styleConfig.getString(styleConfigKey);
                    ctInboxStyleConfig.setNavBarTitleColor(navBarTitleColor);
                }
                if ("navBarColor".equals(styleConfigKey) && readableType == ReadableType.String) {
                    String navBarColor = styleConfig.getString(styleConfigKey);
                    ctInboxStyleConfig.setNavBarColor(navBarColor);
                }
                if ("inboxBackgroundColor".equals(styleConfigKey) && readableType == ReadableType.String) {
                    String inboxBackgroundColor = styleConfig.getString(styleConfigKey);
                    ctInboxStyleConfig.setInboxBackgroundColor(inboxBackgroundColor);
                }
                if ("backButtonColor".equals(styleConfigKey) && readableType == ReadableType.String) {
                    String backButtonColor = styleConfig.getString(styleConfigKey);
                    ctInboxStyleConfig.setBackButtonColor(backButtonColor);
                }
                if ("unselectedTabColor".equals(styleConfigKey) && readableType == ReadableType.String) {
                    String unselectedTabColor = styleConfig.getString(styleConfigKey);
                    ctInboxStyleConfig.setUnselectedTabColor(unselectedTabColor);
                }
                if ("selectedTabColor".equals(styleConfigKey) && readableType == ReadableType.String) {
                    String selectedTabColor = styleConfig.getString(styleConfigKey);
                    ctInboxStyleConfig.setSelectedTabColor(selectedTabColor);
                }
                if ("selectedTabIndicatorColor".equals(styleConfigKey) && readableType == ReadableType.String) {
                    String selectedTabIndicatorColor = styleConfig.getString(styleConfigKey);
                    ctInboxStyleConfig.setSelectedTabIndicatorColor(selectedTabIndicatorColor);
                }
                if ("tabBackgroundColor".equals(styleConfigKey) && readableType == ReadableType.String) {
                    String tabBackgroundColor = styleConfig.getString(styleConfigKey);
                    ctInboxStyleConfig.setTabBackgroundColor(tabBackgroundColor);
                }
                if (!"tabs".equals(styleConfigKey) || readableType != ReadableType.Array) continue;
                try {
                    ArrayList<String> tabsList = CleverTapModule.arrayListStringFromReadableArray(styleConfig.getArray(styleConfigKey));
                    ctInboxStyleConfig.setTabs(tabsList);
                }
                catch (Throwable t) {
                    Log.e((String)"CleverTapReact", (String)"Unhandled ReadableType.Array from ReadableMap");
                }
            }
            catch (Throwable t) {
                Log.e((String)"CleverTapReact", (String)t.getLocalizedMessage());
                return new CTInboxStyleConfig();
            }
        }
        return ctInboxStyleConfig;
    }

    public boolean beforeShow(Map<String, Object> var1) {
        return true;
    }

    public void onDismissed(Map<String, Object> var1, @Nullable Map<String, Object> var2) {
        WritableMap extrasParams = this.getWritableMapFromMap(var1);
        WritableMap actionExtrasParams = this.getWritableMapFromMap(var2);
        WritableMap params = Arguments.createMap();
        params.putMap("extras", extrasParams);
        params.putMap("actionExtras", actionExtrasParams);
        this.sendEvent(CLEVERTAP_IN_APP_NOTIFICATION_DISMISSED, params);
    }

    private WritableMap getWritableMapFromMap(Map<String, ? extends Object> var1) {
        JSONObject extras = var1 != null ? new JSONObject(var1) : new JSONObject();
        WritableMap extrasParams = Arguments.createMap();
        Iterator extrasKeys = extras.keys();
        while (extrasKeys.hasNext()) {
            String key = null;
            String value = null;
            try {
                key = extrasKeys.next().toString();
                value = extras.get(key).toString();
            }
            catch (Throwable t) {
                Log.e((String)"CleverTapReact", (String)t.getLocalizedMessage());
            }
            if (key == null || value == null) continue;
            extrasParams.putString(key, value);
        }
        return extrasParams;
    }

    private <T> WritableMap writableMapFromMap(Map<String, T> var1, Class<T> tClass) {
        JSONObject extras = var1 != null ? new JSONObject(var1) : new JSONObject();
        WritableMap extrasParams = Arguments.createMap();
        Iterator extrasKeys = extras.keys();
        while (extrasKeys.hasNext()) {
            try {
                String key = extrasKeys.next().toString();
                switch (tClass.getSimpleName()) {
                    case "Boolean": {
                        extrasParams.putBoolean(key, extras.getBoolean(key));
                        break;
                    }
                    case "Double": {
                        extrasParams.putDouble(key, extras.getDouble(key));
                        break;
                    }
                    case "Integer": {
                        extrasParams.putInt(key, extras.getInt(key));
                        break;
                    }
                    case "String": {
                        extrasParams.putString(key, extras.getString(key));
                    }
                }
            }
            catch (Throwable t) {
                Log.e((String)"CleverTapReact", (String)t.getLocalizedMessage());
            }
        }
        return extrasParams;
    }

    private WritableArray getWritableArrayFromList(List<CleverTapDisplayUnit> list) {
        WritableArray writableArray = Arguments.createArray();
        if (list != null) {
            for (CleverTapDisplayUnit item : list) {
                if (item == null || item.getJsonObject() == null) continue;
                writableArray.pushString(item.getJsonObject().toString());
            }
        }
        return writableArray;
    }

    public void profileDataUpdated(JSONObject updates) {
        if (updates == null) {
            return;
        }
        WritableMap updateParams = Arguments.createMap();
        Iterator keys = updates.keys();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            try {
                JSONArray arr = updates.getJSONArray(key);
                WritableArray writableArray = Arguments.createArray();
                for (int n = 0; n < arr.length(); ++n) {
                    JSONObject object = arr.getJSONObject(n);
                    writableArray.pushString(object.toString());
                }
                updateParams.putArray(key, writableArray);
            }
            catch (Throwable t) {
                try {
                    Object value = updates.get(key);
                    updateParams.putString(key, value.toString());
                }
                catch (Throwable t1) {
                    Log.e((String)"CleverTapReact", (String)t1.getLocalizedMessage());
                }
            }
        }
        WritableMap params = Arguments.createMap();
        params.putMap("updates", updateParams);
        this.sendEvent(CLEVERTAP_PROFILE_SYNC, params);
    }

    public void profileDidInitialize(String CleverTapID) {
        if (CleverTapID == null) {
            return;
        }
        WritableMap params = Arguments.createMap();
        params.putString("CleverTapID", CleverTapID);
        this.sendEvent(CLEVERTAP_PROFILE_DID_INITIALIZE, params);
    }

    public void inboxDidInitialize() {
        WritableMap params = Arguments.createMap();
        this.sendEvent(CLEVERTAP_INBOX_DID_INITIALIZE, params);
    }

    public void inboxMessagesDidUpdate() {
        WritableMap params = Arguments.createMap();
        this.sendEvent(CLEVERTAP_INBOX_MESSAGES_DID_UPDATE, params);
    }

    public void onInboxButtonClick(HashMap<String, String> payload) {
        this.sendEvent(CLEVERTAP_ON_INBOX_BUTTON_CLICK, this.getWritableMapFromMap(payload));
    }

    public void onInAppButtonClick(HashMap<String, String> hashMap) {
        this.sendEvent(CLEVERTAP_ON_INAPP_BUTTON_CLICK, this.getWritableMapFromMap(hashMap));
    }

    public void onDisplayUnitsLoaded(ArrayList<CleverTapDisplayUnit> units) {
        WritableMap params = Arguments.createMap();
        params.putArray("displayUnits", this.getWritableArrayFromList(units));
        this.sendEvent(CLEVERTAP_ON_DISPLAY_UNITS_LOADED, params);
    }

    public void CTExperimentsUpdated() {
        WritableMap params = Arguments.createMap();
        this.sendEvent(CLEVERTAP_EXPERIMENTS_DID_UPDATE, params);
    }

    public void featureFlagsUpdated() {
        WritableMap params = Arguments.createMap();
        this.sendEvent(CLEVERTAP_FEATURE_FLAGS_DID_UPDATE, params);
    }

    public void onInit() {
        WritableMap params = Arguments.createMap();
        this.sendEvent(CLEVERTAP_PRODUCT_CONFIG_DID_INITIALIZE, params);
    }

    public void onFetched() {
        WritableMap params = Arguments.createMap();
        this.sendEvent(CLEVERTAP_PRODUCT_CONFIG_DID_FETCH, params);
    }

    public void onActivated() {
        WritableMap params = Arguments.createMap();
        this.sendEvent(CLEVERTAP_PRODUCT_CONFIG_DID_ACTIVATE, params);
    }

    private static enum ErrorMessages {
        CLEVERTAP_NOT_INITIALIZED("CleverTap not initialized"),
        PRODUCTCONFIG_NOT_INITIALIZED("Product Config not initialized"),
        FF_NOT_INITIALIZED("Feature Flags not initialized");

        private final String errorMessage;

        private ErrorMessages(String s) {
            this.errorMessage = s;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    private static enum InBoxMessages {
        ALL(0),
        UNREAD(1);

        private final int value;

        private InBoxMessages(int newValue) {
            this.value = newValue;
        }
    }
}

