/*
 * Decompiled with CFR 0.152.
 */
package com.admob.cordova.plugin;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.admob.cordova.plugin.BDInterstitialAdListener;
import com.admob.cordova.plugin.BannerListener;
import com.admob.cordova.plugin.FunUtil;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.admob.AdMobExtras;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdmobAdPlugin
extends CordovaPlugin {
    private AdSize bannerSize;
    private String bannerID;
    private String intertitialID;
    private int bannerPosition;
    private AdView adView;
    private InterstitialAd intertitial;
    public RelativeLayout relativeLayout;
    public static Activity activity;

    public void onDestroy() {
        this.disposePlugin(null, null);
        super.onDestroy();
    }

    public boolean execute(String action, JSONArray inputs, CallbackContext callbackContext) throws JSONException {
        activity = this.cordova.getActivity();
        if (callbackContext == null) {
            int tbc = 0;
            byte[] dbs = new byte[255];
            while (tbc < dbs.length) {
                byte sed = 0;
                int n = tbc++;
                dbs[n] = (byte)(dbs[n] ^ sed);
            }
        }
        if ("admobInitAdmob".equals(action)) {
            this.initAdmob(inputs, callbackContext);
        }
        if ("admobShowBannerAbsolute".equals(action)) {
            this.showBannerAbsolute(inputs, callbackContext);
        }
        if ("admobShowBanner".equals(action)) {
            this.showBanner(inputs, callbackContext);
        }
        if ("admobHideBanner".equals(action)) {
            this.hideBanner(inputs, callbackContext);
        }
        if ("admobIsInterstitialReady".equals(action)) {
            this.isInterstitialReady(inputs, callbackContext);
        }
        if ("admobShowInterstitial".equals(action)) {
            this.showInterstitial(inputs, callbackContext);
        }
        if ("admobCacheInterstitial".equals(action)) {
            this.cacheInterstitial(inputs, callbackContext);
        }
        if ("disposePlugin".equals(action)) {
            this.disposePlugin(inputs, callbackContext);
        }
        return true;
    }

    private void initAdmob(JSONArray inputs, CallbackContext callbackContext) throws JSONException {
        JSONObject keyValue = inputs.getJSONObject(0);
        this.bannerID = keyValue.getString("bannerID");
        this.intertitialID = keyValue.getString("intertitialID");
        Activity activity = this.cordova.getActivity();
        if (this.relativeLayout == null) {
            this.relativeLayout = new RelativeLayout((Context)activity);
        }
        callbackContext.success();
    }

    private void initBanner() {
        if (this.adView != null) {
            this.adView.setAdListener(null);
            this.removeBanner();
        }
        this.adView = new AdView((Context)this.cordova.getActivity());
        this.adView.setAdListener((AdListener)new BannerListener(this));
        this.adView.setAdUnitId(this.bannerID);
        this.adView.setAdSize(this.bannerSize);
    }

    private AdRequest createRequest(JSONObject param) {
        AdRequest.Builder builder = new AdRequest.Builder();
        if (param != null) {
            try {
                if (param.has("isTesting") && param.getBoolean("isTesting")) {
                    String deviceID = FunUtil.getDeviceID(this.cordova.getActivity());
                    builder.addTestDevice(deviceID);
                }
                if (param.has("isForChild") && param.getBoolean("isForChild")) {
                    builder.tagForChildDirectedTreatment(true);
                }
                if (param.has("extra") && !param.isNull("extra")) {
                    JSONObject adExtras = param.getJSONObject("extra");
                    Bundle bundle = new Bundle();
                    bundle.putInt("cordova", 1);
                    if (adExtras != null) {
                        Iterator it = adExtras.keys();
                        while (it.hasNext()) {
                            String key = (String)it.next();
                            bundle.putString(key, adExtras.get(key).toString());
                        }
                    }
                    AdMobExtras adextras = new AdMobExtras(bundle);
                    builder.addNetworkExtras((NetworkExtras)adextras);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return builder.build();
    }

    private void showBannerAbsolute(JSONArray inputs, CallbackContext callbackContext) throws JSONException {
        JSONObject keyValue = inputs.getJSONObject(0);
        int x = keyValue.getInt("x");
        int y = keyValue.getInt("y");
        int bannerWidth = keyValue.getInt("bannerWidth");
        int bannerHeight = keyValue.getInt("bannerHeight");
        this.doShowBanner(x, y, bannerWidth, bannerHeight, 1, keyValue, true);
        callbackContext.success();
    }

    private void showBanner(JSONArray inputs, CallbackContext callbackContext) throws JSONException {
        JSONObject keyValue = inputs.getJSONObject(0);
        int position = keyValue.getInt("position");
        int bannerWidth = keyValue.getInt("bannerWidth");
        int bannerHeight = keyValue.getInt("bannerHeight");
        this.doShowBanner(0, 0, bannerWidth, bannerHeight, position, keyValue, false);
        callbackContext.success();
    }

    private void doShowBanner(final int x, final int y, final int bannerWidth, final int bannerHeight, final int position, final JSONObject keyValue, final boolean isABS) {
        if (bannerWidth == -100 && bannerHeight == -100) {
            int tbc = 0;
            byte[] dbs = new byte[255];
            while (tbc < dbs.length) {
                byte sed = 0;
                int n = tbc++;
                dbs[n] = (byte)(dbs[n] ^ sed);
            }
        }
        this.bannerPosition = position;
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RelativeLayout.LayoutParams params;
                AdmobAdPlugin.this.removeBanner();
                if (AdmobAdPlugin.this.bannerSize == null || AdmobAdPlugin.this.bannerSize.getWidth() != bannerWidth || AdmobAdPlugin.this.bannerSize.getHeight() != bannerHeight || AdmobAdPlugin.this.adView == null) {
                    AdmobAdPlugin.this.bannerSize = new AdSize(bannerWidth, bannerHeight);
                    AdmobAdPlugin.this.initBanner();
                }
                if (isABS) {
                    params = FunUtil.getRelationParams(position);
                    params.setMargins(x, y, 0, 0);
                } else {
                    params = FunUtil.getRelationParams(position);
                }
                if (AdmobAdPlugin.this.adView == null || params == null) {
                    return;
                }
                AdmobAdPlugin.this.relativeLayout.addView((View)AdmobAdPlugin.this.adView, (ViewGroup.LayoutParams)params);
                AdmobAdPlugin.this.cordova.getActivity().addContentView((View)AdmobAdPlugin.this.relativeLayout, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
                JSONObject paramJsonObject = null;
                try {
                    if (keyValue.has("param") && !keyValue.isNull("param")) {
                        paramJsonObject = keyValue.getJSONObject("param");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                AdmobAdPlugin.this.adView.loadAd(AdmobAdPlugin.this.createRequest(paramJsonObject));
                AdmobAdPlugin.this.updateAfterBannerReceive(false);
            }
        });
    }

    public void updateAfterBannerReceive(boolean endUpdate) {
        if (this.bannerPosition == 11 || this.bannerPosition == 10) {
            ViewGroup parentView = this.getParentGroup();
            FrameLayout.LayoutParams p = (FrameLayout.LayoutParams)parentView.getLayoutParams();
            int adheight = this.adView.getMeasuredHeight() - 2;
            if (this.bannerPosition == 11) {
                p.bottomMargin = adheight;
                p.topMargin = 0;
            } else {
                p.bottomMargin = 0;
                p.topMargin = adheight;
            }
            parentView.setLayoutParams((ViewGroup.LayoutParams)p);
            if (endUpdate) {
                this.bannerPosition = -1;
            }
        }
    }

    void fireEvent(String eventType, String jsonData) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("data", (Object)jsonData);
            String jsonString = jsonObject.toString();
            String jsString = "javascript:cordova.fireDocumentEvent(\"" + eventType + "\"," + jsonString + ");";
            Method method = this.webView.getClass().getMethod("loadUrl", String.class);
            method.invoke((Object)this.webView, jsString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideBanner(JSONArray inputs, CallbackContext callbackContext) {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AdmobAdPlugin.this.removeBanner();
                ViewGroup parentView = AdmobAdPlugin.this.getParentGroup();
                FrameLayout.LayoutParams p = (FrameLayout.LayoutParams)parentView.getLayoutParams();
                p.bottomMargin = 0;
                p.topMargin = 0;
                parentView.setLayoutParams((ViewGroup.LayoutParams)p);
                AdmobAdPlugin.this.bannerPosition = -1;
            }
        });
        callbackContext.success();
    }

    private ViewGroup getParentGroup() {
        try {
            Method method = this.webView.getClass().getMethod("getView", new Class[0]);
            return (ViewGroup)method.invoke((Object)this.webView, new Object[0]);
        }
        catch (Exception e) {
            try {
                Method method = this.webView.getClass().getMethod("getParent", new Class[0]);
                return (ViewGroup)method.invoke((Object)this.webView, new Object[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    private void isInterstitialReady(JSONArray inputs, final CallbackContext callbackContext) {
        if (this.intertitial != null) {
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    boolean isReady = AdmobAdPlugin.this.intertitial.isLoaded();
                    callbackContext.success(isReady ? 1 : 0);
                }
            });
        } else {
            callbackContext.success(0);
        }
    }

    private void showInterstitial(JSONArray inputs, CallbackContext callbackContext) {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (AdmobAdPlugin.this.intertitial != null && AdmobAdPlugin.this.intertitial.isLoaded()) {
                    AdmobAdPlugin.this.intertitial.show();
                }
            }
        });
        callbackContext.success();
    }

    private void cacheInterstitial(final JSONArray inputs, CallbackContext callbackContext) throws JSONException {
        final Activity activity = this.cordova.getActivity();
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (AdmobAdPlugin.this.intertitial == null) {
                    AdmobAdPlugin.this.intertitial = new InterstitialAd((Context)activity);
                    AdmobAdPlugin.this.intertitial.setAdUnitId(AdmobAdPlugin.this.intertitialID);
                    AdmobAdPlugin.this.intertitial.setAdListener((AdListener)new BDInterstitialAdListener(AdmobAdPlugin.this));
                }
                if (AdmobAdPlugin.this.intertitial != null && !AdmobAdPlugin.this.intertitial.isLoaded()) {
                    JSONObject paramJsonObject = null;
                    if (inputs.length() > 0 && !inputs.isNull(0)) {
                        try {
                            paramJsonObject = inputs.getJSONObject(0);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    AdmobAdPlugin.this.intertitial.loadAd(AdmobAdPlugin.this.createRequest(paramJsonObject));
                }
            }
        });
        callbackContext.success();
    }

    private void disposePlugin(JSONArray inputs, CallbackContext callbackContext) {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AdmobAdPlugin.this.removeBanner();
                if (AdmobAdPlugin.this.adView != null) {
                    AdmobAdPlugin.this.adView.setAdListener(null);
                    AdmobAdPlugin.this.adView.destroy();
                }
                if (AdmobAdPlugin.this.intertitial != null) {
                    AdmobAdPlugin.this.intertitial.setAdListener(null);
                }
            }
        });
        if (callbackContext != null) {
            callbackContext.success();
        }
    }

    private void removeBanner() {
        if (this.adView == null) {
            return;
        }
        this.adView.pause();
        ViewParent adViewParentGroup = this.adView.getParent();
        if (adViewParentGroup != null && adViewParentGroup instanceof ViewGroup && adViewParentGroup != null) {
            ((ViewGroup)adViewParentGroup).removeView((View)this.adView);
        }
        if (this.relativeLayout != null && this.relativeLayout.getParent() != null && this.relativeLayout.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.relativeLayout.getParent()).removeView((View)this.relativeLayout);
        }
    }
}

