/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.internal.zzgr;
import java.util.Date;
import java.util.Set;

@zzgr
public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationInterstitialAdapter,
MediationNativeAdapter {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    protected AdView zzaK;
    protected InterstitialAd zzaL;
    private AdLoader zzaM;

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string2;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string2 = (String)location.next();
                builder.addKeyword(string2);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            builder.addTestDevice(zzl.zzcF().zzQ(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        string2 = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string2);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzaK != null) {
            this.zzaK.destroy();
            this.zzaK = null;
        }
        if (this.zzaL != null) {
            this.zzaL = null;
        }
        if (this.zzaM != null) {
            this.zzaM = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzaK != null) {
            this.zzaK.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzaK != null) {
            this.zzaK.resume();
        }
    }

    public String getAdUnitId(Bundle serverParameters) {
        return serverParameters.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener bannerListener, Bundle serverParameters, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle extras) {
        this.zzaK = new AdView(context);
        this.zzaK.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzaK.setAdUnitId(this.getAdUnitId(serverParameters));
        this.zzaK.setAdListener(new zzc(this, bannerListener));
        this.zzaK.loadAd(this.zza(context, mediationAdRequest, extras, serverParameters));
    }

    @Override
    public View getBannerView() {
        return this.zzaK;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener interstitialListener, Bundle serverParameters, MediationAdRequest mediationAdRequest, Bundle extras) {
        this.zzaL = new InterstitialAd(context);
        this.zzaL.setAdUnitId(this.getAdUnitId(serverParameters));
        this.zzaL.setAdListener(new zzd(this, interstitialListener));
        this.zzaL.loadAd(this.zza(context, mediationAdRequest, extras, serverParameters));
    }

    @Override
    public void showInterstitial() {
        this.zzaL.show();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener listener, Bundle serverParameters, NativeMediationAdRequest mediationAdRequest, Bundle extras) {
        zze zze2 = new zze(this, listener);
        AdLoader.Builder builder = this.zza(context, serverParameters.getString(AD_UNIT_ID_PARAMETER)).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = mediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (mediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (mediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        this.zzaM = builder.build();
        this.zzaM.loadAd(this.zza(context, mediationAdRequest, extras, serverParameters));
    }

    AdLoader.Builder zza(Context context, String string2) {
        return new AdLoader.Builder(context, string2);
    }

    static class zzb
    extends NativeContentAdMapper {
        private final NativeContentAd zzaO;

        public zzb(NativeContentAd nativeContentAd) {
            this.zzaO = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            this.setLogo(nativeContentAd.getLogo());
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzaO);
            }
        }
    }

    static class zza
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzaN;

        public zza(NativeAppInstallAd nativeAppInstallAd) {
            this.zzaN = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            this.setStarRating(nativeAppInstallAd.getStarRating());
            this.setStore(nativeAppInstallAd.getStore().toString());
            this.setPrice(nativeAppInstallAd.getPrice().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
        }

        @Override
        public void trackView(View view) {
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzaN);
            }
        }
    }

    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzaP;
        final MediationNativeListener zzaS;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzaP = abstractAdViewAdapter;
            this.zzaS = mediationNativeListener;
        }

        @Override
        public void onAdLoaded() {
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            this.zzaS.onAdFailedToLoad(this.zzaP, errorCode);
        }

        @Override
        public void onAdOpened() {
            this.zzaS.onAdOpened(this.zzaP);
        }

        @Override
        public void onAdClosed() {
            this.zzaS.onAdClosed(this.zzaP);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzaS.onAdLeftApplication(this.zzaP);
        }

        @Override
        public void onAdClicked() {
            this.zzaS.onAdClicked(this.zzaP);
        }

        @Override
        public void onAppInstallAdLoaded(NativeAppInstallAd ad) {
            this.zzaS.onAdLoaded(this.zzaP, new zza(ad));
        }

        @Override
        public void onContentAdLoaded(NativeContentAd ad) {
            this.zzaS.onAdLoaded(this.zzaP, new zzb(ad));
        }
    }

    static final class zzd
    extends AdListener
    implements com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzaP;
        final MediationInterstitialListener zzaR;

        public zzd(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzaP = abstractAdViewAdapter;
            this.zzaR = mediationInterstitialListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzaR.onAdLoaded(this.zzaP);
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            this.zzaR.onAdFailedToLoad(this.zzaP, errorCode);
        }

        @Override
        public void onAdOpened() {
            this.zzaR.onAdOpened(this.zzaP);
        }

        @Override
        public void onAdClosed() {
            this.zzaR.onAdClosed(this.zzaP);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzaR.onAdLeftApplication(this.zzaP);
        }

        @Override
        public void onAdClicked() {
            this.zzaR.onAdClicked(this.zzaP);
        }
    }

    static final class zzc
    extends AdListener
    implements com.google.android.gms.ads.internal.client.zza {
        final AbstractAdViewAdapter zzaP;
        final MediationBannerListener zzaQ;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzaP = abstractAdViewAdapter;
            this.zzaQ = mediationBannerListener;
        }

        @Override
        public void onAdLoaded() {
            this.zzaQ.onAdLoaded(this.zzaP);
        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            this.zzaQ.onAdFailedToLoad(this.zzaP, errorCode);
        }

        @Override
        public void onAdOpened() {
            this.zzaQ.onAdOpened(this.zzaP);
        }

        @Override
        public void onAdClosed() {
            this.zzaQ.onAdClosed(this.zzaP);
        }

        @Override
        public void onAdLeftApplication() {
            this.zzaQ.onAdLeftApplication(this.zzaP);
        }

        @Override
        public void onAdClicked() {
            this.zzaQ.onAdClicked(this.zzaP);
        }
    }
}

