/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzb;
import com.google.android.gms.internal.zzav;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AdvertisingIdClient {
    com.google.android.gms.common.zza zzob;
    zzav zzoc;
    boolean zzod;
    Object zzoe = new Object();
    zza zzof;
    private final Context mContext;
    final long zzog;
    private static boolean zzoh = false;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L);
    }

    public AdvertisingIdClient(Context context, long timeoutInMillis) {
        zzx.zzw(context);
        this.mContext = context;
        this.zzod = false;
        this.zzog = timeoutInMillis;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zzb(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzb(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzx.zzcj("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzod) {
                this.finish();
            }
            this.zzob = AdvertisingIdClient.zzo(this.mContext);
            this.zzoc = AdvertisingIdClient.zza(this.mContext, this.zzob);
            this.zzod = true;
            if (bl) {
                this.zzaJ();
            }
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean shouldSkipGmsCoreVersionCheck) {
        zzoh = shouldSkipGmsCoreVersionCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzaJ() {
        Object object = this.zzoe;
        synchronized (object) {
            if (this.zzof != null) {
                this.zzof.cancel();
                try {
                    this.zzof.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.zzog > 0L) {
                this.zzof = new zza(this, this.zzog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        zzx.zzcj("Calling this from your main thread can lead to deadlock");
        Info info = null;
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzod) {
                Object object = this.zzoe;
                synchronized (object) {
                    if (this.zzof == null || !this.zzof.zzaK()) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.zzb(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzod) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzx.zzw(this.zzob);
            zzx.zzw(this.zzoc);
            try {
                info = new Info(this.zzoc.getId(), this.zzoc.zzc(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzaJ();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzx.zzcj("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzob == null) {
                return;
            }
            try {
                if (this.zzod) {
                    zzb.zzqh().zza(this.mContext, this.zzob);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
            }
            this.zzod = false;
            this.zzoc = null;
            this.zzob = null;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    static com.google.android.gms.common.zza zzo(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            PackageManager packageManager = context.getPackageManager();
            packageManager.getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        if (zzoh) {
            Log.d((String)"Ads", (String)"Skipping gmscore version check");
            int n = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
            switch (n) {
                case 0: 
                case 2: {
                    break;
                }
                default: {
                    throw new IOException("Google Play services not available");
                }
            }
        } else {
            try {
                GooglePlayServicesUtil.zzaa(context);
            }
            catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                throw new IOException(googlePlayServicesNotAvailableException);
            }
        }
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (zzb.zzqh().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L);
        try {
            advertisingIdClient.zzb(false);
            Info info = advertisingIdClient.getInfo();
            return info;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    static zzav zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzav.zza.zzb(zza2.zzno());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzom;
        private final boolean zzon;

        public Info(String advertisingId, boolean limitAdTrackingEnabled) {
            this.zzom = advertisingId;
            this.zzon = limitAdTrackingEnabled;
        }

        public String getId() {
            return this.zzom;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.zzon;
        }

        public String toString() {
            return "{" + this.zzom + "}" + this.zzon;
        }
    }

    static class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzoi;
        private long zzoj;
        CountDownLatch zzok;
        boolean zzol;

        public zza(AdvertisingIdClient advertisingIdClient, long l2) {
            this.zzoi = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzoj = l2;
            this.zzok = new CountDownLatch(1);
            this.zzol = false;
            this.start();
        }

        public void cancel() {
            this.zzok.countDown();
        }

        public boolean zzaK() {
            return this.zzol;
        }

        private void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzoi.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzol = true;
            }
        }

        @Override
        public void run() {
            try {
                if (!this.zzok.await(this.zzoj, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
            }
        }
    }
}

