/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzfk;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzja;
import java.util.Collections;

@zzgr
public class zzd
extends zzfk.zza
implements zzo {
    static final int zzBh = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzBi;
    zziz zzoM;
    zzc zzBj;
    zzm zzBk;
    boolean zzBl = false;
    FrameLayout zzBm;
    WebChromeClient.CustomViewCallback zzBn;
    boolean zzBo = false;
    boolean zzBp = false;
    RelativeLayout zzAn;
    boolean zzBq = false;
    int zzBr = 0;
    private boolean zzBs;
    private boolean zzBt = false;
    private boolean zzBu = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
    }

    public void close() {
        this.zzBr = 2;
        this.mActivity.finish();
    }

    public void zzeD() {
        if (this.zzBi != null && this.zzBl) {
            this.setRequestedOrientation(this.zzBi.orientation);
        }
        if (this.zzBm != null) {
            this.mActivity.setContentView((View)this.zzAn);
            this.zzaE();
            this.zzBm.removeAllViews();
            this.zzBm = null;
        }
        if (this.zzBn != null) {
            this.zzBn.onCustomViewHidden();
            this.zzBn = null;
        }
        this.zzBl = false;
    }

    @Override
    public void zzeE() {
        this.zzBr = 1;
        this.mActivity.finish();
    }

    @Override
    public void onBackPressed() {
        this.zzBr = 0;
    }

    @Override
    public boolean zzeF() {
        this.zzBr = 0;
        if (this.zzoM == null) {
            return true;
        }
        boolean bl = this.zzoM.zzhk();
        if (!bl) {
            this.zzoM.zzb("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.zzBo = savedInstanceState != null ? savedInstanceState.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzBi = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzBi == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzBi.zzqj.zzJw > 7500000) {
                this.zzBr = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzBu = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzBp = this.zzBi.zzBM != null ? this.zzBi.zzBM.zzpt : false;
            if (zzby.zzvz.get().booleanValue() && this.zzBp && this.zzBi.zzBM.zzpv != null) {
                new zzd().zzgz();
            }
            if (savedInstanceState == null) {
                if (this.zzBi.zzBC != null && this.zzBu) {
                    this.zzBi.zzBC.zzaW();
                }
                if (this.zzBi.zzBJ != 1 && this.zzBi.zzBB != null) {
                    this.zzBi.zzBB.onAdClicked();
                }
            }
            this.zzAn = new zzb((Context)this.mActivity, this.zzBi.zzBL);
            switch (this.zzBi.zzBJ) {
                case 1: {
                    this.zzv(false);
                    break;
                }
                case 2: {
                    this.zzBj = new zzc(this.zzBi.zzBD);
                    this.zzv(false);
                    break;
                }
                case 3: {
                    this.zzv(true);
                    break;
                }
                case 4: {
                    if (this.zzBo) {
                        this.zzBr = 3;
                        this.mActivity.finish();
                        break;
                    }
                    if (!zzp.zzbs().zza((Context)this.mActivity, this.zzBi.zzBA, this.zzBi.zzBI)) {
                        this.zzBr = 3;
                        this.mActivity.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH(zza2.getMessage());
            this.zzBr = 3;
            this.mActivity.finish();
        }
    }

    @Override
    public void onRestart() {
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onResume() {
        if (this.zzBi != null && this.zzBi.zzBJ == 4) {
            if (this.zzBo) {
                this.zzBr = 3;
                this.mActivity.finish();
            } else {
                this.zzBo = true;
            }
        }
        if (this.zzoM != null && !this.zzoM.isDestroyed()) {
            zzp.zzbx().zzb(this.zzoM.getWebView());
        } else {
            com.google.android.gms.ads.internal.util.client.zzb.zzaH("The webview does not exit. Ignoring action.");
        }
    }

    @Override
    public void onPause() {
        this.zzeD();
        if (!(this.zzoM == null || this.mActivity.isFinishing() && this.zzBj != null)) {
            zzp.zzbx().zza(this.zzoM.getWebView());
        }
        this.zzeH();
    }

    @Override
    public void onSaveInstanceState(Bundle outBundle) {
        outBundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzBo);
    }

    @Override
    public void onStop() {
        this.zzeH();
    }

    @Override
    public void onDestroy() {
        if (this.zzoM != null) {
            this.zzAn.removeView(this.zzoM.getView());
        }
        this.zzeH();
    }

    public void zzu(boolean bl) {
        int n = bl ? 50 : 32;
        this.zzBk = new zzm((Context)this.mActivity, n, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzBk.zza(bl, this.zzBi.zzBG);
        this.zzAn.addView((View)this.zzBk, (ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public void zzaE() {
        this.zzBs = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zzBk != null) {
            this.zzBk.zza(bl, bl2);
        }
    }

    public void zzeG() {
        this.zzAn.removeView((View)this.zzBk);
        this.zzu(true);
    }

    public void setRequestedOrientation(int requestedOrientation) {
        this.mActivity.setRequestedOrientation(requestedOrientation);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzBm = new FrameLayout((Context)this.mActivity);
        this.zzBm.setBackgroundColor(-16777216);
        this.zzBm.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzBm);
        this.zzaE();
        this.zzBn = customViewCallback;
        this.zzBl = true;
    }

    protected void zzv(boolean bl) throws zza {
        Window window;
        if (!this.zzBs) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        if (!this.zzBp || this.zzBi.zzBM != null && this.zzBi.zzBM.zzpu) {
            window.setFlags(1024, 1024);
        }
        boolean bl2 = this.zzBi.zzBD.zzhe().zzbY();
        this.zzBq = false;
        if (bl2) {
            if (this.zzBi.orientation == zzp.zzbx().zzgG()) {
                this.zzBq = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzBi.orientation == zzp.zzbx().zzgH()) {
                this.zzBq = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        com.google.android.gms.ads.internal.util.client.zzb.zzaF("Delay onShow to next orientation change: " + this.zzBq);
        this.setRequestedOrientation(this.zzBi.orientation);
        if (zzp.zzbx().zza(window)) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaF("Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzBp) {
            this.zzAn.setBackgroundColor(-16777216);
        } else {
            this.zzAn.setBackgroundColor(zzBh);
        }
        this.mActivity.setContentView((View)this.zzAn);
        this.zzaE();
        if (bl) {
            this.zzoM = zzp.zzbw().zza((Context)this.mActivity, this.zzBi.zzBD.zzaN(), true, bl2, null, this.zzBi.zzqj);
            this.zzoM.zzhe().zzb(null, null, this.zzBi.zzBE, this.zzBi.zzBI, true, this.zzBi.zzBK, null, this.zzBi.zzBD.zzhe().zzhq(), null);
            this.zzoM.zzhe().zza(new zzja.zza(){

                @Override
                public void zza(zziz zziz2, boolean bl) {
                    zziz2.zzeJ();
                }
            });
            if (this.zzBi.url != null) {
                this.zzoM.loadUrl(this.zzBi.url);
            } else if (this.zzBi.zzBH != null) {
                this.zzoM.loadDataWithBaseURL(this.zzBi.zzBF, this.zzBi.zzBH, "text/html", "UTF-8", null);
            } else {
                throw new zza("No URL or HTML to display in ad overlay.");
            }
            if (this.zzBi.zzBD != null) {
                this.zzBi.zzBD.zzc(this);
            }
        } else {
            this.zzoM = this.zzBi.zzBD;
            this.zzoM.setContext((Context)this.mActivity);
        }
        this.zzoM.zzb(this);
        ViewParent viewParent = this.zzoM.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzoM.getView());
        }
        if (this.zzBp) {
            this.zzoM.setBackgroundColor(zzBh);
        }
        this.zzAn.addView(this.zzoM.getView(), -1, -1);
        if (!bl && !this.zzBq) {
            this.zzeJ();
        }
        this.zzu(bl2);
        if (this.zzoM.zzhf()) {
            this.zza(bl2, true);
        }
    }

    protected void zzeH() {
        if (!this.mActivity.isFinishing() || this.zzBt) {
            return;
        }
        this.zzBt = true;
        if (this.zzoM != null) {
            this.zzv(this.zzBr);
            this.zzAn.removeView(this.zzoM.getView());
            if (this.zzBj != null) {
                this.zzoM.setContext(this.zzBj.context);
                this.zzoM.zzC(false);
                this.zzBj.zzBx.addView(this.zzoM.getView(), this.zzBj.index, this.zzBj.zzBw);
                this.zzBj = null;
            }
            this.zzoM = null;
        }
        if (this.zzBi != null && this.zzBi.zzBC != null) {
            this.zzBi.zzBC.zzaV();
        }
    }

    public void zzeI() {
        if (this.zzBq) {
            this.zzBq = false;
            this.zzeJ();
        }
    }

    protected void zzeJ() {
        this.zzoM.zzeJ();
    }

    protected void zzv(int n) {
        this.zzoM.zzv(n);
    }

    @zzgr
    private class zzd
    extends zzhz {
        private zzd() {
        }

        @Override
        public void zzbn() {
            Bitmap bitmap = zzp.zzbv().zzg((Context)zzd.this.mActivity, zzd.this.zzBi.zzBM.zzpv);
            if (bitmap != null) {
                final Drawable drawable2 = zzp.zzbx().zza((Context)zzd.this.mActivity, bitmap, zzd.this.zzBi.zzBM.zzpw, zzd.this.zzBi.zzBM.zzpx);
                zzid.zzIE.post(new Runnable(){

                    @Override
                    public void run() {
                        zzd.this.mActivity.getWindow().setBackgroundDrawable(drawable2);
                    }
                });
            }
        }

        @Override
        public void onStop() {
        }
    }

    @zzgr
    static final class zzb
    extends RelativeLayout {
        zzif zzqQ;

        public zzb(Context context, String string2) {
            super(context);
            this.zzqQ = new zzif(context, string2);
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            this.zzqQ.zze(event);
            return false;
        }
    }

    @zzgr
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzBw;
        public final ViewGroup zzBx;
        public final Context context;

        public zzc(zziz zziz2) throws zza {
            this.zzBw = zziz2.getLayoutParams();
            ViewParent viewParent = zziz2.getParent();
            this.context = zziz2.zzha();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.zzBx = (ViewGroup)viewParent;
            this.index = this.zzBx.indexOfChild(zziz2.getView());
            this.zzBx.removeView(zziz2.getView());
            zziz2.zzC(true);
        }
    }

    @zzgr
    private static final class zza
    extends Exception {
        public zza(String string2) {
            super(string2);
        }
    }
}

